/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.dnd;

import fr.esrf.tangoatk.widget.dnd.IDropHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;

public class DropTargetListener
implements java.awt.dnd.DropTargetListener {
    int acceptableActions = 1;
    IDropHandler handler;

    public void setAccepableActions(int n) {
        this.acceptableActions = n;
    }

    public int getAcceptiableActions() {
        return this.acceptableActions;
    }

    public void setDropHandler(IDropHandler iDropHandler) {
        this.handler = iDropHandler;
    }

    public IDropHandler getDropHandler() {
        return this.handler;
    }

    private boolean isDragFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].getMimeType().startsWith("tango/entity") || dataFlavorArray[n].getMimeType().startsWith("tango/numberscalar") || dataFlavorArray[n].getMimeType().startsWith("tango/numberspectrum") || dataFlavorArray[n].getMimeType().startsWith("tango/numberimage") || dataFlavorArray[n].getMimeType().startsWith("tango/numberimage") || dataFlavorArray[n].getMimeType().startsWith("tango/command")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
        return dataFlavorArray[dataFlavorArray.length - 1];
    }

    private boolean isDragOn(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragFlavorSupported(dropTargetDragEvent)) {
            return false;
        }
        int n = dropTargetDragEvent.getDropAction();
        return (n & this.acceptableActions) != 0;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.handler.isDragOn(dropTargetDragEvent.getCurrentDataFlavors())) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            return;
        }
        dropTargetDragEvent.rejectDrag();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.handler.isDragOn(dropTargetDragEvent.getCurrentDataFlavors())) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            return;
        }
        dropTargetDragEvent.rejectDrag();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.handler.isDragOn(dropTargetDragEvent.getCurrentDataFlavors())) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            return;
        }
        dropTargetDragEvent.rejectDrag();
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
        if (dataFlavor == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        int n = dropTargetDropEvent.getDropAction();
        int n2 = dropTargetDropEvent.getSourceActions();
        if ((n2 & this.acceptableActions) == 0) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Object object = null;
        try {
            dropTargetDropEvent.acceptDrop(this.acceptableActions);
            object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
            if (object == null) {
                throw new NullPointerException();
            }
        }
        catch (Throwable throwable) {
            System.err.println("Couldn't get transfer data: " + throwable.getMessage());
            throwable.printStackTrace();
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        this.handler.handleDrop(object.toString(), dataFlavor);
        dropTargetDropEvent.dropComplete(true);
    }
}

