/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class AttributeBarChart
extends JLChart
implements INumberScalarListener {
    private String header = "Barchart";
    private String xaxisName = "X";
    private String unit = "unknown";
    private double alarmLevel = 0.0;
    private double faultLevel = 0.0;
    JLDataView alarm;
    JLDataView fault;
    private String configFile = "";
    private String configFile2;
    private String lastConfig = "";
    private int refreshingPeriod = 0;
    private Map dataViewHash = new HashMap();
    private AttributeList model = null;

    public AttributeBarChart() {
        this.initComponents();
        this.addUserAction("Load configuration");
        this.addUserAction("Save configuration");
        this.addUserAction("Set Refresh Interval...");
    }

    private void initComponents() {
        this.setHeaderFont(new Font("Times", 1, 18));
        this.setHeader("BarChart");
        this.setLabelVisible(false);
        this.setSize(640, 480);
        this.setXAxisOnBottom(false);
        this.getY1Axis().setAutoScale(true);
        this.getY1Axis().setGridVisible(true);
        this.getY1Axis().setSubGridVisible(false);
        this.getXAxis().setAutoScale(false);
        this.getXAxis().setMinimum(0.0);
        this.getXAxis().setMaximum(0.0);
        this.getXAxis().setAnnotation(2);
        this.getXAxis().setGridVisible(false);
        this.getXAxis().setSubGridVisible(false);
        this.alarm = new JLDataView();
        this.alarm.setName("Alarm level");
        this.alarm.setColor(ATKConstant.getColor4State("ALARM"));
        this.alarm.setLineWidth(2);
        this.getY1Axis().addDataView(this.alarm);
        this.fault = new JLDataView();
        this.fault.setName("Fault level");
        this.fault.setColor(ATKConstant.getColor4State("FAULT"));
        this.fault.setLineWidth(2);
        this.getY1Axis().addDataView(this.fault);
        this.setPaintAxisFirst(false);
    }

    public void setModel(AttributeList attributeList) {
        Object object;
        int n = 10;
        if (this.model != null) {
            this.clearModel();
            this.model = null;
        }
        if (attributeList == null) {
            return;
        }
        int n2 = attributeList.getSize();
        if (n2 <= 0) {
            return;
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            object = attributeList.getElementAt(n3);
            if (object instanceof INumberScalar) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl) {
            return;
        }
        this.model = attributeList;
        this.refreshingPeriod = this.model.getRefreshInterval();
        int n4 = 0;
        n3 = 0;
        while (n3 < n2) {
            INumberScalar iNumberScalar;
            object = attributeList.getElementAt(n3);
            if (object instanceof INumberScalar && !this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)object)) {
                JLDataView jLDataView = new JLDataView();
                jLDataView.setUnit(iNumberScalar.getUnit());
                jLDataView.setName(iNumberScalar.getName());
                jLDataView.setColor(Color.black);
                jLDataView.setLineWidth(1);
                jLDataView.setBarWidth(n);
                jLDataView.setFillStyle(1);
                jLDataView.setViewType(1);
                this.getY1Axis().addDataView(jLDataView);
                iNumberScalar.addNumberScalarListener((INumberScalarListener)this);
                Vector<Object> vector = new Vector<Object>();
                Integer n5 = new Integer(n4);
                vector.add(0, jLDataView);
                vector.add(1, n5);
                this.dataViewHash.put(iNumberScalar, vector);
                ++n4;
            }
            ++n3;
        }
        this.getXAxis().setMaximum(n4 + 1);
        this.getXAxis().setTickSpacing(n4);
    }

    public void clearModel() {
        if (this.model == null) {
            return;
        }
        int n = this.model.getSize();
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            INumberScalar iNumberScalar;
            Object object = this.model.getElementAt(n2);
            if (object instanceof INumberScalar && this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)object)) {
                iNumberScalar.removeNumberScalarListener((INumberScalarListener)this);
            }
            ++n2;
        }
        this.getY1Axis().clearDataView();
        this.dataViewHash.clear();
        this.initComponents();
    }

    public void setWidth(int n) {
        if (this.model == null) {
            return;
        }
        int n2 = this.model.getSize();
        if (n2 <= 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            Object e;
            int n4;
            List list;
            INumberScalar iNumberScalar;
            Object object = this.model.getElementAt(n3);
            if (object instanceof INumberScalar && this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)object) && (list = (List)this.dataViewHash.get(iNumberScalar)) != null && (n4 = list.size()) >= 2 && (e = list.get(0)) != null && e instanceof JLDataView) {
                JLDataView jLDataView = (JLDataView)e;
                jLDataView.setBarWidth(n);
            }
            ++n3;
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        INumberScalar iNumberScalar = (INumberScalar)numberScalarEvent.getSource();
        if (this.dataViewHash.containsKey(iNumberScalar)) {
            List list = (List)this.dataViewHash.get(iNumberScalar);
            if (list == null) {
                return;
            }
            int n = list.size();
            if (n < 2) {
                return;
            }
            Object e = list.get(0);
            if (e == null) {
                return;
            }
            if (!(e instanceof JLDataView)) {
                return;
            }
            JLDataView jLDataView = (JLDataView)e;
            e = list.get(1);
            if (e == null) {
                return;
            }
            if (!(e instanceof Integer)) {
                return;
            }
            int n2 = (Integer)e;
            double d = numberScalarEvent.getValue();
            jLDataView.reset();
            jLDataView.add(n2 + 1, d);
            if (d > this.faultLevel) {
                jLDataView.setFillColor(Color.red);
            } else if (d > this.alarmLevel) {
                jLDataView.setFillColor(Color.orange);
            } else {
                jLDataView.setFillColor(Color.green);
            }
            this.repaint();
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public double getAlarmLevel() {
        return this.alarmLevel;
    }

    public void setAlarmLevel(double d) {
        this.alarmLevel = d;
        this.alarm.add(-1.0, d);
        this.alarm.add(d, d);
    }

    public double getFaultLevel() {
        return this.faultLevel;
    }

    public void setFaultLevel(double d) {
        this.faultLevel = d;
        this.fault.add(-1.0, d);
        this.fault.add(d, d);
    }

    public String getChartHeader() {
        return this.header;
    }

    public void setChartHeader(String string) {
        this.header = string;
        this.setHeader(string);
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
        this.getY1Axis().setName(string);
        this.alarm.setUnit(string);
        this.fault.setUnit(string);
    }

    public String getXaxisName() {
        return this.xaxisName;
    }

    public void setXaxisName(String string) {
        this.xaxisName = string;
        this.getXAxis().setName(string);
    }

    public String getSettings() {
        Object object;
        String string = "";
        string = string + this.getConfiguration();
        if (this.model != null) {
            string = string + "refresh_time:" + this.refreshingPeriod + "\n";
        }
        string = string + this.getXAxis().getConfiguration("x");
        string = string + this.getY1Axis().getConfiguration("y1");
        string = string + this.getY2Axis().getConfiguration("y2");
        int n = this.model.getSize();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            INumberScalar iNumberScalar;
            object = this.model.getElementAt(n3);
            if (object instanceof INumberScalar && this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)object)) {
                ++n2;
            }
            ++n3;
        }
        string = string + "dv_number:" + n2 + "\n";
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            Object e;
            int n5;
            List list;
            INumberScalar iNumberScalar;
            object = this.model.getElementAt(n4);
            if (object instanceof INumberScalar && this.dataViewHash.containsKey(iNumberScalar = (INumberScalar)object) && (list = (List)this.dataViewHash.get(iNumberScalar)) != null && (n5 = list.size()) >= 2 && (e = list.get(0)) != null && e instanceof JLDataView && (e = list.get(1)) != null && e instanceof Integer) {
                int n6 = (Integer)e;
                JLDataView jLDataView = (JLDataView)e;
                string = string + "dv" + n6 + "_name:'" + iNumberScalar + "'\n";
                string = string + jLDataView.getConfiguration("dv" + n6);
            }
            ++n4;
        }
        return string;
    }

    public void saveSetting(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.getSettings();
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
            this.lastConfig = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getParent(), "Failed to write " + string, "Error", 0);
            exception.printStackTrace();
        }
    }

    public String loadSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.readFile(string)) {
            return "Failed to read " + string;
        }
        this.lastConfig = string;
        return this.applySettings(cfFileReader);
    }

    public int getRefreshingPeriod() {
        if (this.model == null) {
            return 0;
        }
        this.refreshingPeriod = this.model.getRefreshInterval();
        return this.refreshingPeriod;
    }

    public void setRefreshingPeriod(int n) {
        if (this.model == null) {
            return;
        }
        this.refreshingPeriod = n;
        this.model.setRefreshInterval(n);
    }

    private String applySettings(CfFileReader cfFileReader) {
        String string = "";
        String string2 = "";
        Vector vector = cfFileReader.getParam("dv_number");
        if (vector != null) {
            int n;
            try {
                n = Integer.parseInt(vector.get(0).toString());
            }
            catch (NumberFormatException numberFormatException) {
                string = string + "dv_number: invalid number\n";
                return string;
            }
            int n2 = 0;
            while (n2 < n) {
                vector = cfFileReader.getParam("dv" + n2 + "_name");
                if (vector == null) {
                    string = string + "Unable to find dv" + n2 + "_name param\n";
                    return string;
                }
                try {
                    string2 = string2 + vector.get(0).toString() + ",";
                }
                catch (Exception exception) {
                    string = string + exception.getMessage() + "\n";
                    return string;
                }
                ++n2;
            }
            if (n > 0) {
                vector = cfFileReader.getParam("refresh_time");
                if (vector != null) {
                    this.setRefreshingPeriod(OFormat.getInt(vector.get(0).toString()));
                }
                string2 = string2.substring(0, string2.lastIndexOf(","));
                this.setAttributeListAsString(string2);
            }
        } else {
            boolean bl = false;
        }
        this.applyConfiguration(cfFileReader);
        this.getXAxis().applyConfiguration("x", cfFileReader);
        this.getY1Axis().applyConfiguration("y1", cfFileReader);
        this.getY2Axis().applyConfiguration("y2", cfFileReader);
        vector = cfFileReader.getParam("dv0_barwidth");
        if (vector == null) {
            string = string + "Unable to find dv" + 0 + "_barwidth param";
            return string;
        }
        this.setWidth(Integer.parseInt(vector.get(0).toString().trim()));
        vector = cfFileReader.getParam("xtitle");
        if (vector == null) {
            string = string + "Unable to find xtitle param";
            return string;
        }
        this.setXaxisName(vector.get(0).toString().replaceAll("'", "").trim());
        vector = cfFileReader.getParam("graph_title");
        if (vector == null) {
            string = string + "Unable to find graph_title param";
            return string;
        }
        this.setChartHeader(vector.get(0).toString().replaceAll("'", "").trim());
        vector = cfFileReader.getParam("y1title");
        if (vector == null) {
            string = string + "Unable to find y1title param";
            return string;
        }
        this.setUnit(vector.get(0).toString().replaceAll("'", "").trim());
        return string;
    }

    private void setAttributeListAsString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        if (stringArray != null) {
            AttributeList attributeList = new AttributeList();
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    attributeList.add(stringArray[n2]);
                }
                catch (ConnectionException connectionException) {
                    connectionException.printStackTrace();
                }
                ++n2;
            }
            this.setModel(attributeList);
            attributeList.startRefresher();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().trim().equalsIgnoreCase("Load configuration")) {
            this.loadPerformed();
        } else if (actionEvent.getActionCommand().trim().equalsIgnoreCase("Save configuration")) {
            this.savePerformed();
        } else if (actionEvent.getActionCommand().trim().equalsIgnoreCase("Set Refresh Interval...")) {
            int n = -1;
            n = this.getRefreshingPeriod();
            String string = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(n));
            if (string != null && string.length() > 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    this.setRefreshingPeriod(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid number !", "Error", 0);
                    return;
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void loadPerformed() {
        String string;
        File file;
        if (this.model != null) {
            this.model.stopRefresher();
        }
        this.clearModel();
        this.getY1Axis().clearDataView();
        double d = this.faultLevel;
        double d2 = this.alarmLevel;
        this.initComponents();
        this.setFaultLevel(d);
        this.setAlarmLevel(d2);
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = AttributeBarChart.this.getExtension(file);
                return string != null && string.equals("txt");
            }

            public String getDescription() {
                return "text files ";
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null && !bl && (string = this.loadSetting(file.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this.getParent(), string, "Errors reading " + file.getName(), 0);
        }
        this.repaint();
    }

    private void savePerformed() {
        int n = 0;
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = AttributeBarChart.this.getExtension(file);
                return string != null && string.equals("txt");
            }

            public String getDescription() {
                return "text files ";
            }
        });
        jFileChooser.setSelectedFile(new File(this.lastConfig));
        int n2 = jFileChooser.showSaveDialog(this.getParent());
        if (n2 == 0) {
            File file = jFileChooser.getSelectedFile();
            if (this.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file != null) {
                if (file.exists()) {
                    n = JOptionPane.showConfirmDialog(this.getParent(), "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
                }
                if (n == 0) {
                    this.saveSetting(file.getAbsolutePath());
                }
            }
        }
    }

    public String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        AttributeBarChart attributeBarChart = new AttributeBarChart();
        AttributeList attributeList = new AttributeList();
        try {
            attributeList.add("jlp/test/1/att_un");
            attributeList.add("jlp/test/1/att_deux");
            attributeList.add("jlp/test/1/att_trois");
            attributeBarChart.setModel(attributeList);
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
            System.exit(1);
        }
        attributeBarChart.setWidth(120);
        attributeBarChart.setXaxisName("Pressures");
        attributeBarChart.setChartHeader("LT1");
        attributeBarChart.setUnit("mbar");
        attributeBarChart.setFaultLevel(200.0);
        attributeBarChart.setAlarmLevel(50.0);
        attributeList.startRefresher();
        jFrame.getContentPane().add((Component)attributeBarChart, "Center");
        jFrame.setSize(640, 480);
        jFrame.setTitle("Bar Chart Example 1");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }
}

