/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class BeanPropertyGenerator {
    int indentLevel = 4;
    PrintStream out;
    String name;
    Properties prop;

    public BeanPropertyGenerator(InputStream inputStream, PrintStream printStream) throws IOException {
        int n = 0;
        this.out = printStream;
        this.prop = new Properties();
        this.prop.load(inputStream);
        this.name = this.prop.getProperty("name").trim();
        this.generateBeanHeader(this.prop.getProperty("package").trim());
        ++n;
        if (!"".equals(this.prop.getProperty("events", "").trim())) {
            this.generateEventSetDescriptor(n, new StringTokenizer(this.prop.getProperty("events").trim(), ","));
        }
        if (!"".equals(this.prop.getProperty("properties", "").trim())) {
            this.generatePropertyDescriptor(n, new StringTokenizer(this.prop.getProperty("properties").trim(), ","));
        }
        this.generateIcon(n);
        this.generateAdditionalBeanInfo(n);
        this.generateBeanFooter(--n);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    int generateBeanHeader(String string) {
        this.out.print("package ");
        this.out.print(string);
        this.out.println(";\n");
        this.out.println("import java.beans.*;\n");
        this.out.println("// This class is autogenerated by the BeanPropertyGenerator");
        this.out.println("// Do not edit");
        this.out.println("// See " + this.name + "BeanInfo.info\n");
        this.out.print("public class ");
        this.out.print(this.name);
        this.out.println("BeanInfo extends SimpleBeanInfo {");
        this.out.println("");
        return 1;
    }

    int generateBeanFooter(int n) {
        this.out.print(this.generatePad(n));
        this.out.println("}");
        return 0;
    }

    String generatePad(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n * this.indentLevel;
        while (n2 >= 0) {
            stringBuffer.append(" ");
            --n2;
        }
        return stringBuffer.toString();
    }

    void generateHeader(String string, String string2, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.generatePad(n));
        stringBuffer.append("public ");
        stringBuffer.append(string);
        stringBuffer.append("[] get");
        stringBuffer.append(string2);
        stringBuffer.append("() {");
        this.out.println(stringBuffer);
        this.out.println("");
        if (bl) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.generatePad(++n));
            stringBuffer.append("try {");
            this.out.println(stringBuffer);
        }
    }

    void generateHeader(String string, int n) {
        this.generateHeader(string, string + "s", n, true);
    }

    void generateHeader(String string, int n, boolean bl) {
        this.generateHeader(string, string + "s", n, bl);
    }

    void generateFooter(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(this.generatePad(--n));
        stringBuffer.append("} catch (Exception e) {");
        this.out.println(stringBuffer);
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(this.generatePad(++n));
        stringBuffer.append("System.err.println(\"" + this.prop.getProperty("name").trim() + "\" + \":\");\n");
        stringBuffer.append(this.generatePad(n));
        stringBuffer.append("System.err.println(e);");
        this.out.println(stringBuffer);
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(this.generatePad(--n));
        stringBuffer.append("}");
        this.out.println(stringBuffer);
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(this.generatePad(n));
        stringBuffer.append("return null;");
        this.out.println(stringBuffer);
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(this.generatePad(--n));
        stringBuffer.append("}");
        this.out.println(stringBuffer);
        this.out.println();
        this.out.println();
    }

    void generateTry(int n) {
        this.printPad(n, "try {");
    }

    void generateCatch(int n, String string) {
        this.out.print(this.generatePad(--n));
        this.out.println("} catch (" + string + ") {");
    }

    void printPad(int n, String string) {
        this.out.print(this.generatePad(n));
        this.out.println(string);
    }

    void generateAdditionalBeanInfo(int n) {
        StringBuffer stringBuffer = new StringBuffer("return new BeanInfo[] { sbi };");
        this.generateHeader("BeanInfo", "AdditionalBeanInfo", n, true);
        ++n;
        this.printPad(++n, "Class s = " + this.getName() + ".class.getSuperclass();");
        this.printPad(++n, "BeanInfo sbi = Introspector.getBeanInfo(s);");
        this.printPad(n, stringBuffer.toString());
        this.generateCatch(n, "IntrospectionException e");
        this.printPad(n, "System.out.println(e);");
        this.printPad(n, "return null;");
        this.printPad(--n, "}");
        this.printPad(--n, "}");
    }

    void generatePropertyDescriptor(int n, StringTokenizer stringTokenizer) {
        this.generateHeader("PropertyDescriptor", n, false);
        ++n;
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().trim());
        }
        this.printPad(n, "PropertyDescriptor [] propdesc = new PropertyDescriptor[" + vector.size() + "];");
        int n2 = 0;
        while (n2 < vector.size()) {
            this.generateTry(n++);
            String string = (String)vector.get(n2);
            this.printPad(n, "propdesc[" + n2 + "] = new PropertyDescriptor(\"" + string + "\", " + this.name + ".class);");
            this.generateCatch(n, "Exception e");
            this.printPad(n, "System.out.println(\"\\n" + string + " not supported (please verify your code)\");");
            this.printPad(--n, "}");
            ++n2;
        }
        this.printPad(n, "return propdesc;");
        this.printPad(--n, "}");
    }

    void generateEventSetDescriptor(int n, StringTokenizer stringTokenizer) {
        this.generateHeader("EventSetDescriptor", n);
        ++n;
        StringBuffer stringBuffer = new StringBuffer("return new EventSetDescriptor [] { ");
        while (stringTokenizer.hasMoreTokens()) {
            this.out.print(this.generatePad(++n));
            String string = stringTokenizer.nextToken().trim();
            stringBuffer.append(string);
            stringBuffer.append(", ");
            String string2 = this.prop.getProperty(string + ".listenerType").trim();
            String string3 = this.prop.getProperty(string + ".listenerMethodName").trim();
            String string4 = this.prop.getProperty(string + ".displayName").trim();
            this.out.print("EventSetDescriptor ");
            this.out.print(string);
            this.out.print(" = new EventSetDescriptor(");
            this.out.print(this.name);
            this.out.print(".class, \"");
            this.out.print(string);
            this.out.print("\", ");
            this.out.print(string2);
            this.out.print(".class, \"");
            this.out.print(string3);
            this.out.println("\");");
            this.out.print(string);
            this.out.print(".setDisplayName(\"");
            this.out.print(string4);
            this.out.println("\");");
        }
        stringBuffer.append(" };");
        this.out.println(stringBuffer);
        this.generateFooter("EventSetDescriptor", --n);
    }

    void generateIcon(int n) {
        String string = this.prop.getProperty("ICON_COLOR_16x16");
        String string2 = this.prop.getProperty("ICON_MONO_16x16");
        String string3 = this.prop.getProperty("ICON_COLOR_32x32");
        String string4 = this.prop.getProperty("ICON_MONO_32x32");
        if (string == null && string2 == null && string3 == null && string4 == null) {
            return;
        }
        this.out.print(this.generatePad(n));
        this.out.println("public java.awt.Image getIcon(int icon) {\n");
        this.generateSingleIcon(string, "ICON_COLOR_16x16", ++n);
        this.generateSingleIcon(string3, "ICON_COLOR_32x32", n);
        this.generateSingleIcon(string2, "ICON_MONO_16x16", n);
        this.generateSingleIcon(string4, "ICON_MONO_32x32", n);
        this.out.print(this.generatePad(n));
        this.out.println("return null;");
        this.out.print(this.generatePad(--n));
        this.out.println("}");
    }

    void generateSingleIcon(String string, String string2, int n) {
        if (string == null) {
            return;
        }
        string.trim();
        if (string.length() < 1) {
            return;
        }
        this.out.print(this.generatePad(n));
        this.out.println("if (icon == BeanInfo." + string2 + ") {");
        this.out.print(this.generatePad(++n));
        this.out.println("return loadImage(\"" + string + "\");");
        this.out.print(this.generatePad(--n));
        this.out.println("}");
    }

    private static String makeInfoName(String string) throws IOException {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            throw new IOException("Invalid filename " + string);
        }
        return string.substring(0, n) + ".info";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.exit(0);
        }
        try {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = BeanPropertyGenerator.makeInfoName(stringArray[n]);
                new BeanPropertyGenerator(new FileInputStream(string2), new PrintStream(new FileOutputStream(string)));
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("BeanPropertyGenerator failed : " + iOException.getMessage());
            System.exit(1);
        }
    }
}

