/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.util;

import fr.esrf.tangoatk.core.util.Timee;
import fr.esrf.tangoatk.core.util.myPrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class AtkTimer {
    protected Map threadMap = new HashMap();
    protected Map methodMap = new HashMap();
    protected static AtkTimer self;
    protected int maxMethodName = Integer.MIN_VALUE;
    protected String skip = "fr.esrf.TangoATK.Core.";
    myPrintWriter pw = new myPrintWriter(System.out);
    protected boolean timer = false;

    protected AtkTimer() {
        if ("on".equals(System.getProperty("TIMER"))) {
            this.timer = true;
        }
    }

    public static AtkTimer getInstance() {
        if (self == null) {
            self = new AtkTimer();
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer(Thread thread) {
        if (!this.timer) {
            return;
        }
        String string = this.getCaller();
        int n = string.length() - this.skip.length();
        this.maxMethodName = this.maxMethodName < n ? n : this.maxMethodName;
        Map map = this.threadMap;
        synchronized (map) {
            Stack<Timee> stack = (Stack<Timee>)this.threadMap.get(thread);
            if (stack == null) {
                stack = new Stack<Timee>();
                this.threadMap.put(thread, stack);
            }
            stack.push(new Timee(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTimer(Thread thread) {
        Vector<Long> vector;
        if (!this.timer) {
            return;
        }
        Timee timee = null;
        Map map = this.threadMap;
        synchronized (map) {
            Stack stack = (Stack)this.threadMap.get(thread);
            timee = (Timee)stack.pop();
        }
        long l = System.currentTimeMillis() - timee.getStartTime();
        String string = this.getCaller();
        if (!timee.getName().equals(string)) {
            System.out.println("not popping correct method, wanted " + string + ", got " + timee.getName() + "\n");
        }
        if ((vector = (Vector<Long>)this.methodMap.get(string)) == null) {
            vector = new Vector<Long>();
            this.methodMap.put(string, vector);
        }
        vector.add(new Long(l));
    }

    public static String padding(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void printResults() {
        if (!this.timer) {
            return;
        }
        System.out.println("\nMethodname" + AtkTimer.padding(this.maxMethodName - "methodName".length() + 5) + "Average\tMin\tMax\tCalls");
        Iterator iterator = this.methodMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)this.methodMap.get(string);
            long l = 0L;
            long l2 = Long.MAX_VALUE;
            long l3 = Long.MIN_VALUE;
            long l4 = 0L;
            int n = 0;
            while (n < list.size()) {
                l4 = (Long)list.get(n);
                l += l4;
                l3 = l4 > l3 ? l4 : l3;
                l2 = l4 < l2 ? l4 : l2;
                ++n;
            }
            String string2 = "";
            if (string.indexOf(this.skip) != -1) {
                string = string.substring(this.skip.length());
            }
            int n2 = 0;
            while (n2 < this.maxMethodName - string.length()) {
                string2 = string2 + " ";
                ++n2;
            }
            String string3 = new Long(l / (long)n).toString();
            System.out.println(string + AtkTimer.padding(this.maxMethodName - string.length() + 5) + AtkTimer.padding(5 - string3.length()) + string3 + "ms\t" + l2 + "\t" + l3 + "\t" + n);
        }
    }

    protected String getCaller() {
        Throwable throwable = new Throwable();
        throwable.printStackTrace(this.pw);
        return this.pw.getCaller();
    }
}

