/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.ShortImageHelper;

public class ShortSpectrumHelper
extends ANumberSpectrumHelper {
    public ShortSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.imageHelper = new ShortImageHelper(iAttribute);
    }

    protected void insert(double[] dArray) {
        short[] sArray = new short[dArray.length];
        int n = 0;
        while (n < sArray.length) {
            sArray[n] = new Double(dArray[n]).shortValue();
            ++n;
        }
        this.deviceAttribute.insert(sArray, this.attribute.getXDimension(), this.attribute.getYDimension());
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Short((short)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Short((short)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Short((short)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Short((short)d));
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Short((short)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Short((short)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Short((short)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Short((short)d), bl);
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        short[] sArray = deviceAttribute.extractShortArray();
        double[] dArray = new double[sArray.length];
        int n = 0;
        while (n < sArray.length) {
            dArray[n] = sArray[n];
            ++n;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: ShortSpectrumHelper.java,v 1.5 2004/12/09 14:56:16 jlpons Exp $";
    }
}

