/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberProperty;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberImage
extends AAttribute
implements INumberImage {
    protected NumberAttributeHelper numberHelper;
    double[][] imageValue;

    public void init(Device device, String string, AttributeInfo attributeInfo) {
        super.init(device, string, attributeInfo);
    }

    public void setNumberHelper(ANumberImageHelper aNumberImageHelper) {
        this.numberHelper = aNumberImageHelper;
    }

    public void addNumberImageListener(IImageListener iImageListener) {
        this.numberHelper.addImageListener(iImageListener);
    }

    public void removeNumberImageListener(IImageListener iImageListener) {
        this.numberHelper.removeImageListener(iImageListener);
    }

    protected void insert(String[][] stringArray) {
        this.checkDimensions(stringArray);
        this.insert(NumberAttributeHelper.flatten2double(stringArray));
    }

    public void refresh() {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.imageValue = this.numberHelper.getNumberImageValue(this.readValueFromNetwork());
                this.numberHelper.fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.imageValue = null;
            System.out.println("NumberImage.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.refresh()------------------------------------------------");
        }
    }

    public void setValue(double[][] dArray) {
        try {
            this.checkDimensions(dArray);
            this.insert(NumberAttributeHelper.flatten(dArray));
            this.writeAtt();
            this.numberHelper.fireImageValueChanged(dArray, System.currentTimeMillis());
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    protected double getNumberProperty(String string) {
        NumberProperty numberProperty = (NumberProperty)this.getProperty(string);
        if (numberProperty != null && numberProperty.isSpecified()) {
            return ((Number)numberProperty.getValue()).doubleValue();
        }
        return Double.NaN;
    }

    public double getMinValue() {
        return this.getNumberProperty("min_value");
    }

    public double getMaxValue() {
        return this.getNumberProperty("max_value");
    }

    public double getMinAlarm() {
        return this.getNumberProperty("min_alarm");
    }

    public double getMaxAlarm() {
        return this.getNumberProperty("max_alarm");
    }

    public void setConfiguration(AttributeInfo attributeInfo) {
        super.setConfiguration(attributeInfo);
        try {
            this.setMinValue(new Double(this.config.min_value), true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMinValue(Double.NaN, true);
            this.getProperty("min_value").setSpecified(false);
        }
        try {
            this.setMaxValue(new Double(this.config.max_value), true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMaxValue(Double.NaN, true);
            this.getProperty("max_value").setSpecified(false);
        }
        try {
            this.setMinAlarm(new Double(this.config.min_alarm), true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMinAlarm(Double.NaN, true);
            this.getProperty("min_alarm").setSpecified(false);
        }
        try {
            this.setMaxAlarm(new Double(this.config.max_alarm), true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMaxAlarm(Double.NaN, true);
            this.getProperty("max_alarm").setSpecified(false);
        }
    }

    public void setMinValue(double d) {
        this.numberHelper.setMinValue(d);
    }

    public void setMaxValue(double d) {
        this.numberHelper.setMaxValue(d);
    }

    public void setMinAlarm(double d) {
        this.numberHelper.setMinAlarm(d);
    }

    public void setMaxAlarm(double d) {
        this.numberHelper.setMaxAlarm(d);
    }

    public void setMinValue(double d, boolean bl) {
        this.numberHelper.setMinValue(d, bl);
    }

    public void setMaxValue(double d, boolean bl) {
        this.numberHelper.setMaxValue(d, bl);
    }

    public void setMinAlarm(double d, boolean bl) {
        this.numberHelper.setMinAlarm(d, bl);
    }

    public void setMaxAlarm(double d, boolean bl) {
        this.numberHelper.setMaxAlarm(d, bl);
    }

    public double getStandardUnit() {
        NumberProperty numberProperty = (NumberProperty)this.getProperty("standard_unit");
        if (numberProperty.isSpecified()) {
            return ((Number)numberProperty.getValue()).doubleValue();
        }
        return Double.NaN;
    }

    public double[][] getStandardValue() throws DevFailed {
        double[][] dArray = this.getValue();
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray.length) {
                double[] dArray2 = dArray[n];
                int n3 = n2++;
                dArray2[n3] = dArray2[n3] * this.getStandardUnit();
            }
            ++n;
        }
        return dArray;
    }

    void insert(double[] dArray) {
        this.numberHelper.insert(dArray);
    }

    public String[][] extract() throws DevFailed {
        return this.numberHelper.getImageValue(this.readValueFromNetwork());
    }

    public double[][] getValue() {
        return this.imageValue;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        block8: {
            ++this.periodicCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoPeriodicEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.imageValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.imageValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                this.imageValue = null;
                System.out.println("NumberImage.periodic.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberImage.periodic.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.numberHelper.getNumberImageValue(deviceAttribute);
                this.numberHelper.fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.imageValue = null;
                System.out.println("NumberImage.periodic.getNumberImageValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberImage.periodic.getNumberImageValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        block8: {
            ++this.changeCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoChangeEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.imageValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.imageValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                this.imageValue = null;
                System.out.println("NumberImage.change.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberImage.change.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.numberHelper.getNumberImageValue(deviceAttribute);
                this.numberHelper.fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.imageValue = null;
                System.out.println("NumberImage.change.getNumberImageValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberImage.change.getNumberImageValue()------------------------------------------------");
            }
        }
    }

    public String getVersion() {
        return "$Id: NumberImage.java,v 1.12 2005/04/28 14:32:24 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

