/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanImage;
import fr.esrf.tangoatk.core.IBooleanImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class BooleanImageHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;
    boolean[][] retval = new boolean[1][1];

    public BooleanImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireImageValueChanged(boolean[][] blArray, long l) {
        this.propChanges.fireBooleanImageEvent((IBooleanImage)this.attribute, blArray, l);
    }

    void insert(boolean[] blArray) {
        this.attribute.getAttribute().insert(blArray, this.attribute.getXDimension(), this.attribute.getYDimension());
    }

    boolean[] flatten(boolean[][] blArray) {
        int n = blArray.length * blArray[0].length;
        boolean[] blArray2 = new boolean[n];
        int n2 = 0;
        while (n2 < blArray.length) {
            System.arraycopy(blArray[n2], 0, blArray2, n2 * blArray.length, blArray.length);
            ++n2;
        }
        return blArray2;
    }

    boolean[][] getBooleanImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        boolean[] blArray = deviceAttribute.extractBooleanArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new boolean[n][n2];
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                this.retval[n4][n5] = blArray[n3++];
                ++n5;
            }
            ++n4;
        }
        return this.retval;
    }

    void addBooleanImageListener(IBooleanImageListener iBooleanImageListener) {
        this.propChanges.addBooleanImageListener(iBooleanImageListener);
    }

    void removeBooleanImageListener(IBooleanImageListener iBooleanImageListener) {
        this.propChanges.removeBooleanImageListener(iBooleanImageListener);
    }

    public String getVersion() {
        return "$Id: BooleanImageHelper.java,v 1.1 2005/02/09 12:48:41 poncet Exp $";
    }
}

