/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DisplayLevelProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.FormatProperty;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.NumberProperty;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringProperty;
import fr.esrf.tangoatk.core.WritableProperty;
import fr.esrf.tangoatk.core.util.AtkTimer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AAttribute
implements IAttribute,
ITangoPeriodicListener,
ITangoChangeListener {
    protected Device device;
    protected transient AttributeInfo config;
    protected DeviceAttribute attribute;
    protected String error;
    protected EventSupport propChanges;
    protected Map propertyMap;
    protected String nameSansDevice;
    protected String name;
    protected transient AtkTimer timer;
    protected String state = "OK";
    protected long timeStamp;
    protected boolean skippingRefresh = false;
    protected String alias;
    protected long refreshCount = 0L;
    protected long changeCount = 0L;
    protected long periodicCount = 0L;
    protected DevFailed eventError = null;
    private boolean hasEvents = false;
    private static String VERSION = "$Id: AAttribute.java,v 1.24 2005/06/15 10:02:54 jlpons Exp $";

    public String getVersion() {
        return VERSION;
    }

    protected AAttribute() {
        if (this.propChanges == null) {
            this.propChanges = new EventSupport();
        }
    }

    protected void serializeInit() throws IOException {
        System.out.print(this.name + "...");
        this.timer = AtkTimer.getInstance();
        try {
            AttributeInfo attributeInfo = this.getDevice().getAttributeInfo(this.name);
            this.init(this.device, this.nameSansDevice, attributeInfo);
            System.out.println("Done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    protected void init(Device device, String string, AttributeInfo attributeInfo) {
        block3: {
            AAttribute aAttribute = this;
            this.timer = aAttribute.timer.getInstance();
            this.propertyMap = new HashMap();
            this.setDevice(device);
            this.nameSansDevice = string;
            this.setName(this.device + "/" + string);
            this.setConfiguration(attributeInfo);
            if (device.doesEvent()) {
                this.subscribeAttributeEvent();
            }
            if (this.hasEvents) break block3;
            try {
                this.readFirstValueFromNetwork();
            }
            catch (DevFailed devFailed) {
                this.readAttError("Couldn't read from network", new ConnectionException(devFailed));
            }
        }
    }

    private void subscribeAttributeEvent() {
        TangoEventsAdapter tangoEventsAdapter = null;
        String[] stringArray = new String[]{};
        try {
            tangoEventsAdapter = new TangoEventsAdapter((DeviceProxy)this.getDevice());
        }
        catch (DevFailed devFailed) {
            this.hasEvents = false;
            return;
        }
        long l = System.currentTimeMillis();
        try {
            tangoEventsAdapter.addTangoChangeListener((ITangoChangeListener)this, this.nameSansDevice, stringArray);
            this.hasEvents = true;
            this.trace(2, "AATtribute.subscribeAttributeEvent(" + this.name + ") ok:", l);
        }
        catch (DevFailed devFailed) {
            this.hasEvents = false;
            this.eventError = devFailed;
            this.trace(1, "AATtribute.subscribeAttributeEvent(" + this.name + ") failed:", l);
        }
    }

    public boolean hasEvents() {
        return this.hasEvents;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public long getChangeCount() {
        return this.changeCount;
    }

    public long getPeriodicCount() {
        return this.periodicCount;
    }

    public String getSubscriptionError() {
        if (!this.getDevice().doesEvent()) {
            return "ATK does not manage event for the parent device " + this.getDevice().getName() + " (IDL<3)";
        }
        if (this.eventError != null) {
            return this.eventError.errors[0].desc;
        }
        return "";
    }

    public DeviceAttribute getDeviceAttribute() {
        return this.attribute;
    }

    public void setProperty(String string, Number number) {
        NumberProperty numberProperty = (NumberProperty)this.propertyMap.get(string);
        if (numberProperty == null) {
            this.timer.endTimer(Thread.currentThread());
            return;
        }
        numberProperty.setValue(number);
    }

    protected void setProperty(String string, Object object, boolean bl) {
        this.propertyMap.put(string, new Property(this, string, object, bl));
    }

    public void setProperty(String string, Number number, boolean bl) {
        Property property = (Property)this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new NumberProperty((IEntity)this, string, number, bl));
        } else {
            property.setValue(number);
        }
    }

    protected void setProperty(String string, AttrWriteType attrWriteType, boolean bl) {
        Property property = (Property)this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new WritableProperty(this, string, attrWriteType, bl));
        } else {
            property.setValue(attrWriteType);
        }
    }

    protected void setProperty(String string, AttrDataFormat attrDataFormat, boolean bl) {
        this.timer.startTimer(Thread.currentThread());
        Property property = (Property)this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new FormatProperty(this, string, attrDataFormat, bl));
        } else {
            property.setValue(attrDataFormat);
        }
        this.timer.endTimer(Thread.currentThread());
    }

    protected void setProperty(String string, DispLevel dispLevel, boolean bl) {
        Property property = (Property)this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new DisplayLevelProperty((IEntity)this, string, dispLevel, bl));
        } else {
            property.setValue(dispLevel);
        }
    }

    protected void setProperty(String string, String string2, boolean bl) {
        Property property = (Property)this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new StringProperty((IEntity)this, string, string2, bl));
        } else {
            property.setValue(string2);
        }
    }

    public void setProperty(String string, Object object) {
        Property property = (Property)this.propertyMap.get(string);
        property.setValue(object);
    }

    public String toString() {
        return this.name;
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }

    public EventSupport getPropChanges() {
        return this.propChanges;
    }

    public String getType() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.config.data_type;
        switch (n) {
            case 2: {
                stringBuffer.append("Short");
                break;
            }
            case 6: {
                stringBuffer.append("UShort");
                break;
            }
            case 19: {
                stringBuffer.append("State");
                break;
            }
            case 1: {
                stringBuffer.append("Boolean");
                break;
            }
            case 5: {
                stringBuffer.append("Double");
                break;
            }
            case 3: {
                stringBuffer.append("Long");
                break;
            }
            case 8: {
                stringBuffer.append("String");
            }
        }
        AttrDataFormat attrDataFormat = this.config.data_format;
        switch (attrDataFormat.value()) {
            case 0: {
                stringBuffer.append("Scalar");
                break;
            }
            case 1: {
                stringBuffer.append("Spectrum");
                break;
            }
            case 2: {
                stringBuffer.append("Image");
            }
        }
        return stringBuffer.toString();
    }

    public void storeConfig() {
        Property property;
        if (this.getProperty("unit").isSpecified()) {
            this.config.unit = this.getProperty("unit").getStringValue();
        }
        if (this.getProperty("standard_unit").isSpecified()) {
            this.config.standard_unit = this.getProperty("standard_unit").getStringValue();
        }
        if (this.getProperty("format").isSpecified()) {
            this.config.format = this.getProperty("format").getStringValue();
        }
        if (this.getProperty("data_type").isSpecified()) {
            this.config.data_type = this.getProperty("data_type").getIntValue();
        }
        if (this.getProperty("max_dim_x").isSpecified()) {
            this.config.max_dim_x = this.getProperty("max_dim_x").getIntValue();
        }
        if (this.getProperty("max_dim_y").isSpecified()) {
            this.config.max_dim_y = this.getProperty("max_dim_y").getIntValue();
        }
        if (this.getProperty("description").isSpecified()) {
            this.config.description = this.getProperty("description").getStringValue();
        }
        if (this.getProperty("label").isSpecified()) {
            this.config.label = this.getProperty("label").getStringValue();
        }
        if (this.getProperty("display_unit").isSpecified()) {
            this.config.display_unit = this.getProperty("display_unit").getStringValue();
        }
        if ((property = this.getProperty("min_value")) != null && property.isSpecified()) {
            this.config.min_value = property.getStringValue();
        }
        if ((property = this.getProperty("max_value")) != null && property.isSpecified()) {
            this.config.max_value = property.getStringValue();
        }
        if ((property = this.getProperty("min_alarm")) != null && property.isSpecified()) {
            this.config.min_alarm = property.getStringValue();
        }
        if ((property = this.getProperty("max_alarm")) != null && property.isSpecified()) {
            this.config.max_alarm = property.getStringValue();
        }
        try {
            this.device.storeInfo(this.config);
            this.setConfiguration(this.device.getAttributeInfo(this.getName()));
            this.getState();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't store config", new AttributeSetException(devFailed));
        }
    }

    public String getFormat() {
        return this.getProperty("format").getStringValue();
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.propChanges.addErrorListener(iErrorListener);
    }

    public void removeErrorListener(IErrorListener iErrorListener) {
        this.propChanges.removeErrorListener(iErrorListener);
    }

    public void addSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.propChanges.addSetErrorListener(iSetErrorListener);
    }

    public void removeSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.propChanges.removeSetErrorListener(iSetErrorListener);
    }

    public void addStateListener(IAttributeStateListener iAttributeStateListener) {
        this.propChanges.addAttributeStateListener(iAttributeStateListener);
    }

    public void removeStateListener(IAttributeStateListener iAttributeStateListener) {
        this.propChanges.removeAttributeStateListener(iAttributeStateListener);
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Device getDevice() {
        return this.device;
    }

    protected void readAttError(String string, Throwable throwable) {
        this.propChanges.fireReadErrorEvent(this, throwable);
    }

    protected void setAttError(String string, Throwable throwable) {
        this.propChanges.fireSetErrorEvent(this, throwable);
    }

    public String getUnit() {
        return this.getProperty("unit").getStringValue();
    }

    void refreshProperties() {
        Iterator iterator = this.getPropertyMap().values().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            property.refresh();
        }
    }

    public Property getProperty(String string) {
        this.timer.startTimer(Thread.currentThread());
        Property property = null;
        if (this.propertyMap != null) {
            property = (Property)this.propertyMap.get(string);
        }
        this.timer.endTimer(Thread.currentThread());
        return property;
    }

    public double getStandardUnit() {
        return new Double(this.getProperty("standard_unit").getStringValue());
    }

    public String getDisplayUnit() {
        return this.getProperty("display_unit").getStringValue();
    }

    public String getLabel() {
        return this.getProperty("label").getStringValue();
    }

    public void setLabel(String string) {
        this.setProperty("label", string, true);
    }

    public void setName(String string) {
        this.name = string;
        this.setProperty("name", string, false);
    }

    public void setDescription(String string) {
        this.setProperty("description", string, true);
    }

    public String getDescription() {
        return this.getProperty("description").getStringValue();
    }

    public int getLevel() {
        return this.getProperty("level").getIntValue();
    }

    public boolean isOperator() {
        Property property = this.getProperty("level");
        if (property != null && property instanceof DisplayLevelProperty) {
            DisplayLevelProperty displayLevelProperty = (DisplayLevelProperty)property;
            return displayLevelProperty.isOperator();
        }
        return false;
    }

    public boolean isExpert() {
        Property property = this.getProperty("level");
        if (property != null && property instanceof DisplayLevelProperty) {
            DisplayLevelProperty displayLevelProperty = (DisplayLevelProperty)property;
            return displayLevelProperty.isExpert();
        }
        return false;
    }

    protected void setConfiguration(AttributeInfo attributeInfo) {
        this.timer.startTimer(Thread.currentThread());
        this.config = attributeInfo;
        this.setProperty("unit", this.config.unit, false);
        this.setProperty("data_format", this.config.data_format, false);
        this.setProperty("format", this.config.format, true);
        this.setProperty("data_type", new Integer(this.config.data_type), false);
        this.setProperty("description", this.config.description, true);
        this.setProperty("label", this.config.label, true);
        this.setProperty("writable", this.config.writable, false);
        this.setProperty("writable_attr_name", this.config.writable_attr_name, false);
        if ("None".equals(this.config.writable_attr_name)) {
            this.getProperty("writable_attr_name").setSpecified(false);
        }
        this.setProperty("display_unit", this.config.display_unit, true);
        this.setProperty("max_dim_x", new Integer(this.config.max_dim_x), false);
        this.setProperty("max_dim_y", new Integer(this.config.max_dim_y), false);
        this.setProperty("level", this.config.level, false);
        try {
            this.setProperty("standard_unit", new Double(this.config.standard_unit), false);
        }
        catch (NumberFormatException numberFormatException) {
            this.setProperty("standard_unit", new Double(Double.NaN), false);
            this.getProperty("standard_unit").setSpecified(false);
        }
        this.timer.endTimer(Thread.currentThread());
    }

    public static String[] getPropertyNames() {
        String[] stringArray = new String[]{"name", "unit", "data_format", "data_type", "description", "label", "writable", "writable_attr_name", "display_unit", "max_dim_x", "max_dim_y", "level", "standard_unit", "min_value", "max_value", "min_alarm", "max_alarm"};
        return stringArray;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSansDevice() {
        return this.nameSansDevice;
    }

    public boolean isWritable() {
        AttrWriteType attrWriteType = (AttrWriteType)this.getProperty("writable").getValue();
        return attrWriteType == AttrWriteType.WRITE || attrWriteType == AttrWriteType.READ_WRITE;
    }

    private final void readFirstValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttribute(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
    }

    protected final DeviceAttribute readValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttribute(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
        return this.attribute;
    }

    protected final DeviceAttribute readDeviceValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttributeFromDevice(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
        return this.attribute;
    }

    protected void setState() throws DevFailed {
        AttrQuality attrQuality = this.attribute.getQuality();
        if (0 == attrQuality.value()) {
            this.setState("VALID");
            return;
        }
        if (1 == attrQuality.value()) {
            this.setState("INVALID");
            return;
        }
        if (2 == attrQuality.value()) {
            this.setState("ALARM");
            return;
        }
        if (4 == attrQuality.value()) {
            this.setState("WARNING");
            return;
        }
        if (3 == attrQuality.value()) {
            this.setState("CHANGING");
            return;
        }
        this.setState("UNKNOWN");
    }

    protected void setState(DeviceAttribute deviceAttribute) throws DevFailed {
        AttrQuality attrQuality = deviceAttribute.getQuality();
        if (0 == attrQuality.value()) {
            this.setState("VALID");
            return;
        }
        if (1 == attrQuality.value()) {
            this.setState("INVALID");
            return;
        }
        if (2 == attrQuality.value()) {
            this.setState("ALARM");
            return;
        }
        if (4 == attrQuality.value()) {
            this.setState("WARNING");
            return;
        }
        if (3 == attrQuality.value()) {
            this.setState("CHANGING");
            return;
        }
        this.setState("UNKNOWN");
    }

    public DeviceAttribute getAttribute() {
        return this.attribute;
    }

    protected void setState(String string) {
        this.state = string;
        this.propChanges.fireAttributeStateEvent(this, string);
    }

    public String getState() {
        try {
            this.readValueFromNetwork();
        }
        catch (DevFailed devFailed) {
            this.readAttError("Couldn't read from network", new ConnectionException(devFailed));
            return "UNKNOWN";
        }
        catch (Exception exception) {
            this.readAttError("Couldn't read from network", exception);
            return "UNKNOWN";
        }
        return this.state;
    }

    protected void writeAtt() throws DevFailed {
        this.device.writeAttribute(this.attribute);
    }

    public void addImageListener(IImageListener iImageListener) {
        this.propChanges.addImageListener(iImageListener);
    }

    public void removeImageListener(IImageListener iImageListener) {
        this.propChanges.removeImageListener(iImageListener);
    }

    public int getMaxXDimension() {
        return this.getProperty("max_dim_x").getIntValue();
    }

    public int getMaxYDimension() {
        return this.getProperty("max_dim_y").getIntValue();
    }

    public int getYDimension() {
        try {
            return this.attribute.getDimY();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getHeight() {
        return this.getYDimension();
    }

    public int getXDimension() {
        try {
            return this.attribute.getDimX();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getWidth() {
        return this.getYDimension();
    }

    public void setSkippingRefresh(boolean bl) {
        this.skippingRefresh = bl;
    }

    public boolean isSkippingRefresh() {
        return this.skippingRefresh;
    }

    protected void checkDimensions(Object[][] objectArray) {
        if (objectArray.length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (objectArray[0].length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkDimensions(double[][] dArray) {
        if (dArray[0].length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (dArray.length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkDimensions(boolean[][] blArray) {
        if (blArray[0].length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (blArray.length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static String[] flatten(String[][] stringArray) {
        int n = stringArray.length * stringArray[0].length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            System.arraycopy(stringArray[n2], 0, stringArray2, n2 * stringArray.length, stringArray.length);
            ++n2;
        }
        return stringArray2;
    }

    protected final DeviceDataHistory[] readAttHistoryFromNetwork() throws DevFailed {
        return this.device.attribute_history(this.nameSansDevice);
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }
}

