/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IRefreshee;
import fr.esrf.tangoatk.core.Refresher;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class DeviceFactory
implements IRefreshee,
Serializable {
    public static final int TRACE_NONE = 0;
    public static final int TRACE_FAIL = 1;
    public static final int TRACE_SUCCESS = 2;
    public static final int TRACE_REFRESHER = 4;
    public static final int TRACE_ATTREFRESHER = 8;
    public static final int TRACE_COMMAND = 16;
    public static final int TRACE_CHANGE_EVENT = 32;
    public static final int TRACE_STATE_REFRESHER = 64;
    public static final int TRACE_DEVFACTORY = 256;
    public static final int TRACE_ATTFACTORY = 512;
    public static final int TRACE_CMDFACTORY = 1024;
    public static final int TRACE_ALL = 255;
    private int traceMode = 0;
    private Object deviceMonitor = new Object();
    private String[] deviceNames = new String[0];
    private Vector devices = new Vector();
    private static DeviceFactory instance;
    protected int refreshInterval = 1000;
    protected Refresher refresher = null;
    protected static boolean autoStart;

    private DeviceFactory() {
    }

    public static DeviceFactory getInstance() {
        if (instance == null) {
            instance = new DeviceFactory();
        }
        return instance;
    }

    public void setTraceMode(int n) {
        this.traceMode = n;
    }

    public int getTraceMode() {
        return this.traceMode;
    }

    public void trace(int n, String string, long l) {
        if ((this.traceMode & n) != 0) {
            long l2 = System.currentTimeMillis();
            if (l >= 0L) {
                System.out.println(string + " : " + Long.toString(l2 - l) + " ms");
            } else {
                System.out.println(string);
            }
        }
    }

    public void setRefreshInterval(int n) {
        this.refreshInterval = n;
        if (this.refresher != null) {
            this.refresher.setRefreshInterval(this.refreshInterval);
        }
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void stopRefresher() {
        if (this.refresher != null) {
            this.refresher.stopRunning();
        }
        this.refresher = null;
    }

    public void startRefresher() {
        if (this.refresher == null) {
            this.refresher = new Refresher("device");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
            this.refresher.addRefreshee(this);
        }
        this.refresher.start();
    }

    public boolean isRefreshing() {
        if (this.refresher == null) {
            return false;
        }
        return this.refresher.isRunning();
    }

    public void setRefresher(Refresher refresher) {
        this.refresher = refresher;
    }

    public boolean isDevice(String string) {
        try {
            this.getDevice(string);
        }
        catch (ConnectionException connectionException) {
            System.out.println("DeviceFactory.isDevice(" + string + ") : " + connectionException.getErrors()[0].desc);
            return false;
        }
        catch (Exception exception) {
            System.out.println("DeviceFactory.isDevice(" + string + ") : Unexpected exception caught...");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Device getDevice(String string) throws ConnectionException {
        Device device = null;
        String string2 = string.toLowerCase();
        int n = Arrays.binarySearch(this.deviceNames, string2);
        if (n >= 0) {
            device = (Device)this.devices.get(n);
        }
        if (n < 0) {
            long l = System.currentTimeMillis();
            try {
                device = new Device(string);
                this.trace(2, "DeviceFactory.getDevice(" + string + ") ok", l);
            }
            catch (DevFailed devFailed) {
                this.trace(1, "DeviceFactory.getDevice(" + string + ") failed", l);
                throw new ConnectionException(devFailed);
            }
            int n2 = -(n + 1);
            int n3 = this.deviceNames.length;
            String[] stringArray = new String[n3 + 1];
            System.arraycopy(this.deviceNames, 0, stringArray, 0, n2);
            System.arraycopy(this.deviceNames, n2, stringArray, n2 + 1, n3 - n2);
            stringArray[n2] = string2;
            Object object = this.deviceMonitor;
            synchronized (object) {
                this.devices.add(n2, device);
                this.deviceNames = stringArray;
            }
            this.dumpFactory("Adding " + string2);
            if (autoStart) {
                this.startRefresher();
            }
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object[] objectArray;
        Object object = this.deviceMonitor;
        synchronized (object) {
            objectArray = this.devices.toArray();
        }
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < objectArray.length) {
            Device device = (Device)objectArray[n];
            if (device.getPropChanges().getListenerCount() > 0) {
                device.refresh();
            }
            ++n;
        }
        this.trace(64, "DeviceFactory.refresh() Loop time", l);
    }

    private void dumpFactory(String string) {
        if ((this.traceMode & 0x100) != 0) {
            System.out.println("-- DeviceFactory : " + string + " --");
            int n = 0;
            while (n < this.deviceNames.length) {
                System.out.println("  " + n + ":" + this.deviceNames[n]);
                ++n;
            }
            System.out.println("-- DeviceFactory --------------------------------------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteDevice(String string) {
        String string2 = string.toLowerCase();
        int n = Arrays.binarySearch(this.deviceNames, string2);
        if (n >= 0) {
            int n2 = this.deviceNames.length;
            String[] stringArray = new String[n2 - 1];
            System.arraycopy(this.deviceNames, 0, stringArray, 0, n);
            System.arraycopy(this.deviceNames, n + 1, stringArray, n, n2 - n - 1);
            Object object = this.deviceMonitor;
            synchronized (object) {
                this.deviceNames = stringArray;
                this.devices.remove(n);
            }
            this.dumpFactory("Removing " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDeviceNames() {
        Vector<String> vector = new Vector<String>();
        Object object = this.deviceMonitor;
        synchronized (object) {
            int n = 0;
            while (n < this.deviceNames.length) {
                vector.add(this.deviceNames[n]);
                ++n;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device[] getDevices() {
        Device[] deviceArray = null;
        Object object = this.deviceMonitor;
        synchronized (object) {
            deviceArray = new Device[this.devices.size()];
            int n = 0;
            while (n < this.devices.size()) {
                deviceArray[n] = (Device)this.devices.get(n);
                ++n;
            }
        }
        return deviceArray;
    }

    public static void setAutoStart(boolean bl) {
        autoStart = bl;
    }

    public static boolean isAutoStart() {
        return autoStart;
    }

    public String getVersion() {
        return "$Id: DeviceFactory.java,v 1.15 2005/06/14 08:02:43 poncet Exp $";
    }

    static {
        autoStart = true;
    }
}

