/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEntity;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public abstract class AEntityFactory
implements TangoConst,
Serializable {
    private DeviceFactory deviceFactory = DeviceFactory.getInstance();

    public static String extractDeviceName(String string) {
        int n = string.lastIndexOf("/");
        return string.substring(0, n);
    }

    public static String getFQName(Device device, String string) {
        return device.toString() + "/" + string;
    }

    public static String extractEntityName(String string) {
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public static boolean isWildCard(String string) {
        return string.indexOf("*") != -1;
    }

    protected Device getDevice(String string) throws ConnectionException {
        return this.deviceFactory.getDevice(string);
    }

    public List getEntities(String string) throws ConnectionException {
        try {
            List<IEntity> list;
            Device device = this.getDevice(AEntityFactory.extractDeviceName(string));
            if (!AEntityFactory.isWildCard(string)) {
                list = new Vector<IEntity>();
                list.add(this.getSingleEntity(string, device));
            } else {
                list = this.getWildCardEntities(string, device);
            }
            return list;
        }
        catch (DevFailed devFailed) {
            throw new ConnectionException(devFailed);
        }
    }

    protected abstract List getWildCardEntities(String var1, Device var2) throws DevFailed;

    protected abstract IEntity getSingleEntity(String var1, Device var2) throws DevFailed;

    public abstract int getSize();

    public abstract String getVersion();
}

