/*
 * Decompiled with CFR 0.152.
 */
package MStatus;

import MStatus.devPopup;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.IconNumberScalarViewer;
import fr.esrf.tangoatk.widget.device.IDevicePopUp;
import fr.esrf.tangoatk.widget.device.SimpleStateViewer;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class Alarm {
    public static Database db = null;
    static ImageIcon icon_no = null;
    static ImageIcon icon_audio = null;
    static ImageIcon icon_i = null;
    static boolean classInited = false;
    int nb;
    String title;
    String[] dev_names;
    JPanel panel1;
    JPanel panel2;
    JPanel[] sub_panels;
    JLabel label;
    SimpleStateViewer[] states;
    IconNumberScalarViewer[] icons;
    Device[] devices;
    AttributeList attributes;

    public Alarm() {
        this.initStatic();
        this.title = "";
        this.devices = null;
        this.dev_names = null;
    }

    public Alarm(String string, String[] stringArray, Font font, Splash splash, int n, double d) {
        this.initStatic();
        this.nb = stringArray.length;
        this.title = string;
        this.dev_names = stringArray;
        this.states = new SimpleStateViewer[this.nb];
        this.icons = new IconNumberScalarViewer[2 * this.nb];
        this.attributes = new AttributeList();
        this.devices = new Device[this.nb];
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.label = new JLabel();
        this.sub_panels = new JPanel[this.nb];
        this.panel1.setLayout(new BorderLayout());
        this.panel1.setBorder(new EtchedBorder());
        this.label.setText(this.title);
        this.label.setForeground(Color.black);
        this.label.setHorizontalAlignment(0);
        this.label.setFont(new Font("Dialog", 0, 12));
        this.panel1.add((Component)this.label, "North");
        int n2 = this.nb / 4;
        if (this.nb % 4 != 0) {
            ++n2;
        }
        this.panel2.setLayout(new GridLayout(n2, 4));
        for (int i = 0; i < this.nb; ++i) {
            this.states[i] = this.CreateStateViewer(stringArray[i], font);
            try {
                this.devices[i] = DeviceFactory.getInstance().getDevice(stringArray[i]);
                this.states[i].setModel(this.devices[i]);
                this.states[i].getPopUp().setModel(this.devices[i]);
            }
            catch (Exception exception) {
                System.out.println(stringArray[i] + " : " + exception.toString());
            }
            this.icons[2 * i + 0] = this.CreateIcon(icon_audio, stringArray[i] + "/VoiceState");
            this.icons[2 * i + 1] = this.CreateIcon(icon_i, stringArray[i] + "/Inhibited");
            this.sub_panels[i] = new JPanel();
            this.sub_panels[i].setLayout(new GridBagLayout());
            this.AddToPanel((Component)this.states[i], 0, 0, 2, 0.9, 1.0, this.sub_panels[i]);
            this.AddToPanel((Component)this.icons[2 * i + 0], 1, 0, 1, 0.1, 1.0, this.sub_panels[i]);
            this.AddToPanel((Component)this.icons[2 * i + 1], 1, 1, 1, 0.1, 1.0, this.sub_panels[i]);
            this.panel2.add(this.sub_panels[i]);
            if (splash == null) continue;
            splash.progress(n + (int)(d * (double)(i + 1) / (double)this.nb));
        }
        this.panel1.add((Component)this.panel2, "Center");
        this.attributes.startRefresher();
    }

    private void initStatic() {
        if (!classInited) {
            try {
                db = ApiUtil.get_db_obj();
                icon_no = new ImageIcon(this.getClass().getResource("/MStatus/icon_no.gif"));
                icon_audio = new ImageIcon(this.getClass().getResource("/MStatus/icon_audio.gif"));
                icon_i = new ImageIcon(this.getClass().getResource("/MStatus/icon_i.gif"));
            }
            catch (Exception exception) {
                System.out.println("Fatal initialisation error : " + exception.toString());
                exception.printStackTrace();
                System.exit(0);
            }
            classInited = true;
        }
    }

    private SimpleStateViewer CreateStateViewer(String string, Font font) {
        SimpleStateViewer simpleStateViewer = new SimpleStateViewer();
        simpleStateViewer.setFont(font);
        simpleStateViewer.setPopUp((IDevicePopUp)new devPopup());
        simpleStateViewer.setBorder((Border)new EtchedBorder(new Color(204, 204, 204), Color.gray));
        simpleStateViewer.setHorizontalAlignment(JSmoothLabel.CENTER_ALIGNMENT);
        simpleStateViewer.setSizingBehavior(JSmoothLabel.MATRIX_BEHAVIOR);
        try {
            String string2 = db.get_device_property(string, "label").extractString();
            simpleStateViewer.setText(string2.toUpperCase());
        }
        catch (Exception exception) {
            simpleStateViewer.setText(string.substring(string.lastIndexOf("/") + 1).toUpperCase());
        }
        return simpleStateViewer;
    }

    private IconNumberScalarViewer CreateIcon(ImageIcon imageIcon, String string) {
        Icon[] iconArray = new Icon[2];
        IconNumberScalarViewer iconNumberScalarViewer = new IconNumberScalarViewer();
        iconArray[0] = icon_no;
        iconArray[1] = imageIcon;
        iconNumberScalarViewer.setIcons(iconArray);
        try {
            INumberScalar iNumberScalar = (INumberScalar)this.attributes.add(string);
            iconNumberScalarViewer.setModel(iNumberScalar);
        }
        catch (ConnectionException connectionException) {
            iconNumberScalarViewer.setPreferredSize(new Dimension(icon_no.getIconWidth(), icon_no.getIconHeight()));
            System.out.println("Warning , " + string + " :" + connectionException.getDescription());
        }
        return iconNumberScalarViewer;
    }

    private void AddToPanel(Component component, int n, int n2, int n3, double d, double d2, JPanel jPanel) {
        if (component != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridheight = n3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = d;
            gridBagConstraints.weighty = d2;
            jPanel.add(component, gridBagConstraints);
        }
    }
}

