/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttributeValueHelper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevErrorListHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierHelper;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.StructuredPushConsumerPOA;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;

public class EventConsumer
extends StructuredPushConsumerPOA
implements TangoConst,
Runnable {
    private static EventConsumer instance = null;
    private static int subscribe_event_id = 0;
    private static final long EVENT_HEARTBEAT_PERIOD = 10000L;
    private static final long EVENT_RESUBSCRIBE_PERIOD = 600000L;
    private EventChannel eventChannel;
    private ConsumerAdmin consumerAdmin;
    private int proxyId;
    private ProxySupplier proxySupplier;
    private StructuredProxyPushSupplier structuredProxyPushSupplier;
    private ORB orb;
    private Database tango_db = ApiUtil.get_db_obj();
    private Hashtable channel_map;
    private Hashtable device_channel_map = null;
    private Hashtable event_callback_map;
    private Thread runner;
    private Timer keepAliveTimer;
    private boolean orbRunning = false;

    public static EventConsumer create() throws DevFailed {
        if (instance != null) {
            return instance;
        }
        return new EventConsumer();
    }

    public void disconnect_structured_push_consumer() {
        System.out.println("calling EventConsumer.disconnect_structured_push_consumer()");
    }

    public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        System.out.println("calling EventConsumer.offer_change()");
    }

    public void push_structured_event(StructuredEvent structuredEvent) {
        long l = System.currentTimeMillis();
        String string = structuredEvent.header.fixed_header.event_type.domain_name;
        String string2 = structuredEvent.header.fixed_header.event_type.type_name;
        String string3 = structuredEvent.header.fixed_header.event_name;
        try {
            if (string3.equals("heartbeat")) {
                if (this.channel_map.containsKey(string)) {
                    EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string);
                    eventChannelStruct.last_heartbeat = System.currentTimeMillis();
                }
            } else {
                String string4 = string + "." + string3;
                if (this.event_callback_map.containsKey(string4)) {
                    EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)this.event_callback_map.get(string4);
                    CallBack callBack = eventCallBackStruct.callback;
                    if (callBack != null) {
                        DeviceAttribute deviceAttribute = null;
                        DevError[] devErrorArray = null;
                        TypeCode typeCode = structuredEvent.remainder_of_body.type();
                        if (typeCode.kind().equals(TCKind.tk_struct)) {
                            deviceAttribute = new DeviceAttribute(AttributeValueHelper.extract(structuredEvent.remainder_of_body));
                        } else {
                            devErrorArray = DevErrorListHelper.extract(structuredEvent.remainder_of_body);
                        }
                        EventData eventData = new EventData(eventCallBackStruct.device, string, string3, deviceAttribute, devErrorArray);
                        callBack.push_event(eventData);
                    }
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof DevFailed) {
                Except.print_exception(exception);
            }
            exception.printStackTrace();
        }
    }

    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, CallBack callBack, String[] stringArray) throws DevFailed {
        String string2;
        String string3;
        if (deviceProxy == null || callBack == null) {
            Except.throw_wrong_syntax_exception("API_InvalidArgs", "Device or callback pointer NULL !!", "EventConsumer.subscribe_event()");
        }
        switch (n) {
            case 0: {
                string3 = "change";
                break;
            }
            case 1: {
                string3 = "quality_change";
                break;
            }
            case 2: {
                string3 = "periodic";
                break;
            }
            case 3: {
                string3 = "archive";
                break;
            }
            case 4: {
                string3 = "user_event";
                break;
            }
            default: {
                string3 = "unknown";
            }
        }
        String string4 = deviceProxy.name().toLowerCase() + "/" + string + "." + string3;
        if (this.event_callback_map.containsKey(string4)) {
            Except.throw_event_system_failed("API_MethodArgument", "Already connected to event " + string4, "EventConsumer.subscribe_event()");
        }
        if (!this.device_channel_map.containsKey(string2 = deviceProxy.name())) {
            this.connect(deviceProxy);
            if (!this.device_channel_map.containsKey(string2)) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect to event channel for device", "EventConsumer.subscribe_event()");
            }
        }
        String string5 = (String)this.device_channel_map.get(string2);
        DeviceData deviceData = new DeviceData();
        String[] stringArray2 = new String[]{string2, string, "subscribe", string3};
        deviceData.insert(stringArray2);
        EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string5);
        eventChannelStruct.adm_device_proxy.command_inout("EventSubscriptionChange", deviceData);
        eventChannelStruct.last_subscribed = System.currentTimeMillis();
        EventCallBackStruct eventCallBackStruct = new EventCallBackStruct();
        eventCallBackStruct.device = deviceProxy;
        eventCallBackStruct.attr_name = string;
        eventCallBackStruct.event_name = string3;
        eventCallBackStruct.channel_name = string5;
        eventCallBackStruct.callback = callBack;
        eventCallBackStruct.id = ++subscribe_event_id;
        String string6 = "$domain_name == '" + string2.toLowerCase() + "/" + string.toLowerCase() + "'" + " and $event_name == '" + string3 + "'";
        if (stringArray != null && stringArray.length != 0) {
            string6 = string6 + " and ((";
            for (int i = 0; i < stringArray.length; ++i) {
                string6 = string6 + stringArray[i];
            }
            string6 = string6 + " ) and $forced_event > 0.5 )";
        }
        eventCallBackStruct.filter_id = this.add_filter_for_channel(eventChannelStruct, string6);
        eventCallBackStruct.filter_constraint = string6;
        eventCallBackStruct.filter_ok = true;
        this.event_callback_map.put(string4, eventCallBackStruct);
        if (n == 0 || n == 2 || n == 1 || n == 3 || n == 4) {
            new PushAttrValueLater(deviceProxy, string, string3, callBack).start();
        }
        return subscribe_event_id;
    }

    public void unsubscribe_event(int n) throws DevFailed {
        Enumeration enumeration = this.event_callback_map.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)this.event_callback_map.get(string);
            if (eventCallBackStruct.id != n) continue;
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(eventCallBackStruct.channel_name);
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(eventCallBackStruct.filter_id);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(eventCallBackStruct.filter_id);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {
                Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, caught exception while calling remove_filter() (hint: check notification daemon is running)", "EventConsumer.unsubscribe_event()");
            }
            this.event_callback_map.remove(string);
            bl = true;
            break;
        }
        if (!bl) {
            Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, the event id (" + n + ") specified does not correspond with any known one", "EventConsumer.unsubscribe_event()");
        }
    }

    public void unsubscribe_device(DeviceProxy deviceProxy) {
    }

    public void connect(DeviceProxy deviceProxy) throws DevFailed {
        String string = deviceProxy.name();
        String string2 = null;
        try {
            string2 = deviceProxy.adm_name();
        }
        catch (DevFailed devFailed) {
            Except.throw_event_system_failed("API_BadConfigurationProperty", "Can't subscribe to event for device " + string + "\n Check that device server is running...", "EventConsumer.connect");
        }
        String string3 = string2;
        if (!this.channel_map.containsKey(string3)) {
            this.connect_event_channel(string3, false);
        }
        EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string3);
        eventChannelStruct.adm_device_proxy = deviceProxy.get_adm_dev();
        this.device_channel_map.put(string, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: {
            try {
                if (!ApiUtil.in_server()) {
                    this.keepAliveTimer.schedule((TimerTask)new KeepAliveThread(), 2000L, 10000L);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EventConsumer eventConsumer = this;
                    synchronized (eventConsumer) {
                        Object object = this.orb.resolve_initial_references("RootPOA");
                        POA pOA = POAHelper.narrow(object);
                        POAManager pOAManager = pOA.the_POAManager();
                        pOAManager.activate();
                    }
                    this.orbRunning = true;
                    this.orb.run();
                    this.orb.destroy();
                    break block8;
                }
                this.keepAliveTimer.schedule((TimerTask)new KeepAliveThread(), 2000L, 10000L);
            }
            catch (UserException userException) {
                System.out.println("EventConsumer.run() : Unable to start orb");
                userException.printStackTrace();
                System.exit(1);
            }
        }
    }

    private EventConsumer() throws DevFailed {
        this.orb = ApiUtil.get_orb();
        instance = this;
        this.channel_map = new Hashtable();
        this.device_channel_map = new Hashtable();
        this.device_channel_map.clear();
        this.event_callback_map = new Hashtable();
        this.keepAliveTimer = new Timer();
        this.runner = new Thread(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                EventConsumer.this.keepAliveTimer.cancel();
                EventConsumer.this.cleanup_heartbeat_filters();
                EventConsumer.this.cleanup_event_filters();
                if (EventConsumer.this.orbRunning) {
                    EventConsumer.this.orb.shutdown(true);
                    try {
                        EventConsumer.this.runner.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        });
        this.runner.start();
    }

    private void cleanup_heartbeat_filters() {
        Enumeration enumeration = this.channel_map.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string);
            try {
                int n = eventChannelStruct.heartbeat_filter_id;
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(n);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(n);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {}
        }
    }

    private void cleanup_event_filters() {
        Enumeration enumeration = this.event_callback_map.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)this.event_callback_map.get(string);
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(eventCallBackStruct.channel_name);
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(eventCallBackStruct.filter_id);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(eventCallBackStruct.filter_id);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {
                // empty catch block
            }
            this.event_callback_map.remove(string);
        }
    }

    private synchronized void connect_event_channel(String string, boolean bl) throws DevFailed {
        EventChannelStruct eventChannelStruct;
        java.lang.Object object;
        DbEventImportInfo dbEventImportInfo = null;
        try {
            dbEventImportInfo = this.tango_db.import_event(string);
        }
        catch (DevFailed devFailed) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", string + " has no event channel defined in the database\n" + " May be the server is not running or is not linked with Tango release 4.x (or above)", "EventConsumer.connect_event_channel");
        }
        String string2 = dbEventImportInfo.channel_ior;
        boolean bl2 = dbEventImportInfo.channel_exported;
        if (bl2) {
            object = this.orb.string_to_object(string2);
            try {
                this.eventChannel = EventChannelHelper.narrow((Object)object);
            }
            catch (RuntimeException runtimeException) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
            }
            if (this.eventChannel == null) {
                bl2 = false;
            }
        }
        if (!bl2) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to narrow EventChannel from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        this.consumerAdmin = this.eventChannel.default_consumer_admin();
        if (this.consumerAdmin == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get default consumer admin from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        object = new IntHolder();
        try {
            this.proxySupplier = this.consumerAdmin.obtain_notification_push_supplier(ClientType.STRUCTURED_EVENT, (IntHolder)object);
            if (this.proxySupplier == null) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
            }
            this.proxyId = ((IntHolder)object).value;
        }
        catch (AdminLimitExceeded adminLimitExceeded) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier due to AdminLimitExceeded (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        this.structuredProxyPushSupplier = StructuredProxyPushSupplierHelper.narrow(this.proxySupplier);
        if (this.structuredProxyPushSupplier == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to narrow the push supplier due to AdminLimitExceeded (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        try {
            this.structuredProxyPushSupplier.connect_structured_push_consumer(this._this(this.orb));
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            Except.throw_event_system_failed("API_NotificationServiceFailed", nullPointerException + " detected when subscribing to " + string, "EventConsumer.connect_event_channel");
        }
        catch (AlreadyConnected alreadyConnected) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect the push supplier due to CosEventChannelAdmin.AlreadyConnected.AlreadyConnected  exception", "EventConsumer.connect_event_channel");
        }
        catch (TypeError typeError) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect the push supplier due to CosEventChannelAdmin.AlreadyConnected.TypeError  exception", "EventConsumer.connect_event_channel");
        }
        if (bl) {
            eventChannelStruct = (EventChannelStruct)this.channel_map.get(string);
            eventChannelStruct.eventChannel = this.eventChannel;
            eventChannelStruct.structuredProxyPushSupplier = this.structuredProxyPushSupplier;
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            try {
                int n = eventChannelStruct.heartbeat_filter_id;
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(n);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(n);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {
                // empty catch block
            }
            String string3 = "$event_name == 'heartbeat'";
            eventChannelStruct.heartbeat_filter_id = this.add_filter_for_channel(eventChannelStruct, string3);
        } else {
            eventChannelStruct = new EventChannelStruct();
            eventChannelStruct.eventChannel = this.eventChannel;
            eventChannelStruct.structuredProxyPushSupplier = this.structuredProxyPushSupplier;
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.adm_device_proxy = null;
            String string4 = "$event_name == 'heartbeat'";
            eventChannelStruct.heartbeat_filter_id = this.add_filter_for_channel(eventChannelStruct, string4);
            this.channel_map.put(string, eventChannelStruct);
        }
    }

    private int add_filter_for_channel(EventChannelStruct eventChannelStruct, String string) throws DevFailed {
        ConstraintExp[] constraintExpArray;
        Filter filter = null;
        int n = -1;
        try {
            constraintExpArray = eventChannelStruct.eventChannel.default_filter_factory();
            filter = constraintExpArray.create_filter("EXTENDED_TCL");
        }
        catch (InvalidGrammar invalidGrammar) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Caught Invalid Grammar exception while creating heartbeat filter : check filter", "EventConsumer.add_filter_for_channel");
        }
        constraintExpArray = new ConstraintExp[]{new ConstraintExp()};
        constraintExpArray[0].event_types = new EventType[0];
        constraintExpArray[0].constraint_expr = string;
        try {
            filter.add_constraints(constraintExpArray);
            n = eventChannelStruct.structuredProxyPushSupplier.add_filter(filter);
        }
        catch (InvalidConstraint invalidConstraint) {
            filter.destroy();
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Caught InvalidConstraint exception while adding constraint for heartbeat : check filter", "EventConsumer.add_filter_for_channel");
        }
        return n;
    }

    class PushAttrValueLater
    extends Thread {
        private DeviceProxy device;
        private String attribute;
        private String event_name;
        private CallBack callback;

        PushAttrValueLater(DeviceProxy deviceProxy, String string, String string2, CallBack callBack) {
            this.device = deviceProxy;
            this.attribute = string;
            this.event_name = string2;
            this.callback = callBack;
        }

        public void run() {
            try {
                PushAttrValueLater.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DeviceAttribute deviceAttribute = null;
            DevError[] devErrorArray = null;
            String string = this.device.name() + "/" + this.attribute.toLowerCase();
            try {
                deviceAttribute = this.device.read_attribute(this.attribute);
            }
            catch (DevFailed devFailed) {
                devErrorArray = devFailed.errors;
            }
            EventData eventData = new EventData(this.device, string, this.event_name, deviceAttribute, devErrorArray);
            this.callback.push_event(eventData);
        }
    }

    private class KeepAliveThread
    extends TimerTask {
        public void run() {
            long l = 15000L;
            if (System.currentTimeMillis() - this.scheduledExecutionTime() >= l) {
                return;
            }
            this.resubscribe_if_needed();
        }

        private void resubscribe_if_needed() {
            Enumeration enumeration = EventConsumer.this.channel_map.keys();
            long l = System.currentTimeMillis();
            while (enumeration.hasMoreElements()) {
                boolean bl;
                java.lang.Object object;
                java.lang.Object object2;
                String string = (String)enumeration.nextElement();
                EventChannelStruct eventChannelStruct = (EventChannelStruct)EventConsumer.this.channel_map.get(string);
                if (l - eventChannelStruct.last_subscribed > 200000L) {
                    Enumeration enumeration2 = EventConsumer.this.event_callback_map.elements();
                    while (enumeration2.hasMoreElements()) {
                        EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration2.nextElement();
                        if (!eventCallBackStruct.channel_name.equals(string)) continue;
                        try {
                            object2 = new DeviceData();
                            object = new String[]{eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, "subscribe", eventCallBackStruct.event_name};
                            ((DeviceData)object2).insert((String[])object);
                            eventChannelStruct.adm_device_proxy.command_inout("EventSubscriptionChange", (DeviceData)object2);
                            eventChannelStruct.last_subscribed = System.currentTimeMillis();
                        }
                        catch (DevFailed devFailed) {
                            // empty catch block
                        }
                        eventChannelStruct.last_subscribed = eventCallBackStruct.last_subscribed = System.currentTimeMillis();
                    }
                }
                boolean bl2 = bl = l - eventChannelStruct.last_heartbeat > 10000L;
                if (!bl && !eventChannelStruct.heartbeat_skipped) continue;
                eventChannelStruct.heartbeat_skipped = true;
                boolean bl3 = false;
                try {
                    object2 = eventChannelStruct.eventChannel.MyFactory();
                }
                catch (RuntimeException runtimeException) {
                    bl3 = true;
                }
                boolean bl4 = true;
                if (bl3 && (bl4 = this.reconnect_to_channel(string))) {
                    this.reconnect_to_event(string);
                }
                object = EventConsumer.this.event_callback_map.elements();
                while (object.hasMoreElements()) {
                    java.lang.Object object3;
                    java.lang.Object object4;
                    EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)object.nextElement();
                    if (!eventCallBackStruct.channel_name.equals(string) || eventCallBackStruct.callback == null) continue;
                    try {
                        if (!eventCallBackStruct.filter_ok) {
                            eventCallBackStruct.filter_id = EventConsumer.this.add_filter_for_channel(eventChannelStruct, eventCallBackStruct.filter_constraint);
                            eventCallBackStruct.filter_ok = true;
                        }
                        DevError[] devErrorArray = new DevError[]{new DevError()};
                        devErrorArray[0].severity = ErrSeverity.ERR;
                        devErrorArray[0].origin = "EventConsumer.KeepAliveThread";
                        devErrorArray[0].reason = "API_EventTimeout";
                        devErrorArray[0].desc = "Event channel is not responding any more, maybe the server or event system is down";
                        object4 = new EventData(eventChannelStruct.adm_device_proxy, "domain_name", "event_name", null, devErrorArray);
                        object3 = eventCallBackStruct.callback;
                        ((EventData)object4).device = eventCallBackStruct.device;
                        ((EventData)object4).name = eventCallBackStruct.device.name();
                        ((EventData)object4).event = eventCallBackStruct.event_name;
                        ((CallBack)object3).push_event((EventData)object4);
                    }
                    catch (DevFailed devFailed) {
                        // empty catch block
                    }
                    if (!bl4) continue;
                    boolean bl5 = false;
                    try {
                        object4 = new DeviceData();
                        object3 = new String[]{eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, "subscribe", eventCallBackStruct.event_name};
                        ((DeviceData)object4).insert((String[])object3);
                        eventChannelStruct.adm_device_proxy.command_inout("EventSubscriptionChange", (DeviceData)object4);
                        eventChannelStruct.heartbeat_skipped = false;
                        eventChannelStruct.last_subscribed = System.currentTimeMillis();
                    }
                    catch (DevFailed devFailed) {
                        bl5 = true;
                    }
                    if (bl5 || !eventCallBackStruct.event_name.equals("change") && !eventCallBackStruct.event_name.equals("quality") && !eventCallBackStruct.event_name.equals("archive") && !eventCallBackStruct.event_name.equals("user_event")) continue;
                    object4 = null;
                    object3 = null;
                    String string2 = eventCallBackStruct.device.name() + "/" + eventCallBackStruct.attr_name;
                    boolean bl6 = eventCallBackStruct.device.get_transparency_reconnection();
                    eventCallBackStruct.device.set_transparency_reconnection(true);
                    try {
                        object4 = eventCallBackStruct.device.read_attribute(eventCallBackStruct.attr_name);
                    }
                    catch (DevFailed devFailed) {
                        object3 = devFailed.errors;
                    }
                    eventCallBackStruct.device.set_transparency_reconnection(bl6);
                    EventData eventData = new EventData(eventCallBackStruct.device, string2, eventCallBackStruct.event_name, (DeviceAttribute)object4, (DevError[])object3);
                    eventCallBackStruct.callback.push_event(eventData);
                }
            }
        }

        private void reconnect_to_event(String string) {
            Enumeration enumeration = EventConsumer.this.event_callback_map.elements();
            while (enumeration.hasMoreElements()) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
                if (!eventCallBackStruct.channel_name.equals(string) || eventCallBackStruct.callback == null) continue;
                try {
                    EventChannelStruct eventChannelStruct = (EventChannelStruct)EventConsumer.this.channel_map.get(string);
                    eventCallBackStruct.filter_id = EventConsumer.this.add_filter_for_channel(eventChannelStruct, eventCallBackStruct.filter_constraint);
                    eventCallBackStruct.filter_ok = true;
                }
                catch (DevFailed devFailed) {
                    eventCallBackStruct.filter_ok = false;
                }
            }
        }

        private boolean reconnect_to_channel(String string) {
            boolean bl = true;
            Enumeration enumeration = EventConsumer.this.event_callback_map.elements();
            while (enumeration.hasMoreElements()) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
                if (!eventCallBackStruct.channel_name.equals(string) || eventCallBackStruct.callback == null) continue;
                try {
                    EventConsumer.this.connect_event_channel(string, true);
                    EventChannelStruct eventChannelStruct = (EventChannelStruct)EventConsumer.this.channel_map.get(string);
                    eventChannelStruct.adm_device_proxy = new DeviceProxy(string);
                }
                catch (DevFailed devFailed) {
                    bl = false;
                }
            }
            return bl;
        }
    }
}

