/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.AttributeConfig_3;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.AttributeValueListHelper;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevAttrHistory_3;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevFailedHelper;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.MultiDevFailed;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AsyncCallObject;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.CallbackThread;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.DServer;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.T2Ttypes;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.NamedDevFailed;
import fr.esrf.TangoDs.NamedDevFailedList;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Request;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UnknownUserException;

public class DeviceProxy
extends Connection
implements ApiDefs {
    private static final boolean check_idl = false;
    private DbDevice db_dev;
    private String full_class_name;
    private DeviceProxy adm_dev = null;
    private String[] attnames_array = null;

    public DeviceProxy() throws DevFailed {
    }

    public DeviceProxy(String string) throws DevFailed {
        super(string);
        this.full_class_name = "DeviceProxy(" + this.name() + ")";
    }

    public DeviceProxy(String string, String string2) throws DevFailed {
        super(string, string2, 1);
        this.full_class_name = "DeviceProxy(" + this.name() + ")";
    }

    public DeviceProxy(String string, String string2, String string3) throws DevFailed {
        super(string, string2, string3);
        this.full_class_name = "DeviceProxy(" + this.name() + ")";
    }

    protected void import_admin_device(String string) throws DevFailed {
        this.checkIfTango(string);
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.adm_dev == null) {
            DServer dServer = DServer.get_instance();
            this.adm_dev = dServer.get_adm_dev(this.adm_name());
        }
    }

    public String name() {
        return this.get_name();
    }

    public String status() throws DevFailed {
        return this.status(true);
    }

    public String status(boolean bl) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            String string;
            try {
                if (bl) {
                    string = this.device.status();
                } else {
                    DeviceData deviceData = this.command_inout("Status");
                    string = deviceData.extractString();
                }
            }
            catch (Exception exception) {
                string = "Unknown";
                this.throw_dev_failed(exception, "DeviceProxy.status()", false);
            }
            return string;
        }
        return this.command_inout("DevStatus").extractString();
    }

    public DevState state() throws DevFailed {
        return this.state(true);
    }

    public DevState state(boolean bl) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            DevState devState = DevState.UNKNOWN;
            int n = this.transparent_reconnection ? 2 : 1;
            boolean bl2 = false;
            for (int i = 0; i < n && !bl2; ++i) {
                try {
                    if (bl) {
                        devState = this.device.state();
                    } else {
                        DeviceData deviceData = this.command_inout("State");
                        devState = deviceData.extractDevState();
                    }
                    bl2 = true;
                    continue;
                }
                catch (Exception exception) {
                    if (exception.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 && i == 0) {
                        this.device = null;
                        this.build_connection();
                        if (i != n - 1) continue;
                        devState = DevState.UNKNOWN;
                        this.throw_dev_failed(exception, "DeviceProxy.state()", false);
                        continue;
                    }
                    devState = DevState.UNKNOWN;
                    this.throw_dev_failed(exception, "DeviceProxy.state()", false);
                }
            }
            return devState;
        }
        DeviceData deviceData = this.command_inout("DevState");
        short s = deviceData.extractShort();
        return T2Ttypes.tangoState(s);
    }

    public CommandInfo command_query(String string) throws DevFailed {
        CommandInfo commandInfo;
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            if (this.device_2 != null) {
                DevCmdInfo_2 devCmdInfo_2 = this.device_2.command_query_2(string);
                commandInfo = new CommandInfo(devCmdInfo_2);
            } else {
                DevCmdInfo devCmdInfo = this.device.command_query(string);
                commandInfo = new CommandInfo(devCmdInfo);
            }
        } else {
            commandInfo = this.taco_device.commandQuery(string);
        }
        return commandInfo;
    }

    public void put_alias(String string) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_alias()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_alias");
        this.db_dev.put_alias(string);
    }

    public String get_alias() throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_alias()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_alias");
        return this.db_dev.get_alias();
    }

    public DeviceInfo get_info() throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").import_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        if (this.url.protocol == 0) {
            return this.db_dev.get_info();
        }
        return null;
    }

    public DbDevImportInfo import_device() throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").import_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        if (this.url.protocol == 0) {
            return this.db_dev.import_device();
        }
        return null;
    }

    public void export_device(DbDevExportInfo dbDevExportInfo) throws DevFailed {
        this.checkIfTango("export_device");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").export_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.db_dev.export_device(dbDevExportInfo);
    }

    public void unexport_device() throws DevFailed {
        this.checkIfTango("unexport_device");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").unexport_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.db_dev.unexport_device();
    }

    public void add_device(DbDevInfo dbDevInfo) throws DevFailed {
        this.checkIfTango("add_device");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").add_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.db_dev.add_device(dbDevInfo);
    }

    public void delete_device() throws DevFailed {
        this.checkIfTango("delete_device");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").add_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.db_dev.delete_device();
    }

    public String[] get_property_list(String string) throws DevFailed {
        this.checkIfTango("get_property_list");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_property_list()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        return this.db_dev.get_property_list(string);
    }

    public DbDatum[] get_property(String[] stringArray) throws DevFailed {
        if (this.url.protocol == 0) {
            if (!this.url.use_db) {
                Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_property()");
            }
            if (this.db_dev == null) {
                this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
            }
            return this.db_dev.get_property(stringArray);
        }
        return this.taco_device.get_property(stringArray);
    }

    public DbDatum get_property(String string) throws DevFailed {
        if (this.url.protocol == 0) {
            if (!this.url.use_db) {
                Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_property()");
            }
            if (this.db_dev == null) {
                this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
            }
            return this.db_dev.get_property(string);
        }
        String[] stringArray = new String[]{string};
        return this.taco_device.get_property(stringArray)[0];
    }

    public DbDatum[] get_property(DbDatum[] dbDatumArray) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_property");
        return this.db_dev.get_property(dbDatumArray);
    }

    public void put_property(DbDatum dbDatum) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_property");
        DbDatum[] dbDatumArray = new DbDatum[]{dbDatum};
        this.put_property(dbDatumArray);
    }

    public void put_property(DbDatum[] dbDatumArray) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_property");
        this.db_dev.put_property(dbDatumArray);
    }

    public void delete_property(String[] stringArray) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(stringArray);
    }

    public void delete_property(String string) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(string);
    }

    public void delete_property(DbDatum[] dbDatumArray) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(dbDatumArray);
    }

    public String[] get_attribute_list() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            String[] stringArray = new String[]{this.device_3 != null ? "All attributes_3" : "All attributes"};
            AttributeInfo[] attributeInfoArray = this.get_attribute_config(stringArray);
            String[] stringArray2 = new String[attributeInfoArray.length];
            for (int i = 0; i < attributeInfoArray.length; ++i) {
                stringArray2[i] = attributeInfoArray[i].name;
            }
            return stringArray2;
        }
        return this.taco_device.get_attribute_list();
    }

    public void put_attribute_property(DbAttribute[] dbAttributeArray) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_attribute_property");
        this.db_dev.put_attribute_property(dbAttributeArray);
    }

    public void put_attribute_property(DbAttribute dbAttribute) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_attribute_property");
        this.db_dev.put_attribute_property(dbAttribute);
    }

    public void delete_attribute_property(String string, String[] stringArray) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(string, stringArray);
    }

    public void delete_attribute_property(String string, String string2) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(string, string2);
    }

    public void delete_attribute_property(DbAttribute dbAttribute) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(dbAttribute);
    }

    public void delete_attribute_property(DbAttribute[] dbAttributeArray) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(dbAttributeArray);
    }

    public DbAttribute[] get_attribute_property(String[] stringArray) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_attribute_property");
        return this.db_dev.get_attribute_property(stringArray);
    }

    public DbAttribute get_attribute_property(String string) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_attribute_property");
        return this.db_dev.get_attribute_property(string);
    }

    public void delete_attribute(String string) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute");
        this.db_dev.delete_attribute(string);
    }

    public AttributeInfo[] get_attribute_info(String[] stringArray) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            AttributeConfig[] attributeConfigArray = null;
            AttributeConfig_2[] attributeConfig_2Array = null;
            if (this.url.protocol == 0) {
                if (this.device_2 != null) {
                    attributeConfig_2Array = this.device_2.get_attribute_config_2(stringArray);
                } else {
                    attributeConfigArray = this.device.get_attribute_config(stringArray);
                }
            } else {
                attributeConfigArray = this.taco_device.get_attribute_config(stringArray);
            }
            int n = attributeConfig_2Array != null ? attributeConfig_2Array.length : attributeConfigArray.length;
            AttributeInfo[] attributeInfoArray = new AttributeInfo[n];
            for (int i = 0; i < n; ++i) {
                attributeInfoArray[i] = attributeConfig_2Array != null ? new AttributeInfo(attributeConfig_2Array[i]) : new AttributeInfo(attributeConfigArray[i]);
            }
            return attributeInfoArray;
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.throw_dev_failed(exception, "get_attribute_config", true);
            return null;
        }
    }

    public AttributeInfoEx[] get_attribute_info_ex(String[] stringArray) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            AttributeInfoEx[] attributeInfoExArray = null;
            AttributeConfig_3[] attributeConfig_3Array = null;
            AttributeConfig_2[] attributeConfig_2Array = null;
            AttributeConfig[] attributeConfigArray = null;
            if (this.url.protocol == 0) {
                if (this.device_3 != null) {
                    attributeConfig_3Array = this.device_3.get_attribute_config_3(stringArray);
                } else if (this.device_2 != null) {
                    attributeConfig_2Array = this.device_2.get_attribute_config_2(stringArray);
                } else {
                    Except.throw_non_supported_exception("TangoApi_IDL_NOT_SUPPORTED", "Not supported by the IDL version used by device", new String(this.full_class_name + ".get_attribute_info_ex()"));
                }
            } else {
                attributeConfigArray = this.taco_device.get_attribute_config(stringArray);
            }
            int n = attributeConfig_3Array != null ? attributeConfig_3Array.length : (attributeConfig_2Array != null ? attributeConfig_2Array.length : attributeConfigArray.length);
            attributeInfoExArray = new AttributeInfoEx[n];
            for (int i = 0; i < n; ++i) {
                if (attributeConfig_3Array != null) {
                    attributeInfoExArray[i] = new AttributeInfoEx(attributeConfig_3Array[i]);
                    continue;
                }
                if (attributeConfig_2Array != null) {
                    attributeInfoExArray[i] = new AttributeInfoEx(attributeConfig_2Array[i]);
                    continue;
                }
                if (attributeConfigArray == null) continue;
                attributeInfoExArray[i] = new AttributeInfoEx(attributeConfigArray[i]);
            }
            return attributeInfoExArray;
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.throw_dev_failed(exception, "get_attribute_config_ex", true);
            return null;
        }
    }

    public AttributeInfo[] get_attribute_config(String[] stringArray) throws DevFailed {
        return this.get_attribute_info(stringArray);
    }

    public AttributeInfo get_attribute_info(String string) throws DevFailed {
        String[] stringArray = ApiUtil.toStringArray(string);
        AttributeInfo[] attributeInfoArray = this.get_attribute_info(stringArray);
        return attributeInfoArray[0];
    }

    public AttributeInfoEx get_attribute_info_ex(String string) throws DevFailed {
        String[] stringArray = ApiUtil.toStringArray(string);
        AttributeInfoEx[] attributeInfoExArray = this.get_attribute_info_ex(stringArray);
        return attributeInfoExArray[0];
    }

    public AttributeInfo get_attribute_config(String string) throws DevFailed {
        return this.get_attribute_info(string);
    }

    public AttributeInfo[] get_attribute_info() throws DevFailed {
        String[] stringArray = new String[]{this.device_3 != null ? "All attributes_3" : "All attributes"};
        AttributeInfo[] attributeInfoArray = this.get_attribute_info(stringArray);
        return attributeInfoArray;
    }

    public AttributeInfoEx[] get_attribute_info_ex() throws DevFailed {
        String[] stringArray = new String[]{this.device_3 != null ? "All attributes_3" : "All attributes"};
        AttributeInfoEx[] attributeInfoExArray = this.get_attribute_info_ex(stringArray);
        return attributeInfoExArray;
    }

    public AttributeInfo[] get_attribute_config() throws DevFailed {
        return this.get_attribute_info();
    }

    public void set_attribute_info(AttributeInfo[] attributeInfoArray) throws DevFailed {
        this.checkIfTango("set_attribute_config");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            AttributeConfig[] attributeConfigArray = new AttributeConfig[attributeInfoArray.length];
            for (int i = 0; i < attributeInfoArray.length; ++i) {
                attributeConfigArray[i] = attributeInfoArray[i].get_attribute_config_obj();
            }
            this.device.set_attribute_config(attributeConfigArray);
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "set_attribute_info", true);
        }
    }

    public void set_attribute_info(AttributeInfoEx[] attributeInfoExArray) throws DevFailed {
        this.checkIfTango("set_attribute_config");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            if (this.device_3 != null) {
                AttributeConfig_3[] attributeConfig_3Array = new AttributeConfig_3[attributeInfoExArray.length];
                for (int i = 0; i < attributeInfoExArray.length; ++i) {
                    attributeConfig_3Array[i] = attributeInfoExArray[i].get_attribute_config_obj_3();
                }
                this.device_3.set_attribute_config_3(attributeConfig_3Array);
            } else {
                AttributeConfig[] attributeConfigArray = new AttributeConfig[attributeInfoExArray.length];
                for (int i = 0; i < attributeInfoExArray.length; ++i) {
                    attributeConfigArray[i] = attributeInfoExArray[i].get_attribute_config_obj();
                }
                this.device.set_attribute_config(attributeConfigArray);
            }
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "set_attribute_info", true);
        }
    }

    public void set_attribute_config(AttributeInfo[] attributeInfoArray) throws DevFailed {
        this.set_attribute_info(attributeInfoArray);
    }

    public DeviceAttribute read_attribute(String string) throws DevFailed {
        String[] stringArray = ApiUtil.toStringArray(string);
        DeviceAttribute[] deviceAttributeArray = this.read_attribute(stringArray);
        return deviceAttributeArray[0];
    }

    public AttributeValue read_attribute_value(String string) throws DevFailed {
        this.checkIfTango("read_attribute_value");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.attnames_array == null) {
            this.attnames_array = new String[1];
        }
        this.attnames_array[0] = string;
        try {
            AttributeValue[] attributeValueArray = this.device_2 != null ? this.device_2.read_attributes_2(this.attnames_array, this.dev_src) : this.device.read_attributes(this.attnames_array);
            return attributeValueArray[0];
        }
        catch (DevFailed devFailed) {
            Except.throw_connection_failed(devFailed, "TangoApi_CANNOT_READ_ATTRIBUTE", "Cannot read attribute:   " + string, new String(this.full_class_name + ".read_attribute()"));
            return null;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "device.read_attributes()", false);
            return null;
        }
    }

    public DeviceAttribute[] read_attribute(String[] stringArray) throws DevFailed {
        DeviceAttribute[] deviceAttributeArray;
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        AttributeValue[] attributeValueArray = new AttributeValue[]{};
        AttributeValue_3[] attributeValue_3Array = new AttributeValue_3[]{};
        if (this.url.protocol == 0) {
            int n;
            boolean bl = false;
            int n2 = this.transparent_reconnection ? 2 : 1;
            for (n = 0; n < n2 && !bl; ++n) {
                try {
                    if (this.device_3 != null) {
                        attributeValue_3Array = this.device_3.read_attributes_3(stringArray, this.dev_src);
                    } else {
                        attributeValueArray = this.device_2 != null ? this.device_2.read_attributes_2(stringArray, this.dev_src) : this.device.read_attributes(stringArray);
                    }
                    bl = true;
                    continue;
                }
                catch (DevFailed devFailed) {
                    StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuffer.append(", " + stringArray[i]);
                    }
                    Except.throw_connection_failed(devFailed, "TangoApi_CANNOT_READ_ATTRIBUTE", "Cannot read attribute(s):   " + stringBuffer.toString(), new String(this.full_class_name + ".read_attribute()"));
                    continue;
                }
                catch (Exception exception) {
                    if (exception.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 && n == 0) {
                        this.device = null;
                        this.ior = null;
                        this.build_connection();
                        if (n != n2 - 1) continue;
                        this.throw_dev_failed(exception, "device.read_attributes()", false);
                        continue;
                    }
                    this.throw_dev_failed(exception, "device.read_attributes()", false);
                }
            }
            if (this.device_3 != null) {
                deviceAttributeArray = new DeviceAttribute[attributeValue_3Array.length];
                for (n = 0; n < attributeValue_3Array.length; ++n) {
                    deviceAttributeArray[n] = new DeviceAttribute(attributeValue_3Array[n]);
                }
            } else {
                deviceAttributeArray = new DeviceAttribute[attributeValueArray.length];
                for (n = 0; n < attributeValueArray.length; ++n) {
                    deviceAttributeArray[n] = new DeviceAttribute(attributeValueArray[n]);
                }
            }
        } else {
            deviceAttributeArray = this.taco_device.read_attribute(stringArray);
        }
        return deviceAttributeArray;
    }

    public void write_attribute(DeviceAttribute deviceAttribute) throws DevFailed {
        this.checkIfTango("write_attribute");
        try {
            DeviceAttribute[] deviceAttributeArray = new DeviceAttribute[]{deviceAttribute};
            this.write_attribute(deviceAttributeArray);
        }
        catch (NamedDevFailedList namedDevFailedList) {
            NamedDevFailed namedDevFailed = namedDevFailedList.elementAt(0);
            DevFailed devFailed = new DevFailed(namedDevFailed.err_stack);
            throw devFailed;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "device.write_attributes()", false);
        }
    }

    public void write_attribute(DeviceAttribute[] deviceAttributeArray) throws DevFailed {
        this.checkIfTango("write_attribute");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        AttributeValue[] attributeValueArray = new AttributeValue[deviceAttributeArray.length];
        for (int i = 0; i < deviceAttributeArray.length; ++i) {
            attributeValueArray[i] = deviceAttributeArray[i].getAttributeValueObject_2();
        }
        try {
            if (this.device_3 != null) {
                this.device_3.write_attributes_3(attributeValueArray);
            } else {
                this.device.write_attributes(attributeValueArray);
            }
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (MultiDevFailed multiDevFailed) {
            throw new NamedDevFailedList(multiDevFailed, this.name(), "DeviceProxy.write_attribute", "MultiDevFailed");
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "device.write_attributes()", false);
        }
    }

    public DeviceProxy get_adm_dev() throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("get_adm_dev");
        }
        return this.adm_dev;
    }

    private void poll_object(String string, String string2, int n) throws DevFailed {
        DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
        devVarLongStringArray.lvalue = new int[1];
        devVarLongStringArray.svalue = new String[3];
        devVarLongStringArray.svalue[0] = this.devname;
        devVarLongStringArray.svalue[1] = string2;
        devVarLongStringArray.svalue[2] = string;
        devVarLongStringArray.lvalue[0] = n;
        if (this.adm_dev == null) {
            this.import_admin_device("poll_object");
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(devVarLongStringArray);
        try {
            this.adm_dev.command_inout("AddObjPolling", deviceData);
        }
        catch (DevFailed devFailed) {
            for (int i = 0; i < devFailed.errors.length; ++i) {
                if (!devFailed.errors[i].reason.equals("API_AlreadyPolled")) continue;
                this.adm_dev.command_inout("UpdObjPollingPeriod", deviceData);
                return;
            }
            Except.throw_communication_failed(devFailed, "TangoApi_CANNOT_POLL_OBJECT", "Cannot poll object " + string, new String(this.full_class_name + ".poll_object()"));
        }
    }

    public void poll_command(String string, int n) throws DevFailed {
        this.poll_object(string, "command", n);
    }

    public void poll_attribute(String string, int n) throws DevFailed {
        this.poll_object(string, "attribute", n);
    }

    private void remove_poll_object(String string, String string2) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("remove_poll_object");
        }
        DeviceData deviceData = new DeviceData();
        String[] stringArray = new String[]{this.devname, string2, string};
        deviceData.insert(stringArray);
        this.adm_dev.command_inout("RemObjPolling", deviceData);
    }

    public void stop_poll_command(String string) throws DevFailed {
        this.remove_poll_object(string, "command");
    }

    public void stop_poll_attribute(String string) throws DevFailed {
        this.remove_poll_object(string, "attribute");
    }

    public String[] polling_status() throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("polling_status");
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(this.devname);
        DeviceData deviceData2 = this.adm_dev.command_inout("DevPollStatus", deviceData);
        String[] stringArray = deviceData2.extractStringArray();
        return stringArray;
    }

    public DeviceDataHistory[] command_history(String string, int n) throws DevFailed {
        this.checkIfTango("command_history");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        DevCmdHistory[] devCmdHistoryArray = this.device_2.command_inout_history_2(string, n);
        DeviceDataHistory[] deviceDataHistoryArray = new DeviceDataHistory[devCmdHistoryArray.length];
        for (int i = 0; i < devCmdHistoryArray.length; ++i) {
            deviceDataHistoryArray[i] = new DeviceDataHistory(string, devCmdHistoryArray[i]);
        }
        return deviceDataHistoryArray;
    }

    public DeviceDataHistory[] attribute_history(String string, int n) throws DevFailed {
        DeviceDataHistory[] deviceDataHistoryArray;
        block4: {
            block3: {
                this.checkIfTango("attribute_history");
                if (this.device == null && this.devname != null) {
                    this.build_connection();
                }
                deviceDataHistoryArray = new DeviceDataHistory[]{};
                if (this.device_3 == null) break block3;
                DevAttrHistory_3[] devAttrHistory_3Array = this.device_3.read_attribute_history_3(string, n);
                deviceDataHistoryArray = new DeviceDataHistory[devAttrHistory_3Array.length];
                for (int i = 0; i < devAttrHistory_3Array.length; ++i) {
                    deviceDataHistoryArray[i] = new DeviceDataHistory(devAttrHistory_3Array[i]);
                }
                break block4;
            }
            if (this.device_2 == null) break block4;
            DevAttrHistory[] devAttrHistoryArray = this.device_2.read_attribute_history_2(string, n);
            deviceDataHistoryArray = new DeviceDataHistory[devAttrHistoryArray.length];
            for (int i = 0; i < devAttrHistoryArray.length; ++i) {
                deviceDataHistoryArray[i] = new DeviceDataHistory(devAttrHistoryArray[i]);
            }
        }
        return deviceDataHistoryArray;
    }

    public DeviceDataHistory[] command_history(String string) throws DevFailed {
        int n = 10;
        DbDatum dbDatum = this.get_property("poll_ring_depth");
        if (!dbDatum.is_empty()) {
            n = dbDatum.extractLong();
        }
        return this.command_history(string, n);
    }

    public DeviceDataHistory[] attribute_history(String string) throws DevFailed {
        int n = 10;
        DbDatum dbDatum = this.get_property("poll_ring_depth");
        if (!dbDatum.is_empty()) {
            n = dbDatum.extractLong();
        }
        return this.attribute_history(string, n);
    }

    public int command_inout_asynch(String string, DeviceData deviceData) throws DevFailed {
        return this.command_inout_asynch(string, deviceData, false);
    }

    public int command_inout_asynch(String string) throws DevFailed {
        return this.command_inout_asynch(string, new DeviceData(), false);
    }

    public int command_inout_asynch(String string, boolean bl) throws DevFailed {
        return this.command_inout_asynch(string, new DeviceData(), bl);
    }

    public int command_inout_asynch(String string, DeviceData deviceData, boolean bl) throws DevFailed {
        this.checkIfTango("command_inout_asynch");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        Request request = this.idl_version < 2 ? this.device._request("command_inout") : this.device_2._request("command_inout");
        ORB oRB = ApiUtil.get_orb();
        request.add_in_arg().insert_string(string);
        request.add_in_arg().insert_any(deviceData.any);
        request.set_return_type(oRB.get_primitive_tc(TCKind.tk_any));
        request.exceptions().add(DevFailedHelper.type());
        int n = 0;
        boolean bl2 = false;
        int n2 = this.transparent_reconnection ? 2 : 1;
        for (int i = 0; i < n2 && !bl2; ++i) {
            try {
                if (bl) {
                    request.send_oneway();
                } else {
                    request.send_deferred();
                    String[] stringArray = new String[]{string};
                    n = ApiUtil.put_async_request(new AsyncCallObject(request, this, 0, stringArray));
                }
                bl2 = true;
                continue;
            }
            catch (Exception exception) {
                if (exception.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 && i == 0) {
                    this.device = null;
                    this.build_connection();
                    if (i != n2 - 1) continue;
                    this.throw_dev_failed(exception, string, true);
                    continue;
                }
                this.throw_dev_failed(exception, string, true);
            }
        }
        return n;
    }

    public void command_inout_asynch(String string, DeviceData deviceData, CallBack callBack) throws DevFailed {
        int n = this.command_inout_asynch(string, deviceData, false);
        ApiUtil.set_async_reply_model(n, 2);
        ApiUtil.set_async_reply_cb(n, callBack);
        if (ApiUtil.get_asynch_cb_sub_model() == 0) {
            AsyncCallObject asyncCallObject = ApiUtil.get_async_object(n);
            new CallbackThread(asyncCallObject).start();
        }
    }

    public void command_inout_asynch(String string, CallBack callBack) throws DevFailed {
        this.command_inout_asynch(string, new DeviceData(), callBack);
    }

    public DeviceData command_inout_reply(int n, int n2) throws DevFailed, AsynReplyNotArrived {
        return this.command_inout_reply(ApiUtil.get_async_object(n), n2);
    }

    DeviceData command_inout_reply(AsyncCallObject asyncCallObject, int n) throws DevFailed, AsynReplyNotArrived {
        long l;
        DeviceData deviceData = null;
        int n2 = 50;
        AsynReplyNotArrived asynReplyNotArrived = null;
        long l2 = l = System.currentTimeMillis();
        while ((l2 - l < (long)n || n == 0) && deviceData == null) {
            try {
                deviceData = this.command_inout_reply(asyncCallObject);
            }
            catch (AsynReplyNotArrived asynReplyNotArrived2) {
                asynReplyNotArrived = asynReplyNotArrived2;
                this.sleep(n2);
                l2 = System.currentTimeMillis();
            }
            catch (DevFailed devFailed) {
                throw devFailed;
            }
        }
        if (deviceData == null && asynReplyNotArrived != null) {
            throw asynReplyNotArrived;
        }
        return deviceData;
    }

    public DeviceData command_inout_reply(int n) throws DevFailed, AsynReplyNotArrived {
        return this.command_inout_reply(ApiUtil.get_async_object(n));
    }

    DeviceData command_inout_reply(AsyncCallObject asyncCallObject) throws DevFailed, AsynReplyNotArrived {
        DeviceData deviceData = null;
        this.check_asynch_reply(asyncCallObject.request, asyncCallObject.id, "command_inout");
        Any any = asyncCallObject.request.return_value().extract_any();
        deviceData = new DeviceData();
        deviceData.any = any;
        ApiUtil.remove_async_request(asyncCallObject.id);
        return deviceData;
    }

    public int read_attribute_asynch(String string) throws DevFailed {
        String[] stringArray = new String[]{string};
        return this.read_attribute_asynch(stringArray);
    }

    public int read_attribute_asynch(String[] stringArray) throws DevFailed {
        this.checkIfTango("read_attributes_asynch");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        Request request = this.idl_version < 2 ? this.device._request("read_attributes") : this.device_2._request("read_attributes");
        Any any = request.add_in_arg();
        DevVarStringArrayHelper.insert(any, stringArray);
        request.set_return_type(AttributeValueListHelper.type());
        request.exceptions().add(DevFailedHelper.type());
        request.send_deferred();
        int n = ApiUtil.put_async_request(new AsyncCallObject(request, this, 1, stringArray));
        return n;
    }

    protected String get_asynch_idl_cmd(Request request, String string) {
        NVList nVList = request.arguments();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (string.equals("command_inout")) {
                return nVList.item(0).value().extract_string();
            }
            String[] stringArray = DevVarStringArrayHelper.extract(nVList.item(0).value());
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(", ");
            }
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    protected void check_asynch_reply(Request request, int n, String string) throws DevFailed, AsynReplyNotArrived {
        if (request == null) {
            Except.throw_connection_failed("TangoApi_CommandFailed", "Asynchronous call id not found", new String(this.full_class_name + "." + string + "_reply()"));
        }
        if (!request.operation().equals(string)) {
            Except.throw_connection_failed("TangoApi_CommandFailed", new String("Asynchronous call id not for " + string), new String(this.full_class_name + "." + string + "_reply()"));
        }
        if (!request.poll_response()) {
            Except.throw_asyn_reply_not_arrived("API_AsynReplyNotArrived", new String("Device " + this.devname + ": reply for asynchronous call (id = " + n + ") is not yet arrived"), new String(this.full_class_name + "." + string + "_reply()"));
        } else {
            Exception exception = request.env().exception();
            if (exception != null) {
                if (exception instanceof UnknownUserException) {
                    Any any = ((UnknownUserException)exception).except;
                    DevFailed devFailed = DevFailedHelper.extract(any);
                    Except.throw_connection_failed(devFailed, "TangoApi_CommandFailed", "Asynchronous command failed", new String(this.full_class_name + "." + string + "_reply(" + this.get_asynch_idl_cmd(request, string) + ")"));
                } else {
                    ApiUtil.remove_async_request(n);
                    this.throw_dev_failed(exception, new String(this.full_class_name + "." + string + "_reply(" + this.get_asynch_idl_cmd(request, string) + ")"), false);
                }
            }
        }
    }

    public DeviceAttribute[] read_attribute_reply(int n, int n2) throws DevFailed, AsynReplyNotArrived {
        long l;
        DeviceAttribute[] deviceAttributeArray = null;
        int n3 = 50;
        AsynReplyNotArrived asynReplyNotArrived = null;
        long l2 = l = System.currentTimeMillis();
        while ((l2 - l < (long)n2 || n2 == 0) && deviceAttributeArray == null) {
            try {
                deviceAttributeArray = this.read_attribute_reply(n);
            }
            catch (AsynReplyNotArrived asynReplyNotArrived2) {
                asynReplyNotArrived = asynReplyNotArrived2;
                this.sleep(n3);
                l2 = System.currentTimeMillis();
            }
            catch (DevFailed devFailed) {
                throw devFailed;
            }
        }
        if (deviceAttributeArray == null && asynReplyNotArrived != null) {
            throw asynReplyNotArrived;
        }
        return deviceAttributeArray;
    }

    public DeviceAttribute[] read_attribute_reply(int n) throws DevFailed, AsynReplyNotArrived {
        DeviceAttribute[] deviceAttributeArray = null;
        Request request = ApiUtil.get_async_request(n);
        this.check_asynch_reply(request, n, "read_attributes");
        Any any = request.return_value();
        AttributeValue[] attributeValueArray = AttributeValueListHelper.extract(any);
        deviceAttributeArray = new DeviceAttribute[attributeValueArray.length];
        for (int i = 0; i < attributeValueArray.length; ++i) {
            deviceAttributeArray[i] = new DeviceAttribute(attributeValueArray[i]);
        }
        ApiUtil.remove_async_request(n);
        return deviceAttributeArray;
    }

    public void read_attribute_asynch(String string, CallBack callBack) throws DevFailed {
        String[] stringArray = new String[]{string};
        this.read_attribute_asynch(stringArray, callBack);
    }

    public void read_attribute_asynch(String[] stringArray, CallBack callBack) throws DevFailed {
        int n = this.read_attribute_asynch(stringArray);
        ApiUtil.set_async_reply_model(n, 2);
        ApiUtil.set_async_reply_cb(n, callBack);
        if (ApiUtil.get_asynch_cb_sub_model() == 0) {
            AsyncCallObject asyncCallObject = ApiUtil.get_async_object(n);
            new CallbackThread(asyncCallObject).start();
        }
    }

    public int write_attribute_asynch(DeviceAttribute deviceAttribute) throws DevFailed {
        return this.write_attribute_asynch(deviceAttribute, false);
    }

    public int write_attribute_asynch(DeviceAttribute deviceAttribute, boolean bl) throws DevFailed {
        DeviceAttribute[] deviceAttributeArray = new DeviceAttribute[]{deviceAttribute};
        return this.write_attribute_asynch(deviceAttributeArray);
    }

    public int write_attribute_asynch(DeviceAttribute[] deviceAttributeArray) throws DevFailed {
        return this.write_attribute_asynch(deviceAttributeArray, false);
    }

    public int write_attribute_asynch(DeviceAttribute[] deviceAttributeArray, boolean bl) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        AttributeValue[] attributeValueArray = new AttributeValue[deviceAttributeArray.length];
        String[] stringArray = new String[deviceAttributeArray.length];
        for (int i = 0; i < deviceAttributeArray.length; ++i) {
            attributeValueArray[i] = deviceAttributeArray[i].getAttributeValueObject_2();
            stringArray[i] = attributeValueArray[i].name;
        }
        Request request = this.idl_version < 2 ? this.device._request("write_attributes") : this.device_2._request("write_attributes");
        Any any = request.add_in_arg();
        AttributeValueListHelper.insert(any, attributeValueArray);
        request.exceptions().add(DevFailedHelper.type());
        int n = 0;
        if (bl) {
            request.send_oneway();
        } else {
            request.send_deferred();
            n = ApiUtil.put_async_request(new AsyncCallObject(request, this, 2, stringArray));
        }
        return n;
    }

    public void write_attribute_reply(int n) throws DevFailed, AsynReplyNotArrived {
        Object var2_2 = null;
        Request request = ApiUtil.get_async_request(n);
        this.check_asynch_reply(request, n, "write_attributes");
    }

    public void write_attribute_reply(int n, int n2) throws DevFailed, AsynReplyNotArrived {
        long l;
        int n3 = 50;
        AsynReplyNotArrived asynReplyNotArrived = null;
        long l2 = l = System.currentTimeMillis();
        boolean bl = false;
        while (!(l2 - l >= (long)n2 && n2 != 0 || bl)) {
            try {
                this.write_attribute_reply(n);
                bl = true;
            }
            catch (AsynReplyNotArrived asynReplyNotArrived2) {
                asynReplyNotArrived = asynReplyNotArrived2;
                this.sleep(n3);
                l2 = System.currentTimeMillis();
            }
            catch (DevFailed devFailed) {
                throw devFailed;
            }
        }
        if (asynReplyNotArrived != null && !bl) {
            throw asynReplyNotArrived;
        }
    }

    public void write_attribute_asynch(DeviceAttribute deviceAttribute, CallBack callBack) throws DevFailed {
        DeviceAttribute[] deviceAttributeArray = new DeviceAttribute[]{deviceAttribute};
        this.write_attribute_asynch(deviceAttributeArray, callBack);
    }

    public void write_attribute_asynch(DeviceAttribute[] deviceAttributeArray, CallBack callBack) throws DevFailed {
        int n = this.write_attribute_asynch(deviceAttributeArray);
        ApiUtil.set_async_reply_model(n, 2);
        ApiUtil.set_async_reply_cb(n, callBack);
        if (ApiUtil.get_asynch_cb_sub_model() == 0) {
            AsyncCallObject asyncCallObject = ApiUtil.get_async_object(n);
            new CallbackThread(asyncCallObject).start();
        }
    }

    public int pending_asynch_call(int n) {
        return ApiUtil.pending_asynch_call(this, n);
    }

    public void get_asynch_replies() {
        ApiUtil.get_asynch_replies(this);
    }

    public void get_asynch_replies(int n) {
        ApiUtil.get_asynch_replies(this, n);
    }

    public void add_logging_target(String string, String string2) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("add_logging_target");
        }
        String[] stringArray = new String[]{this.get_name(), string + "::" + string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.adm_dev.command_inout("AddLoggingTarget", deviceData);
    }

    public void add_logging_target(String string) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("add_logging_target");
        }
        String[] stringArray = new String[]{this.get_name(), string};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.adm_dev.command_inout("AddLoggingTarget", deviceData);
    }

    public void remove_logging_target(String string, String string2) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("remove_logging_target");
        }
        String[] stringArray = new String[]{this.get_name(), string + "::" + string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.adm_dev.command_inout("RemoveLoggingTarget", deviceData);
    }

    public String[] get_logging_target() throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("get_logging_target");
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(this.get_name());
        DeviceData deviceData2 = this.adm_dev.command_inout("GetLoggingTarget", deviceData);
        return deviceData2.extractStringArray();
    }

    public int get_logging_level() throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("get_logging_level");
        }
        String[] stringArray = new String[]{this.get_name()};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        DeviceData deviceData2 = this.adm_dev.command_inout("GetLoggingLevel", deviceData);
        DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
        return devVarLongStringArray.lvalue[0];
    }

    public void set_logging_level(int n) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("set_logging_level");
        }
        DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
        devVarLongStringArray.lvalue = new int[1];
        devVarLongStringArray.svalue = new String[1];
        devVarLongStringArray.lvalue[0] = n;
        devVarLongStringArray.svalue[0] = this.get_name();
        DeviceData deviceData = new DeviceData();
        deviceData.insert(devVarLongStringArray);
        this.adm_dev.command_inout("SetLoggingLevel", deviceData);
    }

    public String[] dev_inform() throws DevFailed {
        this.checkIfTaco("dev_inform");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.taco_device.dev_inform();
    }

    public void set_rpc_protocol(int n) throws DevFailed {
        this.checkIfTaco("dev_rpc_protocol");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        this.taco_device.set_rpc_protocol(n);
    }

    public int get_rpc_protocol() throws DevFailed {
        this.checkIfTaco("get_rpc_protocol");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.taco_device.get_rpc_protocol();
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            string2 = stringArray[0];
            string = stringArray[1];
        }
        catch (Exception exception) {
            if (string2 == null) {
                System.out.println("Usage :");
                System.out.println("fr.esrf.TangoApi.DeviceProxy  cmdname devname");
                System.out.println("\t- cmdname : command name (ping, state, status, unexport...)");
                System.out.println("\t- devname : device name to send command.");
            } else {
                System.out.println("Device name ?");
            }
            System.exit(0);
        }
        try {
            int n;
            String[] stringArray2 = string.indexOf("*") < 0 ? new String[]{string} : ApiUtil.get_db_obj().getDevices(string);
            DeviceProxy[] deviceProxyArray = new DeviceProxy[stringArray2.length];
            for (n = 0; n < stringArray2.length; ++n) {
                deviceProxyArray[n] = new DeviceProxy(stringArray2[n]);
            }
            if (string2.equals("ping")) {
                while (true) {
                    for (n = 0; n < deviceProxyArray.length; ++n) {
                        try {
                            long l = deviceProxyArray[n].ping();
                            System.out.println(stringArray2[n] + " is alive  (" + l / 1000L + " ms)");
                            continue;
                        }
                        catch (DevFailed devFailed) {
                            System.out.println(stringArray2[n] + "  " + devFailed.errors[0].desc);
                        }
                    }
                    if (deviceProxyArray.length > 1) {
                        System.out.println();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (string2.equals("status")) {
                for (n = 0; n < deviceProxyArray.length; ++n) {
                    try {
                        System.out.println(stringArray2[n] + " - " + deviceProxyArray[n].status());
                        continue;
                    }
                    catch (DevFailed devFailed) {
                        System.out.println(stringArray2[n] + "  " + devFailed.errors[0].desc);
                    }
                }
            } else if (string2.equals("state")) {
                for (n = 0; n < deviceProxyArray.length; ++n) {
                    try {
                        System.out.println(stringArray2[n] + " is " + ApiUtil.stateName(deviceProxyArray[n].state()));
                        continue;
                    }
                    catch (DevFailed devFailed) {
                        System.out.println(stringArray2[n] + "  " + devFailed.errors[0].desc);
                    }
                }
            } else if (string2.equals("unexport")) {
                for (n = 0; n < deviceProxyArray.length; ++n) {
                    try {
                        deviceProxyArray[n].unexport_device();
                        System.out.println(stringArray2[n] + " unexported !");
                        continue;
                    }
                    catch (DevFailed devFailed) {
                        System.out.println(stringArray2[n] + "  " + devFailed.errors[0].desc);
                    }
                }
            } else {
                System.out.println(string2 + " ?   Unknow command !");
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
        }
    }

    private synchronized void sleep(long l) {
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
    }

    public int subscribe_event(String string, int n, CallBack callBack, String[] stringArray) throws DevFailed {
        if (ApiUtil.get_event_consumer() == null) {
            ApiUtil.create_event_consumer();
        }
        EventConsumer eventConsumer = ApiUtil.get_event_consumer();
        return eventConsumer.subscribe_event(this, string.toLowerCase(), n, callBack, stringArray);
    }

    public void unsubscribe_event(int n) throws DevFailed {
        if (ApiUtil.get_event_consumer() == null) {
            ApiUtil.create_event_consumer();
        }
        EventConsumer eventConsumer = ApiUtil.get_event_consumer();
        eventConsumer.unsubscribe_event(n);
    }
}

