/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import LogConsumer.LogConsumer;
import LogConsumer.SourceSet;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Util;
import fr.esrf.logviewer.HistoryArea;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.tangoatk.core.ATKException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

class TangoLoggingReceiver
extends Thread {
    private static final Logger LOG;
    private final MyTableModel mModel;
    final String mDYN_DEV_NAME_PREFIX = "tmp/log/";
    private String mServerName;
    private String mDevName;
    private final SourceSet mSet = SourceSet.instance();
    private boolean mRunningInStaticMode = false;
    private final String mLOG_SRC_PROPERTY = "logging_source";
    private HistoryArea mHistoryArea;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("fr.esrf.logviewer.TangoLoggingReceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    TangoLoggingReceiver(String[] aArgs, MyTableModel aModel, HistoryArea aHistoryArea) throws Exception {
        this.setDaemon(true);
        this.mModel = aModel;
        this.mHistoryArea = aHistoryArea;
        try {
            String device_name;
            String instance_name;
            String[] args = null;
            boolean instance_name_provided = true;
            Random rand = new Random(System.currentTimeMillis());
            String dev_name_suffix = "@" + rand.nextInt(128);
            if (aArgs.length == 0 || aArgs[0].indexOf("/") == -1) {
                LOG.debug((Object)"No instance name provided.");
                instance_name_provided = false;
                String hostname = InetAddress.getLocalHost().getHostName();
                String[] tokens = hostname.split(".");
                if (tokens.length != 0) {
                    hostname = tokens[0];
                }
                instance_name = String.valueOf(hostname) + dev_name_suffix;
                device_name = "tmp/log/" + instance_name;
            } else {
                LOG.debug((Object)("Provided device name: " + aArgs[0]));
                device_name = aArgs[0];
                int pos = device_name.lastIndexOf(47);
                if (pos == -1) {
                    LOG.fatal((Object)"Invalid device name specified. Quiting");
                    JOptionPane.showMessageDialog(null, "Invalid device name specified. Quiting", "Tango Log Viewer", 0);
                    System.exit(1);
                }
                instance_name = device_name.substring(pos + 1);
                this.mRunningInStaticMode = true;
            }
            this.mServerName = "logconsumer/" + instance_name;
            LOG.debug((Object)("Instance name is " + instance_name));
            LOG.debug((Object)("Server name is " + this.mServerName));
            LOG.debug((Object)("Device name is " + device_name));
            LOG.debug((Object)"Registering the LogConsumer into the database");
            DbDevInfo dinfo = new DbDevInfo(device_name, "LogConsumer", this.mServerName);
            ApiUtil.get_db_obj().add_device(dinfo);
            args = instance_name_provided ? new String[aArgs.length] : new String[aArgs.length + 1];
            args[0] = instance_name;
            int i = instance_name_provided ? 1 : 0;
            int j = 1;
            while (i < aArgs.length) {
                args[j] = aArgs[i];
                ++i;
                ++j;
            }
            LOG.debug((Object)"Initializing the util singleton");
            LOG.debug((Object)"Passing following args to Util.init:");
            i = 0;
            while (i < args.length) {
                LOG.debug((Object)("\targs[" + String.valueOf(i) + "]: " + args[i]));
                ++i;
            }
            Util tg = Util.init((String[])args, (String)"LogConsumer");
            LOG.debug((Object)"Initializing the server");
            tg.server_init();
            Vector dev_list = tg.get_device_list_by_class("LogConsumer");
            ((LogConsumer)((Object)dev_list.elementAt(0))).setModel(aModel);
            this.mDevName = ((LogConsumer)((Object)dev_list.elementAt(0))).name();
            if (this.mRunningInStaticMode) {
                this.getLoggingSourceProperty();
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    public String getDeviceName() {
        return this.mDevName;
    }

    public boolean isRunningInStaticMode() {
        return this.mRunningInStaticMode;
    }

    public void run() {
        LOG.debug((Object)"Device thread started");
        try {
            LOG.info((Object)"Ready to accept request");
            Util.instance().server_run();
            LOG.debug((Object)"Device thread exiting");
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    private String[] getDeviceList(String pattern) {
        String[] dev_list = new String[]{};
        try {
            DeviceData argin = new DeviceData();
            argin.insert(pattern);
            DeviceData argout = ApiUtil.get_db_obj().command_inout("DbGetDeviceExportedList", argin);
            dev_list = argout.extractStringArray();
        }
        catch (Exception e) {
            this.displayException(e);
        }
        return dev_list;
    }

    public int addLoggingSources(String pattern) {
        int result = 0;
        String[] dev_list = this.getDeviceList(pattern);
        int i = 0;
        while (i < dev_list.length) {
            if (this.addLoggingSource(dev_list[i]) == -1) {
                result = -1;
            }
            ++i;
        }
        return result;
    }

    public int addColocatedSources(String dev_name) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            String[] argin = new String[]{"*", "device::" + this.mDevName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("AddLoggingTarget", dd);
            String server_name = dp.adm_name().substring(dp.adm_name().indexOf(47) + 1);
            LOG.debug((Object)("TangoLoggingReceiver::addColocatedSources::server_name is " + server_name));
            String[] dev_list = ApiUtil.get_db_obj().get_device_class_list(server_name);
            int i = 0;
            while (i < dev_list.length) {
                LOG.debug((Object)("TangoLoggingReceiver::addColocatedSources::mSet adding " + dev_list[i]));
                this.mSet.add(dev_list[i]);
                i += 2;
            }
            LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int addLoggingSource(String dev_name) {
        try {
            LOG.debug((Object)("Adding " + dev_name + " to logging sources list"));
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            String[] argin = new String[]{dev_name, "device::" + this.mDevName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("AddLoggingTarget", dd);
            this.mSet.add(dev_name);
            LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int addTangoCoreLogger(String dev_name) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            LOG.debug((Object)("Adding " + dsp.get_name() + " to logging sources list"));
            String[] argin = new String[]{dsp.get_name(), "device::" + this.mDevName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("AddLoggingTarget", dd);
            this.mSet.add(dev_name);
            LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int removeLoggingSources(String pattern) {
        int result = 0;
        String[] dev_list = this.getDeviceList(pattern);
        int i = 0;
        while (i < dev_list.length) {
            if (this.removeLoggingSource(dev_list[i]) == -1) {
                result = -1;
            }
            ++i;
        }
        return result;
    }

    public int removeLoggingSource(String dev_name) {
        return this.removeLoggingSource(dev_name, true);
    }

    private int removeLoggingSource(String dev_name, boolean removeFromSet) {
        try {
            LOG.debug((Object)("Removing " + dev_name + " from logging sources list"));
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            String[] argin = new String[]{dev_name, "device::" + this.mDevName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("RemoveLoggingTarget", dd);
            if (removeFromSet) {
                this.mSet.remove(dev_name);
                LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
            }
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int removeTangoCoreLogger(String dev_name) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            LOG.debug((Object)("Removing " + dsp.get_name() + " from logging sources list"));
            String[] argin = new String[]{dsp.get_name(), "device::" + this.mDevName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("RemoveLoggingTarget", dd);
            this.mSet.remove(dsp.get_name());
            LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int removeColocatedSources(String dev_name) {
        return this.removeColocatedSources(dev_name, true);
    }

    public int removeColocatedSources(String dev_name, boolean removeFromSet) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            String[] argin = new String[]{"*", "device::" + this.mDevName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("RemoveLoggingTarget", dd);
            if (removeFromSet) {
                String server_name = dp.adm_name().substring(dp.adm_name().indexOf(47) + 1);
                LOG.debug((Object)("TangoLoggingReceiver::removeColocatedSources::server_name is " + server_name));
                String[] dev_list = ApiUtil.get_db_obj().get_device_class_list(server_name);
                int i = 0;
                while (i < dev_list.length) {
                    LOG.debug((Object)("TangoLoggingReceiver::removeColocatedSources::mSet removing " + dev_list[i]));
                    this.mSet.remove(dev_list[i]);
                    i += 2;
                }
                LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
            }
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int removeAllSources() {
        LOG.debug((Object)"Removing all logging sources");
        String[] slist = this.mSet.content();
        int result = 0;
        int i = 0;
        while (i < slist.length) {
            if (this.removeColocatedSources(slist[i], false) == -1) {
                result = -1;
            }
            ++i;
        }
        this.mSet.clear();
        return 0;
    }

    public int getDeviceLoggingLevel(String dev_name) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            String[] dvsa = new String[]{dev_name};
            DeviceData ddin = new DeviceData();
            ddin.insert(dvsa);
            DeviceData ddout = dsp.command_inout("GetLoggingLevel", ddin);
            DevVarLongStringArray dvlsa = ddout.extractLongStringArray();
            if (dvlsa.lvalue.length > 0) {
                return dvlsa.lvalue[0];
            }
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int setDevicesLoggingLevel(String pattern, int level) {
        int result = 0;
        String[] dev_list = this.getDeviceList(pattern);
        int i = 0;
        while (i < dev_list.length) {
            if (this.setDeviceLoggingLevel(dev_list[i], level, false) == -1) {
                result = -1;
            }
            ++i;
        }
        return result;
    }

    public int setDeviceLoggingLevel(String dev_name, int level, boolean add_before) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            if (add_before) {
                String[] argin = new String[]{dev_name, "device::" + this.mDevName};
                DeviceData dd = new DeviceData();
                dd.insert(argin);
                dsp.command_inout("AddLoggingTarget", dd);
            }
            DevVarLongStringArray dvlsa = new DevVarLongStringArray();
            dvlsa.lvalue = new int[1];
            dvlsa.lvalue[0] = level;
            dvlsa.svalue = new String[1];
            dvlsa.svalue[0] = dev_name;
            DeviceData argin = new DeviceData();
            argin.insert(dvlsa);
            dsp.command_inout("SetLoggingLevel", argin);
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int setColocatedDevicesLoggingLevel(String dev_name, int level) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            DevVarLongStringArray dvlsa = new DevVarLongStringArray();
            dvlsa.lvalue = new int[1];
            dvlsa.lvalue[0] = level;
            dvlsa.svalue = new String[1];
            dvlsa.svalue[0] = "*";
            DeviceData argin = new DeviceData();
            argin.insert(dvlsa);
            dsp.command_inout("SetLoggingLevel", argin);
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public String[] getLoggingSources() {
        return this.mSet.content();
    }

    protected void displayException(Exception e) {
        LOG.error((Object)e);
        Exception ex = null;
        ex = e instanceof DevFailed ? new ATKException((DevFailed)e) : e;
        this.mHistoryArea.write(ex);
    }

    public int setLoggingSourceProperty() {
        LOG.debug((Object)"Saving current logging source list into the TANGO database");
        String[] list = new String[this.mSet.size()];
        int i = 0;
        Iterator it = this.mSet.iterator();
        while (it.hasNext()) {
            list[i++] = (String)it.next();
        }
        DbDatum[] dbd = new DbDatum[]{new DbDatum("logging_source", list)};
        try {
            ApiUtil.get_db_obj().put_device_property(this.mDevName, dbd);
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int deleteLoggingSourceProperty() {
        try {
            ApiUtil.get_db_obj().delete_device_property(this.mDevName, "logging_source");
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int getLoggingSourceProperty() {
        try {
            DbDatum dbd = ApiUtil.get_db_obj().get_device_property(this.mDevName, "logging_source");
            if (dbd.is_empty()) {
                LOG.debug((Object)"Restore sources::nothing to restore");
                return 0;
            }
            String[] src_list = dbd.extractStringArray();
            LOG.debug((Object)("Restore sources::#source to add " + src_list.length));
            int i = 0;
            while (i < src_list.length) {
                LOG.debug((Object)("Restore sources::adding " + src_list[i]));
                this.addLoggingSource(src_list[i]);
                ++i;
            }
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public void cleanup() {
        int user_answer;
        if (this.mRunningInStaticMode && this.mSet.size() != 0 && (user_answer = JOptionPane.showConfirmDialog(null, "Save current source list before quitting?", "Tango LogViewer", 0)) == 0) {
            this.setLoggingSourceProperty();
        }
        this.removeAllSources();
        try {
            if (!this.mRunningInStaticMode) {
                LOG.debug((Object)"Deleting server from the TANGO database");
                ApiUtil.get_db_obj().delete_server(Util.instance().get_ds_name());
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }
}

