/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.EventDetails;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MyTableModel
extends AbstractTableModel {
    private static double freeMemoryThreshold = 10.0;
    private static double lastFreeMemory = 0.0;
    private static long nEventsThreshold = 50000L;
    private static final int filteredEventsUpdadetTimeThreshold = 100;
    private static final int pendingEventsThreshold = 4096;
    private static final double eventsPercent = 0.5;
    private static final Logger LOG;
    private static final Comparator MY_COMP;
    private static final String[] COL_NAMES;
    private static final EventDetails[] EMPTY_LIST;
    private final Object mLock = new Object();
    private final SortedSet mAllEvents = new TreeSet(MY_COMP);
    private EventDetails[] mFilteredEvents = EMPTY_LIST;
    private final List mPendingEvents = new ArrayList();
    private boolean mPaused = false;
    private String mTimeStampFilter = "";
    private String mThreadFilter = "";
    private String mMessageFilter = "";
    private String mCategoryFilter = "";
    private Level mLevelFilter = Level.DEBUG;
    private final JCheckBox mTrue = new JCheckBox("", true);
    private final JCheckBox mFalse = new JCheckBox("", false);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("fr.esrf.logviewer.MyTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
        MY_COMP = new Comparator(){

            public int compare(Object aObj1, Object aObj2) {
                if (aObj1 == null && aObj2 == null) {
                    return 0;
                }
                if (aObj1 == null) {
                    return -1;
                }
                if (aObj2 == null) {
                    return 1;
                }
                EventDetails le1 = (EventDetails)aObj1;
                EventDetails le2 = (EventDetails)aObj2;
                if (le1.getTimeStamp() < le2.getTimeStamp()) {
                    return 1;
                }
                return -1;
            }
        };
        COL_NAMES = new String[]{"Trace", "Time", "Level", "Source", "Message"};
        EMPTY_LIST = new EventDetails[0];
    }

    public MyTableModel() {
        Thread t = new Thread(new Processor());
        t.setDaemon(true);
        t.start();
    }

    public int getRowCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents.length;
        }
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int aCol) {
        return COL_NAMES[aCol];
    }

    public Class getColumnClass(int aCol) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object getValueAt(int aRow, int aCol) {
        Object object = this.mLock;
        synchronized (object) {
            EventDetails event = this.mFilteredEvents[aRow];
            if (aCol == 0) {
                return event.getThrowableStrRep() == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (aCol == 1) {
                return event.getRenderedTimeStamp();
            }
            if (aCol == 2) {
                return event.getLevel();
            }
            if (aCol == 3) {
                return event.getCategoryName();
            }
            return event.getMessage();
        }
    }

    public void setLevelFilter(Level aLevel) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLevelFilter = aLevel;
            this.updateFilteredEvents(false);
        }
    }

    public void setThreadFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mThreadFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    public void setMessageFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMessageFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    public void setTimeStampFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTimeStampFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    public void setCategoryFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCategoryFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    public void addEvent(EventDetails aEvent) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingEvents.add(aEvent);
        }
    }

    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAllEvents.clear();
            this.mFilteredEvents = new EventDetails[0];
            this.mPendingEvents.clear();
            this.fireTableDataChanged();
        }
    }

    public void clearOldEvents() {
        int n = this.mAllEvents.size();
        LOG.debug((Object)("In clearOldEvents: #before:" + n));
        int n_to_clear = (int)((double)n * 0.5);
        if (n_to_clear <= 0) {
            return;
        }
        int remaining = (int)(0.5 * (double)n);
        LOG.debug((Object)("In clearOldEvents: #to-clear:" + n_to_clear));
        Iterator it = this.mAllEvents.iterator();
        int n_skip = n - n_to_clear;
        int i = 0;
        while (i < n_skip && it.hasNext()) {
            it.next();
            ++i;
        }
        i = 0;
        while (i < n_to_clear && it.hasNext()) {
            EventDetails ed = (EventDetails)it.next();
            if (!ed.getLevel().isGreaterOrEqual((Priority)Level.WARN)) {
                it.remove();
            }
            ++i;
        }
        LOG.debug((Object)("In clearOldEvents: #after:" + this.mAllEvents.size()));
    }

    public void toggle() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPaused = !this.mPaused;
        }
    }

    public boolean isPaused() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPaused;
        }
    }

    public EventDetails getEventDetails(int aRow) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents[aRow];
        }
    }

    private long updateFilteredEvents(boolean aInsertedToFront) {
        long start = System.currentTimeMillis();
        ArrayList<EventDetails> filtered = new ArrayList<EventDetails>();
        int size = this.mAllEvents.size();
        Iterator it = this.mAllEvents.iterator();
        while (it.hasNext()) {
            EventDetails event = (EventDetails)it.next();
            if (!this.matchFilter(event)) continue;
            filtered.add(event);
        }
        EventDetails lastFirst = this.mFilteredEvents.length == 0 ? null : this.mFilteredEvents[0];
        this.mFilteredEvents = filtered.toArray(EMPTY_LIST);
        if (aInsertedToFront && lastFirst != null) {
            int index = filtered.indexOf(lastFirst);
            if (index < 1) {
                LOG.warn((Object)"In strange state");
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(0, index - 1);
            }
        } else {
            this.fireTableDataChanged();
        }
        long end = System.currentTimeMillis();
        LOG.debug((Object)("# logs: " + size));
        LOG.debug((Object)("Update time [ms]: " + (end - start)));
        return end - start;
    }

    private boolean matchFilter(EventDetails aEvent) {
        if (aEvent.getLevel().isGreaterOrEqual((Priority)this.mLevelFilter) && aEvent.getCategoryName().indexOf(this.mCategoryFilter) >= 0 && aEvent.getRenderedTimeStamp().indexOf(this.mTimeStampFilter) >= 0 && aEvent.getThreadName().indexOf(this.mThreadFilter) >= 0) {
            String rm = aEvent.getMessage();
            if (rm == null) {
                return this.mMessageFilter.length() == 0;
            }
            return rm.indexOf(this.mMessageFilter) >= 0;
        }
        return false;
    }

    private class Processor
    implements Runnable {
        private long lastUpdateTime = 0L;

        Processor() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = MyTableModel.this.mLock;
                synchronized (object) {
                    if (MyTableModel.this.mPaused && MyTableModel.this.mPendingEvents.size() < 4096) {
                        continue;
                    }
                    boolean needUpdate = false;
                    Runtime rt = Runtime.getRuntime();
                    double freeMemory = 100.0 * (double)rt.freeMemory() / (double)rt.totalMemory();
                    LOG.debug((Object)("Last free memory    [%]: " + lastFreeMemory));
                    LOG.debug((Object)("Current free memory [%]: " + freeMemory));
                    if (this.lastUpdateTime > 100L && (long)MyTableModel.this.mAllEvents.size() > nEventsThreshold || freeMemory - lastFreeMemory > 5.0 && freeMemory < freeMemoryThreshold) {
                        MyTableModel.this.clearOldEvents();
                        MyTableModel.this.mFilteredEvents = new EventDetails[0];
                        Runtime.getRuntime().gc();
                        lastFreeMemory = 100.0 * (double)rt.freeMemory() / (double)rt.totalMemory();
                        needUpdate = true;
                    } else {
                        lastFreeMemory = freeMemory;
                    }
                    Iterator it = MyTableModel.this.mPendingEvents.iterator();
                    boolean toHead = true;
                    while (it.hasNext()) {
                        EventDetails event = (EventDetails)it.next();
                        MyTableModel.this.mAllEvents.add(event);
                        toHead = toHead && event == MyTableModel.this.mAllEvents.first();
                        boolean bl = needUpdate = needUpdate || MyTableModel.this.matchFilter(event);
                    }
                    MyTableModel.this.mPendingEvents.clear();
                    if (needUpdate) {
                        this.lastUpdateTime = MyTableModel.this.updateFilteredEvents(toHead);
                    }
                }
            }
        }
    }
}

