/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.ControlPanel;
import fr.esrf.logviewer.DetailPanel;
import fr.esrf.logviewer.ExitAction;
import fr.esrf.logviewer.HistoryArea;
import fr.esrf.logviewer.LoadXMLAction;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.logviewer.TangoLoggingReceiver;
import fr.esrf.tangoatk.widget.device.Tree;
import fr.esrf.tangoatk.widget.device.tree.DomainNode;
import fr.esrf.tangoatk.widget.device.tree.FamilyNode;
import fr.esrf.tangoatk.widget.device.tree.MemberNode;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main
extends JFrame {
    private static final Logger LOG;
    private static TangoLoggingReceiver mTlr;
    private static Tree mAtkTree;
    private static JPopupMenu mRootPopup;
    private static JPopupMenu mDomainFamilyPopup;
    private static JPopupMenu mMemberPopup;
    private static JMenu mDomainFamilyLevelMenu;
    private static JMenuItem mDomainFamilyNameItem;
    private static JMenu mMemberLevelMenu;
    private static ButtonGroup mMemberLevelGroup1;
    private static ButtonGroup mMemberLevelGroup2;
    private static JMenuItem mMemberNameItem;
    private static JMenu mMemberColocatedLevelMenu;
    private static JMenuItem mColocatedDevNameItem;
    private static CustomLabel mLabel;
    private static HistoryArea mHistoryArea;
    private boolean mPopupTrigger = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("fr.esrf.logviewer.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    private Main(String[] aArgs) {
        super("Tango LogViewer (exported as ...)");
        String host = System.getProperty("HOST");
        Object ic = null;
        Splash splash = new Splash();
        splash.setTitle("TANGO LogViewer");
        splash.setVersion("1.1.0");
        splash.setAuthor("Stolen and hacked by Nicolas Leclercq");
        splash.setCopyright("(c) TANGO Team 2002-2004 / (c) Apache Project 2002");
        splash.initProgress(10);
        splash.setMessage("Setting up UI...");
        int splashProgression = 1;
        splash.progress(splashProgression++);
        Font font = new Font("terminal", 0, 12);
        UIManager.put("Label.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("Button.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableColumn.font", font);
        UIManager.put("TextArea.font", font);
        MyTableModel model = new MyTableModel();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        try {
            LoadXMLAction lxa = new LoadXMLAction(this, model);
            JMenuItem loadMenuItem = new JMenuItem("Load file...");
            menu.add(loadMenuItem);
            loadMenuItem.addActionListener(lxa);
        }
        catch (NoClassDefFoundError e) {
            LOG.info((Object)"Missing classes for XML parser", (Throwable)e);
            JOptionPane.showMessageDialog(this, "XML parser not in classpath - unable to load XML events.", "Tango LogViewer", 0);
        }
        catch (Exception e) {
            LOG.info((Object)"Unable to create the action to load XML files", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Unable to create a XML parser - unable to load XML events.", "Tango LogViewer", 0);
        }
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        menu.add(exitMenuItem);
        exitMenuItem.addActionListener(ExitAction.INSTANCE);
        JMenu actionMenu = new JMenu("Actions");
        menuBar.add(actionMenu);
        JMenuItem anItem = new JMenuItem("Refresh Device Tree");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mLabel.setText("Refreshing the device tree... ");
                mAtkTree.refresh();
                mLabel.setText(" ");
            }
        });
        actionMenu.add(anItem);
        actionMenu.add(new JSeparator());
        anItem = new JMenuItem("Logging Source List");
        anItem.addActionListener(new SourceListActionListener());
        actionMenu.add(anItem);
        actionMenu.add(new JSeparator());
        anItem = new JMenuItem("Remove All Logging Source");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mLabel.setText("Removing all logging source... ");
                if (mTlr.removeAllSources() != -1) {
                    mHistoryArea.write("Removed all sources");
                }
                mLabel.setText(" ");
            }
        });
        actionMenu.add(anItem);
        splash.progress(splashProgression++);
        ControlPanel cp = new ControlPanel(model);
        this.getContentPane().add((Component)cp, "North");
        splash.progress(splashProgression++);
        JTable table = new JTable(model);
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(true);
        table.setDragEnabled(true);
        table.setSelectionMode(0);
        Enumeration<TableColumn> cenum = table.getColumnModel().getColumns();
        LogTableRowRenderer dtcr = new LogTableRowRenderer();
        int i = 0;
        int[] col_width = new int[]{60, 140, 75, 155, 500};
        while (cenum.hasMoreElements()) {
            TableColumn tc = cenum.nextElement();
            tc.setCellRenderer(dtcr);
            tc.setPreferredWidth(col_width[i++]);
        }
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBorder(BorderFactory.createTitledBorder("Logs"));
        scrollPane.setMinimumSize(new Dimension(150, 150));
        scrollPane.setPreferredSize(new Dimension(790, 450));
        splash.progress(splashProgression++);
        DetailPanel details = new DetailPanel(table, model);
        details.setMinimumSize(new Dimension(0, 0));
        details.setPreferredSize(new Dimension(790, 0));
        splash.progress(splashProgression++);
        JSplitPane jsp1 = new JSplitPane(0, scrollPane, details);
        jsp1.setOneTouchExpandable(true);
        jsp1.setDividerSize(9);
        mAtkTree = new Tree();
        mAtkTree.getSelectionModel().setSelectionMode(1);
        mAtkTree.setMinimumSize(new Dimension(0, 0));
        mAtkTree.setDragEnabled(true);
        mAtkTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Main.this.deviceTreeMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                Main.this.deviceTreeMouseReleased(evt);
            }
        });
        splash.progress(splashProgression++);
        mRootPopup = new JPopupMenu();
        anItem = new JMenuItem("Refresh");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mLabel.setText("Refreshing the device tree... ");
                mAtkTree.refresh();
                mLabel.setText(" ");
            }
        });
        mRootPopup.add(anItem);
        mDomainFamilyPopup = new JPopupMenu();
        mDomainFamilyNameItem = new JMenuItem("domain/family/goes.here");
        mDomainFamilyNameItem.setEnabled(false);
        mDomainFamilyPopup.add(mDomainFamilyNameItem);
        mDomainFamilyPopup.add(new JSeparator());
        anItem = new JMenuItem("Add");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.addLoggingSource();
            }
        });
        mDomainFamilyPopup.add(anItem);
        mDomainFamilyPopup.add(new JSeparator());
        anItem = new JMenuItem("Remove");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.removeLoggingSource();
            }
        });
        mDomainFamilyPopup.add(anItem);
        mDomainFamilyPopup.add(new JSeparator());
        mDomainFamilyPopup.add(new BasicLoggingLevelMenu("Set Logging Level"));
        mMemberPopup = new JPopupMenu();
        mMemberNameItem = new JMenuItem("dev/name/goes.here");
        mMemberNameItem.setEnabled(false);
        mMemberPopup.add(mMemberNameItem);
        mMemberPopup.add(new JSeparator());
        anItem = new JMenuItem("Add");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.addLoggingSource();
            }
        });
        mMemberPopup.add(anItem);
        anItem = new JMenuItem("Add Colocated");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.addColocatedSources();
            }
        });
        mMemberPopup.add(anItem);
        mMemberLevelGroup1 = new ButtonGroup();
        mMemberPopup.add(new LoggingLevelMenu("Add/Set Logging Level", mMemberLevelGroup1, true));
        mMemberPopup.add(new JSeparator());
        anItem = new JMenuItem("Remove");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.removeLoggingSource();
            }
        });
        mMemberPopup.add(anItem);
        anItem = new JMenuItem("Remove Colocated");
        anItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.removeColocatedSources();
            }
        });
        mMemberPopup.add(anItem);
        mMemberPopup.add(anItem);
        mMemberPopup.add(new JSeparator());
        mMemberLevelGroup2 = new ButtonGroup();
        mMemberPopup.add(new LoggingLevelMenu("Set Logging Level", mMemberLevelGroup2, false));
        mMemberPopup.add(new BasicLoggingLevelMenu("Set Logging Level (colocated)"));
        JScrollPane sp = new JScrollPane((Component)mAtkTree);
        JSplitPane jsp2 = new JSplitPane(1, sp, jsp1);
        jsp2.setOneTouchExpandable(true);
        jsp2.setDividerSize(9);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent aEvent) {
                ExitAction.INSTANCE.actionPerformed(null);
            }
        });
        splash.progress(splashProgression++);
        scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createTitledBorder("History"));
        mHistoryArea = new HistoryArea(scrollPane);
        mHistoryArea.setMinimumSize(new Dimension(0, 0));
        Date today = new Date(System.currentTimeMillis());
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        mHistoryArea.write("Welcome to the TANGO LogViewer (started on " + df.format(today) + ")");
        scrollPane.setViewportView(mHistoryArea);
        JSplitPane jsp3 = new JSplitPane(0, jsp2, scrollPane);
        jsp3.setOneTouchExpandable(true);
        jsp3.setDividerSize(9);
        this.getContentPane().add((Component)jsp3, "Center");
        splash.progress(splashProgression++);
        mLabel = new CustomLabel();
        mLabel.setBorder(new SoftBevelBorder(1));
        this.getContentPane().add((Component)mLabel, "South");
        splash.setMessage("Starting up the LogConsumer device...");
        this.setupReceiver(aArgs, model);
        splash.progress(splashProgression++);
        if (mTlr.isRunningInStaticMode()) {
            actionMenu.add(new JSeparator());
            menu = new JMenu("Logging Sources Property");
            anItem = new JMenuItem("Save");
            anItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    mLabel.setText("Saving logging source list into the TANGO database...");
                    mTlr.setLoggingSourceProperty();
                    mLabel.setText(" ");
                }
            });
            menu.add(anItem);
            anItem = new JMenuItem("Delete");
            anItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    mLabel.setText("Deleting logging source list from the TANGO database...");
                    mTlr.deleteLoggingSourceProperty();
                    mLabel.setText(" ");
                }
            });
            menu.add(anItem);
            anItem = new JMenuItem("Restore");
            anItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    mLabel.setText("Restoring logging sources from the TANGO database...");
                    mTlr.removeAllSources();
                    mTlr.getLoggingSourceProperty();
                    mLabel.setText(" ");
                }
            });
            menu.add(anItem);
            actionMenu.add(menu);
        }
        String dev_name = mTlr.getDeviceName();
        this.setTitle("Tango Log Viewer [" + dev_name + "]");
        this.pack();
        this.setLocationRelativeTo((Component)splash);
        splash.setVisible(false);
        this.setVisible(true);
        splash.toFront();
        splash.setVisible(true);
        mAtkTree.setVisible(false);
        splash.setMessage("Initializing device tree...");
        mLabel.setText("Initializing the device tree... ");
        mAtkTree.refresh();
        mLabel.setText(" ");
        splash.progress(splashProgression++);
        splash.setVisible(false);
        splash.dispose();
        mAtkTree.setVisible(true);
    }

    private void setupReceiver(String[] aArgs, MyTableModel aModel) {
        try {
            mTlr = new TangoLoggingReceiver(aArgs, aModel, mHistoryArea);
            mTlr.start();
        }
        catch (Exception e) {
            LOG.fatal((Object)"Unable to instanciate the TANGO log consumer device. Quiting", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Unable to instanciate the TANGO log consumer device. Quiting", "Tango Log Viewer", 0);
            System.exit(1);
        }
    }

    private void addLoggingSource() {
        Object n = mAtkTree.getLastSelectedPathComponent();
        if (n == null || !(n instanceof DomainNode)) {
            return;
        }
        if (n instanceof MemberNode) {
            String devname = ((MemberNode)n).getName();
            mLabel.setText("Contacting " + devname + "...");
            if (mTlr.addLoggingSource(devname) != -1) {
                mHistoryArea.write("Added " + devname);
            }
        } else {
            String suffix = "logging sources matching " + ((DomainNode)n).getName() + "/*";
            mLabel.setText("Adding " + suffix);
            if (mTlr.addLoggingSources(String.valueOf(((DomainNode)n).getName()) + "/*") != -1) {
                mHistoryArea.write("Added " + suffix);
            }
        }
        mLabel.reset();
    }

    private void addTangoCoreLogger() {
        Object n = mAtkTree.getLastSelectedPathComponent();
        if (n == null || !(n instanceof DomainNode)) {
            return;
        }
        if (n instanceof MemberNode) {
            String devname = ((MemberNode)n).getName();
            mLabel.setText("Contacting admin device for " + devname);
            if (mTlr.addTangoCoreLogger(devname) != -1) {
                mHistoryArea.write("Added Tango core logger for " + devname);
            }
        }
        mLabel.reset();
    }

    private void addColocatedSources() {
        Object n = mAtkTree.getLastSelectedPathComponent();
        if (n == null || !(n instanceof MemberNode)) {
            return;
        }
        String devname = ((MemberNode)n).getName();
        mLabel.setText("Adding  " + devname + " and colocated devices...");
        if (mTlr.addColocatedSources(devname) != -1) {
            mHistoryArea.write("Added  " + devname + " and colocated devices");
        }
        mLabel.reset();
    }

    private void removeLoggingSource() {
        Object n = mAtkTree.getLastSelectedPathComponent();
        if (n == null || !(n instanceof DomainNode)) {
            return;
        }
        if (n instanceof MemberNode) {
            String devname = ((MemberNode)n).getName();
            mLabel.setText("Contacting " + devname + "...");
            if (mTlr.removeLoggingSource(devname) != -1) {
                mHistoryArea.write("Removed " + devname);
            }
        } else {
            String suffix = "logging sources matching " + ((DomainNode)n).getName() + "/*";
            mLabel.setText("Removing " + suffix);
            if (mTlr.removeLoggingSources(String.valueOf(((DomainNode)n).getName()) + "/*") != -1) {
                mHistoryArea.write("Removed " + suffix);
            }
        }
        mLabel.reset();
    }

    private void removeTangoCoreLogger() {
        Object n = mAtkTree.getLastSelectedPathComponent();
        if (n == null || !(n instanceof DomainNode)) {
            return;
        }
        if (n instanceof MemberNode) {
            String devname = ((MemberNode)n).getName();
            mLabel.setText("Contacting admin device for " + devname);
            if (mTlr.removeTangoCoreLogger(devname) != -1) {
                mHistoryArea.write("Removed Tango core logger for " + devname);
            }
        }
        mLabel.reset();
    }

    private void removeColocatedSources() {
        Object n = mAtkTree.getLastSelectedPathComponent();
        if (n == null || !(n instanceof MemberNode)) {
            return;
        }
        String devname = ((MemberNode)n).getName();
        mLabel.setText("Removing  " + devname + " and colocated devices...");
        if (mTlr.removeColocatedSources(devname) != -1) {
            mHistoryArea.write("Removed  " + devname + " and colocated devices");
        }
        mLabel.reset();
    }

    public void deviceTreeMousePressed(MouseEvent evt) {
        int selectedRow = mAtkTree.getRowForLocation(evt.getX(), evt.getY());
        if (selectedRow != -1) {
            LoggingLevelMenuItem item;
            this.mPopupTrigger = evt.isPopupTrigger();
            mAtkTree.setSelectionRow(selectedRow);
            Object n = mAtkTree.getLastSelectedPathComponent();
            if (n == null || !(n instanceof MemberNode)) {
                return;
            }
            mLabel.setText("Contacting " + ((MemberNode)n).getName());
            int level = mTlr.getDeviceLoggingLevel(((MemberNode)n).getName());
            mLabel.reset();
            if (level == -1) {
                return;
            }
            Enumeration<AbstractButton> enumeration = mMemberLevelGroup1.getElements();
            while (enumeration.hasMoreElements()) {
                item = (LoggingLevelMenuItem)enumeration.nextElement();
                if (item.getLevel() != level) continue;
                item.setSelected(true);
                break;
            }
            enumeration = mMemberLevelGroup2.getElements();
            while (enumeration.hasMoreElements()) {
                item = (LoggingLevelMenuItem)enumeration.nextElement();
                if (item.getLevel() != level) continue;
                item.setSelected(true);
                break;
            }
        }
    }

    public void deviceTreeMouseReleased(MouseEvent evt) {
        int selectedRow = mAtkTree.getRowForLocation(evt.getX(), evt.getY());
        if (selectedRow != -1 && (evt.isPopupTrigger() || this.mPopupTrigger)) {
            mAtkTree.setSelectionRow(selectedRow);
            Object n = mAtkTree.getLastSelectedPathComponent();
            if (n == null || !(n instanceof DefaultMutableTreeNode)) {
                return;
            }
            LOG.debug((Object)("n is a " + n.getClass().getName()));
            if (n instanceof MemberNode) {
                mMemberNameItem.setText(((DomainNode)n).getName());
                mMemberPopup.show(evt.getComponent(), evt.getX(), evt.getY());
            } else if (n instanceof DomainNode || n instanceof FamilyNode) {
                mDomainFamilyNameItem.setText(((DomainNode)n).getName());
                mDomainFamilyPopup.show(evt.getComponent(), evt.getX(), evt.getY());
            } else {
                mRootPopup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private static void initLog4J() {
        Properties props = new Properties();
        props.setProperty("log4j.rootCategory", "ERROR, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)props);
    }

    public static void cleanup() {
        mTlr.cleanup();
    }

    public static void main(String[] aArgs) {
        Main.initLog4J();
        new Main(aArgs);
    }

    private class SourceListActionListener
    implements ActionListener {
        SourceListActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            mHistoryArea.write("Current source list:");
            String[] slist = mTlr.getLoggingSources();
            if (slist.length == 0) {
                mHistoryArea.write("\t- none");
            } else {
                int i = 0;
                while (i < slist.length) {
                    mHistoryArea.write("\t- " + slist[i]);
                    ++i;
                }
            }
        }
    }

    private class BasicLevelActionListener
    implements ActionListener {
        BasicLevelActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String levelStr = ((JMenuItem)e.getSource()).getText();
            Object n = mAtkTree.getLastSelectedPathComponent();
            if (n == null) {
                return;
            }
            int level = ((BasicLoggingLevelMenuItem)e.getSource()).getLevel();
            String suffix = "logging level for devices matching " + ((DomainNode)n).getName() + "/* to " + levelStr;
            mLabel.setText("Changing " + suffix);
            if (mTlr.setDevicesLoggingLevel(String.valueOf(((DomainNode)n).getName()) + "/*", level) != -1) {
                mHistoryArea.write("Changed " + suffix);
            }
            mLabel.reset();
        }
    }

    private class BasicLoggingLevelMenuItem
    extends JMenuItem {
        private int mLevel;

        public BasicLoggingLevelMenuItem(String iText, int iLevel) {
            super(iText);
            this.mLevel = iLevel;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }

    private class BasicLoggingLevelMenu
    extends JMenu {
        public BasicLoggingLevelMenu(String title) {
            super(title);
            BasicLoggingLevelMenuItem anItem = new BasicLoggingLevelMenuItem("OFF", 0);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("FATAL", 1);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("ERROR", 2);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("WARN", 3);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("INFO", 4);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
            anItem = new BasicLoggingLevelMenuItem("DEBUG", 5);
            anItem.addActionListener(new BasicLevelActionListener());
            this.add(anItem);
        }
    }

    private class LevelActionListener
    implements ActionListener {
        private boolean mAddBefore = false;

        public LevelActionListener(boolean add_before) {
            this.mAddBefore = add_before;
        }

        public void actionPerformed(ActionEvent e) {
            String levelStr = ((JMenuItem)e.getSource()).getText();
            Object n = mAtkTree.getLastSelectedPathComponent();
            if (n == null || !(n instanceof DomainNode)) {
                return;
            }
            if (n instanceof MemberNode) {
                int level = ((LoggingLevelMenuItem)e.getSource()).getLevel();
                String devname = ((MemberNode)n).getName();
                mLabel.setText("Contacting " + devname + "...");
                if (mTlr.setDeviceLoggingLevel(devname, level, this.mAddBefore) != -1) {
                    if (this.mAddBefore) {
                        mHistoryArea.write("Added " + devname);
                    }
                    mHistoryArea.write("Changed " + devname + " logging level to " + levelStr);
                }
            } else {
                int level = ((BasicLoggingLevelMenuItem)e.getSource()).getLevel();
                String suffix = "for sources matching " + ((DomainNode)n).getName() + "/* to " + levelStr;
                mLabel.setText("Setting logging level " + suffix);
                if (mTlr.setDevicesLoggingLevel(String.valueOf(((DomainNode)n).getName()) + "/*", level) != -1) {
                    mHistoryArea.write("Changed logging level " + suffix);
                }
            }
            mLabel.reset();
        }
    }

    private class LoggingLevelMenuItem
    extends JRadioButtonMenuItem {
        private int mLevel;

        public LoggingLevelMenuItem(String iText, int iLevel) {
            super(iText);
            this.mLevel = iLevel;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }

    private class LoggingLevelMenu
    extends JMenu {
        public LoggingLevelMenu(String title, ButtonGroup _group, boolean add_before) {
            super(title);
            ButtonGroup group = _group != null ? _group : new ButtonGroup();
            LoggingLevelMenuItem lItem = new LoggingLevelMenuItem("OFF", 0);
            lItem.addActionListener(new LevelActionListener(add_before));
            lItem.setSelected(true);
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("FATAL", 1);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("ERROR", 2);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("WARN", 3);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("INFO", 4);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
            lItem = new LoggingLevelMenuItem("DEBUG", 5);
            lItem.addActionListener(new LevelActionListener(add_before));
            group.add(lItem);
            this.add(lItem);
        }
    }

    private class CustomLabel
    extends JLabel {
        public CustomLabel() {
            super.setText(" ");
        }

        public void setText(String txt) {
            super.setText(txt);
            this.update(this.getGraphics());
        }

        public void reset() {
            this.setText(" ");
        }
    }

    public class LogTableRowRenderer
    extends DefaultTableCellRenderer {
        private final Color _scolor = new Color(204, 204, 255);
        private final Color _color = new Color(230, 230, 230);
        private final JCheckBox _true = new JCheckBox("", true);
        private final JCheckBox _false = new JCheckBox("", false);

        LogTableRowRenderer() {
            this.setHorizontalAlignment(0);
            this._true.setHorizontalAlignment(0);
            this._false.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String col_header = (String)table.getColumnModel().getColumn(col).getHeaderValue();
            if (isSelected) {
                this.setBackground(this._scolor);
            } else if (col_header.equals("Level")) {
                Level level = (Level)value;
                if (level == Level.FATAL) {
                    this.setBackground(Color.black);
                    this.setForeground(Color.white);
                } else if (level == Level.ERROR) {
                    this.setBackground(Color.red);
                    this.setForeground(Color.black);
                } else if (level == Level.WARN) {
                    this.setBackground(Color.orange);
                    this.setForeground(Color.black);
                } else if (level == Level.INFO) {
                    this.setBackground(Color.green);
                    this.setForeground(Color.black);
                } else if (level == Level.DEBUG) {
                    this.setBackground(Color.cyan);
                    this.setForeground(Color.black);
                }
            } else {
                if (row % 2 == 0) {
                    this.setBackground(this._color);
                } else {
                    this.setBackground(Color.white);
                }
                this.setForeground(Color.black);
            }
            if (col_header.equals("Trace")) {
                JCheckBox cb = (Boolean)value == Boolean.TRUE ? this._true : this._false;
                return cb;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
    }
}

