/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class EventDetails {
    private final long mTimeStamp;
    private final String mTimeStampStr;
    private final Level mLevel;
    private final String mCategoryName;
    private final String mNDC;
    private final String mThreadName;
    private final String mMessage;
    private final String[] mThrowableStrRep;
    private final String mLocationDetails;
    private static final DateFormat mDateFormatter = DateFormat.getDateTimeInstance(3, 2);

    public EventDetails(long aTimeStamp, Level aLevel, String aCategoryName, String aNDC, String aThreadName, String aMessage, String[] aThrowableStrRep, String aLocationDetails) {
        this.mTimeStamp = aTimeStamp;
        Timestamp tms = new Timestamp(this.mTimeStamp);
        this.mTimeStampStr = String.valueOf(mDateFormatter.format(new Date(this.mTimeStamp))) + "." + tms.getNanos() / 1000000;
        this.mLevel = aLevel;
        this.mCategoryName = aCategoryName;
        this.mNDC = aNDC;
        this.mThreadName = aThreadName;
        this.mMessage = aMessage;
        this.mThrowableStrRep = aThrowableStrRep;
        this.mLocationDetails = aLocationDetails;
    }

    EventDetails(LoggingEvent anEvent) {
        this(anEvent.timeStamp, anEvent.getLevel(), anEvent.getLoggerName(), anEvent.getNDC(), anEvent.getThreadName(), anEvent.getRenderedMessage(), anEvent.getThrowableStrRep(), anEvent.getLocationInformation() == null ? null : anEvent.getLocationInformation().fullInfo);
    }

    long getTimeStamp() {
        return this.mTimeStamp;
    }

    String getRenderedTimeStamp() {
        return this.mTimeStampStr;
    }

    Level getLevel() {
        return this.mLevel;
    }

    String getCategoryName() {
        return this.mCategoryName;
    }

    String getNDC() {
        return this.mNDC;
    }

    String getThreadName() {
        return this.mThreadName;
    }

    String getMessage() {
        return this.mMessage;
    }

    String getLocationDetails() {
        return this.mLocationDetails;
    }

    String[] getThrowableStrRep() {
        return this.mThrowableStrRep;
    }
}

