/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.EventDetails;
import fr.esrf.logviewer.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class DetailPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG;
    private static final MessageFormat FORMATTER;
    private final MyTableModel mModel;
    private final JEditorPane mDetails;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("fr.esrf.logviewer.DetailPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
        FORMATTER = new MessageFormat("<b>Time:</b> <code>{0}</code>&nbsp;&nbsp;<b>Level:</b> <code>{1}</code>&nbsp;&nbsp;<b>Device:</b> <code>{3}</code>&nbsp;&nbsp;<b>Thread:</b> <code>{2}</code><pre>{4}</pre>");
    }

    public DetailPanel(JTable aTable, MyTableModel aModel) {
        this.mModel = aModel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Log Details"));
        this.mDetails = new JEditorPane();
        this.mDetails.setEditable(false);
        this.mDetails.setContentType("text/html");
        this.add((Component)new JScrollPane(this.mDetails), "Center");
        ListSelectionModel rowSM = aTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent aEvent) {
        if (aEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)aEvent.getSource();
        if (lsm.isSelectionEmpty()) {
            this.mDetails.setText("Nothing selected");
        } else {
            int selectedRow = lsm.getMinSelectionIndex();
            EventDetails e = this.mModel.getEventDetails(selectedRow);
            Object[] args = new Object[]{e.getRenderedTimeStamp(), e.getLevel(), this.escape(e.getThreadName()), this.escape(e.getCategoryName()), this.escape(e.getMessage())};
            this.mDetails.setText(FORMATTER.format(args));
            this.mDetails.setCaretPosition(0);
        }
    }

    private static String getThrowableStrRep(EventDetails aEvent) {
        String[] strs = aEvent.getThrowableStrRep();
        if (strs == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            sb.append(strs[i]).append("\n");
            ++i;
        }
        return sb.toString();
    }

    private String escape(String aStr) {
        if (aStr == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < aStr.length()) {
            char c = aStr.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

