/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.ExitAction;
import fr.esrf.logviewer.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

class ControlPanel
extends JPanel {
    private static final Logger LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("fr.esrf.logviewer.ControlPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    ControlPanel(final MyTableModel aModel) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Controls"));
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Level Filter");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jp.add((Component)label, gridBagConstraints);
        int gridy = 1;
        label = new JLabel("Time Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jp.add((Component)label, gridBagConstraints);
        label = new JLabel("Thread Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jp.add((Component)label, gridBagConstraints);
        label = new JLabel("Source Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jp.add((Component)label, gridBagConstraints);
        label = new JLabel("Message Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jp.add((Component)label, gridBagConstraints);
        Level[] levels = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG};
        final JComboBox<Level> priorities = new JComboBox<Level>(levels);
        Level lowest = levels[levels.length - 1];
        priorities.setSelectedItem(lowest);
        aModel.setLevelFilter(lowest);
        priorities.setEditable(false);
        priorities.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aEvent) {
                aModel.setLevelFilter((Level)priorities.getSelectedItem());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        jp.add(priorities, gridBagConstraints);
        gridy = 1;
        final JTextField timeField = new JTextField("");
        timeField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent aEvent) {
                aModel.setTimeStampFilter(timeField.getText());
            }

            public void removeUpdate(DocumentEvent aEvent) {
                aModel.setTimeStampFilter(timeField.getText());
            }

            public void changedUpdate(DocumentEvent aEvent) {
                aModel.setTimeStampFilter(timeField.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jp.add((Component)timeField, gridBagConstraints);
        final JTextField threadField = new JTextField("");
        threadField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent aEvent) {
                aModel.setThreadFilter(threadField.getText());
            }

            public void removeUpdate(DocumentEvent aEvente) {
                aModel.setThreadFilter(threadField.getText());
            }

            public void changedUpdate(DocumentEvent aEvent) {
                aModel.setThreadFilter(threadField.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jp.add((Component)threadField, gridBagConstraints);
        final JTextField catField = new JTextField("");
        catField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent aEvent) {
                aModel.setCategoryFilter(catField.getText());
            }

            public void removeUpdate(DocumentEvent aEvent) {
                aModel.setCategoryFilter(catField.getText());
            }

            public void changedUpdate(DocumentEvent aEvent) {
                aModel.setCategoryFilter(catField.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jp.add((Component)catField, gridBagConstraints);
        final JTextField msgField = new JTextField("");
        msgField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent aEvent) {
                aModel.setMessageFilter(msgField.getText());
            }

            public void removeUpdate(DocumentEvent aEvent) {
                aModel.setMessageFilter(msgField.getText());
            }

            public void changedUpdate(DocumentEvent aEvent) {
                aModel.setMessageFilter(msgField.getText());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jp.add((Component)msgField, gridBagConstraints);
        gridy = 1;
        JButton exitButton = new JButton("Exit");
        exitButton.setMnemonic('x');
        exitButton.addActionListener(ExitAction.INSTANCE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jp.add((Component)exitButton, gridBagConstraints);
        JButton dummyButton = new JButton(" ");
        dummyButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jp.add((Component)dummyButton, gridBagConstraints);
        JButton clearButton = new JButton("Clear");
        clearButton.setMnemonic('c');
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aEvent) {
                aModel.clear();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jp.add((Component)clearButton, gridBagConstraints);
        final JButton toggleButton = new JButton("Pause");
        toggleButton.setMnemonic('p');
        toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aEvent) {
                aModel.toggle();
                toggleButton.setText(aModel.isPaused() ? "Resume" : "Pause");
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jp.add((Component)toggleButton, gridBagConstraints);
        this.add((Component)jp, "Center");
    }
}

