/*
 * Decompiled with CFR 0.152.
 */
package LogConsumer;

import LogConsumer.SourceSet;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import fr.esrf.logviewer.EventDetails;
import fr.esrf.logviewer.MyTableModel;
import org.apache.log4j.Level;

public class LogConsumer
extends DeviceImpl
implements TangoConst {
    protected int state;
    private MyTableModel mModel;

    LogConsumer(DeviceClass cl, String s) throws DevFailed {
        super(cl, s);
        this.init_device();
    }

    LogConsumer(DeviceClass cl, String s, String d) throws DevFailed {
        super(cl, s, d);
        this.init_device();
    }

    public void init_device() throws DevFailed {
        this.get_logger().debug((Object)("LogConsumer ctor: allocating " + this.device_name + " resources"));
        this.set_state(DevState.ON);
    }

    public void delete_device() throws DevFailed {
        this.get_logger().debug((Object)("LogConsumer dtor: releasing " + this.device_name + " resources"));
        this.set_state(DevState.OFF);
    }

    public void always_executed_hook() {
        Util.out2.println("In always_executed_hook method()");
    }

    public void log(String[] argin) throws DevFailed {
        int num_logs = argin.length / 6;
        if (num_logs != 0) {
            try {
                int idx = 0;
                String[] loc = new String[]{""};
                int i = 0;
                while (i < num_logs) {
                    this.mModel.addEvent(new EventDetails(Long.parseLong(argin[idx]), Level.toLevel((String)argin[idx + 1]), argin[idx + 2], argin[idx + 4], argin[idx + 5], argin[idx + 3], loc, ""));
                    idx += 6;
                    ++i;
                }
            }
            catch (OutOfMemoryError e) {
                this.get_logger().debug((Object)"mModel.addEvent failed: OutOfMemoryError caught");
            }
            catch (Throwable e) {
                this.get_logger().debug((Object)"mModel.addEvent failed: unknown exception caught");
                this.get_logger().debug((Object)e);
            }
        }
    }

    public void log_xml(String argin) throws DevFailed {
        this.get_logger().debug((Object)argin);
    }

    public void register(String argin) throws DevFailed {
        String[] loc = new String[]{""};
        this.mModel.addEvent(new EventDetails(System.currentTimeMillis(), Level.toLevel((String)"INFO"), "LogViewer", "", "Local Thread", "Registering logging source: " + argin, loc, ""));
        SourceSet.instance().add(argin);
    }

    public void unregister(String argin) throws DevFailed {
        String[] loc = new String[]{""};
        this.mModel.addEvent(new EventDetails(System.currentTimeMillis(), Level.toLevel((String)"INFO"), "LogViewer", "", "Local Thread", "Unregistering logging source: " + argin, loc, ""));
        SourceSet.instance().remove(argin);
    }

    public void setModel(MyTableModel aModel) {
        this.mModel = aModel;
    }
}

