/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import jive3.JTextTips;

class TipPopup
implements MouseMotionListener,
MouseListener {
    String[] items;
    JLabel text;
    JScrollPane textView;
    JTextTips parent;
    Popup popup;
    int hFont;
    int selectedIdx = -1;
    int[] globalIdx = null;
    boolean visible = false;
    String prefix;
    int compWidth;

    TipPopup(JTextTips jTextTips) {
        this.parent = jTextTips;
        this.text = new JLabel();
        this.text.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.text.setBackground(new Color(245, 245, 250));
        this.text.setHorizontalAlignment(2);
        this.text.setOpaque(true);
        this.hFont = (int)(ATKGraphicsUtils.measureString((String)"ABC", (Font)this.text.getFont()).getHeight() + 0.5) + 1;
        this.text.addMouseMotionListener(this);
        this.text.addMouseListener(this);
        this.textView = new JScrollPane(this.text);
        this.textView.setHorizontalScrollBarPolicy(31);
    }

    void setList(String[] stringArray) {
        this.items = stringArray;
    }

    void down() {
        if (this.visible && this.selectedIdx < this.globalIdx.length - 1) {
            ++this.selectedIdx;
            this.buildText();
            if (this.selectedIdx >= 0) {
                this.parent.setTextInternal(this.items[this.globalIdx[this.selectedIdx]]);
            }
            this.scrollToVisible();
        }
    }

    void up() {
        if (this.visible && this.selectedIdx > 0) {
            --this.selectedIdx;
            this.buildText();
            if (this.selectedIdx < this.globalIdx.length) {
                this.parent.setTextInternal(this.items[this.globalIdx[this.selectedIdx]]);
            }
            this.scrollToVisible();
        }
    }

    void select() {
        if (this.selectedIdx >= 0 && this.selectedIdx < this.globalIdx.length) {
            this.parent.setTextInternal(this.items[this.globalIdx[this.selectedIdx]]);
        }
        this.selectedIdx = -1;
        this.globalIdx = new int[0];
        this.setVisible(false);
    }

    void scrollToVisible() {
        Rectangle rectangle = new Rectangle();
        this.parent.getBounds(rectangle);
        rectangle.x = 0;
        rectangle.y = this.selectedIdx * this.hFont;
        rectangle.height = this.hFont;
        this.text.scrollRectToVisible(rectangle);
    }

    int buildText() {
        int n;
        if (this.items == null || this.items.length == 0) {
            return 0;
        }
        String string = this.prefix.toLowerCase();
        int n2 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("<table cellpadding=\"0\" cellspacing=\"0\" width=\"" + this.compWidth + "px\">\n");
        for (n = 0; n < this.items.length; ++n) {
            if (!this.items[n].toLowerCase().startsWith(string)) continue;
            String string2 = "<font color=\"#000000\" >" + this.prefix + "</font><font color=\"#A5A5A5\">" + this.items[n].substring(this.prefix.length()) + "</font>";
            if (n2 == this.selectedIdx) {
                stringBuffer.append("<tr><td bgcolor=\"#959595\">" + string2 + "</td></tr>");
            } else {
                stringBuffer.append("<tr><td>" + string2 + "</td></tr>");
            }
            vector.add(n);
            ++n2;
        }
        stringBuffer.append("</table>\n");
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        this.text.setText(stringBuffer.toString());
        this.globalIdx = new int[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.globalIdx[n] = (Integer)vector.get(n);
        }
        return n2;
    }

    void updateText() {
        this.selectedIdx = -1;
        this.globalIdx = new int[0];
        this.prefix = this.parent.getText();
        this.setVisible(this.buildText() > 0);
    }

    public void setVisible(boolean bl) {
        if (this.popup != null) {
            this.popup.hide();
        }
        if (bl) {
            Rectangle rectangle = new Rectangle();
            this.parent.getBounds(rectangle);
            this.compWidth = rectangle.width;
            int n = this.text.getPreferredSize().height + 10;
            if (n > 150) {
                n = 150;
            }
            this.textView.setPreferredSize(new Dimension(rectangle.width, n));
            Point point = this.parent.getLocationOnScreen();
            this.popup = PopupFactory.getSharedInstance().getPopup(this.parent, this.textView, point.x, point.y + rectangle.height);
            this.popup.show();
        }
        this.visible = bl;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.selectedIdx = mouseEvent.getY() / this.hFont;
        this.buildText();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.selectedIdx = mouseEvent.getY() / this.hFont;
        this.select();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

