/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskLoggingNode
extends TangoNode {
    private Database db;
    private String devName;

    TaskLoggingNode(Database database, String string) {
        this.db = database;
        this.devName = string;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.leaflogicon;
    }

    @Override
    public String toString() {
        return "Logging";
    }

    @Override
    String getTitle() {
        return "Logging";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    String getCurrentLoggingLevel() {
        String[] stringArray = JiveUtils.getLoggingStatus(this.db, this.devName, 0);
        return JiveUtils.stringArrayToString(stringArray);
    }

    void setCurrentLoggingLevel(String string) {
        JiveUtils.setLoggingLevel(this.db, this.devName, string);
    }

    String getCurrentLoggingTarget() {
        String[] stringArray = JiveUtils.getLoggingStatus(this.db, this.devName, 1);
        return JiveUtils.stringArrayToString(stringArray);
    }

    void setCurrentLoggingTarget(String string) {
        JiveUtils.setLoggingTarget(this.db, this.devName, string);
    }

    String getLoggingLevel() {
        try {
            String[] stringArray = this.db.get_device_property(this.devName, "logging_level").extractStringArray();
            return JiveUtils.stringArrayToString(stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return "";
        }
    }

    void setLoggingLevel(String string) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("logging_level", string));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLoggingLevel() {
        try {
            this.db.delete_device_property(this.devName, "logging_level");
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getLoggingTarget() {
        try {
            String[] stringArray = this.db.get_device_property(this.devName, "logging_target").extractStringArray();
            return JiveUtils.stringArrayToString(stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return "";
        }
    }

    void setLoggingTarget(String string) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("logging_target", string));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLoggingTarget() {
        try {
            this.db.delete_device_property(this.devName, "logging_target");
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getLoggingRft() {
        try {
            String[] stringArray = this.db.get_device_property(this.devName, "logging_rft").extractStringArray();
            return JiveUtils.stringArrayToString(stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return "2";
        }
    }

    void setLoggingRft(String string) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum("logging_rft", string));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLoggingRft() {
        try {
            this.db.delete_device_property(this.devName, "logging_rft");
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }
}

