/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import jive3.TangoNode;

class DefaultPanel
extends JPanel
implements ActionListener {
    private JTextArea value;
    private JScrollPane valueView;
    private JPanel btnPanel;
    private JButton refreshButton;
    private TangoNode src = null;
    private int size;

    DefaultPanel() {
        this.setLayout(new BorderLayout());
        this.value = new JTextArea();
        this.value.setEditable(false);
        this.value.setDragEnabled(true);
        this.value.setFont(new Font("Monospaced", 0, 11));
        this.value.setBorder(BorderFactory.createLoweredBevelBorder());
        this.valueView = new JScrollPane(this.value);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.valueView.setBorder(titledBorder);
        this.add((Component)this.valueView, "Center");
        this.btnPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.btnPanel.add(this.refreshButton);
        this.add((Component)this.btnPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refreshValue();
        }
    }

    void setSource(TangoNode tangoNode, int n) {
        this.src = tangoNode;
        this.size = n;
        this.refreshValue();
    }

    private void refreshValue() {
        if (this.src != null) {
            this.value.setText(this.src.getValue());
            this.value.setCaretPosition(0);
            String string = this.src.getTitle();
            if (this.size > 1) {
                string = string + " [" + this.size + " items]";
            }
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.valueView.setBorder(titledBorder);
        } else {
            this.value.setText("");
            this.value.setCaretPosition(0);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
            this.valueView.setBorder(titledBorder);
        }
    }
}

