/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DevicePipe;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.PipeBlob;
import fr.esrf.TangoApi.PipeDataElement;
import fr.esrf.TangoApi.PipeInfo;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jive.ArgParser;
import jive.CommonPanel;
import jive.ConsolePanel;
import jive.TransferableString;

class PipePanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TangoConst,
MouseListener,
ClipboardOwner,
DragGestureListener,
DragSourceListener {
    private List<PipeInfo> pipeInfo;
    private ConsolePanel console;
    private DeviceProxy device;
    private CommonPanel common;
    private JComboBox arginCombo;
    private JLabel arginLabel;
    private JLabel descrLabel;
    private JList pipeList;
    private JScrollPane pipeView;
    private JTextArea descrList;
    private JScrollPane descrView;
    private JButton readBtn;
    private JButton writeBtn;
    private JButton helpBtn;
    private JPopupMenu copyMenu;
    private JMenuItem copyAttributeMenuItem;
    private JMenuItem copyDevAttributeMenuItem;

    PipePanel(DeviceProxy deviceProxy, ConsolePanel consolePanel, CommonPanel commonPanel) throws DevFailed {
        this.setLayout(null);
        this.console = consolePanel;
        this.common = commonPanel;
        this.device = deviceProxy;
        this.pipeInfo = this.getPipeInfo();
        this.arginLabel = new JLabel("Argin value");
        this.arginLabel.setFont(ATKConstant.labelFont);
        this.add(this.arginLabel);
        this.descrLabel = new JLabel();
        this.descrLabel.setFont(ATKConstant.labelFont);
        this.descrLabel.setHorizontalAlignment(4);
        this.add(this.descrLabel);
        this.arginCombo = new JComboBox();
        this.arginCombo.setEditable(true);
        this.arginCombo.setFont(ATKConstant.labelFont);
        this.add(this.arginCombo);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < this.pipeInfo.size(); ++i) {
            defaultListModel.add(i, this.pipeInfo.get(i).getName());
        }
        this.pipeList = new JList(defaultListModel);
        this.pipeList.addListSelectionListener(this);
        this.pipeList.addMouseListener(this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.pipeList, 2, this);
        this.pipeView = new JScrollPane(this.pipeList);
        this.add(this.pipeView);
        this.descrList = new JTextArea();
        this.descrList.setFont(new Font("monospaced", 0, 12));
        this.descrList.setEditable(false);
        this.descrView = new JScrollPane(this.descrList);
        this.add(this.descrView);
        this.readBtn = new JButton("Read");
        this.readBtn.setFont(ATKConstant.labelFont);
        this.add(this.readBtn);
        this.readBtn.addActionListener(this);
        this.writeBtn = new JButton("Write");
        this.writeBtn.setFont(ATKConstant.labelFont);
        this.add(this.writeBtn);
        this.writeBtn.addActionListener(this);
        this.helpBtn = new JButton("Help");
        this.helpBtn.setFont(ATKConstant.labelFont);
        this.add(this.helpBtn);
        this.helpBtn.addActionListener(this);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PipePanel.this.placeComponents(PipePanel.this.getSize());
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                PipePanel.this.placeComponents(PipePanel.this.getSize());
            }
        });
        this.pipeList.setSelectedIndex(0);
        this.copyMenu = new JPopupMenu();
        this.copyAttributeMenuItem = new JMenuItem("Copy pipe name");
        this.copyAttributeMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyAttributeMenuItem);
        this.copyDevAttributeMenuItem = new JMenuItem("Copy device/pipe name");
        this.copyDevAttributeMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyDevAttributeMenuItem);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.pipeList.getSelectedIndex();
        if (this.pipeInfo.size() == 0) {
            return;
        }
        PipeInfo pipeInfo = this.pipeInfo.get(n);
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (pipeInfo.isWritable()) {
                this.descrLabel.setText("  Blobname,[ Name1,type1,value1 ],... (Help for details)");
                this.arginCombo.setEnabled(true);
                this.writeBtn.setEnabled(true);
                this.helpBtn.setEnabled(true);
            } else {
                this.descrLabel.setText("");
                this.arginCombo.setEnabled(false);
                this.writeBtn.setEnabled(false);
                this.helpBtn.setEnabled(false);
            }
            this.descrList.setText("Name         " + pipeInfo.getName() + "\n" + "Label        " + pipeInfo.getLabel() + "\n" + "Writable     " + Boolean.toString(pipeInfo.isWritable()) + "\n" + "Level        " + pipeInfo.getLevel() + "\n" + "Descr        " + pipeInfo.getDescription());
            this.descrList.setCaretPosition(0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.pipeList) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                this.readPipe();
            }
            if (mouseEvent.getButton() == 3) {
                this.copyMenu.show(this.pipeList, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new TransferableString(this.getCopyString(false)), this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.readBtn) {
            this.readPipe();
        } else if (object == this.writeBtn) {
            this.writePipe();
        } else if (object == this.helpBtn) {
            String string = "Argin syntax for a blob:\n Blobname,[ Name1,type1,value1 ],[ Name2,typ2,value2 ],... \n where the value is formatted as \n   D,1,2.5,3,4      (double)\n   F,1.0,2.3,4,4    (float)\n  UC,1,2,3,4        (unsigned char)\n   S,1,-2,3,4       (short)\n  US,1,2,3,4        (unsigned short)\n   L,1,-2,3,4       (long)\n  UL,1,2,3,4        (unsigned long)\n  LL,1,2,3,4        (int64)\n  ST,ON,OFF,STANDY  (state)\n STR,\"str 1\",str2   (string)\n [ blob ]   (inner blob)\n";
            JOptionPane.showMessageDialog(this, string, "Argin syntax", 1);
        } else if (object == this.copyAttributeMenuItem) {
            this.copyAttributeToClipboard(true);
        } else if (object == this.copyDevAttributeMenuItem) {
            this.copyAttributeToClipboard(false);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimunSize();
    }

    public Dimension getMinimunSize() {
        return new Dimension(470, 210);
    }

    private String getCopyString(boolean bl) {
        String string = "";
        PipeInfo pipeInfo = this.pipeInfo.get(this.pipeList.getSelectedIndex());
        string = bl ? pipeInfo.getName() : this.device.get_name() + "/" + pipeInfo.getName();
        return string;
    }

    private void copyAttributeToClipboard(boolean bl) {
        StringSelection stringSelection = new StringSelection(this.getCopyString(bl));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    static String getFormatString(AttributeInfo attributeInfo) {
        switch (attributeInfo.data_format.value()) {
            case 0: {
                return "Scalar";
            }
            case 1: {
                return "Spectrum";
            }
            case 2: {
                return "Image";
            }
        }
        return "Unknown";
    }

    static String getWriteString(AttributeInfo attributeInfo) {
        switch (attributeInfo.writable.value()) {
            case 0: {
                return "READ";
            }
            case 1: {
                return "READ_WITH_WRITE";
            }
            case 3: {
                return "READ_WRITE";
            }
            case 2: {
                return "WRITE";
            }
        }
        return "Unknown";
    }

    private List<PipeInfo> getPipeInfo() throws DevFailed {
        return this.device.getPipeConfig();
    }

    private void placeComponents(Dimension dimension) {
        this.arginLabel.setBounds(10, 0, 80, 20);
        this.descrLabel.setBounds(90, 0, dimension.width - 100, 20);
        this.arginCombo.setBounds(10, 20, dimension.width - 20, 25);
        this.pipeView.setBounds(10, 50, 190, dimension.height - 60);
        this.pipeView.revalidate();
        this.descrView.setBounds(205, 50, dimension.width - 215, dimension.height - 90);
        this.descrView.revalidate();
        int n = (dimension.width - 220) / 3;
        this.readBtn.setBounds(205, dimension.height - 35, n, 25);
        this.writeBtn.setBounds(205 + n + 2, dimension.height - 35, n, 25);
        this.helpBtn.setBounds(205 + 2 * n + 5, dimension.height - 35, n, 25);
    }

    private void addArgin(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.arginCombo.getItemCount() && !bl) {
            bl = string.equals(this.arginCombo.getItemAt(n).toString());
            if (bl) continue;
            ++n;
        }
        if (!bl) {
            this.arginCombo.addItem(string);
        }
    }

    private void writePipe() {
        try {
            PipeInfo pipeInfo = this.pipeInfo.get(this.pipeList.getSelectedIndex());
            String string = (String)this.arginCombo.getSelectedItem();
            if (string != null) {
                this.addArgin(string);
            }
            DevicePipe devicePipe = new DevicePipe(pipeInfo.getName(), this.parseData(string));
            long l = System.currentTimeMillis();
            this.device.writePipe(devicePipe);
            long l2 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Pipe: " + this.device.name() + "/" + pipeInfo.getName() + "\n");
            this.console.print("Duration: " + (l2 - l) + " msec\n");
            this.console.print("Write OK\n");
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + numberFormatException.getMessage());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
        }
    }

    private void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.console.print("  ");
        }
    }

    private void indent(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
    }

    private void printPipeBlop(PipeBlob pipeBlob, int n) throws DevFailed {
        this.indent(n);
        this.console.print("[" + pipeBlob.getName() + "]\n");
        block3: for (PipeDataElement pipeDataElement : pipeBlob) {
            int n2 = pipeDataElement.getType();
            this.indent(n + 1);
            this.console.print(pipeDataElement.getName() + ":" + TangoConst.Tango_CmdArgTypeName[n2]);
            switch (n2) {
                case 30: {
                    this.console.print("\n");
                    this.printPipeBlop(pipeDataElement.extractPipeBlob(), n + 1);
                    continue block3;
                }
            }
            this.console.print(this.extractData(n + 1, pipeDataElement));
        }
    }

    private void readPipe() {
        try {
            PipeInfo pipeInfo = this.pipeInfo.get(this.pipeList.getSelectedIndex());
            long l = System.currentTimeMillis();
            DevicePipe devicePipe = this.device.readPipe(pipeInfo.getName());
            long l2 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Pipe: " + this.device.name() + "/" + pipeInfo.getName() + "\n");
            this.console.print("Duration: " + (l2 - l) + " msec\n");
            TimeVal timeVal = devicePipe.getDevPipeDataObject().time;
            Date date = new Date((long)((double)timeVal.tv_sec * 1000.0 + (double)timeVal.tv_usec / 1000.0));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            this.console.print("measure date: " + simpleDateFormat.format(date) + " + " + timeVal.tv_usec / 1000 + "ms\n");
            this.printPipeBlop(devicePipe.getPipeBlob(), 0);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
        }
    }

    private String getExample(AttributeInfo attributeInfo) {
        String string = "";
        switch (attributeInfo.data_type) {
            case 19: {
                string = string + "0 (16bits value)";
                break;
            }
            case 22: {
                string = string + "10 or 0xa (unsigned 8bits)";
                break;
            }
            case 1: {
                string = string + "true,false or 0,1";
                break;
            }
            case 6: {
                string = string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                string = string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 3: {
                string = string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 7: {
                string = string + "10 or 0xa (unsigned 32bits)";
                break;
            }
            case 23: {
                string = string + "10 or 0xa (signed 64bits)";
                break;
            }
            case 24: {
                string = string + "10 or 0xa (unsigned 64bits)";
                break;
            }
            case 4: {
                string = string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                string = string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                string = "quotes needed for string with space or special char";
                break;
            }
            default: {
                string = new String("");
            }
        }
        if (attributeInfo.data_format.value() == 1) {
            return "Array of " + string + " Ex: a,b,c";
        }
        if (attributeInfo.data_format.value() == 2) {
            return "Image of " + string + " Ex: [a,b,c][d,e,f][g,h,i]";
        }
        return "Ex: " + string;
    }

    private int getLimitMax(int n, StringBuffer stringBuffer, int n2) {
        if (n2 > this.common.getAnswerLimitMax()) {
            this.indent(n, stringBuffer);
            stringBuffer.append("Array cannot be fully displayed. (You may change the AnswerLimitMax)\n");
            return this.common.getAnswerLimitMax();
        }
        return n2;
    }

    private int getLimitMin(int n, StringBuffer stringBuffer, int n2) {
        if (n2 <= this.common.getAnswerLimitMin()) {
            this.indent(n, stringBuffer);
            stringBuffer.append("Array cannot be displayed. (You may change the AnswerLimitMin)\n");
            return n2;
        }
        return this.common.getAnswerLimitMin();
    }

    private PipeBlob parseData(String string) throws NumberFormatException {
        ArgParser argParser = new ArgParser(string);
        return argParser.parse_pipe();
    }

    private void printArrayItem(StringBuffer stringBuffer, int n, boolean bl, String string, int n2) {
        this.indent(n2 + 1, stringBuffer);
        if (bl) {
            stringBuffer.append("Read [" + n + "]\t" + string + "\n");
        } else {
            stringBuffer.append("Read:\t" + string + "\n");
        }
    }

    private String extractData(int n, PipeDataElement pipeDataElement) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            switch (pipeDataElement.getType()) {
                case 19: {
                    boolean bl;
                    DevState[] devStateArray = pipeDataElement.extractDevStateArray();
                    boolean bl2 = bl = devStateArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(devStateArray.length));
                    }
                    stringBuffer.append("\n");
                    int n2 = this.getLimitMin(n, stringBuffer, devStateArray.length);
                    int n3 = this.getLimitMax(n, stringBuffer, devStateArray.length);
                    for (int i = n2; i < n3; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Tango_DevStateName[devStateArray[i].value()], n);
                    }
                    break;
                }
                case 22: {
                    boolean bl;
                    short[] sArray = pipeDataElement.extractUCharArray();
                    boolean bl3 = bl = sArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(sArray.length));
                    }
                    stringBuffer.append("\n");
                    int n4 = this.getLimitMin(n, stringBuffer, sArray.length);
                    int n5 = this.getLimitMax(n, stringBuffer, sArray.length);
                    for (int i = n4; i < n5; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Short.toString(sArray[i]), n);
                    }
                    break;
                }
                case 2: {
                    boolean bl;
                    short[] sArray = pipeDataElement.extractShortArray();
                    boolean bl4 = bl = sArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(sArray.length));
                    }
                    stringBuffer.append("\n");
                    int n6 = this.getLimitMin(n, stringBuffer, sArray.length);
                    int n7 = this.getLimitMax(n, stringBuffer, sArray.length);
                    for (int i = n6; i < n7; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Short.toString(sArray[i]), n);
                    }
                    break;
                }
                case 1: {
                    boolean bl;
                    boolean[] blArray = pipeDataElement.extractBooleanArray();
                    boolean bl5 = bl = blArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(blArray.length));
                    }
                    stringBuffer.append("\n");
                    int n8 = this.getLimitMin(n, stringBuffer, blArray.length);
                    int n9 = this.getLimitMax(n, stringBuffer, blArray.length);
                    for (int i = n8; i < n9; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Boolean.toString(blArray[i]), n);
                    }
                    break;
                }
                case 6: {
                    boolean bl;
                    int[] nArray = pipeDataElement.extractUShortArray();
                    boolean bl6 = bl = nArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(nArray.length));
                    }
                    stringBuffer.append("\n");
                    int n10 = this.getLimitMin(n, stringBuffer, nArray.length);
                    int n11 = this.getLimitMax(n, stringBuffer, nArray.length);
                    for (int i = n10; i < n11; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Integer.toString(nArray[i]), n);
                    }
                    break;
                }
                case 3: {
                    boolean bl;
                    int[] nArray = pipeDataElement.extractLongArray();
                    boolean bl7 = bl = nArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(nArray.length));
                    }
                    stringBuffer.append("\n");
                    int n12 = this.getLimitMin(n, stringBuffer, nArray.length);
                    int n13 = this.getLimitMax(n, stringBuffer, nArray.length);
                    for (int i = n12; i < n13; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Integer.toString(nArray[i]), n);
                    }
                    break;
                }
                case 7: {
                    boolean bl;
                    long[] lArray = pipeDataElement.extractULongArray();
                    boolean bl8 = bl = lArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(lArray.length));
                    }
                    stringBuffer.append("\n");
                    int n14 = this.getLimitMin(n, stringBuffer, lArray.length);
                    int n15 = this.getLimitMax(n, stringBuffer, lArray.length);
                    for (int i = n14; i < n15; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Long.toString(lArray[i]), n);
                    }
                    break;
                }
                case 23: {
                    boolean bl;
                    long[] lArray = pipeDataElement.extractLong64Array();
                    boolean bl9 = bl = lArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(lArray.length));
                    }
                    stringBuffer.append("\n");
                    int n16 = this.getLimitMin(n, stringBuffer, lArray.length);
                    int n17 = this.getLimitMax(n, stringBuffer, lArray.length);
                    for (int i = n16; i < n17; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Long.toString(lArray[i]), n);
                    }
                    break;
                }
                case 24: {
                    boolean bl;
                    long[] lArray = pipeDataElement.extractULong64Array();
                    boolean bl10 = bl = lArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(lArray.length));
                    }
                    stringBuffer.append("\n");
                    int n18 = this.getLimitMin(n, stringBuffer, lArray.length);
                    int n19 = this.getLimitMax(n, stringBuffer, lArray.length);
                    for (int i = n18; i < n19; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Long.toString(lArray[i]), n);
                    }
                    break;
                }
                case 5: {
                    boolean bl;
                    double[] dArray = pipeDataElement.extractDoubleArray();
                    boolean bl11 = bl = dArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(dArray.length));
                    }
                    stringBuffer.append("\n");
                    int n20 = this.getLimitMin(n, stringBuffer, dArray.length);
                    int n21 = this.getLimitMax(n, stringBuffer, dArray.length);
                    for (int i = n20; i < n21; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Double.toString(dArray[i]), n);
                    }
                    break;
                }
                case 4: {
                    boolean bl;
                    float[] fArray = pipeDataElement.extractFloatArray();
                    boolean bl12 = bl = fArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(fArray.length));
                    } else {
                        stringBuffer.append("\n");
                    }
                    int n22 = this.getLimitMin(n, stringBuffer, fArray.length);
                    int n23 = this.getLimitMax(n, stringBuffer, fArray.length);
                    for (int i = n22; i < n23; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, Float.toString(fArray[i]), n);
                    }
                    break;
                }
                case 8: {
                    boolean bl;
                    String[] stringArray = pipeDataElement.extractStringArray();
                    boolean bl13 = bl = stringArray.length > 1;
                    if (bl) {
                        stringBuffer.append(" Array length=" + Integer.toString(stringArray.length));
                    }
                    stringBuffer.append("\n");
                    int n24 = this.getLimitMin(n, stringBuffer, stringArray.length);
                    int n25 = this.getLimitMax(n, stringBuffer, stringArray.length);
                    for (int i = n24; i < n25; ++i) {
                        this.printArrayItem(stringBuffer, i, bl, stringArray[i], n);
                    }
                    break;
                }
                case 28: {
                    DevEncoded[] devEncodedArray = pipeDataElement.extractDevEncodedArray();
                    for (int i = 0; i < devEncodedArray.length; ++i) {
                        boolean bl;
                        if (devEncodedArray.length > 1) {
                            this.indent(n, stringBuffer);
                            this.console.print("Item #" + i + "\n");
                        }
                        this.indent(n, stringBuffer);
                        stringBuffer.append("Format: " + devEncodedArray[i].encoded_format + "\n");
                        boolean bl14 = bl = devEncodedArray[i].encoded_data.length > 1;
                        if (bl) {
                            stringBuffer.append(" Array length=" + Integer.toString(devEncodedArray[i].encoded_data.length));
                        }
                        stringBuffer.append("\n");
                        int n26 = this.getLimitMin(n, stringBuffer, devEncodedArray[i].encoded_data.length);
                        int n27 = this.getLimitMax(n, stringBuffer, devEncodedArray[i].encoded_data.length);
                        for (int j = n26; j < n27; ++j) {
                            short s = devEncodedArray[i].encoded_data[j];
                            s = (short)(s & 0xFF);
                            this.printArrayItem(stringBuffer, j, bl, Short.toString(s), n);
                        }
                    }
                    break;
                }
                default: {
                    this.indent(n, stringBuffer);
                    stringBuffer.append("Unsupported type code=" + pipeDataElement.getType() + "\n");
                }
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)(this.device.name() + "/" + pipeDataElement.getName()), (DevFailed)devFailed);
        }
        return stringBuffer.toString();
    }
}

