/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import jive.DevItem;
import jive.JiveUtils;

public class MultiLineCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final Font TABLE_FONT = new Font("Dialog", 0, 12);
    private static final Font TABLE_FONT_BOLD = new Font("Dialog", 1, 12);
    private static BufferedImage arrowButton = null;
    Color selColor = new Color(200, 200, 255);
    Border selBorder = BorderFactory.createLineBorder(this.selColor);
    private boolean doBold = false;
    private boolean doSelection = false;
    private Vector items;
    private boolean hasDevice = false;
    private boolean doDevice = true;

    public MultiLineCellRenderer() {
        this.setLayout(null);
        this.setEditable(false);
        this.setLineWrap(false);
        this.setWrapStyleWord(false);
        this.items = new Vector();
        if (arrowButton == null) {
            try {
                arrowButton = ImageIO.read(MultiLineCellRenderer.class.getResource("/jive/arrow_btn.gif"));
            }
            catch (IOException iOException) {
                System.out.println("Warning, /jive/arrow_btn.gif is missing");
            }
        }
    }

    public MultiLineCellRenderer(boolean bl, boolean bl2, boolean bl3) {
        this();
        this.doBold = bl;
        this.doSelection = bl2;
        this.doDevice = bl3;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        boolean bl3 = true;
        if (object instanceof String) {
            if (this.doBold) {
                object2 = (String)object;
                if (((String)object2).startsWith("/B")) {
                    this.setFont(TABLE_FONT_BOLD);
                    this.setText(((String)object2).substring(2));
                    bl3 = false;
                } else {
                    this.setFont(TABLE_FONT);
                    this.setText((String)object2);
                }
            } else {
                this.setText((String)object);
            }
        } else {
            this.setText("");
        }
        if (this.doSelection && bl3) {
            object2 = jTable.getSelectedRows();
            if (JiveUtils.contains((int[])object2, n) && n2 == 0) {
                this.setBackground(this.selColor);
            } else {
                this.setBackground(Color.WHITE);
            }
            if (bl && n2 == 1) {
                this.setBorder(this.selBorder);
            } else {
                this.setBorder(null);
            }
        } else {
            this.setBackground(Color.WHITE);
            this.setBorder(null);
        }
        return this;
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (!this.doDevice) {
            return;
        }
        this.items.clear();
        if (string.length() == 0) {
            this.hasDevice = false;
            return;
        }
        String[] stringArray = JiveUtils.makeStringArray(string);
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2 = JiveUtils.isDeviceName(stringArray[i]);
            Dimension dimension = ATKGraphicsUtils.measureString((String)stringArray[i], (Font)this.getFont());
            DevItem devItem = new DevItem();
            devItem.str = stringArray[i];
            devItem.x = 16;
            devItem.y = n + 1;
            devItem.h = dimension.height - 2;
            devItem.isDevice = bl2;
            this.items.add(devItem);
            n += dimension.height + 1;
            if (!bl2) continue;
            bl = true;
        }
        this.hasDevice = bl;
    }

    public boolean hasDevice() {
        return this.hasDevice;
    }

    public String getDevice(int n, int n2) {
        Object object;
        int n3 = 0;
        boolean bl = false;
        while (!bl && n3 < this.items.size()) {
            object = (DevItem)this.items.get(n3);
            bl = n < ((DevItem)object).x - 2 && n > 2 && n2 > ((DevItem)object).y + 2 && n2 < ((DevItem)object).y + 2 + ((DevItem)object).h;
            if (bl) continue;
            ++n3;
        }
        if (bl) {
            object = ((DevItem)this.items.get((int)n3)).str;
            if (((String)object).startsWith("tango:")) {
                return ((String)object).substring(6);
            }
            return object;
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.hasDevice) {
            super.paint(graphics);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(this.getFont());
            graphics2D.setColor(this.getForeground());
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            for (int i = 0; i < this.items.size(); ++i) {
                DevItem devItem = (DevItem)this.items.get(i);
                graphics2D.drawString(devItem.str, devItem.x, devItem.y + devItem.h - 1);
                if (!devItem.isDevice) continue;
                graphics.drawImage(arrowButton, 2, devItem.y + 2, null);
            }
        }
    }
}

