/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive3.JiveTable;
import jive3.MainPanel;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.PropertyEditorDlg;
import jive3.PropertyNode;
import jive3.TaskClassAttributePropertyNode;
import jive3.TaskClassPropertyNode;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskFreePropertyNode;
import jive3.TaskSubDevicePropertyNode;

public class PropertyPanel
extends JPanel
implements ActionListener,
MouseListener {
    private JScrollPane textView;
    private JiveTable theTable;
    private JButton refreshButton;
    private JButton applyButton;
    private JButton deleteButton;
    private JButton copyButton;
    private JButton newButton;
    private MainPanel parent;
    private PropertyEditorDlg propertyEditor = null;
    private PropertyNode[] source = null;
    private DefaultTableModel dm;
    private boolean[] updatedProp;
    private JPopupMenu tableMenu;
    private JMenuItem historyMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem editMenuItem;

    PropertyPanel() {
        this.setLayout(new BorderLayout());
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    PropertyPanel.this.applyButton.setEnabled(true);
                    ((PropertyPanel)PropertyPanel.this).updatedProp[n] = true;
                }
            }
        };
        this.theTable = new JiveTable(this.dm);
        this.theTable.addMouseListener(this);
        this.theTable.getEditor().getTextArea().addMouseListener(this);
        this.textView = new JScrollPane(this.theTable);
        this.add((Component)this.textView, "Center");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.textView.setBorder(titledBorder);
        this.add((Component)this.textView, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(!JiveUtils.readOnly);
        this.deleteButton.addActionListener(this);
        this.copyButton = new JButton("Copy");
        this.copyButton.setEnabled(!JiveUtils.readOnly);
        this.copyButton.addActionListener(this);
        this.newButton = new JButton("New property");
        this.newButton.setEnabled(!JiveUtils.readOnly);
        this.newButton.addActionListener(this);
        jPanel.add(this.refreshButton);
        jPanel.add(this.applyButton);
        jPanel.add(this.newButton);
        jPanel.add(this.copyButton);
        jPanel.add(this.deleteButton);
        this.add((Component)jPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.renameMenuItem = new JMenuItem("Rename");
        this.renameMenuItem.addActionListener(this);
        this.historyMenuItem = new JMenuItem("View history");
        this.historyMenuItem.addActionListener(this);
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(this);
        this.editMenuItem = new JMenuItem("Edit");
        this.editMenuItem.addActionListener(this);
        this.tableMenu.add(this.copyMenuItem);
        this.tableMenu.add(this.deleteMenuItem);
        this.tableMenu.add(this.renameMenuItem);
        this.tableMenu.add(this.editMenuItem);
        this.tableMenu.add(this.historyMenuItem);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        String string;
        int n;
        Object object = mouseEvent.getSource();
        if (object == this.theTable && mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 && !JiveUtils.readOnly && (n = this.theTable.getRowForLocation(mouseEvent.getY())) != -1) {
            this.theTable.addRowSelectionInterval(n, n);
            this.theTable.setColumnSelectionInterval(0, 1);
            int[] nArray = this.theTable.getSelectedRows();
            this.renameMenuItem.setEnabled(nArray.length == 1);
            this.historyMenuItem.setEnabled(nArray.length == 1);
            this.tableMenu.show(this.theTable, mouseEvent.getX(), mouseEvent.getY());
        }
        if (object == this.theTable.getEditor().getTextArea() && mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 && (string = this.theTable.getEditor().getTextArea().getSelectedText()) != null) {
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '/') continue;
                ++n2;
            }
            if (n2 == 2) {
                this.parent.goToDeviceNode(string);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setParent(MainPanel mainPanel) {
        this.parent = mainPanel;
        this.theTable.setParent(mainPanel);
    }

    public boolean hasChanged() {
        return this.applyButton.isEnabled();
    }

    public void saveChange() {
        int n;
        int n2 = this.getNbUpdated() * this.source.length;
        int n3 = 0;
        if (this.source.length > 1) {
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < this.updatedProp.length; ++n) {
                if (!this.updatedProp[n]) continue;
                vector.add((String)this.dm.getValueAt(n, 0));
                vector.add((String)this.dm.getValueAt(n, 1));
            }
            if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length)) {
                this.applyButton.setEnabled(false);
                for (n = 0; n < this.updatedProp.length; ++n) {
                    this.updatedProp[n] = false;
                }
                return;
            }
        }
        if (n2 > 1) {
            ProgressFrame.displayProgress("Updating properties");
        }
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            for (n = 0; n < this.source.length; ++n) {
                ProgressFrame.setProgress("Applying " + this.source[n].getName() + "/" + this.dm.getValueAt(i, 0), ++n3 * 100 / n2);
                this.source[n].setProperty((String)this.dm.getValueAt(i, 0), (String)this.dm.getValueAt(i, 1));
            }
            this.updatedProp[i] = false;
        }
        this.applyButton.setEnabled(false);
        ProgressFrame.hideProgress();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block20: {
            Object object;
            block25: {
                String string;
                block30: {
                    String string2;
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block19: {
                                                        object = actionEvent.getSource();
                                                        if (object != this.refreshButton) break block19;
                                                        this.refreshValue();
                                                        break block20;
                                                    }
                                                    if (object != this.applyButton) break block21;
                                                    this.saveChange();
                                                    break block20;
                                                }
                                                if (object != this.deleteMenuItem && object != this.deleteButton) break block22;
                                                int[] nArray = this.theTable.getSelectedRows();
                                                if (nArray.length == 0) {
                                                    JiveUtils.showJiveError("Selection is empty.");
                                                    return;
                                                }
                                                int n = JOptionPane.showConfirmDialog(this, "Delete selection ?", "Confirm delete", 0);
                                                if (n == 0) {
                                                    int n2 = nArray.length * this.source.length;
                                                    int n3 = 0;
                                                    if (n2 > 1) {
                                                        ProgressFrame.displayProgress("Deleting properties");
                                                    }
                                                    for (int i = 0; i < nArray.length; ++i) {
                                                        for (int j = 0; j < this.source.length; ++j) {
                                                            ProgressFrame.setProgress("Deleting " + this.source[j].getName() + "/" + this.dm.getValueAt(nArray[i], 0), ++n3 * 100 / n2);
                                                            this.source[j].deleteProperty((String)this.dm.getValueAt(nArray[i], 0));
                                                        }
                                                    }
                                                    ProgressFrame.hideProgress();
                                                    this.refreshValue();
                                                }
                                                break block20;
                                            }
                                            if (object != this.renameMenuItem) break block23;
                                            int n = this.theTable.getSelectedRow();
                                            String string3 = (String)this.dm.getValueAt(n, 0);
                                            String string4 = (String)this.dm.getValueAt(n, 1);
                                            String string5 = JOptionPane.showInputDialog(null, "Rename property", string3);
                                            if (string5 == null) {
                                                return;
                                            }
                                            if (this.propertyExists(string5)) {
                                                JiveUtils.showJiveError("Name already exists.");
                                                return;
                                            }
                                            int n4 = 0;
                                            int n5 = this.source.length;
                                            if (n5 > 1) {
                                                ProgressFrame.displayProgress("Renaming properties");
                                            }
                                            for (int i = 0; i < this.source.length; ++i) {
                                                ProgressFrame.setProgress("Renaming " + this.source[i].getName() + "/" + string3, ++n4 * 100 / n5);
                                                this.source[i].rename(string3, string4, string5);
                                            }
                                            this.refreshValue();
                                            ProgressFrame.hideProgress();
                                            break block20;
                                        }
                                        if (object != this.editMenuItem) break block24;
                                        if (this.propertyEditor == null) {
                                            this.propertyEditor = new PropertyEditorDlg(this.parent);
                                        }
                                        int n = this.theTable.getSelectedRow();
                                        String string6 = (String)this.dm.getValueAt(n, 0);
                                        String string7 = (String)this.dm.getValueAt(n, 1);
                                        this.propertyEditor.setSource(this.source[0], string6, string7);
                                        this.propertyEditor.setVisible(true);
                                        this.refreshValue();
                                        break block20;
                                    }
                                    if (object != this.historyMenuItem) break block25;
                                    int n = this.theTable.getSelectedRow();
                                    string = (String)this.dm.getValueAt(n, 0);
                                    string2 = this.source[0].getName();
                                    if (!(this.source[0] instanceof TaskDevicePropertyNode)) break block26;
                                    this.parent.historyDlg.viewDevicePropertyHistory(string2, string);
                                    this.parent.showHistory();
                                    break block20;
                                }
                                if (!(this.source[0] instanceof TaskDeviceAttributePropertyNode)) break block27;
                                String string8 = ((TaskDeviceAttributePropertyNode)this.source[0]).getAttributeName();
                                String string9 = ((TaskDeviceAttributePropertyNode)this.source[0]).getDevName();
                                this.parent.historyDlg.viewDeviceAttPropertyHistory(string9, string8, string);
                                this.parent.showHistory();
                                break block20;
                            }
                            if (!(this.source[0] instanceof TaskClassAttributePropertyNode)) break block28;
                            String string10 = ((TaskClassAttributePropertyNode)this.source[0]).getAttributeName();
                            this.parent.historyDlg.viewClassAttPropertyHistory(string2, string10, string);
                            this.parent.showHistory();
                            break block20;
                        }
                        if (!(this.source[0] instanceof TaskFreePropertyNode)) break block29;
                        this.parent.historyDlg.viewFreePropertyHistory(string2, string);
                        this.parent.showHistory();
                        break block20;
                    }
                    if (!(this.source[0] instanceof TaskClassPropertyNode)) break block30;
                    this.parent.historyDlg.viewClassPropertyHistory(string2, string);
                    this.parent.showHistory();
                    break block20;
                }
                if (!(this.source[0] instanceof TaskSubDevicePropertyNode)) break block20;
                String string11 = ((TaskSubDevicePropertyNode)this.source[0]).getDevName();
                String string12 = ((TaskSubDevicePropertyNode)this.source[0]).getSubName() + "/" + string;
                this.parent.historyDlg.viewDevicePropertyHistory(string11, string12);
                this.parent.showHistory();
                break block20;
            }
            if (object == this.newButton) {
                String string = JOptionPane.showInputDialog(null, "Add property", "");
                if (string == null) {
                    return;
                }
                if (this.propertyExists(string)) {
                    JiveUtils.showJiveError("Name already exists.");
                    return;
                }
                int n = 0;
                int n6 = this.source.length;
                if (n6 > 1) {
                    ProgressFrame.displayProgress("Creating properties");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    ProgressFrame.setProgress("Creating " + this.source[i].getName() + "/" + string, ++n * 100 / n6);
                    this.source[i].setProperty(string, "");
                }
                this.refreshValue();
                ProgressFrame.hideProgress();
            } else if (object == this.copyMenuItem || object == this.copyButton) {
                int[] nArray = this.theTable.getSelectedRows();
                if (nArray.length == 0) {
                    JiveUtils.showJiveError("Nothing to copy.");
                    return;
                }
                JiveUtils.the_clipboard.clear();
                for (int i = 0; i < nArray.length; ++i) {
                    JiveUtils.the_clipboard.add((String)this.dm.getValueAt(nArray[i], 0), (String)this.dm.getValueAt(nArray[i], 1));
                }
            }
        }
    }

    void setSource(PropertyNode[] propertyNodeArray) {
        this.source = propertyNodeArray;
        this.refreshValue();
    }

    private void refreshValue() {
        this.applyButton.setEnabled(false);
        if (this.source != null) {
            Object[] objectArray = new String[]{"Property name", "Value"};
            Object[][] objectArray2 = this.source[0].getProperties();
            this.dm.setDataVector(objectArray2, objectArray);
            this.updatedProp = new boolean[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                this.updatedProp[i] = false;
            }
            this.theTable.updateRows();
            this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.theTable.validate();
            String string = this.source[0].getTitle();
            string = this.source.length == 1 ? string + " [" + this.source[0].getName() + "]" : string + " [" + this.source.length + " items selected]";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.textView.setBorder(titledBorder);
        }
    }

    private boolean propertyExists(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.dm.getRowCount() && !bl) {
            bl = ((String)this.dm.getValueAt(n, 0)).equalsIgnoreCase(string);
            if (bl) continue;
            ++n;
        }
        return bl;
    }

    private int getNbUpdated() {
        int n = 0;
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            ++n;
        }
        return n;
    }
}

