/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.DetailsDlg;
import jive.JiveUtils;
import jive.MultiLineToolTipUI;
import jive.SearchDlg;
import jive.TangoFileReader;
import jive.TangoTreeNode;
import jive.TangoTreeNodeRenderer;
import jive.ThreadDlg;

public class MainPanel
extends JFrame {
    static ThreadDlg applyDlg;
    static TreePath[] applySelPath;
    static String applyValue;
    private JTree mainTree = null;
    private DefaultTreeModel mainTreeModel;
    private DefaultMutableTreeNode rootNode;
    private TangoTreeNodeRenderer renderer;
    private MouseListener treeMousellistemner;
    private MouseListener valueMousellistemner;
    private TreeSelectionListener treeSelectionlistemner;
    private JScrollPane treeView;
    private JSplitPane splitPane;
    private JPanel resPanel;
    private JPanel btnPanel;
    private JTextArea resValue;
    private JScrollPane resView;
    private JButton applyPb;
    private JButton refreshPb;
    private JButton detailsPb;
    private Database db;
    private String tangoHost;
    private JLabel statusLine;
    private JMenuBar mainMenu;
    private JPopupMenu treeMenu;
    private JMenuItem[] treeMenuItem;
    private JMenuItem jMenuItemMDelete;
    private JMenuItem jMenuItemMCopy;
    private JMenuItem jMenuItemMSave;
    private JPopupMenu treeMenuMultiple;
    private JMenuItem jMenuItemMDelete2;
    private JMenuItem jMenuItemMCopy2;
    private JMenuItem jMenuItemMSave2;
    private boolean running_from_shell;
    private boolean refresh_values = true;
    private boolean searchInProgress = false;
    private static final String appVersion = "Jive 2.7e ";

    public MainPanel() {
        this.running_from_shell = false;
        this.initComponents();
        this.centerWindow();
        this.placeComponents();
        this.setTitle(appVersion);
        this.setVisible(true);
        JiveUtils.parent = this;
    }

    public MainPanel(boolean bl, boolean bl2) {
        this.running_from_shell = bl;
        JiveUtils.readOnly = bl2;
        this.initComponents();
        this.centerWindow();
        this.placeComponents();
        this.setTitle(appVersion);
        this.setVisible(true);
        JiveUtils.parent = this;
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = new Dimension(750, 500);
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setBounds(n, n2, dimension2.width, dimension2.height);
    }

    private boolean isEditable(String string) {
        return string.startsWith("Property value") || string.startsWith("Polling configuration property") || string.startsWith("Attribute configuration property") || string.startsWith("HDB configuration property") || string.startsWith("Logging configuration property");
    }

    private void refreshValues(TreePath treePath) {
        String[] stringArray = JiveUtils.getValue(treePath);
        this.resValue.setText(stringArray[0]);
        this.resValue.setCaretPosition(0);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), stringArray[1]);
        this.resView.setBorder(titledBorder);
        this.resValue.setEditable(this.isEditable(stringArray[1]) && !JiveUtils.readOnly);
        this.applyPb.setEnabled(false);
        this.detailsPb.setEnabled(false);
    }

    private void refreshEmptySelection() {
        this.resValue.setText("");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.resView.setBorder(titledBorder);
        this.resValue.setEditable(false);
        this.applyPb.setEnabled(false);
        this.detailsPb.setEnabled(false);
        this.statusLine.setText("");
        this.jMenuItemMDelete.setEnabled(false);
        this.jMenuItemMCopy.setEnabled(false);
        this.jMenuItemMSave.setEnabled(false);
        this.jMenuItemMDelete2.setEnabled(false);
        this.jMenuItemMCopy2.setEnabled(false);
        this.jMenuItemMSave2.setEnabled(false);
    }

    private void refreshValuesMultiple(TreePath[] treePathArray) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String[] stringArray = JiveUtils.getValue(treePathArray[0]);
        boolean bl = this.isEditable(stringArray[1]);
        boolean bl2 = true;
        String string = stringArray[0];
        for (int i = 1; i < treePathArray.length; ++i) {
            stringArray = JiveUtils.getValue(treePathArray[i]);
            bl2 &= stringArray[0].equals(string);
            bl &= this.isEditable(stringArray[1]);
        }
        if (bl2) {
            this.resValue.setText(string);
        } else {
            this.resValue.setText("Values are not equals");
        }
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Multiple selection");
        this.resView.setBorder(titledBorder);
        this.resValue.setEditable(bl && !JiveUtils.readOnly);
        this.applyPb.setEnabled(false);
        this.detailsPb.setEnabled(!bl2);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void gobalValueRefresh() {
        TreePath[] treePathArray = this.mainTree.getSelectionPaths();
        if (treePathArray != null) {
            if (treePathArray.length == 1) {
                String string = JiveUtils.formatPath(treePathArray[0]);
                this.statusLine.setText(string);
                this.refreshValues(treePathArray[0]);
                this.jMenuItemMDelete.setEnabled(false);
                this.jMenuItemMCopy.setEnabled(false);
                this.jMenuItemMSave.setEnabled(false);
                this.jMenuItemMDelete2.setEnabled(false);
                this.jMenuItemMCopy2.setEnabled(false);
                this.jMenuItemMSave2.setEnabled(false);
            } else if (treePathArray.length > 1) {
                this.statusLine.setText("Multiple selection: " + treePathArray.length + " items selected");
                this.refreshValuesMultiple(treePathArray);
                this.jMenuItemMDelete.setEnabled(!JiveUtils.readOnly);
                this.jMenuItemMCopy.setEnabled(!JiveUtils.readOnly);
                this.jMenuItemMSave.setEnabled(true);
                this.jMenuItemMDelete2.setEnabled(!JiveUtils.readOnly);
                this.jMenuItemMCopy2.setEnabled(!JiveUtils.readOnly);
                this.jMenuItemMSave2.setEnabled(true);
            } else if (treePathArray.length == 0) {
                this.refreshEmptySelection();
            }
        } else {
            this.refreshEmptySelection();
        }
    }

    private void refreshTree() {
        TreePath treePath = this.mainTree.getSelectionPath();
        this.splitPane.remove(this.treeView);
        this.createMainTree();
        this.splitPane.setLeftComponent(this.treeView);
        TreePath treePath2 = JiveUtils.convertOldPath(this.mainTreeModel, (TangoTreeNode)this.rootNode, treePath);
        this.mainTree.setSelectionPath(treePath2);
        this.mainTree.expandPath(treePath2);
        this.mainTree.makeVisible(treePath2);
        this.mainTree.scrollPathToVisible(treePath2);
        this.placeComponents();
    }

    private void createMainTree() {
        if (this.mainTree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.mainTree);
        }
        this.renderer = new TangoTreeNodeRenderer();
        this.rootNode = new TangoTreeNode(0, 0, this.tangoHost, this.db, true);
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.mainTree = new JTree(this.mainTreeModel);
        this.mainTree.setEditable(false);
        this.mainTree.setCellRenderer(this.renderer);
        this.mainTree.getSelectionModel().setSelectionMode(4);
        this.mainTree.setShowsRootHandles(true);
        this.mainTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.mainTree);
        this.mainTree.addMouseListener(this.treeMousellistemner);
        this.mainTree.addTreeSelectionListener(this.treeSelectionlistemner);
        ToolTipManager.sharedInstance().registerComponent(this.mainTree);
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        ToolTipManager.sharedInstance().setInitialDelay(500);
    }

    public void showClipboard() {
        JiveUtils.the_clipboard.show(this);
    }

    public void showDetails() {
        TreePath[] treePathArray = this.mainTree.getSelectionPaths();
        if (treePathArray != null) {
            Object object;
            Object[][] objectArray = new Object[treePathArray.length][2];
            for (int i = 0; i < treePathArray.length; ++i) {
                object = JiveUtils.getValue(treePathArray[i]);
                objectArray[i][0] = JiveUtils.formatPath(treePathArray[i]);
                objectArray[i][1] = object[0];
            }
            object = new DetailsDlg((Frame)this, objectArray, treePathArray);
            ((DetailsDlg)object).showDlg();
        }
    }

    public boolean checkDeviceName(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string.length() && n <= 2; ++i) {
            if (string.charAt(i) != '/') continue;
            ++n;
        }
        return n == 2;
    }

    public void applyChange() {
        applySelPath = this.mainTree.getSelectionPaths();
        applyValue = this.resValue.getText();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < applySelPath.length && !ThreadDlg.stopflag; ++i) {
                        JiveUtils.setValue(applySelPath[i], applyValue);
                        applyDlg.setProgress((i + 1) * 100 / applySelPath.length);
                    }
                    MainPanel.this.gobalValueRefresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                applyDlg.hideDlg();
            }
        };
        if (applySelPath != null) {
            if (applySelPath.length > 1) {
                applyDlg = new ThreadDlg((Frame)this, "", true, thread);
                applyDlg.showDlg();
            } else {
                for (int i = 0; i < applySelPath.length; ++i) {
                    JiveUtils.setValue(applySelPath[i], applyValue);
                }
                this.gobalValueRefresh();
            }
        }
    }

    private void initComponents() {
        int n;
        this.getContentPane().setLayout(null);
        MultiLineToolTipUI.initialize();
        this.tangoHost = System.getProperty("TANGO_HOST", "null");
        if (this.tangoHost.equals("null") || this.tangoHost.equals("")) {
            System.out.println("TANGO_HOST no defined, exiting...");
            this.exitForm();
        }
        try {
            this.db = ApiUtil.get_db_obj();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            this.db = null;
        }
        if (JiveUtils.hdbEnabled) {
            try {
                JiveUtils.hdbManager = new DeviceProxy("Archivage/HdbManager/HdbManager");
                JiveUtils.hdbEnabled = true;
            }
            catch (DevFailed devFailed) {
                JiveUtils.hdbEnabled = false;
            }
        }
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(1);
        this.resPanel = new JPanel(new BorderLayout());
        this.resPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btnPanel = new JPanel(new FlowLayout(0));
        this.resPanel.add((Component)this.btnPanel, "South");
        this.resValue = new JTextArea();
        this.resValue.setBackground(Color.white);
        this.resValue.setForeground(Color.black);
        this.resValue.setOpaque(true);
        this.resValue.setText("");
        this.resValue.setEditable(false);
        this.resValue.setBorder(BorderFactory.createLoweredBevelBorder());
        this.resValue.setFont(new Font("Monospaced", 0, 11));
        this.valueMousellistemner = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TangoTreeNode tangoTreeNode;
                TangoTreeNode tangoTreeNode2;
                String string;
                if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3 && MainPanel.this.checkDeviceName(string = MainPanel.this.resValue.getSelectedText()) && (tangoTreeNode2 = JiveUtils.findDeviceNode(tangoTreeNode = (TangoTreeNode)MainPanel.this.rootNode.getChildAt(2), string)) != null) {
                    TreePath treePath = tangoTreeNode2.getCompletePath();
                    MainPanel.this.mainTree.setSelectionPath(treePath);
                    MainPanel.this.mainTree.scrollPathToVisible(treePath);
                }
            }
        };
        this.resValue.addMouseListener(this.valueMousellistemner);
        this.resValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                MainPanel.this.applyPb.setEnabled(!JiveUtils.readOnly);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                MainPanel.this.applyPb.setEnabled(!JiveUtils.readOnly);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                MainPanel.this.applyPb.setEnabled(!JiveUtils.readOnly);
            }

            public void updateLog(DocumentEvent documentEvent, String string) {
                MainPanel.this.applyPb.setEnabled(!JiveUtils.readOnly);
            }
        });
        this.resView = new JScrollPane(this.resValue);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.resView.setBorder(titledBorder);
        this.resPanel.add((Component)this.resView, "Center");
        this.applyPb = new JButton();
        this.applyPb.setText("Apply change");
        this.applyPb.setEnabled(false);
        this.applyPb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MainPanel.this.applyPb.isEnabled()) {
                    MainPanel.this.applyChange();
                }
            }
        });
        this.btnPanel.add(this.applyPb);
        this.detailsPb = new JButton();
        this.detailsPb.setText("Show details");
        this.detailsPb.setEnabled(false);
        this.detailsPb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MainPanel.this.detailsPb.isEnabled()) {
                    MainPanel.this.showDetails();
                }
            }
        });
        this.btnPanel.add(this.detailsPb);
        this.refreshPb = new JButton();
        this.refreshPb.setText("Refresh");
        this.btnPanel.add(this.refreshPb);
        this.refreshPb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MainPanel.this.gobalValueRefresh();
            }
        });
        this.splitPane.setRightComponent(this.resPanel);
        this.statusLine = new JLabel();
        this.statusLine.setFont(new Font("Dialog", 0, 12));
        this.statusLine.setBackground(Color.white);
        this.statusLine.setForeground(Color.black);
        this.statusLine.setOpaque(true);
        this.statusLine.setText("");
        this.statusLine.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add(this.statusLine);
        this.treeMousellistemner = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = MainPanel.this.mainTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                int n = MainPanel.this.mainTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3 && treePath != null) {
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < MainPanel.this.mainTree.getSelectionCount() && !bl) {
                        bl = MainPanel.this.mainTree.getSelectionPaths()[n2].equals(treePath);
                        if (bl) continue;
                        ++n2;
                    }
                    if (MainPanel.this.mainTree.getSelectionCount() <= 1 || !bl) {
                        MainPanel.this.mainTree.setSelectionPath(treePath);
                        boolean[] blArray = JiveUtils.getAction(treePath);
                        for (n2 = 0; n2 < blArray.length; ++n2) {
                            MainPanel.this.treeMenuItem[n2].setEnabled(blArray[n2]);
                            if (n2 <= 3) continue;
                            MainPanel.this.treeMenuItem[n2].setVisible(blArray[n2]);
                        }
                        MainPanel.this.treeMenu.show(MainPanel.this.mainTree, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        boolean bl2 = true;
                        boolean bl3 = true;
                        boolean bl4 = true;
                        for (n2 = 0; n2 < MainPanel.this.mainTree.getSelectionCount(); ++n2) {
                            boolean[] blArray = JiveUtils.getAction(MainPanel.this.mainTree.getSelectionPaths()[n2]);
                            bl2 = bl2 && blArray[1];
                            bl3 = bl3 && blArray[3];
                            bl4 = blArray[15];
                        }
                        MainPanel.this.jMenuItemMCopy2.setEnabled(bl2);
                        MainPanel.this.jMenuItemMDelete2.setEnabled(bl3);
                        MainPanel.this.jMenuItemMSave2.setEnabled(bl4);
                        MainPanel.this.treeMenuMultiple.show(MainPanel.this.mainTree, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        };
        this.treeSelectionlistemner = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (MainPanel.this.refresh_values) {
                    MainPanel.this.gobalValueRefresh();
                }
            }
        };
        this.createMainTree();
        this.splitPane.setLeftComponent(this.treeView);
        this.getContentPane().add(this.splitPane);
        this.mainMenu = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        JMenuItem jMenuItem4 = new JMenuItem();
        this.jMenuItemMDelete = new JMenuItem();
        this.jMenuItemMCopy = new JMenuItem();
        this.jMenuItemMSave = new JMenuItem();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        JMenuItem jMenuItem7 = new JMenuItem();
        JMenuItem jMenuItem8 = new JMenuItem();
        jMenu.setText("File");
        jMenu2.setText("Edit");
        jMenuItem.setText("Exit");
        jMenuItem2.setText("Refresh tree");
        jMenuItem3.setText("Show clipbaord");
        jMenuItem4.setText("Clear clipbaord");
        this.jMenuItemMDelete.setText("Multiple delete");
        this.jMenuItemMCopy.setText("Multiple copy");
        this.jMenuItemMSave.setText("Multiple save");
        jMenuItem5.setText("Multiple selection");
        jMenuItem6.setText("Find property");
        jMenuItem7.setText("Find next");
        jMenuItem8.setText("Load property file");
        jMenuItem8.setEnabled(!JiveUtils.readOnly);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.exitForm();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.refreshTree();
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.showClipboard();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JiveUtils.the_clipboard.clear();
            }
        });
        this.jMenuItemMDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.execMultipleAction(3);
            }
        });
        this.jMenuItemMCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.execMultipleAction(1);
            }
        });
        this.jMenuItemMSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.execMultipleAction(15);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainPanel.this.searchInProgress) {
                    MainPanel.this.searchInProgress = true;
                    MainPanel.this.selectProperties();
                    MainPanel.this.searchInProgress = false;
                }
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainPanel.this.searchInProgress) {
                    MainPanel.this.searchInProgress = true;
                    MainPanel.this.findProperty(0);
                    MainPanel.this.searchInProgress = false;
                }
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainPanel.this.searchInProgress) {
                    MainPanel.this.searchInProgress = true;
                    MainPanel.this.findProperty(1);
                    MainPanel.this.searchInProgress = false;
                }
            }
        });
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.loadPropFile();
            }
        });
        this.jMenuItemMDelete.setEnabled(false);
        this.jMenuItemMCopy.setEnabled(false);
        this.jMenuItemMSave.setEnabled(false);
        jMenu.add(jMenuItem8);
        jMenu.add(new JSeparator());
        jMenu.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        jMenu2.add(new JSeparator());
        jMenu2.add(this.jMenuItemMDelete);
        jMenu2.add(this.jMenuItemMCopy);
        jMenu2.add(this.jMenuItemMSave);
        jMenu2.add(new JSeparator());
        jMenu2.add(jMenuItem6);
        jMenu2.add(jMenuItem7);
        this.mainMenu.add(jMenu);
        this.mainMenu.add(jMenu2);
        this.setJMenuBar(this.mainMenu);
        this.treeMenu = new JPopupMenu();
        this.treeMenuItem = new JMenuItem[JiveUtils.nbAction];
        for (n = 0; n < JiveUtils.nbAction; ++n) {
            this.treeMenuItem[n] = new JMenuItem();
            this.treeMenuItem[n].setEnabled(false);
            this.treeMenuItem[n].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainPanel.this.execMenuAction(actionEvent);
                }
            });
        }
        this.treeMenuItem[0].setText("Cut");
        this.treeMenuItem[1].setText("Copy");
        this.treeMenuItem[2].setText("Paste");
        this.treeMenuItem[3].setText("Delete");
        this.treeMenuItem[4].setText("Add device");
        this.treeMenuItem[5].setText("Create server");
        this.treeMenuItem[6].setText("Create new property");
        this.treeMenuItem[7].setText("Change TANGO HOST");
        this.treeMenuItem[8].setText("Add class to server");
        this.treeMenuItem[9].setText("Rename");
        this.treeMenuItem[10].setText("Monitor device");
        this.treeMenuItem[11].setText("Test device");
        this.treeMenuItem[12].setText("Show properties");
        this.treeMenuItem[13].setText("Test admin server");
        this.treeMenuItem[14].setText("Unexport devices");
        this.treeMenuItem[15].setText("Save server data");
        this.treeMenuItem[16].setText("Define device alias");
        this.treeMenuItem[17].setText("Go to server node");
        this.treeMenuItem[18].setText("Go to device node");
        this.treeMenuItem[19].setText("Restart device");
        this.treeMenuItem[20].setText("Reset to default value");
        this.treeMenuItem[21].setText("Go to device admin node");
        this.treeMenuItem[22].setText("Change Archiving mode");
        this.treeMenuItem[23].setText("Create class attribute");
        this.treeMenuItem[24].setText("Server wizard");
        this.treeMenuItem[25].setText("Classes wizard");
        this.treeMenuItem[26].setText("Devices wizard");
        this.treeMenuItem[27].setText("Device wizard");
        for (n = 0; n < JiveUtils.nbAction; ++n) {
            if (n == 4) {
                this.treeMenu.add(new JSeparator());
            }
            this.treeMenu.add(this.treeMenuItem[n]);
        }
        this.treeMenuMultiple = new JPopupMenu();
        this.jMenuItemMDelete2 = new JMenuItem();
        this.jMenuItemMCopy2 = new JMenuItem();
        this.jMenuItemMSave2 = new JMenuItem();
        this.jMenuItemMDelete2.setText("Delete");
        this.jMenuItemMCopy2.setText("Copy");
        this.jMenuItemMSave2.setText("Save servers");
        this.treeMenuMultiple.add(this.jMenuItemMCopy2);
        this.treeMenuMultiple.add(this.jMenuItemMDelete2);
        this.treeMenuMultiple.add(this.jMenuItemMSave2);
        this.jMenuItemMDelete2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.execMultipleAction(3);
            }
        });
        this.jMenuItemMCopy2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.execMultipleAction(1);
            }
        });
        this.jMenuItemMSave2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.execMultipleAction(15);
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                MainPanel.this.exitForm();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                TreePath treePath;
                if (JiveUtils.dlg != null && (treePath = MainPanel.this.mainTree.getSelectionPath()) != null) {
                    MainPanel.this.mainTree.makeVisible(treePath);
                    Rectangle rectangle = MainPanel.this.mainTree.getPathBounds(treePath);
                    Point point = rectangle.getLocation();
                    SwingUtilities.convertPointToScreen(point, MainPanel.this.mainTree);
                    JiveUtils.dlg.moveToLocation(point.x, point.y);
                }
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MainPanel.this.placeComponents();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                MainPanel.this.placeComponents();
            }
        });
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/jive/jive.jpg"));
        this.setIconImage(imageIcon.getImage());
    }

    public void loadPropFile() {
        String string = "";
        TangoFileReader tangoFileReader = new TangoFileReader(this.db);
        JFileChooser jFileChooser = new JFileChooser(".");
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file != null) {
                string = tangoFileReader.parse_res_file(file.getAbsolutePath());
            }
            if (string.length() > 0) {
                JiveUtils.showJiveError(string);
            }
        }
    }

    public void execMenuAction(ActionEvent actionEvent) {
        boolean bl;
        String[] stringArray;
        Object object;
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        int n = 0;
        boolean bl2 = false;
        while (n < JiveUtils.nbAction && !bl2) {
            bl2 = jMenuItem == this.treeMenuItem[n];
            if (bl2) continue;
            ++n;
        }
        if (n == 7 && (object = JOptionPane.showInputDialog(this, "Enter tango host (ex gizmo:20000)", "Jive", 3)) != null) {
            stringArray = ((String)object).split(":");
            if (stringArray.length != 2) {
                JiveUtils.showJiveError("Invalid tango host syntax: should be host:port");
                return;
            }
            try {
                Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                JiveUtils.showJiveError("Invalid tango host port number\n" + numberFormatException.getMessage());
                return;
            }
            this.tangoHost = object;
            try {
                this.db = ApiUtil.change_db_obj((String)stringArray[0], (String)stringArray[1]);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
                this.db = null;
            }
            catch (Exception exception) {
                JiveUtils.showJiveError(exception.getMessage());
                this.db = null;
            }
            this.refreshTree();
        }
        if ((object = this.mainTree.getSelectionPath()) != null && (bl = JiveUtils.execAction(n, (TreePath)object, this.mainTree, this.mainTreeModel, (Rectangle)(stringArray = JiveUtils.computeBounds(this.mainTree, (TreePath)object)), 0, 1))) {
            this.refreshTree();
        }
    }

    public void execMultipleAction(int n) {
        Rectangle rectangle = new Rectangle();
        TreePath[] treePathArray = this.mainTree.getSelectionPaths();
        if (n == 1) {
            JiveUtils.the_clipboard.clear();
        }
        if (n == 3 && JOptionPane.showConfirmDialog(this, "Delete multiple selection ?", "Confirm delete", 0) != 0) {
            return;
        }
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                JiveUtils.execAction(n + 100, treePathArray[i], this.mainTree, this.mainTreeModel, rectangle, i, treePathArray.length);
            }
        }
    }

    public void placeComponents() {
        Dimension dimension = this.getContentPane().getSize();
        int n = dimension.width - 10;
        int n2 = dimension.height;
        this.statusLine.setBounds(5, 2, n, 20);
        this.splitPane.setBounds(5, 25, n, n2 - 30);
        this.splitPane.setDividerLocation(0.4);
    }

    public void findProperty(int n) {
        Serializable serializable;
        if (n == 0) {
            JiveUtils.scan_progress = 0;
            TreePath treePath = this.mainTree.getSelectionPath();
            serializable = treePath == null ? (TangoTreeNode)this.rootNode : (TangoTreeNode)treePath.getLastPathComponent();
            SearchDlg searchDlg = new SearchDlg((Frame)this, true, "Search Tango data base", "Text to find");
            if (!searchDlg.showDlg()) {
                return;
            }
            JiveUtils.InitiateSearch((TangoTreeNode)serializable, SearchDlg.textToFind, SearchDlg.textToFindValue, SearchDlg.dIgnoreCase, SearchDlg.dSearchValues, SearchDlg.dSearchAttributes, SearchDlg.dSearchCommands, SearchDlg.dSearchUseRegexp, false);
        }
        JiveUtils.error_report = false;
        serializable = JiveUtils.findText();
        if (serializable != null) {
            this.mainTree.setSelectionPath((TreePath)serializable);
            this.mainTree.scrollPathToVisible((TreePath)serializable);
        }
        JiveUtils.error_report = true;
        if (serializable == null) {
            JiveUtils.showJiveError("No item found...");
        }
    }

    public void selectProperties() {
        JiveUtils.scan_progress = 0;
        applySelPath = this.mainTree.getSelectionPaths();
        if (applySelPath == null) {
            JiveUtils.showJiveError("Please select starting nodes");
            return;
        }
        SearchDlg searchDlg = new SearchDlg((Frame)this, true, "Multiple selection", "Select");
        if (!searchDlg.showDlg()) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    int n;
                    TreePath[] treePathArray;
                    int n2;
                    Vector<TreePath> vector = new Vector<TreePath>();
                    for (n2 = 0; n2 < applySelPath.length && !ThreadDlg.stopflag; ++n2) {
                        TangoTreeNode tangoTreeNode = (TangoTreeNode)applySelPath[n2].getLastPathComponent();
                        JiveUtils.InitiateSearch(tangoTreeNode, SearchDlg.textToFind, SearchDlg.textToFindValue, SearchDlg.dIgnoreCase, SearchDlg.dSearchValues, SearchDlg.dSearchAttributes, SearchDlg.dSearchCommands, SearchDlg.dSearchUseRegexp, true);
                        JiveUtils.error_report = false;
                        treePathArray = JiveUtils.findMultipleText();
                        if (treePathArray != null) {
                            for (n = 0; n < treePathArray.length; ++n) {
                                vector.add(treePathArray[n]);
                            }
                        }
                        applyDlg.setProgress((int)((double)(n2 + 1) / (double)applySelPath.length * 50.0));
                    }
                    MainPanel.this.mainTree.clearSelection();
                    if (ThreadDlg.stopflag) {
                        applyDlg.hideDlg();
                        return;
                    }
                    MainPanel.this.refresh_values = false;
                    int n3 = vector.size() / 10 + 1;
                    for (n2 = 0; n2 < vector.size() && !ThreadDlg.stopflag; n2 += n3) {
                        treePathArray = null;
                        treePathArray = n2 + n3 < vector.size() ? new TreePath[n3] : new TreePath[vector.size() - n2];
                        for (n = 0; n < treePathArray.length; ++n) {
                            treePathArray[n] = (TreePath)vector.get(n2 + n);
                        }
                        MainPanel.this.mainTree.addSelectionPaths(treePathArray);
                        applyDlg.setProgress((int)((double)(n2 + 1) / (double)vector.size() * 50.0 + 50.0));
                    }
                    if (vector.size() > 0) {
                        MainPanel.this.mainTree.scrollPathToVisible((TreePath)vector.get(0));
                    }
                    JiveUtils.error_report = true;
                    MainPanel.this.gobalValueRefresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                MainPanel.this.refresh_values = true;
                applyDlg.hideDlg();
            }
        };
        applyDlg = new ThreadDlg((Frame)this, "", true, thread);
        applyDlg.showDlg();
    }

    private void exitForm() {
        if (this.running_from_shell) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            new MainPanel(true, false);
        } else if (stringArray[0].equalsIgnoreCase("-r")) {
            new MainPanel(true, true);
        } else {
            System.out.println("Usage: jive [-r]");
            System.out.println("   -r  Read only mode (No write access to database allowed)");
        }
    }
}

