/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelDevice
extends TreePanel {
    String deviceFilterString = "*/*/*";
    String domainFilterString = "*";
    String familyFilterString = "*";
    String memberFilterString = "*";

    public TreePanelDevice(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    public boolean isDomain(String string) {
        TangoNode tangoNode = this.searchNode(this.root, string);
        return tangoNode != null;
    }

    public TangoNode selectDevice(String string) {
        int n = string.indexOf(47);
        int n2 = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1);
        TangoNode tangoNode = this.searchNode(this.root, string2);
        if (tangoNode == null) {
            return null;
        }
        TangoNode tangoNode2 = this.searchNode(tangoNode, string3);
        if (tangoNode2 == null) {
            return null;
        }
        TangoNode tangoNode3 = this.searchNode(tangoNode2, string4);
        if (tangoNode3 == null) {
            return null;
        }
        TreePath treePath = new TreePath(this.root);
        treePath = treePath.pathByAddingChild(tangoNode);
        treePath = treePath.pathByAddingChild(tangoNode2);
        treePath = treePath.pathByAddingChild(tangoNode3);
        this.tree.setSelectionPath(treePath);
        return tangoNode3;
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode(this);
    }

    public void applyFilter(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length != 3) {
            JOptionPane.showMessageDialog(this.invoker, "Invalid device filter\n3 fields expected: domain/family/member");
            return;
        }
        this.deviceFilterString = string;
        this.domainFilterString = stringArray[0];
        this.familyFilterString = stringArray[1];
        this.memberFilterString = stringArray[2];
    }

    public String getFilter() {
        return this.deviceFilterString;
    }

    class DeviceNode
    extends TangoNode {
        private String domain;
        private String family;
        private String member;
        private String devName;

        DeviceNode(String string, String string2, String string3) {
            this.domain = string;
            this.family = string2;
            this.member = string3;
            this.devName = this.domain + "/" + this.family + "/" + string3;
        }

        @Override
        void populateNode() throws DevFailed {
            this.add(new TaskDevicePropertyNode(TreePanelDevice.this.self, TreePanelDevice.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelDevice.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelDevice.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelDevice.this.db, this.devName));
            this.add(new AttributeNode(this.devName));
            this.add(new TaskLoggingNode(TreePanelDevice.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.member;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        String getValue() {
            return TreePanelDevice.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }

        @Override
        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[]{10, 11, 16, 17};
            }
            return new int[]{0, 1, 3, 10, 11, 12, 16, 14, 17, 25};
        }

        @Override
        void execAction(int n) {
            switch (n) {
                case 0: {
                    JiveUtils.copyDeviceProperties(TreePanelDevice.this.db, this.devName);
                    break;
                }
                case 1: {
                    TreePanelDevice.this.pasteDeviceProperty(TreePanelDevice.this.db, this.devName);
                    break;
                }
                case 3: {
                    int n2 = JOptionPane.showConfirmDialog(TreePanelDevice.this.invoker, "Delete device " + this.devName + " ?", "Confirm delete", 0);
                    if (n2 != 0) break;
                    try {
                        TreePanelDevice.this.db.delete_device(this.devName);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelDevice.this.refresh();
                    break;
                }
                case 10: {
                    new atkpanel.MainPanel(this.devName, false, true, !JiveUtils.readOnly);
                    break;
                }
                case 11: {
                    TreePanelDevice.this.testDevice(this.devName);
                    break;
                }
                case 12: {
                    String string = JOptionPane.showInputDialog(null, "Define device alias", "");
                    if (string == null) {
                        return;
                    }
                    try {
                        TreePanelDevice.this.db.put_device_alias(this.devName, string);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 16: {
                    try {
                        DbDevImportInfo dbDevImportInfo = TreePanelDevice.this.db.import_device(this.devName);
                        TreePanelDevice.this.invoker.goToServerFullNode(dbDevImportInfo.server);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 14: {
                    try {
                        DbDevImportInfo dbDevImportInfo = TreePanelDevice.this.db.import_device(this.devName);
                        DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
                        DeviceData deviceData = new DeviceData();
                        deviceData.insert(this.devName);
                        deviceProxy.command_inout("DevRestart", deviceData);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 17: {
                    try {
                        DbDevImportInfo dbDevImportInfo = TreePanelDevice.this.db.import_device(this.devName);
                        TreePanelDevice.this.selectDevice("dserver/" + dbDevImportInfo.server);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 25: {
                    TreePanelDevice.this.launchLogViewer(this.devName);
                }
            }
        }
    }

    class AttributeNode
    extends TangoNode {
        private String devName;

        AttributeNode(String string) {
            this.devName = string;
        }

        @Override
        void populateNode() throws DevFailed {
            String[] stringArray = null;
            int n = 0;
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            try {
                stringArray = deviceProxy.get_attribute_list();
                n = deviceProxy.get_idl_version();
            }
            catch (DevFailed devFailed) {
                stringArray = TreePanelDevice.this.db.get_device_attribute_list(this.devName);
            }
            JiveUtils.sortList(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new TaskDeviceAttributePropertyNode(TreePanelDevice.this.self, TreePanelDevice.this.db, this.devName, stringArray[i], n));
            }
        }

        @Override
        public String toString() {
            return "Attribute properties";
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }
    }

    class FamilyNode
    extends TangoNode {
        private String domain;
        private String family;

        FamilyNode(String string, String string2, TreePanel treePanel) {
            this.domain = string;
            this.family = string2;
            this.parentPanel = treePanel;
        }

        @Override
        void populateNode() throws DevFailed {
            if (TreePanelDevice.this.domainFilterString.equals("*") && TreePanelDevice.this.familyFilterString.equals("*") && TreePanelDevice.this.memberFilterString.equals("*")) {
                String string = this.domain + "/" + this.family + "/";
                String[] stringArray = TreePanelDevice.this.db.get_device_member(string + TreePanelDevice.this.memberFilterString);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.add(new DeviceNode(this.domain, this.family, stringArray[i]));
                }
            } else {
                String string = this.domain + "/" + this.family + "/" + TreePanelDevice.this.memberFilterString;
                String string2 = this.parentPanel.replaceWildcard(string);
                DeviceData deviceData = new DeviceData();
                String string3 = "select distinct member from device where name LIKE '" + string2 + "' order by member";
                deviceData.insert(string3);
                DeviceData deviceData2 = TreePanelDevice.this.db.command_inout("DbMySqlSelect", deviceData);
                DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
                for (int i = 0; i < devVarLongStringArray.svalue.length; ++i) {
                    this.add(new DeviceNode(this.domain, this.family, devVarLongStringArray.svalue[i]));
                }
            }
        }

        @Override
        public String toString() {
            return this.family;
        }

        @Override
        int[] getAction() {
            return new int[]{20, 21, 22, 23, 24};
        }

        @Override
        void execAction(int n) {
            switch (n) {
                case 20: {
                    this.parentPanel.selectNodesFromFamily(this, "Properties");
                    break;
                }
                case 21: {
                    this.parentPanel.selectNodesFromFamily(this, "Polling");
                    break;
                }
                case 22: {
                    this.parentPanel.selectNodesFromFamily(this, "Event");
                    break;
                }
                case 23: {
                    this.parentPanel.selectNodesFromFamily(this, "Attribute config");
                    break;
                }
                case 24: {
                    this.parentPanel.selectNodesFromFamily(this, "Logging");
                }
            }
        }
    }

    class DomainNode
    extends TangoNode {
        private String domain;

        DomainNode(String string, TreePanel treePanel) {
            this.domain = string;
            this.parentPanel = treePanel;
        }

        @Override
        void populateNode() throws DevFailed {
            if (TreePanelDevice.this.domainFilterString.equals("*") && TreePanelDevice.this.familyFilterString.equals("*") && TreePanelDevice.this.memberFilterString.equals("*")) {
                String[] stringArray = TreePanelDevice.this.db.get_device_family(this.domain + "/" + TreePanelDevice.this.familyFilterString);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.add(new FamilyNode(this.domain, stringArray[i], this.parentPanel));
                }
            } else {
                String string = this.domain + "/" + TreePanelDevice.this.familyFilterString + "/" + TreePanelDevice.this.memberFilterString;
                String string2 = this.parentPanel.replaceWildcard(string);
                DeviceData deviceData = new DeviceData();
                String string3 = "select distinct family from device where name LIKE '" + string2 + "' order by family";
                deviceData.insert(string3);
                DeviceData deviceData2 = TreePanelDevice.this.db.command_inout("DbMySqlSelect", deviceData);
                DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
                for (int i = 0; i < devVarLongStringArray.svalue.length; ++i) {
                    this.add(new FamilyNode(this.domain, devVarLongStringArray.svalue[i], this.parentPanel));
                }
            }
        }

        @Override
        public String toString() {
            return this.domain;
        }

        @Override
        int[] getAction() {
            return new int[]{20, 21, 22, 23, 24};
        }

        @Override
        void execAction(int n) {
            switch (n) {
                case 20: {
                    this.parentPanel.selectNodesFromDomain(this, "Properties");
                    break;
                }
                case 21: {
                    this.parentPanel.selectNodesFromDomain(this, "Polling");
                    break;
                }
                case 22: {
                    this.parentPanel.selectNodesFromDomain(this, "Event");
                    break;
                }
                case 23: {
                    this.parentPanel.selectNodesFromDomain(this, "Attribute config");
                    break;
                }
                case 24: {
                    this.parentPanel.selectNodesFromDomain(this, "Logging");
                }
            }
        }
    }

    class RootNode
    extends TangoNode {
        RootNode(TreePanel treePanel) {
            this.parentPanel = treePanel;
        }

        @Override
        void populateNode() throws DevFailed {
            if (TreePanelDevice.this.domainFilterString.equals("*") && TreePanelDevice.this.familyFilterString.equals("*") && TreePanelDevice.this.memberFilterString.equals("*")) {
                String[] stringArray = TreePanelDevice.this.db.get_device_domain(TreePanelDevice.this.domainFilterString);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.add(new DomainNode(stringArray[i], this.parentPanel));
                }
            } else {
                String string = TreePanelDevice.this.domainFilterString + "/" + TreePanelDevice.this.familyFilterString + "/" + TreePanelDevice.this.memberFilterString;
                String string2 = this.parentPanel.replaceWildcard(string);
                DeviceData deviceData = new DeviceData();
                String string3 = "select distinct domain from device where name LIKE '" + string2 + "' order by domain";
                deviceData.insert(string3);
                DeviceData deviceData2 = TreePanelDevice.this.db.command_inout("DbMySqlSelect", deviceData);
                DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
                for (int i = 0; i < devVarLongStringArray.svalue.length; ++i) {
                    this.add(new DomainNode(devVarLongStringArray.svalue[i], this.parentPanel));
                }
            }
        }

        @Override
        public String toString() {
            return "Device:";
        }
    }
}

