/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jive.JiveUtils;

public class TangoClassSelector
extends JDialog
implements ActionListener {
    private String[] devList;
    private String[] classList;
    private String[] classInfo;
    private JLabel label1;
    private JList classSel;
    private JScrollPane classScroll;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okFlag = false;

    public TangoClassSelector(JFrame jFrame, String[] stringArray, String string) {
        super((Frame)jFrame, true);
        this.devList = stringArray;
        this.buildClassList();
        this.setLayout(null);
        this.setTitle("Class for " + string + " node selection");
        this.label1 = new JLabel(this.classList.length + " class(es) found, choose class to select");
        this.label1.setBounds(10, 10, 300, 25);
        this.add(this.label1);
        this.classSel = new JList();
        this.classSel.setSelectionMode(0);
        this.classSel.setListData(this.classInfo);
        this.classScroll = new JScrollPane(this.classSel);
        this.classScroll.setBounds(10, 40, 300, 300);
        this.add(this.classScroll);
        this.okButton = new JButton("Select");
        this.okButton.setBounds(10, 350, 80, 25);
        this.okButton.addActionListener(this);
        this.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setBounds(230, 345, 80, 25);
        this.cancelButton.addActionListener(this);
        this.add(this.cancelButton);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.okFlag = true;
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.okFlag = false;
            this.setVisible(false);
        }
    }

    private void buildClassList() {
        int n;
        Vector<String> vector = new Vector<String>();
        int[] nArray = new int[32768];
        for (n = 0; n < this.devList.length; n += 2) {
            int n2 = vector.indexOf(this.devList[n + 1]);
            if (n2 < 0) {
                vector.add(this.devList[n + 1]);
                nArray[vector.size() - 1] = 1;
                continue;
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
        this.classList = new String[vector.size()];
        this.classInfo = new String[vector.size()];
        for (n = 0; n < this.classList.length; ++n) {
            this.classList[n] = (String)vector.get(n);
            this.classInfo[n] = (String)vector.get(n) + "     (" + Integer.toString(nArray[n]) + " devices)";
        }
    }

    public String getSelectedClass() {
        ATKGraphicsUtils.centerDialog((Dialog)this, (int)320, (int)380);
        this.setVisible(true);
        this.dispose();
        if (!this.okFlag) {
            return null;
        }
        int n = this.classSel.getSelectedIndex();
        if (n < 0) {
            JiveUtils.showJiveError("No class selected");
            return null;
        }
        return this.classList[n];
    }
}

