/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.MultiLineInputDlg;
import jive3.PItem;

public class SelectionDlg
extends JFrame
implements ActionListener {
    Database db = null;
    String[] colName = new String[]{"Name", "Value"};
    private MultiLineCellEditor editor;
    JTextField selectionText;
    JLabel selectionLabel;
    JButton searchButton;
    JButton applyAllButton;
    JButton applyButton;
    JButton dismissButton;
    JLabel infoLabel;
    DefaultTableModel dm;
    JTable theTable;
    String selectText;
    Vector<PItem> items;

    public SelectionDlg() {
        this.initComponents();
    }

    public void setDatabase(Database database) {
        this.db = database;
    }

    public void clear() {
        this.items.clear();
        this.infoLabel.setText(this.items.size() + " item(s)");
        Object[][] objectArray = new String[0][2];
        this.dm.setDataVector(objectArray, this.colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        ((JPanel)this.getContentPane()).revalidate();
    }

    void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        JLabel jLabel = new JLabel(" Selection ");
        jLabel.setFont(ATKConstant.labelFont);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.selectionText = new JTextField();
        this.selectionText.addActionListener(this);
        this.selectionText.setFont(ATKConstant.labelFont);
        jPanel.add((Component)this.selectionText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(this);
        jPanel.add((Component)this.searchButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this.infoLabel = new JLabel("0 item(s)");
        this.infoLabel.setFont(ATKConstant.labelFont);
        jPanel2.add(this.infoLabel);
        this.applyAllButton = new JButton("Apply to all ...");
        this.applyAllButton.setToolTipText("Ask for a value and apply it to the current selection");
        this.applyAllButton.addActionListener(this);
        jPanel2.add(this.applyAllButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setToolTipText("Apply change to the database");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        jPanel2.add(this.applyButton);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.addActionListener(this);
        jPanel2.add(this.dismissButton);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jPanel2, "South");
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    SelectionDlg.this.items.get((int)n).value = JiveUtils.makeStringArray((String)object);
                    SelectionDlg.this.items.get((int)n).updated = true;
                    SelectionDlg.this.applyButton.setEnabled(true);
                }
            }
        };
        this.theTable = new JTable(this.dm);
        this.editor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer(false, false, false);
        this.theTable.setDefaultRenderer(String.class, multiLineCellRenderer);
        this.theTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.theTable);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setTitle("Multiple selection");
        this.setPreferredSize(new Dimension(800, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelectionDlg.this.exitDlg();
                super.windowClosing(windowEvent);
            }
        });
        this.items = new Vector();
        this.clear();
    }

    private void selectProperty() {
        this.refresh();
    }

    private void refresh() {
        int n;
        String string = this.selectionText.getText();
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '/') continue;
            ++n2;
        }
        if (n2 != 3) {
            JiveUtils.showJiveError("Invalid selection pattern, 4 slash separated fields expected");
            return;
        }
        try {
            n = string.lastIndexOf(47);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.items.clear();
            String[] stringArray = this.db.get_device_list(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = this.db.get_device_property_list(stringArray[i], string3);
                for (int j = 0; j < stringArray2.length; ++j) {
                    PItem pItem = new PItem();
                    pItem.devName = stringArray[i];
                    pItem.pName = stringArray2[j];
                    pItem.updated = false;
                    DbDatum dbDatum = this.db.get_device_property(pItem.devName, pItem.pName);
                    pItem.value = dbDatum.extractStringArray();
                    this.items.add(pItem);
                }
            }
            if (this.items.size() == 0) {
                JOptionPane.showMessageDialog(this, "No property found");
            }
            this.infoLabel.setText(this.items.size() + " item(s)");
            this.refreshTable();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    private void refreshTable() {
        Object[][] objectArray = new String[this.items.size()][2];
        for (int i = 0; i < this.items.size(); ++i) {
            objectArray[i][0] = this.items.get((int)i).devName + "/" + this.items.get((int)i).pName;
            objectArray[i][1] = this.items.get(i).toString();
        }
        this.dm.setDataVector(objectArray, this.colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        ((JPanel)this.getContentPane()).revalidate();
    }

    private void applyAll() {
        if (this.items.size() == 0) {
            JOptionPane.showMessageDialog(this, "No selection");
            return;
        }
        String[] stringArray = MultiLineInputDlg.getInputText(this, "Apply to all", "Apply to " + this.items.size() + " item(s)", this.items.get((int)0).value);
        if (stringArray != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                this.items.get((int)i).value = stringArray;
                this.items.get((int)i).updated = true;
            }
            this.apply();
            this.refreshTable();
        }
    }

    private void apply() {
        try {
            for (int i = 0; i < this.items.size(); ++i) {
                PItem pItem = this.items.get(i);
                if (pItem.updated) {
                    DbDatum[] dbDatumArray = new DbDatum[1];
                    DbDatum dbDatum = new DbDatum(pItem.pName);
                    dbDatum.insert(pItem.value);
                    dbDatumArray[0] = dbDatum;
                    this.db.put_device_property(pItem.devName, dbDatumArray);
                }
                pItem.updated = false;
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        this.applyButton.setEnabled(false);
    }

    public boolean hasChanged() {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.items.size()) {
            bl = this.items.get((int)n).updated;
            if (bl) continue;
            ++n;
        }
        return bl;
    }

    private void exitDlg() {
        int n;
        if (this.hasChanged() && (n = JOptionPane.showConfirmDialog(this, "Some properties have changed\nDo you want to update the database ?", "Confirmation", 0)) == 0) {
            this.apply();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.searchButton || object == this.selectionText) {
            this.selectProperty();
        } else if (object == this.dismissButton) {
            this.exitDlg();
            this.setVisible(false);
        } else if (object == this.applyButton) {
            this.apply();
        } else if (object == this.applyAllButton) {
            this.applyAll();
        }
    }
}

