/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskClassAttributePropertyNode;
import jive3.TaskClassPropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelClass
extends TreePanel {
    String classFilterString = "*";
    Pattern classPattern = null;

    public TreePanelClass(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    void addAttribute(TangoNode tangoNode, String string, String string2) {
        if (this.searchNode(tangoNode, string2) != null) {
            JOptionPane.showMessageDialog(null, "Attribute already exists", "Error", 0);
            return;
        }
        this.treeModel.insertNodeInto(new TaskClassAttributePropertyNode(this.self, this.db, string, string2), tangoNode, 0);
    }

    public void applyFilter(String string) {
        this.classFilterString = string;
        if (string.equals("*")) {
            this.classPattern = null;
        } else if (string.length() == 0) {
            this.classPattern = null;
        } else {
            try {
                String string2 = this.filterToRegExp(this.classFilterString);
                this.classPattern = Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this.invoker, patternSyntaxException.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.classFilterString;
    }

    class DeviceNode
    extends TangoNode {
        private String devName;

        DeviceNode(String string) {
            this.devName = string;
        }

        @Override
        void populateNode() throws DevFailed {
            this.add(new TaskDevicePropertyNode(TreePanelClass.this.self, TreePanelClass.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelClass.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelClass.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelClass.this.db, this.devName));
            this.add(new AttributeNode(this.devName));
            this.add(new TaskLoggingNode(TreePanelClass.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.devName;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        String getValue() {
            return TreePanelClass.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }

        @Override
        int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[]{10, 11, 16};
            }
            return new int[]{0, 1, 3, 10, 11, 12, 16, 14, 25};
        }

        @Override
        void execAction(int n) {
            switch (n) {
                case 0: {
                    JiveUtils.copyDeviceProperties(TreePanelClass.this.db, this.devName);
                    break;
                }
                case 1: {
                    TreePanelClass.this.pasteDeviceProperty(TreePanelClass.this.db, this.devName);
                    break;
                }
                case 3: {
                    int n2 = JOptionPane.showConfirmDialog(TreePanelClass.this.invoker, "Delete device " + this.devName + " ?", "Confirm delete", 0);
                    if (n2 != 0) break;
                    try {
                        TreePanelClass.this.db.delete_device(this.devName);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelClass.this.refresh();
                    break;
                }
                case 10: {
                    new atkpanel.MainPanel(this.devName, false, true, !JiveUtils.readOnly);
                    break;
                }
                case 11: {
                    TreePanelClass.this.testDevice(this.devName);
                    break;
                }
                case 12: {
                    String string = JOptionPane.showInputDialog(null, "Define device alias", "");
                    if (string == null) {
                        return;
                    }
                    try {
                        TreePanelClass.this.db.put_device_alias(this.devName, string);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 16: {
                    try {
                        DbDevImportInfo dbDevImportInfo = TreePanelClass.this.db.import_device(this.devName);
                        TreePanelClass.this.invoker.goToServerFullNode(dbDevImportInfo.server);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 14: {
                    try {
                        DbDevImportInfo dbDevImportInfo = TreePanelClass.this.db.import_device(this.devName);
                        DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
                        DeviceData deviceData = new DeviceData();
                        deviceData.insert(this.devName);
                        deviceProxy.command_inout("DevRestart", deviceData);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    break;
                }
                case 25: {
                    TreePanelClass.this.launchLogViewer(this.devName);
                }
            }
        }
    }

    class DevicesNode
    extends TangoNode {
        private String className;

        DevicesNode(String string) {
            this.className = string;
        }

        @Override
        void populateNode() throws DevFailed {
            DeviceData deviceData = new DeviceData();
            String string = "select name from device where class='" + this.className + "' order by name";
            deviceData.insert(string);
            DeviceData deviceData2 = TreePanelClass.this.db.command_inout("DbMySqlSelect", deviceData);
            DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
            for (int i = 0; i < devVarLongStringArray.svalue.length; ++i) {
                this.add(new DeviceNode(devVarLongStringArray.svalue[i]));
            }
        }

        @Override
        public String toString() {
            return "Devices";
        }

        @Override
        public int[] getAction() {
            return new int[0];
        }

        @Override
        public void execAction(int n) {
        }
    }

    class AttributeNode
    extends TangoNode {
        private String className;

        AttributeNode(String string) {
            this.className = string;
        }

        @Override
        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelClass.this.db.get_class_attribute_list(this.getParent().toString(), "*");
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new TaskClassAttributePropertyNode(TreePanelClass.this.self, TreePanelClass.this.db, this.className, stringArray[i]));
            }
        }

        @Override
        public String toString() {
            return "Attribute properties";
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }

        @Override
        public int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[0];
            }
            return new int[]{18};
        }

        @Override
        public void execAction(int n) {
            switch (n) {
                case 18: {
                    String string = JOptionPane.showInputDialog(null, "Add class attribute", "");
                    if (string == null) {
                        return;
                    }
                    TreePanelClass.this.addAttribute(this, this.className, string);
                }
            }
        }
    }

    class ClassNode
    extends TangoNode {
        private String className;

        ClassNode(String string) {
            this.className = string;
        }

        @Override
        void populateNode() throws DevFailed {
            this.add(new TaskClassPropertyNode(TreePanelClass.this.self, TreePanelClass.this.db, this.className));
            this.add(new AttributeNode(this.className));
            this.add(new DevicesNode(this.className));
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelClass.this.db.get_class_list("*");
            for (int i = 0; i < stringArray.length; ++i) {
                if (TreePanelClass.this.classPattern != null) {
                    Matcher matcher = TreePanelClass.this.classPattern.matcher(stringArray[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != stringArray[i].length()) continue;
                    this.add(new ClassNode(stringArray[i]));
                    continue;
                }
                this.add(new ClassNode(stringArray[i]));
            }
        }

        @Override
        public String toString() {
            return "Class:";
        }
    }
}

