/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.Frame;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JFrame;
import javax.swing.tree.TreePath;
import jive.JiveUtils;
import jive.ThreadDlg;
import jive3.TangoNode;

public class SearchEngine {
    int scanProgress;
    Stack<TangoNode> searchStack = null;
    String searchText;
    boolean searchIgnoreCase;
    boolean searchPath;
    boolean searchProperty;
    boolean searchPolling;
    boolean searchAttConfig;
    boolean searchEvent;
    boolean searchAttProperty;
    boolean searchUseRegexp;
    boolean searchOnlyLeaf;
    TreePath searchResult;
    ThreadDlg searchDlg;
    JFrame parent;

    SearchEngine(JFrame jFrame) {
        this.parent = jFrame;
        this.scanProgress = 0;
        this.searchStack = new Stack();
        this.searchIgnoreCase = true;
        this.searchPath = true;
        this.searchProperty = false;
        this.searchPolling = false;
        this.searchAttConfig = false;
        this.searchEvent = false;
        this.searchAttProperty = false;
        this.searchUseRegexp = false;
    }

    public boolean isStackEmpty() {
        if (this.searchStack == null) {
            return true;
        }
        return this.searchStack.empty();
    }

    public void resetSearch() {
        this.searchStack.clear();
    }

    public TreePath findText(String string, TangoNode tangoNode) {
        this.scanProgress = 0;
        this.searchStack.clear();
        this.searchStack.push(tangoNode);
        this.searchText = this.searchIgnoreCase ? string.toLowerCase() : string;
        Thread thread = new Thread(){

            @Override
            public void run() {
                SearchEngine.this.searchResult = SearchEngine.this.findTextTask();
                SearchEngine.this.searchDlg.hideDlg();
            }
        };
        this.searchResult = null;
        this.searchDlg = new ThreadDlg((Frame)this.parent, "Searching the database", false, thread);
        this.searchDlg.showDlg();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        thread = null;
        return this.searchResult;
    }

    public TreePath findNext() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SearchEngine.this.searchResult = SearchEngine.this.findTextTask();
                SearchEngine.this.searchDlg.hideDlg();
            }
        };
        this.searchResult = null;
        this.searchDlg = new ThreadDlg((Frame)this.parent, "Searching the database", false, thread);
        this.searchDlg.showDlg();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        thread = null;
        return this.searchResult;
    }

    private TreePath findTextTask() {
        Pattern pattern = null;
        TangoNode tangoNode = null;
        if (this.searchUseRegexp) {
            try {
                pattern = Pattern.compile(this.searchText);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JiveUtils.showJiveError("Invalid regular expression\n" + patternSyntaxException.getDescription());
                return null;
            }
        }
        boolean bl = false;
        while (!(this.searchStack.empty() || ThreadDlg.stopflag || bl)) {
            tangoNode = (TangoNode)this.searchStack.get(0);
            this.searchStack.remove(0);
            ++this.scanProgress;
            String string = null;
            if (this.searchPath) {
                TreePath treePath = tangoNode.getCompletePath();
                string = JiveUtils.getPathAsText(treePath);
                if (this.searchIgnoreCase) {
                    string = string.toLowerCase();
                }
                if (this.searchUseRegexp) {
                    bl = pattern.matcher(string).matches();
                } else {
                    boolean bl2 = bl = string.indexOf(this.searchText) != -1;
                }
            }
            if (bl) continue;
            int n = tangoNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.searchStack.add((TangoNode)tangoNode.getChildAt(i));
            }
        }
        if (bl) {
            return tangoNode.getCompletePath();
        }
        return null;
    }
}

