/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevSource;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jive.ConsolePanel;
import jive.JiveUtils;

class CommonPanel
extends JPanel
implements ActionListener {
    private DeviceProxy device = null;
    private DeviceProxy deviceAdm = null;
    private ConsolePanel console;
    private int answerLimitMin = 0;
    private int answerLimitMax = 1024;
    private JLabel sourceLabel;
    private JComboBox sourceCombo;
    private JLabel timeoutLabel;
    private JTextField timeoutText;
    private JLabel blackBoxLabel;
    private JTextField blackBoxText;
    private JLabel limitMinLabel;
    private JTextField limitMinText;
    private JLabel limitLengthLabel;
    private JTextField limitLengthText;
    private JButton restartBtn;
    private JButton pollStatusBtn;
    private JButton infoBtn;
    private JButton pingBtn;
    private JButton setTimeoutBtn;
    private JButton blackBoxBtn;
    private JButton limitMinBtn;
    private JButton limitLengthBtn;

    CommonPanel(DeviceProxy deviceProxy, ConsolePanel consolePanel) throws DevFailed {
        this.device = deviceProxy;
        this.console = consolePanel;
        this.setLayout(null);
        this.sourceLabel = new JLabel("Source");
        this.sourceLabel.setFont(ATKConstant.labelFont);
        this.add(this.sourceLabel);
        this.sourceCombo = new JComboBox();
        this.sourceCombo.addItem("CACHE");
        this.sourceCombo.addItem("CACHE_DEVICE");
        this.sourceCombo.addItem("DEVICE");
        this.sourceCombo.setFont(ATKConstant.labelFont);
        this.sourceCombo.setSelectedIndex(1);
        this.sourceCombo.addActionListener(this);
        this.add(this.sourceCombo);
        this.timeoutLabel = new JLabel("Timeout (ms)");
        this.timeoutLabel.setFont(ATKConstant.labelFont);
        this.add(this.timeoutLabel);
        this.timeoutText = new JTextField();
        this.timeoutText.setText(Integer.toString(deviceProxy.get_timeout_millis()));
        this.timeoutText.setFont(ATKConstant.labelFont);
        this.timeoutText.setMargin(JiveUtils.noMargin);
        this.add(this.timeoutText);
        this.setTimeoutBtn = new JButton("Apply");
        this.setTimeoutBtn.setFont(ATKConstant.labelFont);
        this.setTimeoutBtn.addActionListener(this);
        this.add(this.setTimeoutBtn);
        this.blackBoxLabel = new JLabel("BlackBox (nb cmd)");
        this.blackBoxLabel.setFont(ATKConstant.labelFont);
        this.add(this.blackBoxLabel);
        this.blackBoxText = new JTextField();
        this.blackBoxText.setText("10");
        this.blackBoxText.setFont(ATKConstant.labelFont);
        this.blackBoxText.setMargin(JiveUtils.noMargin);
        this.add(this.blackBoxText);
        this.blackBoxBtn = new JButton("Execute");
        this.blackBoxBtn.setFont(ATKConstant.labelFont);
        this.blackBoxBtn.addActionListener(this);
        this.add(this.blackBoxBtn);
        this.limitMinLabel = new JLabel("Answer limit (min)");
        this.limitMinLabel.setFont(ATKConstant.labelFont);
        this.add(this.limitMinLabel);
        this.limitMinText = new JTextField();
        this.limitMinText.setText("0");
        this.limitMinText.setFont(ATKConstant.labelFont);
        this.limitMinText.setMargin(JiveUtils.noMargin);
        this.add(this.limitMinText);
        this.limitMinBtn = new JButton("Apply");
        this.limitMinBtn.setFont(ATKConstant.labelFont);
        this.limitMinBtn.addActionListener(this);
        this.add(this.limitMinBtn);
        this.limitLengthLabel = new JLabel("Answer limit (length)");
        this.limitLengthLabel.setFont(ATKConstant.labelFont);
        this.add(this.limitLengthLabel);
        this.limitLengthText = new JTextField();
        this.limitLengthText.setText("1024");
        this.limitLengthText.setFont(ATKConstant.labelFont);
        this.limitLengthText.setMargin(JiveUtils.noMargin);
        this.add(this.limitLengthText);
        this.limitLengthBtn = new JButton("Apply");
        this.limitLengthBtn.setFont(ATKConstant.labelFont);
        this.limitLengthBtn.addActionListener(this);
        this.add(this.limitLengthBtn);
        this.infoBtn = new JButton("Device Info");
        this.infoBtn.addActionListener(this);
        this.infoBtn.setFont(ATKConstant.labelFont);
        this.add(this.infoBtn);
        this.pingBtn = new JButton("Ping Device");
        this.pingBtn.setFont(ATKConstant.labelFont);
        this.pingBtn.addActionListener(this);
        this.add(this.pingBtn);
        this.pollStatusBtn = new JButton("Polling status");
        this.pollStatusBtn.setFont(ATKConstant.labelFont);
        this.pollStatusBtn.addActionListener(this);
        this.add(this.pollStatusBtn);
        this.restartBtn = new JButton("Restart");
        this.restartBtn.addActionListener(this);
        this.restartBtn.setFont(ATKConstant.labelFont);
        this.add(this.restartBtn);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CommonPanel.this.placeComponents(CommonPanel.this.getSize());
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                CommonPanel.this.placeComponents(CommonPanel.this.getSize());
            }
        });
        try {
            deviceProxy.ping();
            this.deviceAdm = deviceProxy.get_adm_dev();
        }
        catch (DevFailed devFailed) {
            this.pingBtn.setEnabled(false);
            this.pollStatusBtn.setEnabled(false);
            this.restartBtn.setEnabled(false);
        }
    }

    private void placeComponents(Dimension dimension) {
        this.sourceLabel.setBounds(10, 10, 120, 25);
        this.sourceCombo.setBounds(130, 10, 150, 25);
        this.timeoutLabel.setBounds(10, 40, 120, 25);
        this.timeoutText.setBounds(130, 40, 60, 25);
        this.setTimeoutBtn.setBounds(190, 40, 90, 25);
        this.blackBoxLabel.setBounds(10, 70, 120, 25);
        this.blackBoxText.setBounds(130, 70, 60, 25);
        this.blackBoxBtn.setBounds(190, 70, 90, 25);
        this.limitMinLabel.setBounds(10, 100, 120, 25);
        this.limitMinText.setBounds(130, 100, 60, 25);
        this.limitMinBtn.setBounds(190, 100, 90, 25);
        this.limitLengthLabel.setBounds(10, 130, 120, 25);
        this.limitLengthText.setBounds(130, 130, 60, 25);
        this.limitLengthBtn.setBounds(190, 130, 90, 25);
        this.infoBtn.setBounds(300, 10, 110, 25);
        this.pingBtn.setBounds(300, 40, 110, 25);
        this.pollStatusBtn.setBounds(300, 70, 110, 25);
        this.restartBtn.setBounds(300, 100, 110, 25);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.limitMinBtn) {
            try {
                this.answerLimitMin = Integer.parseInt(this.limitMinText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid answer limit\n" + numberFormatException.getMessage());
            }
        } else if (object == this.limitLengthBtn) {
            try {
                this.answerLimitMax = Integer.parseInt(this.limitLengthText.getText()) + this.answerLimitMin;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid answer lenght\n" + numberFormatException.getMessage());
            }
        } else if (object == this.blackBoxBtn) {
            try {
                int n = Integer.parseInt(this.blackBoxText.getText());
                long l = System.currentTimeMillis();
                String[] stringArray = this.device.black_box(n);
                long l2 = System.currentTimeMillis();
                this.console.print("------------------------------------------\n");
                this.console.print("Command: " + this.device.name() + "/BlackBox\n");
                this.console.print("Duration: " + (l2 - l) + " msec\n\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.console.print("[" + i + "]\t " + stringArray[i] + "\n");
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid command number\n" + numberFormatException.getMessage());
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
            }
        } else if (object == this.infoBtn) {
            try {
                long l = System.currentTimeMillis();
                DevInfo devInfo = this.device.info();
                long l3 = System.currentTimeMillis();
                this.console.print("----------------------------------------------------\n");
                this.console.print("Command: " + this.device.name() + "/Info\n");
                this.console.print("Duration: " + (l3 - l) + " msec\n\n");
                this.console.print("Server: " + devInfo.server_id + "\n");
                this.console.print("Server host: " + devInfo.server_host + "\n");
                this.console.print("Server version: " + devInfo.server_version + "\n");
                this.console.print("Class: " + devInfo.dev_class + "\n");
                this.console.print(devInfo.doc_url + "\n");
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
            }
        } else if (object == this.pingBtn) {
            try {
                long l = System.currentTimeMillis();
                this.device.ping();
                long l4 = System.currentTimeMillis();
                this.console.print("------------------------------------------\n");
                this.console.print("Command: " + this.device.name() + "/Ping\n");
                this.console.print("Duration: " + (l4 - l) + " msec\n\n");
                this.console.print("Device is alive\n");
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
            }
        } else if (object == this.pollStatusBtn) {
            try {
                DeviceData deviceData = new DeviceData();
                deviceData.insert(this.device.name());
                DeviceData deviceData2 = this.deviceAdm.command_inout("DevPollStatus", deviceData);
                String[] stringArray = deviceData2.extractStringArray();
                this.console.print("----------------------------------------------------\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.console.print(stringArray[i] + "\n\n");
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
            }
        } else if (object == this.restartBtn) {
            try {
                DeviceData deviceData = new DeviceData();
                deviceData.insert(this.device.name());
                this.deviceAdm.command_inout("DevRestart", deviceData);
                this.console.print("----------------------------------------------------\n");
                this.console.print("Restart OK\n\n");
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
            }
        } else if (object == this.setTimeoutBtn) {
            try {
                int n = Integer.parseInt(this.timeoutText.getText());
                this.device.set_timeout_millis(n);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid timeout value\n" + numberFormatException.getMessage());
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
            }
        } else if (object == this.sourceCombo) {
            try {
                int n = this.sourceCombo.getSelectedIndex();
                switch (n) {
                    case 0: {
                        this.device.set_source(DevSource.CACHE);
                        break;
                    }
                    case 1: {
                        this.device.set_source(DevSource.CACHE_DEV);
                        break;
                    }
                    case 2: {
                        this.device.set_source(DevSource.DEV);
                    }
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
            }
        }
    }

    public int getAnswerLimitMin() {
        return this.answerLimitMin;
    }

    public int getAnswerLimitMax() {
        return this.answerLimitMax;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimunSize();
    }

    public Dimension getMinimunSize() {
        return new Dimension(470, 135);
    }
}

