/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.TaskAttributeNode;

public class DeviceAttributePanel
extends JPanel
implements MouseListener,
ActionListener {
    private JTabbedPane tabPane;
    private JTable alarmTable;
    private DefaultTableModel alarmModel;
    private JTable unitTable;
    private DefaultTableModel unitModel;
    private JTable rangeTable;
    private DefaultTableModel rangeModel;
    private JTable displayTable;
    private DefaultTableModel displayModel;
    private JTable descriptionTable;
    private DefaultTableModel descriptionModel;
    private JTable aliasTable;
    private DefaultTableModel aliasModel;
    private JButton refreshButton;
    private JButton applyButton;
    private JPopupMenu tableMenu;
    private JMenuItem resetMenuItem;
    private JMenuItem resetLMenuItem;
    private JMenuItem resetULMenuItem;
    private JMenuItem resetCULMenuItem;
    private JMenuItem alarmMinMenuItem;
    private JMenuItem alarmMaxMenuItem;
    private JMenuItem warningMinMenuItem;
    private JMenuItem warningMaxMenuItem;
    private JMenuItem deltaTMenuItem;
    private JMenuItem deltaValMenuItem;
    private JMenuItem rangeMinMenuItem;
    private JMenuItem rangeMaxMenuItem;
    private JMenuItem unitMenuItem;
    private JMenuItem displayUnitMenuItem;
    private JMenuItem standardUnitMenuItem;
    private JMenuItem labelMenuItem;
    private JMenuItem formatMenuItem;
    private JMenuItem descriptionMenuItem;
    private JTable selectedTable;
    private int[] selectedRows;
    private TaskAttributeNode[] source = null;

    DeviceAttributePanel() {
        this.setLayout(new BorderLayout());
        this.alarmModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceAttributePanel.this.source.length;
                    int n4 = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String string = (String)DeviceAttributePanel.this.alarmModel.getValueAt(n, 0);
                        Vector<String> vector = new Vector<String>();
                        switch (n2) {
                            case 1: {
                                vector.add("min_alarm");
                                break;
                            }
                            case 2: {
                                vector.add("max_alarm");
                                break;
                            }
                            case 3: {
                                vector.add("min_warning");
                                break;
                            }
                            case 4: {
                                vector.add("max_warning");
                                break;
                            }
                            case 5: {
                                vector.add("delta_t");
                                break;
                            }
                            case 6: {
                                vector.add("delta_val");
                            }
                        }
                        vector.add((String)object);
                        if (!MultiChangeConfirmDlg.confirmChange(vector, DeviceAttributePanel.this.source.length, " for attribute " + string)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/min_alarm", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setMinAlarm(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/max_alarm", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setMaxAlarm(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 3: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/min_warning", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setMinWarning(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 4: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/max_warning", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setMaxWarning(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 5: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/delta_t", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setDeltaT(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 6: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/delta_val", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setDeltaVal(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.alarmTable = new JTable(this.alarmModel);
        this.alarmTable.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.alarmTable);
        this.unitModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceAttributePanel.this.source.length;
                    int n4 = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String string = (String)DeviceAttributePanel.this.unitModel.getValueAt(n, 0);
                        Vector<String> vector = new Vector<String>();
                        switch (n2) {
                            case 1: {
                                vector.add("unit");
                                break;
                            }
                            case 2: {
                                vector.add("display_unit");
                                break;
                            }
                            case 3: {
                                vector.add("standard_unit");
                            }
                        }
                        vector.add((String)object);
                        if (!MultiChangeConfirmDlg.confirmChange(vector, DeviceAttributePanel.this.source.length, " for attribute " + string)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating unit");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/unit", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setUnit(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating unit");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/display_unit", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setDisplayUnit(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 3: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating unit");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/standard_unit", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setStandardUnit(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.unitTable = new JTable(this.unitModel);
        this.unitTable.addMouseListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.unitTable);
        this.rangeModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceAttributePanel.this.source.length;
                    int n4 = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String string = (String)DeviceAttributePanel.this.rangeModel.getValueAt(n, 0);
                        Vector<String> vector = new Vector<String>();
                        switch (n2) {
                            case 1: {
                                vector.add("min");
                                break;
                            }
                            case 2: {
                                vector.add("max");
                            }
                        }
                        vector.add((String)object);
                        if (!MultiChangeConfirmDlg.confirmChange(vector, DeviceAttributePanel.this.source.length, " for attribute " + string)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating range");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/min", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setMin(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating range");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/max", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setMax(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.rangeTable = new JTable(this.rangeModel);
        this.rangeTable.addMouseListener(this);
        JScrollPane jScrollPane3 = new JScrollPane(this.rangeTable);
        this.displayModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceAttributePanel.this.source.length;
                    int n4 = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String string = (String)DeviceAttributePanel.this.displayModel.getValueAt(n, 0);
                        Vector<String> vector = new Vector<String>();
                        switch (n2) {
                            case 1: {
                                vector.add("label");
                                break;
                            }
                            case 2: {
                                vector.add("format");
                            }
                        }
                        vector.add((String)object);
                        if (!MultiChangeConfirmDlg.confirmChange(vector, DeviceAttributePanel.this.source.length, " for attribute " + string)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating label");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/label", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setLabel(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating format");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/format", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setFormat(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.displayTable = new JTable(this.displayModel);
        this.displayTable.addMouseListener(this);
        JScrollPane jScrollPane4 = new JScrollPane(this.displayTable);
        this.descriptionModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceAttributePanel.this.source.length;
                    int n4 = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String string = (String)DeviceAttributePanel.this.descriptionModel.getValueAt(n, 0);
                        Vector<String> vector = new Vector<String>();
                        switch (n2) {
                            case 1: {
                                vector.add("description");
                            }
                        }
                        vector.add((String)object);
                        if (!MultiChangeConfirmDlg.confirmChange(vector, DeviceAttributePanel.this.source.length, " for attribute " + string)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating description");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/description", ++n4 * 100 / n3);
                                DeviceAttributePanel.this.source[i].setDescription(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.descriptionTable = new JTable(this.descriptionModel);
        this.descriptionTable.addMouseListener(this);
        JScrollPane jScrollPane5 = new JScrollPane(this.descriptionTable);
        this.aliasModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceAttributePanel.this.source.length;
                    boolean bl = false;
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                JiveUtils.showJiveError("Cannot apply attribute alias to multiple instance");
                            } else if (n3 == 1) {
                                DeviceAttributePanel.this.source[0].setAlias(n, (String)object);
                            }
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.aliasTable = new JTable(this.aliasModel);
        this.aliasTable.addMouseListener(this);
        JScrollPane jScrollPane6 = new JScrollPane(this.aliasTable);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(ATKConstant.labelFont);
        this.tabPane.add("Display", jScrollPane4);
        this.tabPane.add("Unit", jScrollPane2);
        this.tabPane.add("Range", jScrollPane3);
        this.tabPane.add("Alarms", jScrollPane);
        this.tabPane.add("Description", jScrollPane5);
        this.tabPane.add("Alias", jScrollPane6);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.tabPane.setBorder(titledBorder);
        this.add((Component)this.tabPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        jPanel.add(this.refreshButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        jPanel.add(this.applyButton);
        this.add((Component)jPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.resetMenuItem = new JMenuItem("Reset to default value");
        this.resetMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetMenuItem);
        this.resetLMenuItem = new JMenuItem("Return to lib default value");
        this.resetLMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetLMenuItem);
        this.resetULMenuItem = new JMenuItem("Return to code/lib default value");
        this.resetULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetULMenuItem);
        this.resetCULMenuItem = new JMenuItem("Return to class/code/lib default value");
        this.resetCULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetCULMenuItem);
        this.alarmMinMenuItem = new JMenuItem("Set min alarm");
        this.alarmMinMenuItem.addActionListener(this);
        this.tableMenu.add(this.alarmMinMenuItem);
        this.alarmMaxMenuItem = new JMenuItem("Set max alarm");
        this.alarmMaxMenuItem.addActionListener(this);
        this.tableMenu.add(this.alarmMaxMenuItem);
        this.warningMinMenuItem = new JMenuItem("Set min warning");
        this.warningMinMenuItem.addActionListener(this);
        this.tableMenu.add(this.warningMinMenuItem);
        this.warningMaxMenuItem = new JMenuItem("Set max warning");
        this.warningMaxMenuItem.addActionListener(this);
        this.tableMenu.add(this.warningMaxMenuItem);
        this.deltaTMenuItem = new JMenuItem("Set delta time");
        this.deltaTMenuItem.addActionListener(this);
        this.tableMenu.add(this.deltaTMenuItem);
        this.deltaValMenuItem = new JMenuItem("Set delta value");
        this.deltaValMenuItem.addActionListener(this);
        this.tableMenu.add(this.deltaValMenuItem);
        this.rangeMinMenuItem = new JMenuItem("Set min");
        this.rangeMinMenuItem.addActionListener(this);
        this.tableMenu.add(this.rangeMinMenuItem);
        this.rangeMaxMenuItem = new JMenuItem("Set max");
        this.rangeMaxMenuItem.addActionListener(this);
        this.tableMenu.add(this.rangeMaxMenuItem);
        this.unitMenuItem = new JMenuItem("Set unit");
        this.unitMenuItem.addActionListener(this);
        this.tableMenu.add(this.unitMenuItem);
        this.displayUnitMenuItem = new JMenuItem("Set display unit");
        this.displayUnitMenuItem.addActionListener(this);
        this.tableMenu.add(this.displayUnitMenuItem);
        this.standardUnitMenuItem = new JMenuItem("Set standard unit");
        this.standardUnitMenuItem.addActionListener(this);
        this.tableMenu.add(this.standardUnitMenuItem);
        this.labelMenuItem = new JMenuItem("Set label");
        this.labelMenuItem.addActionListener(this);
        this.tableMenu.add(this.labelMenuItem);
        this.formatMenuItem = new JMenuItem("Set format");
        this.formatMenuItem.addActionListener(this);
        this.tableMenu.add(this.formatMenuItem);
        this.descriptionMenuItem = new JMenuItem("Set description");
        this.descriptionMenuItem.addActionListener(this);
        this.tableMenu.add(this.descriptionMenuItem);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        this.selectedTable = (JTable)mouseEvent.getSource();
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 && !JiveUtils.readOnly && (n = this.getRowForLocation(mouseEvent.getY())) != -1) {
            this.selectedTable.addRowSelectionInterval(n, n);
            this.selectedTable.setColumnSelectionInterval(0, this.selectedTable.getColumnCount() - 1);
            this.selectedRows = this.selectedTable.getSelectedRows();
            this.alarmMinMenuItem.setVisible(false);
            this.alarmMaxMenuItem.setVisible(false);
            this.warningMinMenuItem.setVisible(false);
            this.warningMaxMenuItem.setVisible(false);
            this.deltaTMenuItem.setVisible(false);
            this.deltaValMenuItem.setVisible(false);
            this.rangeMinMenuItem.setVisible(false);
            this.rangeMaxMenuItem.setVisible(false);
            this.unitMenuItem.setVisible(false);
            this.displayUnitMenuItem.setVisible(false);
            this.standardUnitMenuItem.setVisible(false);
            this.labelMenuItem.setVisible(false);
            this.formatMenuItem.setVisible(false);
            this.descriptionMenuItem.setVisible(false);
            if (this.selectedTable == this.alarmTable) {
                this.alarmMinMenuItem.setVisible(true);
                this.alarmMaxMenuItem.setVisible(true);
                this.warningMinMenuItem.setVisible(true);
                this.warningMaxMenuItem.setVisible(true);
                this.deltaTMenuItem.setVisible(true);
                this.deltaValMenuItem.setVisible(true);
            } else if (this.selectedTable == this.unitTable) {
                this.unitMenuItem.setVisible(true);
                this.displayUnitMenuItem.setVisible(true);
                this.standardUnitMenuItem.setVisible(true);
            } else if (this.selectedTable == this.rangeTable) {
                this.rangeMinMenuItem.setVisible(true);
                this.rangeMaxMenuItem.setVisible(true);
            } else if (this.selectedTable == this.displayTable) {
                this.labelMenuItem.setVisible(true);
                this.formatMenuItem.setVisible(true);
            } else if (this.selectedTable == this.descriptionTable) {
                this.descriptionMenuItem.setVisible(true);
            }
            boolean bl = true;
            for (int i = 0; bl && i < this.source.length; ++i) {
                bl = this.source[i].isTango8();
            }
            if (bl) {
                this.resetLMenuItem.setVisible(true);
                this.resetULMenuItem.setVisible(true);
                this.resetCULMenuItem.setVisible(true);
            } else {
                this.resetLMenuItem.setVisible(false);
                this.resetULMenuItem.setVisible(false);
                this.resetCULMenuItem.setVisible(false);
            }
            this.tableMenu.show(this.selectedTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refreshValue();
        } else if (object == this.resetMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n2 = 0;
            if (this.selectedTable == this.alarmTable) {
                String string;
                int n3;
                if (this.source.length > 1 && (n3 = JOptionPane.showConfirmDialog(this, string = "You are going to reset alarm configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting alarms");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n3 = 0; n3 < this.selectedRows.length; ++n3) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[n3], 0), ++n2 * 100 / n);
                        this.source[i].resetAlarms(this.selectedRows[n3]);
                    }
                    this.source[i].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.unitTable) {
                String string;
                int n4;
                if (this.source.length > 1 && (n4 = JOptionPane.showConfirmDialog(this, string = "You are going to reset unit configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting units");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n4 = 0; n4 < this.selectedRows.length; ++n4) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[n4], 0), ++n2 * 100 / n);
                        this.source[i].resetUnit(this.selectedRows[n4]);
                    }
                    this.source[i].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.rangeTable) {
                String string;
                int n5;
                if (this.source.length > 1 && (n5 = JOptionPane.showConfirmDialog(this, string = "You are going to reset range configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting ranges");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n5 = 0; n5 < this.selectedRows.length; ++n5) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[n5], 0), ++n2 * 100 / n);
                        this.source[i].resetRange(this.selectedRows[n5]);
                    }
                    this.source[i].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.displayTable) {
                String string;
                int n6;
                if (this.source.length > 1 && (n6 = JOptionPane.showConfirmDialog(this, string = "You are going to reset display configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting display");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n6 = 0; n6 < this.selectedRows.length; ++n6) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[n6], 0), ++n2 * 100 / n);
                        this.source[i].resetDisplay(this.selectedRows[n6]);
                    }
                    this.source[i].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String string;
                int n7;
                if (this.source.length > 1 && (n7 = JOptionPane.showConfirmDialog(this, string = "You are going to reset description for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n7 = 0; n7 < this.selectedRows.length; ++n7) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[n7], 0), ++n2 * 100 / n);
                        this.source[i].resetDescription(this.selectedRows[n7]);
                    }
                    this.source[i].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.aliasTable) {
                String string;
                int n8;
                if (this.source.length > 1 && (n8 = JOptionPane.showConfirmDialog(this, string = "You are going to reset alias for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting alias");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n8 = 0; n8 < this.selectedRows.length; ++n8) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.aliasModel.getValueAt(this.selectedRows[n8], 0), ++n2 * 100 / n);
                        this.source[i].setAlias(this.selectedRows[n8], "");
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.resetLMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n9 = 0;
            if (this.selectedTable == this.alarmTable) {
                String string;
                int n10;
                if (this.source.length > 1 && (n10 = JOptionPane.showConfirmDialog(this, string = "You are going to reset alarm configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting alarms");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n10 = 0; n10 < this.selectedRows.length; ++n10) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[n10], 0), ++n9 * 100 / n);
                        this.source[i].resetLAlarms(this.selectedRows[n10]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.unitTable) {
                String string;
                int n11;
                if (this.source.length > 1 && (n11 = JOptionPane.showConfirmDialog(this, string = "You are going to reset unit configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting units");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n11 = 0; n11 < this.selectedRows.length; ++n11) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[n11], 0), ++n9 * 100 / n);
                        this.source[i].resetLUnit(this.selectedRows[n11]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.rangeTable) {
                String string;
                int n12;
                if (this.source.length > 1 && (n12 = JOptionPane.showConfirmDialog(this, string = "You are going to reset range configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting ranges");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n12 = 0; n12 < this.selectedRows.length; ++n12) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[n12], 0), ++n9 * 100 / n);
                        this.source[i].resetLRange(this.selectedRows[n12]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.displayTable) {
                String string;
                int n13;
                if (this.source.length > 1 && (n13 = JOptionPane.showConfirmDialog(this, string = "You are going to reset display configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting display");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n13 = 0; n13 < this.selectedRows.length; ++n13) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[n13], 0), ++n9 * 100 / n);
                        this.source[i].resetLDisplay(this.selectedRows[n13]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String string;
                int n14;
                if (this.source.length > 1 && (n14 = JOptionPane.showConfirmDialog(this, string = "You are going to reset description to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n14 = 0; n14 < this.selectedRows.length; ++n14) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[n14], 0), ++n9 * 100 / n);
                        this.source[i].resetLDescription(this.selectedRows[n14]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.resetULMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n15 = 0;
            if (this.selectedTable == this.alarmTable) {
                String string;
                int n16;
                if (this.source.length > 1 && (n16 = JOptionPane.showConfirmDialog(this, string = "You are going to reset alarm configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting alarms");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n16 = 0; n16 < this.selectedRows.length; ++n16) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[n16], 0), ++n15 * 100 / n);
                        this.source[i].resetULAlarms(this.selectedRows[n16]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.unitTable) {
                String string;
                int n17;
                if (this.source.length > 1 && (n17 = JOptionPane.showConfirmDialog(this, string = "You are going to reset unit configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting units");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n17 = 0; n17 < this.selectedRows.length; ++n17) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[n17], 0), ++n15 * 100 / n);
                        this.source[i].resetULUnit(this.selectedRows[n17]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.rangeTable) {
                String string;
                int n18;
                if (this.source.length > 1 && (n18 = JOptionPane.showConfirmDialog(this, string = "You are going to reset range configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting ranges");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n18 = 0; n18 < this.selectedRows.length; ++n18) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[n18], 0), ++n15 * 100 / n);
                        this.source[i].resetULRange(this.selectedRows[n18]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.displayTable) {
                String string;
                int n19;
                if (this.source.length > 1 && (n19 = JOptionPane.showConfirmDialog(this, string = "You are going to reset display configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting display");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n19 = 0; n19 < this.selectedRows.length; ++n19) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[n19], 0), ++n15 * 100 / n);
                        this.source[i].resetULDisplay(this.selectedRows[n19]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String string;
                int n20;
                if (this.source.length > 1 && (n20 = JOptionPane.showConfirmDialog(this, string = "You are going to reset description to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n20 = 0; n20 < this.selectedRows.length; ++n20) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[n20], 0), ++n15 * 100 / n);
                        this.source[i].resetULDescription(this.selectedRows[n20]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.resetCULMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n21 = 0;
            if (this.selectedTable == this.alarmTable) {
                String string;
                int n22;
                if (this.source.length > 1 && (n22 = JOptionPane.showConfirmDialog(this, string = "You are going to reset alarm configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting alarms");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n22 = 0; n22 < this.selectedRows.length; ++n22) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[n22], 0), ++n21 * 100 / n);
                        this.source[i].resetCULAlarms(this.selectedRows[n22]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.unitTable) {
                String string;
                int n23;
                if (this.source.length > 1 && (n23 = JOptionPane.showConfirmDialog(this, string = "You are going to reset unit configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting units");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n23 = 0; n23 < this.selectedRows.length; ++n23) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[n23], 0), ++n21 * 100 / n);
                        this.source[i].resetCULUnit(this.selectedRows[n23]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.rangeTable) {
                String string;
                int n24;
                if (this.source.length > 1 && (n24 = JOptionPane.showConfirmDialog(this, string = "You are going to reset range configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting ranges");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n24 = 0; n24 < this.selectedRows.length; ++n24) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[n24], 0), ++n21 * 100 / n);
                        this.source[i].resetCULRange(this.selectedRows[n24]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.displayTable) {
                String string;
                int n25;
                if (this.source.length > 1 && (n25 = JOptionPane.showConfirmDialog(this, string = "You are going to reset display configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting display");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n25 = 0; n25 < this.selectedRows.length; ++n25) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[n25], 0), ++n21 * 100 / n);
                        this.source[i].resetCULDisplay(this.selectedRows[n25]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String string;
                int n26;
                if (this.source.length > 1 && (n26 = JOptionPane.showConfirmDialog(this, string = "You are going to reset description to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (n > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    for (n26 = 0; n26 < this.selectedRows.length; ++n26) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[n26], 0), ++n21 * 100 / n);
                        this.source[i].resetCULDescription(this.selectedRows[n26]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (object == this.labelMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter label", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n27 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("label");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating label");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[j], 0), ++n27 * 100 / n);
                    this.source[i].setLabel(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.formatMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter format", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n28 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("format");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating format");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[j], 0), ++n28 * 100 / n);
                    this.source[i].setFormat(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.unitMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter unit", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n29 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("unit");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating unit");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[j], 0), ++n29 * 100 / n);
                    this.source[i].setUnit(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.displayUnitMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter display unit", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n30 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("display_unit");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating display unit");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[j], 0), ++n30 * 100 / n);
                    this.source[i].setDisplayUnit(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.standardUnitMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter standard unit", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n31 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("standard_unit");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating standard unit");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[j], 0), ++n31 * 100 / n);
                    this.source[i].setStandardUnit(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.rangeMinMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter min", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n32 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("min");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating min");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[j], 0), ++n32 * 100 / n);
                    this.source[i].setMin(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.rangeMaxMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter max", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n33 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("max");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating max");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[j], 0), ++n33 * 100 / n);
                    this.source[i].setMax(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.alarmMinMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter min alarm", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n34 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("min_alarm");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating min alarm");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[j], 0), ++n34 * 100 / n);
                    this.source[i].setMinAlarm(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.alarmMaxMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter max alarm", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n35 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("max_alarm");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating max alarm");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[j], 0), ++n35 * 100 / n);
                    this.source[i].setMaxAlarm(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.warningMinMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter min warning", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n36 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("min_warning");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating min warning");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[j], 0), ++n36 * 100 / n);
                    this.source[i].setMinWarning(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.warningMaxMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter max warning", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n37 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("max_warning");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating max warning");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[j], 0), ++n37 * 100 / n);
                    this.source[i].setMaxWarning(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.deltaTMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter delta T", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n38 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("delta_t");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating delta T");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[j], 0), ++n38 * 100 / n);
                    this.source[i].setDeltaT(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.deltaValMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter delta value", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n39 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("delta_val");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating delta value");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[j], 0), ++n39 * 100 / n);
                    this.source[i].setDeltaVal(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.descriptionMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter description", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n40 = 0;
            if (this.source.length > 1) {
                Vector<String> vector = new Vector<String>();
                vector.add("description");
                vector.add(string);
                if (!MultiChangeConfirmDlg.confirmChange(vector, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (n > 1) {
                ProgressFrame.displayProgress("Updating description");
            }
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[j], 0), ++n40 * 100 / n);
                    this.source[i].setDescription(this.selectedRows[j], string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.applyButton) {
            String string;
            if (this.alarmTable.isEditing()) {
                string = ((JTextField)this.alarmTable.getEditorComponent()).getText();
                this.alarmModel.setValueAt(string, this.alarmTable.getEditingRow(), this.alarmTable.getEditingColumn());
            }
            if (this.unitTable.isEditing()) {
                string = ((JTextField)this.unitTable.getEditorComponent()).getText();
                this.unitModel.setValueAt(string, this.unitTable.getEditingRow(), this.unitTable.getEditingColumn());
            }
            if (this.rangeTable.isEditing()) {
                string = ((JTextField)this.rangeTable.getEditorComponent()).getText();
                this.rangeModel.setValueAt(string, this.rangeTable.getEditingRow(), this.rangeTable.getEditingColumn());
            }
            if (this.displayTable.isEditing()) {
                string = ((JTextField)this.displayTable.getEditorComponent()).getText();
                this.displayModel.setValueAt(string, this.displayTable.getEditingRow(), this.displayTable.getEditingColumn());
            }
            if (this.descriptionTable.isEditing()) {
                string = ((JTextField)this.descriptionTable.getEditorComponent()).getText();
                this.descriptionModel.setValueAt(string, this.descriptionTable.getEditingRow(), this.descriptionTable.getEditingColumn());
            }
            if (this.aliasTable.isEditing()) {
                string = ((JTextField)this.aliasTable.getEditorComponent()).getText();
                this.aliasModel.setValueAt(string, this.aliasTable.getEditingRow(), this.aliasTable.getEditingColumn());
            }
        }
    }

    void setSource(TaskAttributeNode[] taskAttributeNodeArray) {
        this.source = taskAttributeNodeArray;
        this.refreshValue();
    }

    private int getRowForLocation(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.selectedTable.getRowCount() && !bl) {
            bl = n >= n3 && n <= n3 + this.selectedTable.getRowHeight(n2);
            if (bl) continue;
            n3 += this.selectedTable.getRowHeight(n2);
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    private void refreshValue() {
        if (this.source != null) {
            this.source[0].browseAttributeInfo();
            Object[] objectArray = new String[]{"Attribute name", "Min alarm", "Max alarm", "Min Warning", "Max Warning", "Delta t", "Delta val"};
            Object[][] objectArray2 = new Object[this.source[0].getAttributeNumber()][7];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray2[i][0] = this.source[0].getAttName(i);
                objectArray2[i][1] = this.source[0].getMinAlarm(i);
                objectArray2[i][2] = this.source[0].getMaxAlarm(i);
                objectArray2[i][3] = this.source[0].getMinWarning(i);
                objectArray2[i][4] = this.source[0].getMaxWarning(i);
                objectArray2[i][5] = this.source[0].getDeltaT(i);
                objectArray2[i][6] = this.source[0].getDeltaVal(i);
            }
            this.alarmModel.setDataVector(objectArray2, objectArray);
            this.alarmTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] objectArray3 = new String[]{"Attribute name", "Unit", "Display Unit", "Standard Unit"};
            Object[][] objectArray4 = new Object[this.source[0].getAttributeNumber()][4];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray4[i][0] = this.source[0].getAttName(i);
                objectArray4[i][1] = this.source[0].getUnit(i);
                objectArray4[i][2] = this.source[0].getDisplayUnit(i);
                objectArray4[i][3] = this.source[0].getStandardUnit(i);
            }
            this.unitModel.setDataVector(objectArray4, objectArray3);
            this.unitTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] objectArray5 = new String[]{"Attribute name", "Min value", "Max value"};
            Object[][] objectArray6 = new Object[this.source[0].getAttributeNumber()][3];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray6[i][0] = this.source[0].getAttName(i);
                objectArray6[i][1] = this.source[0].getMin(i);
                objectArray6[i][2] = this.source[0].getMax(i);
            }
            this.rangeModel.setDataVector(objectArray6, objectArray5);
            this.rangeTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] objectArray7 = new String[]{"Attribute name", "Label", "Format"};
            Object[][] objectArray8 = new Object[this.source[0].getAttributeNumber()][3];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray8[i][0] = this.source[0].getAttName(i);
                objectArray8[i][1] = this.source[0].getLabel(i);
                objectArray8[i][2] = this.source[0].getFormat(i);
            }
            this.displayModel.setDataVector(objectArray8, objectArray7);
            this.displayTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] objectArray9 = new String[]{"Attribute name", "Description"};
            Object[][] objectArray10 = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray10[i][0] = this.source[0].getAttName(i);
                objectArray10[i][1] = this.source[0].getDescription(i);
            }
            this.descriptionModel.setDataVector(objectArray10, objectArray9);
            this.descriptionTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            Object[] objectArray11 = new String[]{"Attribute name", "Alias"};
            Object[][] objectArray12 = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray10[i][0] = this.source[0].getAttName(i);
                objectArray10[i][1] = this.source[0].getAlias(i);
            }
            this.aliasModel.setDataVector(objectArray10, objectArray11);
            this.aliasTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            String string = this.source[0].getTitle();
            string = this.source.length == 1 ? string + " [" + this.source[0].getName() + "]" : string + " [" + this.source.length + " devices selected]";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.tabPane.setBorder(titledBorder);
        }
    }
}

