/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.MainPanel;

public class JiveTable
extends JTable {
    private MultiLineCellEditor editor = new MultiLineCellEditor(this);
    private MainPanel parent = null;

    public JiveTable(TableModel tableModel) {
        super(tableModel);
        this.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer(false, true, true);
        this.setDefaultRenderer(String.class, multiLineCellRenderer);
    }

    public void setParent(MainPanel mainPanel) {
        this.parent = mainPanel;
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        int n;
        MouseEvent mouseEvent;
        if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getButton() == 1 && mouseEvent.getID() == 501 && (n = this.getColumnForLocation(mouseEvent.getX())) == 1) {
            int n2 = this.getRowForLocation(mouseEvent.getY());
            String string = (String)this.getModel().getValueAt(n2, n);
            MultiLineCellRenderer multiLineCellRenderer = (MultiLineCellRenderer)this.getCellRenderer(n2, n);
            multiLineCellRenderer.setText(string);
            if (multiLineCellRenderer.hasDevice()) {
                int n3;
                Rectangle rectangle = this.getCellRect(n2, n, false);
                int n4 = mouseEvent.getX() - rectangle.x;
                String string2 = multiLineCellRenderer.getDevice(n4, n3 = mouseEvent.getY() - rectangle.y);
                if (string2 != null && this.parent != null) {
                    this.parent.goToDeviceNode(string2);
                    return;
                }
            }
        }
        super.processEvent(aWTEvent);
    }

    public MultiLineCellEditor getEditor() {
        return this.editor;
    }

    public void updateRows() {
        this.editor.updateRows();
    }

    public int getRowForLocation(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.getModel().getRowCount() && !bl) {
            bl = n >= n3 && n <= n3 + this.getRowHeight(n2);
            if (bl) continue;
            n3 += this.getRowHeight(n2);
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public int getColumnForLocation(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.getModel().getColumnCount() && !bl) {
            int n4 = this.getColumnModel().getColumn(n2).getWidth();
            bl = n >= n3 && n <= n3 + n4;
            if (bl) continue;
            n3 += n4;
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }
}

