/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jive.JiveUtils;
import jive3.ProgressFrame;
import jive3.TaskPollingNode;

public class DevicePollingPanel
extends JPanel
implements MouseListener,
ActionListener {
    private JTabbedPane tabPane;
    private JTable cmdTable;
    private DefaultTableModel cmdModel;
    private JTable attTable;
    private DefaultTableModel attModel;
    private JTable adminTable;
    private DefaultTableModel adminModel;
    private JButton refreshButton;
    private JButton applyButton;
    private JButton resetButton;
    private JPopupMenu tableMenu;
    private JMenuItem enablePollingMenuItem;
    private JMenuItem disablePollingMenuItem;
    private JMenuItem setPeriodMenuItem;
    private JTable selectedTable;
    private int[] selectedRows;
    private TaskPollingNode[] source = null;

    DevicePollingPanel() {
        this.setLayout(new BorderLayout());
        this.cmdModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                if (n == 1) {
                    return Boolean.class;
                }
                return String.class;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    String string = (String)DevicePollingPanel.this.cmdModel.getValueAt(n, 0);
                    boolean bl = (Boolean)DevicePollingPanel.this.cmdModel.getValueAt(n, 1);
                    String string2 = (String)DevicePollingPanel.this.cmdModel.getValueAt(n, 2);
                    if (n2 == 2) {
                        bl = true;
                    }
                    int n3 = DevicePollingPanel.this.source.length;
                    int n4 = 0;
                    if (n3 > 1) {
                        ProgressFrame.displayProgress("Updating polling");
                    }
                    for (int i = 0; i < DevicePollingPanel.this.source.length; ++i) {
                        ProgressFrame.setProgress("Updating " + DevicePollingPanel.this.source[i].getName() + "/" + string, ++n4 * 100 / n3);
                        DevicePollingPanel.this.source[i].updateCommandPolling(string, bl, string2);
                    }
                    ProgressFrame.hideProgress();
                    DevicePollingPanel.this.refreshValue();
                }
            }
        };
        this.cmdTable = new JTable(this.cmdModel);
        this.cmdTable.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.cmdTable);
        this.attModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                if (n == 1) {
                    return Boolean.class;
                }
                return String.class;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    String string = (String)DevicePollingPanel.this.attModel.getValueAt(n, 0);
                    boolean bl = (Boolean)DevicePollingPanel.this.attModel.getValueAt(n, 1);
                    String string2 = (String)DevicePollingPanel.this.attModel.getValueAt(n, 2);
                    if (n2 == 2) {
                        bl = true;
                    }
                    int n3 = DevicePollingPanel.this.source.length;
                    int n4 = 0;
                    if (n3 > 1) {
                        ProgressFrame.displayProgress("Updating polling");
                    }
                    for (int i = 0; i < DevicePollingPanel.this.source.length; ++i) {
                        ProgressFrame.setProgress("Updating " + DevicePollingPanel.this.source[i].getName() + "/" + string, ++n4 * 100 / n3);
                        DevicePollingPanel.this.source[i].updateAttributePolling(string, bl, string2);
                    }
                    ProgressFrame.hideProgress();
                    DevicePollingPanel.this.refreshValue();
                }
            }
        };
        this.attTable = new JTable(this.attModel);
        this.attTable.addMouseListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.attTable);
        this.adminModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DevicePollingPanel.this.source.length;
                    int n4 = 0;
                    if (n3 > 1) {
                        ProgressFrame.displayProgress("Updating polling");
                    }
                    if (n == 0) {
                        for (int i = 0; i < DevicePollingPanel.this.source.length; ++i) {
                            ProgressFrame.setProgress("Updating " + DevicePollingPanel.this.source[i].getName() + "/PollOldFactor", ++n4 * 100 / n3);
                            DevicePollingPanel.this.source[i].setPollOldFactor((String)object);
                        }
                    } else {
                        for (int i = 0; i < DevicePollingPanel.this.source.length; ++i) {
                            ProgressFrame.setProgress("Updating " + DevicePollingPanel.this.source[i].getName() + "/PollRingDepth", ++n4 * 100 / n3);
                            DevicePollingPanel.this.source[i].setPollRingDepth((String)object);
                        }
                    }
                    ProgressFrame.hideProgress();
                    DevicePollingPanel.this.refreshValue();
                }
            }
        };
        this.adminTable = new JTable(this.adminModel);
        this.adminTable.addMouseListener(this);
        JScrollPane jScrollPane3 = new JScrollPane(this.adminTable);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(ATKConstant.labelFont);
        this.tabPane.add("Command", jScrollPane);
        this.tabPane.add("Attribute", jScrollPane2);
        this.tabPane.add("Settings", jScrollPane3);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.tabPane.setBorder(titledBorder);
        this.add((Component)this.tabPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        jPanel.add(this.refreshButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        jPanel.add(this.applyButton);
        this.resetButton = new JButton("Reset");
        this.resetButton.setEnabled(!JiveUtils.readOnly);
        this.resetButton.addActionListener(this);
        jPanel.add(this.resetButton);
        this.add((Component)jPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.enablePollingMenuItem = new JMenuItem("Enable polling");
        this.enablePollingMenuItem.addActionListener(this);
        this.disablePollingMenuItem = new JMenuItem("Disable polling");
        this.disablePollingMenuItem.addActionListener(this);
        this.setPeriodMenuItem = new JMenuItem("Set period");
        this.setPeriodMenuItem.addActionListener(this);
        this.tableMenu.add(this.enablePollingMenuItem);
        this.tableMenu.add(this.disablePollingMenuItem);
        this.tableMenu.add(this.setPeriodMenuItem);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.selectedTable = (JTable)mouseEvent.getSource();
        if (!(mouseEvent.getButton() != 3 || mouseEvent.getClickCount() != 1 || JiveUtils.readOnly || this.selectedTable != this.attTable && this.selectedTable != this.cmdTable || (n = this.getRowForLocation(mouseEvent.getY())) == -1)) {
            this.selectedTable.addRowSelectionInterval(n, n);
            this.selectedTable.setColumnSelectionInterval(0, 1);
            this.selectedRows = this.selectedTable.getSelectedRows();
            this.tableMenu.show(this.selectedTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refreshValue();
        } else if (object == this.applyButton) {
            String string;
            if (this.cmdTable.isEditing()) {
                string = ((JTextField)this.cmdTable.getEditorComponent()).getText();
                this.cmdModel.setValueAt(string, this.cmdTable.getEditingRow(), this.cmdTable.getEditingColumn());
            }
            if (this.attTable.isEditing()) {
                string = ((JTextField)this.attTable.getEditorComponent()).getText();
                this.attModel.setValueAt(string, this.attTable.getEditingRow(), this.attTable.getEditingColumn());
            }
            if (this.adminTable.isEditing()) {
                string = ((JTextField)this.adminTable.getEditorComponent()).getText();
                this.adminModel.setValueAt(string, this.adminTable.getEditingRow(), this.adminTable.getEditingColumn());
            }
        } else if (object == this.resetButton) {
            int n = JOptionPane.showConfirmDialog(null, "This will reset polling configuration for all\nattributes and commands.\nReset configuration ?", "Confirm reset", 0);
            if (n == 0) {
                int n2 = this.source.length;
                int n3 = 0;
                if (n2 > 1) {
                    ProgressFrame.displayProgress("Reseting config");
                }
                for (int i = 0; i < this.source.length; ++i) {
                    ProgressFrame.setProgress("Reseting " + this.source[i].getName(), ++n3 * 100 / n2);
                    this.source[i].resetConfig();
                }
                ProgressFrame.hideProgress();
                JOptionPane.showMessageDialog(null, "The polling configuration has been succesfully reset.\nThe server needs to be restarted to take change into account.");
            }
        } else if (object == this.enablePollingMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n4 = 0;
            if (n > 1) {
                ProgressFrame.displayProgress("Enabling polling");
            }
            TableModel tableModel = this.selectedTable.getModel();
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Enabling " + this.source[i].getName() + "/" + tableModel.getValueAt(this.selectedRows[j], 0), ++n4 * 100 / n);
                    if (this.selectedTable == this.attTable) {
                        this.source[i].updateAttributePolling((String)tableModel.getValueAt(this.selectedRows[j], 0), true, (String)tableModel.getValueAt(this.selectedRows[j], 2));
                        continue;
                    }
                    if (this.selectedTable != this.cmdTable) continue;
                    this.source[i].updateCommandPolling((String)tableModel.getValueAt(this.selectedRows[j], 0), true, (String)tableModel.getValueAt(this.selectedRows[j], 2));
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.disablePollingMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n5 = 0;
            if (n > 1) {
                ProgressFrame.displayProgress("Disabling polling");
            }
            TableModel tableModel = this.selectedTable.getModel();
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Disabling " + this.source[i].getName() + "/" + tableModel.getValueAt(this.selectedRows[j], 0), ++n5 * 100 / n);
                    if (this.selectedTable == this.attTable) {
                        this.source[i].updateAttributePolling((String)tableModel.getValueAt(this.selectedRows[j], 0), false, (String)tableModel.getValueAt(this.selectedRows[j], 2));
                        continue;
                    }
                    if (this.selectedTable != this.cmdTable) continue;
                    this.source[i].updateCommandPolling((String)tableModel.getValueAt(this.selectedRows[j], 0), false, (String)tableModel.getValueAt(this.selectedRows[j], 2));
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.setPeriodMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter polling period (ms)", "3000");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n6 = 0;
            if (n > 1) {
                ProgressFrame.displayProgress("Updating polling period");
            }
            TableModel tableModel = this.selectedTable.getModel();
            for (int i = 0; i < this.source.length; ++i) {
                for (int j = 0; j < this.selectedRows.length; ++j) {
                    ProgressFrame.setProgress("Setting " + this.source[i].getName() + "/" + tableModel.getValueAt(this.selectedRows[j], 0), ++n6 * 100 / n);
                    if (this.selectedTable == this.attTable) {
                        this.source[i].updateAttributePolling((String)tableModel.getValueAt(this.selectedRows[j], 0), true, string);
                        continue;
                    }
                    if (this.selectedTable != this.cmdTable) continue;
                    this.source[i].updateCommandPolling((String)tableModel.getValueAt(this.selectedRows[j], 0), true, string);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        }
    }

    void setSource(TaskPollingNode[] taskPollingNodeArray) {
        this.source = taskPollingNodeArray;
        this.refreshValue();
    }

    private int getRowForLocation(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.selectedTable.getRowCount() && !bl) {
            bl = n >= n3 && n <= n3 + this.selectedTable.getRowHeight(n2);
            if (bl) continue;
            n3 += this.selectedTable.getRowHeight(n2);
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    private void refreshValue() {
        if (this.source != null) {
            this.source[0].browsePollingStatus();
            Object[] objectArray = new String[]{"Command name", "Polled", "Period (ms)"};
            Object[][] objectArray2 = new Object[this.source[0].getCommandNumber()][3];
            for (int i = 0; i < this.source[0].getCommandNumber(); ++i) {
                objectArray2[i][0] = this.source[0].getCommandName(i);
                objectArray2[i][1] = new Boolean(this.source[0].isCommandPolled(i));
                objectArray2[i][2] = this.source[0].getCommandPollingPeriod(i);
            }
            this.cmdModel.setDataVector(objectArray2, objectArray);
            this.cmdTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] objectArray3 = new String[]{"Attribute name", "Polled", "Period (ms)"};
            Object[][] objectArray4 = new Object[this.source[0].getAttributeNumber()][3];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray4[i][0] = this.source[0].getAttributeName(i);
                objectArray4[i][1] = new Boolean(this.source[0].isAttributePolled(i));
                objectArray4[i][2] = this.source[0].getAttributePollingPeriod(i);
            }
            this.attModel.setDataVector(objectArray4, objectArray3);
            this.attTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] objectArray5 = new String[]{"Parameters name", "Value"};
            Object[][] objectArray6 = new Object[2][2];
            objectArray6[0][0] = "Poll old factor";
            objectArray6[0][1] = this.source[0].getPollOldFactor();
            objectArray6[1][0] = "Poll ring depth";
            objectArray6[1][1] = this.source[0].getPollRingDepth();
            this.adminModel.setDataVector(objectArray6, objectArray5);
            this.adminTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            String string = this.source[0].getTitle();
            string = this.source.length == 1 ? string + " [" + this.source[0].getName() + "]" : string + " [" + this.source.length + " devices selected]";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.tabPane.setBorder(titledBorder);
        }
    }
}

