/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jive.DevWizard;
import jive.JiveUtils;
import jive.MultiLineToolTipUI;
import jive.ServerDlg;
import jive.TangoFileReader;
import jive3.DefaultPanel;
import jive3.DeviceAttributePanel;
import jive3.DeviceEventPanel;
import jive3.DeviceLoggingPanel;
import jive3.DevicePollingPanel;
import jive3.DiffDlg;
import jive3.FilterDlg;
import jive3.ProgressFrame;
import jive3.PropertyHistoryDlg;
import jive3.PropertyNode;
import jive3.PropertyPanel;
import jive3.ResDlg;
import jive3.SingleAttributePanel;
import jive3.TangoNode;
import jive3.TaskAttributeNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPollingNode;
import jive3.TaskSingleAttributeNode;
import jive3.TreePanelAlias;
import jive3.TreePanelAttributeAlias;
import jive3.TreePanelClass;
import jive3.TreePanelDevice;
import jive3.TreePanelFreeProperty;
import jive3.TreePanelServer;

public class MainPanel
extends JFrame
implements ChangeListener {
    private Database db;
    JTabbedPane treePane;
    JSplitPane splitPane;
    JPanel lockPanel;
    TreePanelServer serverTreePanel = null;
    TreePanelDevice deviceTreePanel = null;
    TreePanelClass classTreePanel = null;
    TreePanelAlias aliasTreePanel = null;
    TreePanelAttributeAlias attributeAliasTreePanel = null;
    TreePanelFreeProperty propertyTreePanel = null;
    DefaultPanel defaultPanel;
    PropertyPanel propertyPanel;
    DevicePollingPanel devicePollingPanel;
    DeviceEventPanel deviceEventPanel;
    DeviceAttributePanel deviceAttributePanel;
    DeviceLoggingPanel deviceLoggingPanel;
    SingleAttributePanel singleAttributePanel;
    PropertyHistoryDlg historyDlg;
    FilterDlg filterDlg = null;
    private String lastResOpenedDir = ".";
    private boolean running_from_shell;
    private static final String appVersion = "Jive 4.35 ";

    public MainPanel() {
        this(false, false);
    }

    public MainPanel(boolean bl, boolean bl2) {
        this.running_from_shell = bl;
        JiveUtils.readOnly = bl2;
        this.initComponents();
        this.centerWindow();
        this.setVisible(true);
        JiveUtils.parent = this;
    }

    private void initComponents() {
        JMenuItem jMenuItem;
        JComponent jComponent;
        JComponent jComponent2;
        this.getContentPane().setLayout(new BorderLayout());
        MultiLineToolTipUI.initialize();
        String string = null;
        try {
            string = ApiUtil.getTangoHost();
        }
        catch (DevFailed devFailed) {
            System.out.println("TANGO_HOST no defined, exiting...");
            this.exitForm();
        }
        try {
            this.db = ApiUtil.get_db_obj();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            this.db = null;
        }
        this.updateTitle(string);
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(1);
        this.serverTreePanel = new TreePanelServer(this);
        this.serverTreePanel.setDatabase(this.db);
        this.deviceTreePanel = new TreePanelDevice(this);
        this.deviceTreePanel.setDatabase(this.db);
        this.classTreePanel = new TreePanelClass(this);
        this.classTreePanel.setDatabase(this.db);
        this.aliasTreePanel = new TreePanelAlias(this);
        this.aliasTreePanel.setDatabase(this.db);
        this.attributeAliasTreePanel = new TreePanelAttributeAlias(this);
        this.attributeAliasTreePanel.setDatabase(this.db);
        this.propertyTreePanel = new TreePanelFreeProperty(this);
        this.propertyTreePanel.setDatabase(this.db);
        this.historyDlg = new PropertyHistoryDlg();
        this.historyDlg.setDatabase(this.db, string);
        this.treePane = new JTabbedPane();
        this.treePane.setMinimumSize(new Dimension(365, 0));
        this.treePane.setFont(ATKConstant.labelFont);
        this.treePane.add("Server", this.serverTreePanel);
        this.treePane.add("Device", this.deviceTreePanel);
        this.treePane.add("Class", this.classTreePanel);
        this.treePane.add("Alias", this.aliasTreePanel);
        this.treePane.add("Att. Alias", this.attributeAliasTreePanel);
        this.treePane.add("Property", this.propertyTreePanel);
        this.treePane.addChangeListener(this);
        this.splitPane.setLeftComponent(this.treePane);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.defaultPanel = new DefaultPanel();
        this.propertyPanel = new PropertyPanel();
        this.propertyPanel.setParent(this);
        this.devicePollingPanel = new DevicePollingPanel();
        this.deviceEventPanel = new DeviceEventPanel();
        this.deviceAttributePanel = new DeviceAttributePanel();
        this.deviceLoggingPanel = new DeviceLoggingPanel();
        this.singleAttributePanel = new SingleAttributePanel();
        this.splitPane.setRightComponent(this.defaultPanel);
        if (JiveUtils.readOnly) {
            this.lockPanel = new JPanel();
            this.lockPanel.setLayout(new FlowLayout(0));
            this.lockPanel.setBackground(new Color(233, 233, 233));
            jComponent2 = new JLabel();
            ((JLabel)jComponent2).setIcon(new ImageIcon(this.getClass().getResource("/jive/lock.gif")));
            this.lockPanel.add(jComponent2);
            jComponent = new JLabel("Read only mode (No write access to database allowed)");
            jComponent.setFont(ATKConstant.labelFont);
            this.lockPanel.add(jComponent);
            this.getContentPane().add((Component)this.lockPanel, "North");
        }
        jComponent2 = new JMenuBar();
        jComponent = new JMenu("File");
        JMenuItem jMenuItem2 = new JMenuItem("Load property file");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.loadPropFile();
            }
        });
        jMenuItem2.setEnabled(!JiveUtils.readOnly);
        JMenuItem jMenuItem3 = new JMenuItem("Check property file");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.checkPropFile();
            }
        });
        JSeparator jSeparator = new JSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Exit");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.exitForm();
            }
        });
        ((JMenu)jComponent).add(jMenuItem2);
        ((JMenu)jComponent).add(jMenuItem3);
        ((JMenu)jComponent).add(jSeparator);
        ((JMenu)jComponent).add(jMenuItem4);
        ((JMenuBar)jComponent2).add((JMenu)jComponent);
        JMenu jMenu = new JMenu("Edit");
        JMenuItem jMenuItem5 = new JMenuItem("Refresh Tree");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.refreshTree();
            }
        });
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenu.add(jMenuItem5);
        jMenu.add(new JSeparator());
        if (this.running_from_shell) {
            jMenuItem = new JMenuItem("Change Tango Host");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainPanel.this.changeTangoHost();
                }
            });
            jMenu.add(jMenuItem);
            jMenu.add(new JSeparator());
        }
        jMenuItem = new JMenuItem("Create server");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.createServer();
            }
        });
        jMenuItem.setEnabled(!JiveUtils.readOnly);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem6 = new JMenuItem("Create free property");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.createFreeProperty();
            }
        });
        jMenuItem6.setEnabled(!JiveUtils.readOnly);
        jMenu.add(jMenuItem6);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem7 = new JMenuItem("Show clipboard");
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.showClipboard();
            }
        });
        jMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Clear clipboard");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JiveUtils.the_clipboard.clear();
            }
        });
        jMenu.add(jMenuItem8);
        JMenu jMenu2 = new JMenu("Tools");
        JMenuItem jMenuItem9 = new JMenuItem("Server Wizard");
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.createServerWz();
            }
        });
        jMenuItem9.setEnabled(!JiveUtils.readOnly);
        jMenu2.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem("Database Info");
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.showDatabaseInfo();
            }
        });
        jMenu2.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem("Database history");
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.showHistory();
            }
        });
        jMenu2.add(jMenuItem11);
        JMenu jMenu3 = new JMenu("Filter");
        JMenuItem jMenuItem12 = new JMenuItem("Server");
        jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.filterServer();
            }
        });
        jMenu3.add(jMenuItem12);
        JMenuItem jMenuItem13 = new JMenuItem("Device");
        jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.filterDevice();
            }
        });
        jMenu3.add(jMenuItem13);
        JMenuItem jMenuItem14 = new JMenuItem("Class");
        jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.filterClass();
            }
        });
        jMenu3.add(jMenuItem14);
        JMenuItem jMenuItem15 = new JMenuItem("Alias");
        jMenuItem15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.filterAlias();
            }
        });
        jMenu3.add(jMenuItem15);
        JMenuItem jMenuItem16 = new JMenuItem("Att. Alias");
        jMenuItem16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.filterAttributeAlias();
            }
        });
        jMenu3.add(jMenuItem16);
        JMenuItem jMenuItem17 = new JMenuItem("Property");
        jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.filterProperty();
            }
        });
        jMenu3.add(jMenuItem17);
        ((JMenuBar)jComponent2).add((JMenu)jComponent);
        ((JMenuBar)jComponent2).add(jMenu);
        ((JMenuBar)jComponent2).add(jMenu2);
        ((JMenuBar)jComponent2).add(jMenu3);
        this.setJMenuBar((JMenuBar)jComponent2);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                MainPanel.this.exitForm();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/jive/jive.jpg"));
        this.setIconImage(imageIcon.getImage());
    }

    public void showClipboard() {
        JiveUtils.the_clipboard.show(this);
    }

    private void createFreeProperty() {
        String string = JOptionPane.showInputDialog(this, "Enter property object name", "Jive", 3);
        if (string != null) {
            this.propertyTreePanel.addProperty(string);
            this.treePane.setSelectedComponent(this.propertyTreePanel);
            this.propertyTreePanel.setVisible(true);
        }
    }

    private void createServer() {
        ServerDlg serverDlg = new ServerDlg(this);
        serverDlg.setValidFields(true, true);
        serverDlg.setDefaults("", "");
        if (serverDlg.showDlg()) {
            String[] stringArray = serverDlg.getDeviceNames();
            String string = serverDlg.getServerName();
            String string2 = serverDlg.getClassName();
            try {
                int n;
                Vector<String> vector = new Vector<String>();
                for (n = 0; n < stringArray.length; ++n) {
                    try {
                        this.db.import_device(stringArray[n]);
                    }
                    catch (DevFailed devFailed) {
                        continue;
                    }
                    vector.add(stringArray[n]);
                }
                if (vector.size() > 0) {
                    String string3 = "Warning, following device(s) already declared:\n";
                    for (int i = 0; i < vector.size(); ++i) {
                        string3 = string3 + "   " + vector.get(i) + "\n";
                    }
                    if (JOptionPane.showConfirmDialog(this, string3 = string3 + "Do you want to continue ?", "Confirmation", 0) != 0) {
                        return;
                    }
                }
                for (n = 0; n < stringArray.length; ++n) {
                    this.db.add_device(stringArray[n], string2, string);
                }
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
            this.refreshTree();
            this.serverTreePanel.selectServer(string);
        }
    }

    private void filterServer() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Server filter");
        this.filterDlg.setFilter(this.serverTreePanel.getFilter());
        if (this.filterDlg.showDialog()) {
            this.serverTreePanel.applyFilter(this.filterDlg.getFilterText());
            this.serverTreePanel.refresh();
        }
    }

    private void filterDevice() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Device filter");
        this.filterDlg.setFilter(this.deviceTreePanel.getFilter());
        if (this.filterDlg.showDialog()) {
            this.deviceTreePanel.applyFilter(this.filterDlg.getFilterText());
            this.deviceTreePanel.refresh();
        }
    }

    private void filterClass() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Class filter");
        this.filterDlg.setFilter(this.classTreePanel.getFilter());
        if (this.filterDlg.showDialog()) {
            this.classTreePanel.applyFilter(this.filterDlg.getFilterText());
            this.classTreePanel.refresh();
        }
    }

    private void filterAlias() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Alias filter");
        this.filterDlg.setFilter(this.aliasTreePanel.getFilter());
        if (this.filterDlg.showDialog()) {
            this.aliasTreePanel.applyFilter(this.filterDlg.getFilterText());
            this.aliasTreePanel.refresh();
        }
    }

    private void filterAttributeAlias() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Att. Alias filter");
        this.filterDlg.setFilter(this.attributeAliasTreePanel.getFilter());
        if (this.filterDlg.showDialog()) {
            this.attributeAliasTreePanel.applyFilter(this.filterDlg.getFilterText());
            this.attributeAliasTreePanel.refresh();
        }
    }

    private void filterProperty() {
        if (this.filterDlg == null) {
            this.filterDlg = new FilterDlg(this);
        }
        this.filterDlg.setLabelName("Property filter");
        this.filterDlg.setFilter(this.propertyTreePanel.getFilter());
        if (this.filterDlg.showDialog()) {
            this.propertyTreePanel.applyFilter(this.filterDlg.getFilterText());
            this.propertyTreePanel.refresh();
        }
    }

    private void createServerWz() {
        DevWizard devWizard = new DevWizard(this);
        devWizard.showWizard(null);
        this.refreshTree();
    }

    private void updateTitle(String string) {
        String string2 = new String(appVersion);
        if (JiveUtils.readOnly) {
            string2 = string2 + "(Read Only)";
        }
        if (this.db == null) {
            this.setTitle(string2 + " [No connection]");
        } else {
            this.setTitle(string2 + " [" + string + "]");
        }
    }

    private void changeTangoHost() {
        String string = JOptionPane.showInputDialog(this, "Enter tango host (ex gizmo:20000)", "Jive", 3);
        if (string != null) {
            String[] stringArray = string.split(":");
            if (stringArray.length != 2) {
                JiveUtils.showJiveError("Invalid tango host syntax: should be host:port");
                return;
            }
            try {
                Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                JiveUtils.showJiveError("Invalid tango host port number\n" + numberFormatException.getMessage());
                return;
            }
            try {
                this.db = ApiUtil.change_db_obj((String)stringArray[0], (String)stringArray[1]);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
                this.db = null;
            }
            catch (Exception exception) {
                JiveUtils.showJiveError(exception.getMessage());
                this.db = null;
            }
            ProgressFrame.displayProgress("Refresh in progress");
            this.serverTreePanel.setDatabase(this.db);
            ProgressFrame.setProgress("Refreshing...", 20);
            this.deviceTreePanel.setDatabase(this.db);
            ProgressFrame.setProgress("Refreshing...", 40);
            this.classTreePanel.setDatabase(this.db);
            ProgressFrame.setProgress("Refreshing...", 60);
            this.aliasTreePanel.setDatabase(this.db);
            this.attributeAliasTreePanel.setDatabase(this.db);
            ProgressFrame.setProgress("Refreshing...", 80);
            this.propertyTreePanel.setDatabase(this.db);
            ProgressFrame.setProgress("Refreshing...", 100);
            this.historyDlg.setDatabase(this.db, string);
            this.updateTitle(string);
            this.defaultPanel.setSource(null);
            this.splitPane.setRightComponent(this.defaultPanel);
            ProgressFrame.hideProgress();
        }
    }

    private void refreshTree() {
        ProgressFrame.displayProgress("Refresh in progress");
        this.serverTreePanel.refresh();
        ProgressFrame.setProgress("Refreshing...", 20);
        this.deviceTreePanel.refresh();
        ProgressFrame.setProgress("Refreshing...", 40);
        this.classTreePanel.refresh();
        ProgressFrame.setProgress("Refreshing...", 60);
        this.aliasTreePanel.refresh();
        this.attributeAliasTreePanel.refresh();
        ProgressFrame.setProgress("Refreshing...", 70);
        this.attributeAliasTreePanel.refresh();
        ProgressFrame.setProgress("Refreshing...", 80);
        this.propertyTreePanel.refresh();
        this.updateTabbedPane();
        ProgressFrame.hideProgress();
    }

    private void loadPropFile() {
        File file;
        ResDlg resDlg;
        String string = "";
        TangoFileReader tangoFileReader = new TangoFileReader(this.db);
        JFileChooser jFileChooser = new JFileChooser(this.lastResOpenedDir);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (resDlg = new ResDlg(this, (file = jFileChooser.getSelectedFile()).getAbsolutePath())).showDlg()) {
            if (file != null) {
                string = tangoFileReader.parse_res_file(file.getAbsolutePath());
            }
            if (string.length() > 0) {
                JiveUtils.showJiveError(string);
            }
            if (file != null) {
                this.lastResOpenedDir = file.getAbsolutePath();
            }
        }
    }

    private void checkPropFile() {
        File file;
        String string = "";
        TangoFileReader tangoFileReader = new TangoFileReader(this.db);
        JFileChooser jFileChooser = new JFileChooser(this.lastResOpenedDir);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            Vector vector = new Vector();
            string = tangoFileReader.check_res_file(file.getAbsolutePath(), vector);
            this.lastResOpenedDir = file.getAbsolutePath();
            if (string.length() > 0) {
                JiveUtils.showJiveError(string);
            } else if (vector.size() > 0) {
                DiffDlg diffDlg = new DiffDlg(vector, file.getAbsolutePath());
                ATKGraphicsUtils.centerFrameOnScreen((Frame)diffDlg);
                diffDlg.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "Database and file match.");
            }
        }
    }

    private void showDatabaseInfo() {
        if (this.db == null) {
            return;
        }
        try {
            String string = this.db.get_info();
            JOptionPane.showMessageDialog(this, string, "Database Info", 1);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public void showHistory() {
        if (!this.historyDlg.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen((Frame)this.historyDlg);
        }
        this.historyDlg.setVisible(true);
    }

    public void goToDeviceNode(String string) {
        this.deviceTreePanel.selectDevice(string);
        this.treePane.setSelectedComponent(this.deviceTreePanel);
        this.treePane.getSelectedComponent().setVisible(true);
    }

    public void goToServerNode(String string) {
        this.serverTreePanel.selectServer(string);
        this.treePane.setSelectedComponent(this.serverTreePanel);
        this.treePane.getSelectedComponent().setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateTabbedPane();
    }

    private void updateTabbedPane() {
        switch (this.treePane.getSelectedIndex()) {
            case 0: {
                this.serverTreePanel.refreshValues();
                break;
            }
            case 1: {
                this.deviceTreePanel.refreshValues();
                break;
            }
            case 2: {
                this.classTreePanel.refreshValues();
                break;
            }
            case 3: {
                this.aliasTreePanel.refreshValues();
                break;
            }
            case 4: {
                this.attributeAliasTreePanel.refreshValues();
                break;
            }
            case 5: {
                this.propertyTreePanel.refreshValues();
            }
        }
    }

    void updatePanel(TangoNode[] tangoNodeArray) {
        TangoNode[] tangoNodeArray2;
        int n;
        Serializable serializable;
        try {
            Component component = this.splitPane.getRightComponent();
            if (component instanceof PropertyPanel && ((PropertyPanel)(serializable = (PropertyPanel)component)).hasChanged() && JOptionPane.showConfirmDialog(this, "Some properties has been updated and not saved.\nWould you like to save change ?", "Confirmation", 0) == 0) {
                ((PropertyPanel)serializable).saveChange();
            }
            if (component instanceof SingleAttributePanel && ((SingleAttributePanel)(serializable = (SingleAttributePanel)component)).hasChanged() && JOptionPane.showConfirmDialog(this, "Some attribute properties has been updated and not saved.\nWould you like to save change ?", "Confirmation", 0) == 0) {
                ((SingleAttributePanel)serializable).saveChange();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tangoNodeArray == null || tangoNodeArray.length == 0) {
            this.defaultPanel.setSource(null);
            this.splitPane.setRightComponent(this.defaultPanel);
            return;
        }
        boolean bl = true;
        serializable = tangoNodeArray[0].getClass();
        for (n = 1; bl && n < tangoNodeArray.length; ++n) {
            bl = tangoNodeArray[n].getClass() == serializable;
        }
        if (!bl) {
            tangoNodeArray2 = new TangoNode[]{tangoNodeArray[0]};
            tangoNodeArray = tangoNodeArray2;
        }
        if (tangoNodeArray[0] instanceof PropertyNode) {
            tangoNodeArray2 = new PropertyNode[tangoNodeArray.length];
            for (n = 0; n < tangoNodeArray.length; ++n) {
                tangoNodeArray2[n] = (PropertyNode)tangoNodeArray[n];
            }
            this.propertyPanel.setSource((PropertyNode[])tangoNodeArray2);
            this.splitPane.setRightComponent(this.propertyPanel);
        } else if (serializable == TaskPollingNode.class) {
            tangoNodeArray2 = new TaskPollingNode[tangoNodeArray.length];
            for (n = 0; n < tangoNodeArray.length; ++n) {
                tangoNodeArray2[n] = (TaskPollingNode)tangoNodeArray[n];
            }
            this.devicePollingPanel.setSource((TaskPollingNode[])tangoNodeArray2);
            this.splitPane.setRightComponent(this.devicePollingPanel);
        } else if (serializable == TaskEventNode.class) {
            tangoNodeArray2 = new TaskEventNode[tangoNodeArray.length];
            for (n = 0; n < tangoNodeArray.length; ++n) {
                tangoNodeArray2[n] = (TaskEventNode)tangoNodeArray[n];
            }
            this.deviceEventPanel.setSource((TaskEventNode[])tangoNodeArray2);
            this.splitPane.setRightComponent(this.deviceEventPanel);
        } else if (serializable == TaskAttributeNode.class) {
            tangoNodeArray2 = new TaskAttributeNode[tangoNodeArray.length];
            for (n = 0; n < tangoNodeArray.length; ++n) {
                tangoNodeArray2[n] = (TaskAttributeNode)tangoNodeArray[n];
            }
            this.deviceAttributePanel.setSource((TaskAttributeNode[])tangoNodeArray2);
            this.splitPane.setRightComponent(this.deviceAttributePanel);
        } else if (serializable == TaskLoggingNode.class) {
            tangoNodeArray2 = new TaskLoggingNode[tangoNodeArray.length];
            for (n = 0; n < tangoNodeArray.length; ++n) {
                tangoNodeArray2[n] = (TaskLoggingNode)tangoNodeArray[n];
            }
            this.deviceLoggingPanel.setSource((TaskLoggingNode[])tangoNodeArray2);
            this.splitPane.setRightComponent(this.deviceLoggingPanel);
        } else if (serializable == TaskSingleAttributeNode.class) {
            tangoNodeArray2 = new TaskSingleAttributeNode[tangoNodeArray.length];
            for (n = 0; n < tangoNodeArray.length; ++n) {
                tangoNodeArray2[n] = (TaskSingleAttributeNode)tangoNodeArray[n];
            }
            this.singleAttributePanel.setSource((TaskSingleAttributeNode[])tangoNodeArray2);
            this.splitPane.setRightComponent(this.singleAttributePanel);
        } else {
            this.defaultPanel.setSource(tangoNodeArray[0]);
            this.splitPane.setRightComponent(this.defaultPanel);
        }
    }

    private void exitForm() {
        if (this.running_from_shell) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = new Dimension(830, 500);
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setBounds(n, n2, dimension2.width, dimension2.height);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            new MainPanel(true, false);
        } else if (stringArray[0].equalsIgnoreCase("-r")) {
            new MainPanel(true, true);
        } else {
            System.out.println("Usage: jive [-r]");
            System.out.println("   -r  Read only mode (No write access to database allowed)");
        }
    }
}

