/*
 * Decompiled with CFR 0.152.
 */
package jive;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class MultiLineToolTipUI
extends ToolTipUI {
    static MultiLineToolTipUI singleton = new MultiLineToolTipUI();
    private static int inset = 3;
    private static int accelerator_offset = 15;

    private MultiLineToolTipUI() {
    }

    public static void initialize() {
        String string = "ToolTipUI";
        Class<?> clazz = singleton.getClass();
        String string2 = clazz.getName();
        UIManager.put(string, string2);
        UIManager.put(string2, clazz);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return singleton;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(jComponent, "ToolTip.border");
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = jComponent.getSize();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getAscent();
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("\n");
        int n3 = stringArray.length;
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(jComponent.getForeground());
        int n4 = 0;
        int n5 = 2 + n2;
        while (n4 < n3) {
            String string2;
            graphics.drawString(stringArray[n4], inset, n5);
            if (n4 == n3 - 1 && !(string2 = this.getAcceleratorString((JToolTip)jComponent)).equals("")) {
                Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                graphics.setFont(font2);
                graphics.drawString(string2, fontMetrics.stringWidth(stringArray[n4]) + accelerator_offset, n5);
            }
            ++n4;
            n5 += n;
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.getHeight();
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            return new Dimension(6, 6);
        }
        String[] stringArray = string.split("\n");
        int n2 = stringArray.length;
        int n3 = n2 * n;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = fontMetrics.stringWidth(stringArray[i]);
            if (i == n2 - 1) {
                String string2 = this.getAcceleratorString((JToolTip)jComponent);
                n5 += fontMetrics.stringWidth(string2) + accelerator_offset;
            }
            n4 = Math.max(n4, n5);
        }
        return new Dimension(n4 + inset * 2, n3 + inset * 2);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public String getAcceleratorString(JToolTip jToolTip) {
        JComponent jComponent = jToolTip.getComponent();
        if (jComponent == null) {
            return "";
        }
        KeyStroke[] keyStrokeArray = jComponent.getRegisteredKeyStrokes();
        String string = "";
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            char c = (char)keyStrokeArray[i].getKeyCode();
            int n = keyStrokeArray[i].getModifiers();
            if (n == 2) {
                string = "cntl+" + (char)keyStrokeArray[i].getKeyCode();
                break;
            }
            if (n != 8) continue;
            string = "alt+" + (char)keyStrokeArray[i].getKeyCode();
            break;
        }
        return string;
    }
}

