/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

public class TaskSingleAttributeNode
extends TangoNode {
    private Database db;
    private String devName;
    private String attributeName;
    private String shortAttName;
    private int idl;
    private String pollingPeriod = "";
    private boolean isPolled = false;
    private String min_alarm = "None";
    private String max_alarm = "None";
    private String min_warning = "None";
    private String max_warning = "None";
    private String delta_t = "None";
    private String delta_val = "None";
    private String unit = "None";
    private String display_unit = "None";
    private String standard_unit = "None";
    private String min = "None";
    private String max = "None";
    private String format = "None";
    private String label = "None";
    private String descr = "None";
    private String abs_change = "None";
    private String rel_change = "None";
    private String periodic = "None";
    private String archive_abs_change = "None";
    private String archive_rel_change = "None";
    private String archive_period = "None";

    TaskSingleAttributeNode(TreePanel treePanel, Database database, String string, String string2, int n) {
        this.db = database;
        this.devName = string;
        this.attributeName = string2;
        this.parentPanel = treePanel;
        this.idl = n;
        this.shortAttName = string2.substring(string2.lastIndexOf(47) + 1);
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.atticon;
    }

    @Override
    public String toString() {
        return "Config";
    }

    @Override
    String getTitle() {
        return this.attributeName;
    }

    String getShortAttName() {
        return this.shortAttName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean isPolled() {
        return this.isPolled;
    }

    public String getPollingPeriod() {
        return this.pollingPeriod;
    }

    public String getRelativeChange() {
        return this.rel_change;
    }

    public String getAbsoluteChange() {
        return this.abs_change;
    }

    public String getArchRelativeChange() {
        return this.archive_rel_change;
    }

    public String getArchAbsoluteChange() {
        return this.archive_rel_change;
    }

    public String getArchPeriod() {
        return this.archive_period;
    }

    public String getPeriodic() {
        return this.periodic;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFormat() {
        return this.format;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDisplayUnit() {
        return this.display_unit;
    }

    public String getStandardUnit() {
        return this.standard_unit;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }

    public String getMinAlarm() {
        return this.min_alarm;
    }

    public String getMaxAlarm() {
        return this.max_alarm;
    }

    public String getMinWarning() {
        return this.min_warning;
    }

    public String getMaxWarning() {
        return this.max_warning;
    }

    public String getDeltaT() {
        return this.delta_t;
    }

    public String getDeltaVal() {
        return this.delta_val;
    }

    public String getDescr() {
        return this.descr;
    }

    void setAttributePolling(boolean bl, String string) {
        int n = 3000;
        if (bl) {
            if (string != "") {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JiveUtils.showJiveError("Invalid period value for attribute " + this.shortAttName + "\n" + numberFormatException.getMessage());
                }
            }
            try {
                DeviceProxy deviceProxy = new DeviceProxy(this.devName);
                deviceProxy.poll_attribute(this.shortAttName, n);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        } else {
            try {
                DeviceProxy deviceProxy = new DeviceProxy(this.devName);
                deviceProxy.stop_poll_attribute(this.shortAttName);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }
    }

    void setAbsoluteChange(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
                attributeInfoEx.events.ch_event.abs_change = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setRelativeChange(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
                attributeInfoEx.events.ch_event.rel_change = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setArchAbsoluteChange(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
                attributeInfoEx.events.arch_event.abs_change = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setArchRelativeChange(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
                attributeInfoEx.events.arch_event.rel_change = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setArchPeriod(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
                attributeInfoEx.events.arch_event.period = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setPeriod(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            if (deviceProxy.get_idl_version() >= 3) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
                attributeInfoEx.events.per_event.period = string;
                deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setLabel(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            attributeInfoEx.label = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setFormat(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            attributeInfoEx.format = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setUnit(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            attributeInfoEx.unit = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setDisplayUnit(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            attributeInfoEx.display_unit = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setStandardUnit(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            attributeInfoEx.standard_unit = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMin(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            attributeInfoEx.min_value = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMax(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            attributeInfoEx.max_value = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMinAlarm(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.min_alarm = string;
            } else {
                attributeInfoEx.min_alarm = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMaxAlarm(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.max_alarm = string;
            } else {
                attributeInfoEx.max_alarm = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMinWarning(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.min_warning = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMaxWarning(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.max_warning = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setDeltaT(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.delta_t = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setDeltaVal(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.delta_val = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setDescr(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            attributeInfoEx.description = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public void updatePollingInfo() {
        String[] stringArray = null;
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            stringArray = deviceProxy.polling_status();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        String[] stringArray2 = null;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length && !bl) {
            stringArray2 = JiveUtils.extractPollingInfo(stringArray[n]);
            bl = stringArray2[0].equalsIgnoreCase("attribute") && stringArray2[1].equalsIgnoreCase(this.shortAttName);
            if (bl) continue;
            ++n;
        }
        if (bl) {
            this.pollingPeriod = stringArray2[2];
            this.isPolled = true;
        } else {
            this.pollingPeriod = "";
            this.isPolled = false;
        }
    }

    private String reformat(String string) {
        if (string.equalsIgnoreCase("Not specified") || string.equalsIgnoreCase("No standard unit") || string.equalsIgnoreCase("No unit") || string.equalsIgnoreCase("No description") || string.equalsIgnoreCase("No display unit")) {
            return "None";
        }
        return string;
    }

    void browseAttributeInfo() {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.shortAttName);
            if (attributeInfoEx != null) {
                if (attributeInfoEx.alarms != null) {
                    this.min_alarm = this.reformat(attributeInfoEx.alarms.min_alarm);
                    this.max_alarm = this.reformat(attributeInfoEx.alarms.max_alarm);
                    this.min_warning = this.reformat(attributeInfoEx.alarms.min_warning);
                    this.max_warning = this.reformat(attributeInfoEx.alarms.max_warning);
                    this.delta_t = this.reformat(attributeInfoEx.alarms.delta_t);
                    this.delta_val = this.reformat(attributeInfoEx.alarms.delta_val);
                } else {
                    this.min_alarm = this.reformat(attributeInfoEx.min_alarm);
                    this.max_alarm = this.reformat(attributeInfoEx.max_alarm);
                    this.min_warning = "None";
                    this.max_warning = "None";
                    this.delta_t = "None";
                    this.delta_val = "None";
                }
                this.unit = this.reformat(attributeInfoEx.unit);
                this.display_unit = this.reformat(attributeInfoEx.display_unit);
                this.standard_unit = this.reformat(attributeInfoEx.standard_unit);
                this.min = this.reformat(attributeInfoEx.min_value);
                this.max = this.reformat(attributeInfoEx.max_value);
                this.format = this.reformat(attributeInfoEx.format);
                this.label = this.reformat(attributeInfoEx.label);
                this.descr = this.reformat(attributeInfoEx.description);
                if (attributeInfoEx.events != null) {
                    this.rel_change = attributeInfoEx.events.ch_event.rel_change;
                    this.abs_change = attributeInfoEx.events.ch_event.abs_change;
                    this.archive_rel_change = attributeInfoEx.events.arch_event.rel_change;
                    this.archive_abs_change = attributeInfoEx.events.arch_event.abs_change;
                    this.archive_period = attributeInfoEx.events.arch_event.period;
                    this.periodic = attributeInfoEx.events.per_event.period;
                }
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }
}

