/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import jive.ClassPanel;
import jive.DevicePanel;
import jive.FinishPanel;
import jive.JiveUtils;
import jive.PropertyPanel;
import jive.ServerPanel;
import jive.WizardPanel;

public class DevWizard
extends JDialog
implements ActionListener {
    static final Font wizFont = new Font("Dialog", 0, 12);
    private JButton nextButton;
    private JButton backButton;
    private JButton skipButton;
    private JButton cancelButton;
    private JPanel buttoniPanel;
    private JPanel buttonPanel;
    private JPanel innerPanel;
    private JPanel helpPanel;
    private JTextArea helpText;
    private JTextArea helpIconText;
    private JLabel helpIcon;
    private JLabel helpLabel;
    private JPanel wizardContainer;
    private Vector allPanels;
    int activePanel = -1;
    private Database db;
    private String dbName;
    static DeviceProxy starter = null;
    public static String lastServStarted;

    public DevWizard(Frame frame) {
        super(frame, true);
        this.initComponents();
        starter = null;
        lastServStarted = null;
    }

    public DevWizard(Dialog dialog) {
        super(dialog, true);
        this.initComponents();
        starter = null;
        lastServStarted = null;
    }

    public DevWizard(Frame frame, DeviceProxy deviceProxy) {
        this(frame);
        starter = deviceProxy;
        lastServStarted = null;
    }

    public DevWizard(Dialog dialog, DeviceProxy deviceProxy) {
        this(dialog);
        starter = deviceProxy;
        lastServStarted = null;
    }

    public void showWizard(String[] stringArray) {
        this.allPanels = new Vector();
        this.allPanels.add(new ServerPanel(this, stringArray));
        this.displayWizard();
    }

    public void showClassesWizard(String string) {
        this.allPanels = new Vector();
        try {
            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + string);
            this.addPanel(new ClassPanel(this, string, deviceProxy));
            this.displayWizard();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public void showDevicesWizard(String string, String string2) {
        this.allPanels = new Vector();
        DevicePanel devicePanel = new DevicePanel(this, string, string2);
        this.addPanel(devicePanel);
        this.addPanel(new FinishPanel(this, string, null, devicePanel));
        this.displayWizard();
    }

    public void showDeviceWizard(String string, String string2, String string3) {
        this.allPanels = new Vector();
        try {
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string2);
            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + string);
            DeviceData deviceData2 = deviceProxy.command_inout("QueryWizardDevProperty", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            for (int i = 0; i < stringArray.length; i += 3) {
                this.addPanel(new PropertyPanel(this, 1, string, string3, stringArray[i], stringArray[i + 1], stringArray[i + 2], string2));
            }
            this.addPanel(new FinishPanel(this, string, null, null));
            this.displayWizard();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    private void displayWizard() {
        this.setActivePanel(0);
        JiveUtils.centerDialog(this);
        this.setVisible(true);
        this.dispose();
    }

    boolean canBack() {
        return this.activePanel > 0;
    }

    private void initComponents() {
        this.innerPanel = new JPanel(new BorderLayout());
        this.setContentPane(this.innerPanel);
        this.setResizable(false);
        this.backButton = new JButton("< Back");
        this.backButton.setFont(wizFont);
        this.backButton.addActionListener(this);
        this.nextButton = new JButton("Next >");
        this.nextButton.setFont(wizFont);
        this.nextButton.addActionListener(this);
        this.skipButton = new JButton("Skip");
        this.skipButton.setFont(wizFont);
        this.skipButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFont(wizFont);
        this.cancelButton.addActionListener(this);
        this.buttoniPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout(2);
        this.buttoniPanel.setLayout(flowLayout);
        this.buttoniPanel.add(this.backButton);
        this.buttoniPanel.add(this.nextButton);
        this.buttoniPanel.add(this.skipButton);
        this.buttoniPanel.add(new JLabel(" "));
        this.buttoniPanel.add(this.cancelButton);
        this.buttonPanel = new JPanel(new BorderLayout());
        this.buttonPanel.add((Component)this.buttoniPanel, "Center");
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(0);
        this.buttonPanel.add((Component)jSeparator, "North");
        this.innerPanel.add((Component)this.buttonPanel, "South");
        this.helpPanel = new JPanel(null);
        this.helpPanel.setPreferredSize(new Dimension(500, 240));
        this.helpIcon = new JLabel();
        this.helpIcon.setBounds(10, 10, 128, 128);
        this.helpPanel.add(this.helpIcon);
        this.helpLabel = new JLabel();
        this.helpLabel.setFont(new Font("Dialog", 1, 16));
        this.helpLabel.setBounds(140, 10, 350, 30);
        this.helpPanel.add(this.helpLabel);
        this.helpText = new JTextArea();
        this.helpText.setEditable(false);
        this.helpText.setBorder(null);
        this.helpText.setBounds(140, 40, 350, 98);
        this.helpText.setBackground(this.innerPanel.getBackground());
        this.helpText.setLineWrap(true);
        this.helpText.setWrapStyleWord(true);
        this.helpPanel.add(this.helpText);
        this.helpIconText = new JTextArea();
        this.helpIconText.setEditable(false);
        this.helpIconText.setBorder(null);
        this.helpIconText.setMargin(new Insets(0, 0, 0, 0));
        this.helpIconText.setBackground(this.innerPanel.getBackground());
        this.helpIconText.setFont(new Font("Dialog", 1, 12));
        this.helpIconText.setLineWrap(true);
        this.helpIconText.setWrapStyleWord(true);
        this.helpIconText.setBounds(10, 140, 128, 95);
        this.helpPanel.add(this.helpIconText);
        this.innerPanel.add((Component)this.helpPanel, "North");
        this.wizardContainer = new JPanel(new GridLayout(1, 1));
        this.wizardContainer.setBorder(null);
        this.wizardContainer.setBounds(140, 140, 350, 95);
        this.helpPanel.add(this.wizardContainer);
        try {
            this.db = ApiUtil.get_db_obj();
            this.dbName = this.db.get_tango_host();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return;
        }
        this.setTitle("Tango Device Installation Wizard on " + this.dbName);
    }

    void addPanel(WizardPanel wizardPanel) {
        this.allPanels.add(wizardPanel);
    }

    void addPanel(int n, WizardPanel wizardPanel) {
        this.allPanels.add(n, wizardPanel);
    }

    WizardPanel getPanel(int n) {
        return (WizardPanel)this.allPanels.get(n);
    }

    Vector getPanels() {
        return this.allPanels;
    }

    private void setActivePanel(int n) {
        this.activePanel = n;
        WizardPanel wizardPanel = this.getPanel(n);
        this.helpIcon.setIcon(wizardPanel.getIcon());
        this.helpText.setText(wizardPanel.getDescription());
        this.helpLabel.setText(wizardPanel.getTitle());
        this.helpIconText.setText(wizardPanel.getSubTitle());
        this.wizardContainer.removeAll();
        this.wizardContainer.add(wizardPanel);
        this.backButton.setEnabled(wizardPanel.getBackState());
        this.backButton.setText(wizardPanel.getBackText());
        this.nextButton.setEnabled(wizardPanel.getNextState());
        this.nextButton.setText(wizardPanel.getNextText());
        this.skipButton.setVisible(wizardPanel.getSkipState());
        this.skipButton.setText(wizardPanel.getSkipText());
        this.innerPanel.revalidate();
        this.repaint();
    }

    private void goToNextPanel() {
        if (this.activePanel + 1 < this.allPanels.size()) {
            this.setActivePanel(this.activePanel + 1);
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            if (JOptionPane.showConfirmDialog(this, "Do you want to exit wizard ?", "Confirmation", 0) == 0) {
                this.setVisible(false);
            }
        } else if (object == this.nextButton) {
            if (this.getPanel(this.activePanel).next()) {
                this.goToNextPanel();
            }
        } else if (object == this.backButton) {
            if (this.getPanel(this.activePanel).back()) {
                this.setActivePanel(this.activePanel - 1);
            }
        } else if (object == this.skipButton && this.getPanel(this.activePanel).skip()) {
            this.goToNextPanel();
        }
    }

    public static void main(String[] stringArray) {
        DevWizard devWizard = new DevWizard((Frame)null);
        devWizard.showWizard(null);
        System.exit(0);
    }
}

