/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskSingleAttributeNode;
import jive3.TreePanel;

public class TreePanelAttributeAlias
extends TreePanel {
    String aliasFilterString = "*";
    Pattern aliasPattern = null;

    public TreePanelAttributeAlias(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    public void applyFilter(String string) {
        this.aliasFilterString = string;
        if (string.equals("*")) {
            this.aliasPattern = null;
        } else if (string.length() == 0) {
            this.aliasPattern = null;
        } else {
            try {
                String string2 = this.filterToRegExp(this.aliasFilterString);
                this.aliasPattern = Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this.invoker, patternSyntaxException.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.aliasFilterString;
    }

    class AliasNode
    extends TangoNode {
        private String aliasName = null;
        private String attName = null;

        AliasNode(String string) {
            this.aliasName = string;
        }

        @Override
        void populateNode() throws DevFailed {
            if (this.attName == null) {
                this.attName = TreePanelAttributeAlias.this.db.get_attribute_alias(this.aliasName);
            }
            int n = this.attName.lastIndexOf("/");
            String string = this.attName.substring(0, n);
            String string2 = this.attName.substring(n + 1);
            DeviceProxy deviceProxy = new DeviceProxy(string);
            int n2 = deviceProxy.get_idl_version();
            this.add(new TaskDeviceAttributePropertyNode(TreePanelAttributeAlias.this.self, TreePanelAttributeAlias.this.db, string, string2, n2));
            this.add(new TaskSingleAttributeNode(TreePanelAttributeAlias.this.self, TreePanelAttributeAlias.this.db, string, this.attName, n2));
        }

        @Override
        public String toString() {
            return this.aliasName;
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }

        @Override
        public int[] getAction() {
            return new int[]{13, 3};
        }

        public void goToDeviceNode() {
            try {
                if (this.attName == null) {
                    this.attName = TreePanelAttributeAlias.this.db.get_attribute_alias(this.aliasName);
                }
                int n = this.attName.lastIndexOf("/");
                String string = this.attName.substring(0, n);
                TreePanelAttributeAlias.this.invoker.goToDeviceNode(string);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }

        @Override
        public void execAction(int n) {
            switch (n) {
                case 3: {
                    try {
                        TreePanelAttributeAlias.this.db.delete_attribute_alias(this.aliasName);
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                    TreePanelAttributeAlias.this.refresh();
                    break;
                }
                case 13: {
                    this.goToDeviceNode();
                }
            }
        }

        @Override
        public String getValue() {
            if (this.attName == null) {
                try {
                    this.attName = TreePanelAttributeAlias.this.db.get_attribute_alias(this.aliasName);
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
            }
            return this.aliasName + " = " + this.attName;
        }

        @Override
        public String getTitle() {
            return "Attribute alias";
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelAttributeAlias.this.db.get_attribute_alias_list("*");
            for (int i = 0; i < stringArray.length; ++i) {
                if (TreePanelAttributeAlias.this.aliasPattern != null) {
                    Matcher matcher = TreePanelAttributeAlias.this.aliasPattern.matcher(stringArray[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != stringArray[i].length()) continue;
                    this.add(new AliasNode(stringArray[i]));
                    continue;
                }
                this.add(new AliasNode(stringArray[i]));
            }
        }

        @Override
        public String toString() {
            return "Alias: ";
        }
    }
}

