/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

class TaskDeviceAttributePropertyNode
extends PropertyNode {
    private Database db;
    private String devName;
    private String attributeName;
    private int idl;

    TaskDeviceAttributePropertyNode(TreePanel treePanel, Database database, String string, String string2, int n) {
        this.db = database;
        this.devName = string;
        this.attributeName = string2;
        this.parentPanel = treePanel;
        this.idl = n;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    @Override
    public String toString() {
        return this.attributeName;
    }

    @Override
    String getTitle() {
        return "Device attribute properties";
    }

    @Override
    String getName() {
        return this.devName + "/" + this.attributeName;
    }

    String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void viewHistory() {
        this.parentPanel.invoker.historyDlg.viewDeviceAttPropertyHistory(this.devName, this.attributeName, "*");
        this.parentPanel.invoker.showHistory();
    }

    @Override
    String[][] getProperties() {
        String[][] stringArray = new String[0][0];
        try {
            int n;
            DbAttribute dbAttribute = this.db.get_device_attribute_property(this.devName, this.attributeName);
            String[] stringArray2 = dbAttribute.get_property_list();
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < stringArray2.length; ++n) {
                if (JiveUtils.IsAttCfgItem(stringArray2[n], this.idl) >= 0) continue;
                vector.add(stringArray2[n]);
            }
            stringArray = new String[vector.size()][2];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n][0] = (String)vector.get(n);
                stringArray[n][1] = dbAttribute.get_string_value((String)vector.get(n));
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        return stringArray;
    }

    @Override
    void setProperty(String string, String string2) {
        try {
            DbAttribute dbAttribute = new DbAttribute(this.attributeName);
            dbAttribute.add(string, JiveUtils.makeStringArray(string2));
            this.db.put_device_attribute_property(this.devName, dbAttribute);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    @Override
    void deleteProperty(String string) {
        try {
            this.db.delete_device_attribute_property(this.devName, this.attributeName, string);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    @Override
    public void execAction(int n) {
        switch (n) {
            case 0: {
                JiveUtils.the_clipboard.clear();
                String[][] stringArray = this.getProperties();
                for (int i = 0; i < stringArray.length; ++i) {
                    JiveUtils.the_clipboard.add(stringArray[i][0], this.attributeName, stringArray[i][1]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < JiveUtils.the_clipboard.getAttPropertyLength(); ++i) {
                    this.setProperty(JiveUtils.the_clipboard.getAttPropertyName(i), JiveUtils.the_clipboard.getAttPropertyValue(i));
                }
                this.parentPanel.refreshValues();
                break;
            }
            case 30: {
                this.viewHistory();
            }
        }
    }
}

