/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import java.awt.BorderLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskClassAttributePropertyNode;
import jive3.TaskClassPropertyNode;
import jive3.TreePanel;

public class TreePanelClass
extends TreePanel {
    String classFilterString = "*";
    Pattern classPattern = null;

    public TreePanelClass(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    public TangoNode createRoot() {
        return new RootNode();
    }

    void addAttribute(TangoNode tangoNode, String string, String string2) {
        if (this.searchNode(tangoNode, string2) != null) {
            JOptionPane.showMessageDialog(null, "Attribute already exists", "Error", 0);
            return;
        }
        this.treeModel.insertNodeInto(new TaskClassAttributePropertyNode(this.self, this.db, string, string2), tangoNode, 0);
    }

    public void applyFilter(String string) {
        this.classFilterString = string;
        if (string.equals("*")) {
            this.classPattern = null;
        } else if (string.length() == 0) {
            this.classPattern = null;
        } else {
            try {
                String string2 = this.filterToRegExp(this.classFilterString);
                this.classPattern = Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this.invoker, patternSyntaxException.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.classFilterString;
    }

    class AttributeNode
    extends TangoNode {
        private String className;

        AttributeNode(String string) {
            this.className = string;
        }

        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelClass.this.db.get_class_attribute_list(this.getParent().toString(), "*");
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new TaskClassAttributePropertyNode(TreePanelClass.this.self, TreePanelClass.this.db, this.className, stringArray[i]));
            }
        }

        public String toString() {
            return "Attribute properties";
        }

        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }

        public int[] getAction() {
            if (JiveUtils.readOnly) {
                return new int[0];
            }
            return new int[]{18};
        }

        public void execAction(int n) {
            switch (n) {
                case 18: {
                    String string = JOptionPane.showInputDialog(null, "Add class attribute", "");
                    if (string == null) {
                        return;
                    }
                    TreePanelClass.this.addAttribute(this, this.className, string);
                }
            }
        }
    }

    class ClassNode
    extends TangoNode {
        private String className;

        ClassNode(String string) {
            this.className = string;
        }

        void populateNode() throws DevFailed {
            this.add(new TaskClassPropertyNode(TreePanelClass.this.self, TreePanelClass.this.db, this.className));
            this.add(new AttributeNode(this.className));
        }

        public String toString() {
            return this.className;
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelClass.this.db.get_class_list("*");
            for (int i = 0; i < stringArray.length; ++i) {
                if (TreePanelClass.this.classPattern != null) {
                    Matcher matcher = TreePanelClass.this.classPattern.matcher(stringArray[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != stringArray[i].length()) continue;
                    this.add(new ClassNode(stringArray[i]));
                    continue;
                }
                this.add(new ClassNode(stringArray[i]));
            }
        }

        public String toString() {
            return "Class: ";
        }
    }
}

