/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive3.ProgressFrame;
import jive3.TaskEventNode;

public class DeviceEventPanel
extends JPanel
implements MouseListener,
ActionListener {
    private JTabbedPane tabPane;
    private JTable changeTable;
    private DefaultTableModel changeModel;
    private JTable archTable;
    private DefaultTableModel archModel;
    private JTable perTable;
    private DefaultTableModel perModel;
    private JButton refreshButton;
    private JButton applyButton;
    private JTable selectedTable;
    private int[] selectedRows;
    private JPopupMenu tableMenu;
    private JMenuItem resetMenuItem;
    private JMenuItem setAbsMenuItem;
    private JMenuItem setRelMenuItem;
    private JMenuItem setPeriodMenuItem;
    private TaskEventNode[] source = null;

    DeviceEventPanel() {
        this.setLayout(new BorderLayout());
        this.changeModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceEventPanel.this.source.length;
                    int n4 = 0;
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/abs_change", ++n4 * 100 / n3);
                                DeviceEventPanel.this.source[i].setAbsChange(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/rel_change", ++n4 * 100 / n3);
                                DeviceEventPanel.this.source[i].setRelChange(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.changeTable = new JTable(this.changeModel);
        this.changeTable.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.changeTable);
        this.archModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceEventPanel.this.source.length;
                    int n4 = 0;
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/arch_abs_change", ++n4 * 100 / n3);
                                DeviceEventPanel.this.source[i].setArchAbsChange(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/arch_rel_change", ++n4 * 100 / n3);
                                DeviceEventPanel.this.source[i].setArchRelChange(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                            break;
                        }
                        case 3: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/arch_period", ++n4 * 100 / n3);
                                DeviceEventPanel.this.source[i].setArchPeriod(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.archTable = new JTable(this.archModel);
        this.archTable.addMouseListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.archTable);
        this.perModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    int n3 = DeviceEventPanel.this.source.length;
                    int n4 = 0;
                    switch (n2) {
                        case 1: {
                            if (n3 > 1) {
                                ProgressFrame.displayProgress("Updating event config");
                            }
                            for (int i = 0; i < DeviceEventPanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceEventPanel.this.source[i].getName() + "/period", ++n4 * 100 / n3);
                                DeviceEventPanel.this.source[i].setPeriodic(n, (String)object);
                            }
                            ProgressFrame.hideProgress();
                            DeviceEventPanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.perTable = new JTable(this.perModel);
        this.perTable.addMouseListener(this);
        JScrollPane jScrollPane3 = new JScrollPane(this.perTable);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(ATKConstant.labelFont);
        this.tabPane.add("Change event", jScrollPane);
        this.tabPane.add("Archive event", jScrollPane2);
        this.tabPane.add("Periodic event", jScrollPane3);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.tabPane.setBorder(titledBorder);
        this.add((Component)this.tabPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        jPanel.add(this.refreshButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        jPanel.add(this.applyButton);
        this.add((Component)jPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.resetMenuItem = new JMenuItem("Reset to default value");
        this.resetMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetMenuItem);
        this.setAbsMenuItem = new JMenuItem("Set absolute change");
        this.setAbsMenuItem.addActionListener(this);
        this.tableMenu.add(this.setAbsMenuItem);
        this.setRelMenuItem = new JMenuItem("Set relative change");
        this.setRelMenuItem.addActionListener(this);
        this.tableMenu.add(this.setRelMenuItem);
        this.setPeriodMenuItem = new JMenuItem("Set period");
        this.setPeriodMenuItem.addActionListener(this);
        this.tableMenu.add(this.setPeriodMenuItem);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.selectedTable = (JTable)mouseEvent.getSource();
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 && !JiveUtils.readOnly) {
            int n = this.getRowForLocation(mouseEvent.getY());
            if (n != -1) {
                this.selectedTable.addRowSelectionInterval(n, n);
                this.selectedTable.setColumnSelectionInterval(0, this.selectedTable.getColumnCount() - 1);
                this.selectedRows = this.selectedTable.getSelectedRows();
                if (this.selectedTable == this.changeTable) {
                    this.setAbsMenuItem.setVisible(true);
                    this.setRelMenuItem.setVisible(true);
                    this.setPeriodMenuItem.setVisible(false);
                } else if (this.selectedTable == this.archTable) {
                    this.setAbsMenuItem.setVisible(true);
                    this.setRelMenuItem.setVisible(true);
                    this.setPeriodMenuItem.setVisible(true);
                } else {
                    this.setAbsMenuItem.setVisible(false);
                    this.setRelMenuItem.setVisible(false);
                    this.setPeriodMenuItem.setVisible(true);
                }
                this.tableMenu.show(this.selectedTable, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.selectedTable = null;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refreshValue();
        } else if (object == this.resetMenuItem) {
            int n = this.selectedRows.length * this.source.length;
            int n2 = 0;
            if (n > 1) {
                ProgressFrame.displayProgress("Reseting event config");
            }
            if (this.selectedTable == this.changeTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[j], 0), ++n2 * 100 / n);
                        this.source[i].resetChangeEvent(this.selectedRows[j]);
                    }
                    this.source[i].restartDevice();
                }
            } else if (this.selectedTable == this.archTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.archModel.getValueAt(this.selectedRows[j], 0), ++n2 * 100 / n);
                        this.source[i].resetArchEvent(this.selectedRows[j]);
                    }
                    this.source[i].restartDevice();
                }
            } else if (this.selectedTable == this.perTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Reseting " + this.source[i].getName() + "/" + this.perModel.getValueAt(this.selectedRows[j], 0), ++n2 * 100 / n);
                        this.source[i].resetPeriodicEvent(this.selectedRows[j]);
                    }
                    this.source[i].restartDevice();
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.setAbsMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter absolute change value", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n3 = 0;
            if (n > 1) {
                ProgressFrame.displayProgress("Updating abs change");
            }
            if (this.selectedTable == this.changeTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[j], 0), ++n3 * 100 / n);
                        this.source[i].setAbsChange(this.selectedRows[j], string);
                    }
                }
            } else if (this.selectedTable == this.archTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.archModel.getValueAt(this.selectedRows[j], 0), ++n3 * 100 / n);
                        this.source[i].setArchAbsChange(this.selectedRows[j], string);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.setRelMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter relative change value", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n4 = 0;
            if (n > 1) {
                ProgressFrame.displayProgress("Updating rel change");
            }
            if (this.selectedTable == this.changeTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[j], 0), ++n4 * 100 / n);
                        this.source[i].setRelChange(this.selectedRows[j], string);
                    }
                }
            } else if (this.selectedTable == this.archTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.archModel.getValueAt(this.selectedRows[j], 0), ++n4 * 100 / n);
                        this.source[i].setArchRelChange(this.selectedRows[j], string);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.setPeriodMenuItem) {
            String string = JOptionPane.showInputDialog(null, "Enter period value (ms)", "");
            if (string == null) {
                return;
            }
            int n = this.selectedRows.length * this.source.length;
            int n5 = 0;
            if (n > 1) {
                ProgressFrame.displayProgress("Updating period");
            }
            if (this.selectedTable == this.archTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.changeModel.getValueAt(this.selectedRows[j], 0), ++n5 * 100 / n);
                        this.source[i].setArchPeriod(this.selectedRows[j], string);
                    }
                }
            } else if (this.selectedTable == this.perTable) {
                for (int i = 0; i < this.source.length; ++i) {
                    for (int j = 0; j < this.selectedRows.length; ++j) {
                        ProgressFrame.setProgress("Updating " + this.source[i].getName() + "/" + this.archModel.getValueAt(this.selectedRows[j], 0), ++n5 * 100 / n);
                        this.source[i].setPeriodic(this.selectedRows[j], string);
                    }
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (object == this.applyButton) {
            String string;
            if (this.changeTable.isEditing()) {
                string = ((JTextField)this.changeTable.getEditorComponent()).getText();
                this.changeModel.setValueAt(string, this.changeTable.getEditingRow(), this.changeTable.getEditingColumn());
            }
            if (this.archTable.isEditing()) {
                string = ((JTextField)this.archTable.getEditorComponent()).getText();
                this.archModel.setValueAt(string, this.archTable.getEditingRow(), this.archTable.getEditingColumn());
            }
            if (this.perTable.isEditing()) {
                string = ((JTextField)this.perTable.getEditorComponent()).getText();
                this.perModel.setValueAt(string, this.perTable.getEditingRow(), this.perTable.getEditingColumn());
            }
        }
    }

    void setSource(TaskEventNode[] taskEventNodeArray) {
        this.source = taskEventNodeArray;
        this.refreshValue();
    }

    private int getRowForLocation(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.selectedTable.getRowCount() && !bl) {
            bl = n >= n3 && n <= n3 + this.selectedTable.getRowHeight(n2);
            if (bl) continue;
            n3 += this.selectedTable.getRowHeight(n2);
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    private void refreshValue() {
        if (this.source != null) {
            this.source[0].browseEventInfo();
            Object[] objectArray = new String[]{"Attribute name", "Absolute", "Relative"};
            Object[][] objectArray2 = new Object[this.source[0].getAttributeNumber()][3];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray2[i][0] = this.source[0].getAttName(i);
                objectArray2[i][1] = this.source[0].getAbsChange(i);
                objectArray2[i][2] = this.source[0].getRelChange(i);
            }
            this.changeModel.setDataVector(objectArray2, objectArray);
            this.changeTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] objectArray3 = new String[]{"Attribute name", "Absolute", "Relative", "Period"};
            Object[][] objectArray4 = new Object[this.source[0].getAttributeNumber()][4];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray4[i][0] = this.source[0].getAttName(i);
                objectArray4[i][1] = this.source[0].getArchAbsChange(i);
                objectArray4[i][2] = this.source[0].getArchRelChange(i);
                objectArray4[i][3] = this.source[0].getArchPeriod(i);
            }
            this.archModel.setDataVector(objectArray4, objectArray3);
            this.archTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] objectArray5 = new String[]{"Attribute name", "Period"};
            Object[][] objectArray6 = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                objectArray6[i][0] = this.source[0].getAttName(i);
                objectArray6[i][1] = this.source[0].getPeriodic(i);
            }
            this.perModel.setDataVector(objectArray6, objectArray5);
            this.perTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            String string = this.source[0].getTitle();
            string = this.source.length == 1 ? string + " [" + this.source[0].getName() + "]" : string + " [" + this.source.length + " devices selected]";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.tabPane.setBorder(titledBorder);
        }
    }
}

