/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.PoolThreadsManager;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.logviewer.Main;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.ExecDev;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoClassSelector;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public abstract class TreePanel
extends JPanel
implements TreeSelectionListener,
MouseListener {
    protected JTree tree;
    protected JScrollPane treeView = null;
    protected DefaultTreeModel treeModel;
    protected TangoNode root;
    protected Database db;
    MainPanel invoker;
    TreePanel self;
    private boolean updateOnChange;
    public static final int ACTION_NUMBER = 30;
    public static final int ACTION_COPY = 0;
    public static final int ACTION_PASTE = 1;
    public static final int ACTION_RENAME = 2;
    public static final int ACTION_DELETE = 3;
    public static final int ACTION_ADDCLASS = 4;
    public static final int ACTION_TESTADMIN = 5;
    public static final int ACTION_SAVESERVER = 6;
    public static final int ACTION_CLASSWIZ = 7;
    public static final int ACTION_ADDDEVICE = 8;
    public static final int ACTION_DEVICESWIZ = 9;
    public static final int ACTION_MONITORDEV = 10;
    public static final int ACTION_TESTDEV = 11;
    public static final int ACTION_DEFALIAS = 12;
    public static final int ACTION_GOTODEVNODE = 13;
    public static final int ACTION_RESTART = 14;
    public static final int ACTION_DEVICEWIZ = 15;
    public static final int ACTION_GOTOSERVNODE = 16;
    public static final int ACTION_GOTOADMINNODE = 17;
    public static final int ACTION_ADDCLASSATT = 18;
    public static final int ACTION_UNEXPORT = 19;
    public static final int ACTION_SELECT_PROP = 20;
    public static final int ACTION_SELECT_POLLING = 21;
    public static final int ACTION_SELECT_EVENT = 22;
    public static final int ACTION_SELECT_ATTCONF = 23;
    public static final int ACTION_SELECT_LOGGING = 24;
    public static final int ACTION_LOG_VIEWER = 25;
    public static final int ACTION_DEV_DEPEND = 26;
    public static final int ACTION_THREAD_POLL = 27;
    public static final int ACTION_VIEW_HISTORY = 28;
    public static final int ACTION_MOVE_SERVER = 29;
    private static TangoNode[] selectedNodes = null;
    static File lastFile = null;
    private static JPopupMenu actionMenu = new JPopupMenu();
    private static JMenuItem copyMenu = new JMenuItem("Copy");
    private static JMenuItem pasteMenu;
    private static JMenuItem renameMenu;
    private static JMenuItem deleteMenu;
    private static JMenuItem addClassMenu;
    private static JMenuItem testAdminMenu;
    private static JMenuItem saveServerMenu;
    private static JMenuItem classWizMenu;
    private static JMenuItem addDeviceMenu;
    private static JMenuItem devicesWizMenu;
    private static JMenuItem monitorMenu;
    private static JMenuItem testMenu;
    private static JMenuItem aliasMenu;
    private static JMenuItem goToDevMenu;
    private static JMenuItem restartMenu;
    private static JMenuItem deviceWizMenu;
    private static JMenuItem goToServMenu;
    private static JMenuItem goToAdminMenu;
    private static JMenuItem addClassAttMenu;
    private static JMenuItem unexportDevices;
    private static JMenuItem selectPropNodeMenu;
    private static JMenuItem selectPollingNodeMenu;
    private static JMenuItem selectEventNodeMenu;
    private static JMenuItem selectAttConfNodeMenu;
    private static JMenuItem selectLoggingNodeMenu;
    private static JMenuItem logviewerMenu;
    private static JMenuItem devDependMenu;
    private static JMenuItem threadPollMenu;
    private static JMenuItem viewHistoryMenu;
    private static JMenuItem moveServerMenu;

    abstract TangoNode createRoot();

    public void initTree() {
        this.root = this.createRoot();
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TangoNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tree.addMouseListener(this);
        this.tree.addTreeSelectionListener(this);
        this.tree.setToggleClickCount(0);
        this.treeView = new JScrollPane(this.tree);
        this.add((Component)this.treeView, "Center");
        this.updateOnChange = true;
    }

    public void setDatabase(Database database) {
        this.db = database;
        if (this.treeView != null) {
            this.remove(this.treeView);
            this.treeView = null;
        }
        if (database != null) {
            this.initTree();
        } else {
            this.repaint();
        }
    }

    public void refresh() {
        if (this.treeView == null) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath();
        this.remove(this.treeView);
        if (this.db != null) {
            this.initTree();
        }
        this.invoker.resetNavigation();
        this.selectPath(treePath);
    }

    public void selectPath(TreePath treePath) {
        if (treePath != null) {
            TreePath treePath2 = new TreePath(this.root);
            TangoNode tangoNode = this.root;
            boolean bl = true;
            int n = 1;
            while (bl && n < treePath.getPathCount()) {
                String string = treePath.getPathComponent(n).toString();
                if ((tangoNode = this.searchNode(tangoNode, string)) != null) {
                    treePath2 = treePath2.pathByAddingChild(tangoNode);
                    ++n;
                    continue;
                }
                bl = false;
            }
            this.tree.setSelectionPath(treePath2);
            this.tree.expandPath(treePath2);
            this.tree.makeVisible(treePath2);
            this.tree.scrollPathToVisible(treePath2);
        }
    }

    public void refreshValues() {
        if (this.treeView == null) {
            return;
        }
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            TangoNode[] tangoNodeArray = new TangoNode[treePathArray.length];
            for (int i = 0; i < tangoNodeArray.length; ++i) {
                tangoNodeArray[i] = (TangoNode)treePathArray[i].getLastPathComponent();
            }
            this.invoker.updatePanel(tangoNodeArray);
            if (treePathArray.length == 1) {
                this.tree.scrollPathToVisible(treePathArray[0]);
            }
        } else {
            this.invoker.updatePanel(null);
        }
    }

    public boolean isRootItem(String string) {
        TangoNode tangoNode = this.searchNodeStartingWith(this.root, string);
        return tangoNode != null;
    }

    public TreePath selectRootItem(String string) {
        TangoNode tangoNode = this.searchNodeStartingWith(this.root, string);
        TreePath treePath = new TreePath(this.root);
        treePath = treePath.pathByAddingChild(tangoNode);
        this.tree.setSelectionPath(treePath);
        return treePath;
    }

    public TangoNode searchNode(TangoNode tangoNode, String string) {
        int n = this.treeModel.getChildCount(tangoNode);
        int n2 = 0;
        boolean bl = false;
        TangoNode tangoNode2 = null;
        while (n2 < n && !bl) {
            tangoNode2 = (TangoNode)this.treeModel.getChild(tangoNode, n2);
            bl = tangoNode2.toString().compareToIgnoreCase(string) == 0;
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return tangoNode2;
        }
        return null;
    }

    public TangoNode searchNodeStartingWith(TangoNode tangoNode, String string) {
        int n = this.treeModel.getChildCount(tangoNode);
        int n2 = 0;
        boolean bl = false;
        TangoNode tangoNode2 = null;
        while (n2 < n && !bl) {
            tangoNode2 = (TangoNode)this.treeModel.getChild(tangoNode, n2);
            bl = tangoNode2.toString().toLowerCase().startsWith(string.toLowerCase());
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return tangoNode2;
        }
        return null;
    }

    public TangoNode searchNodeCaseSensitive(TangoNode tangoNode, String string) {
        int n = this.treeModel.getChildCount(tangoNode);
        int n2 = 0;
        boolean bl = false;
        TangoNode tangoNode2 = null;
        while (n2 < n && !bl) {
            tangoNode2 = (TangoNode)this.treeModel.getChild(tangoNode, n2);
            bl = tangoNode2.toString().compareTo(string) == 0;
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return tangoNode2;
        }
        return null;
    }

    public void testDevice(String string) {
        JDialog jDialog = new JDialog((Frame)this.invoker, false);
        jDialog.setTitle("Device Panel [" + string + "]");
        try {
            ExecDev execDev = new ExecDev(string);
            jDialog.setContentPane(execDev);
            JiveUtils.centerDialog(jDialog);
            jDialog.setVisible(true);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public void pasteDeviceProperty(Database database, String string) {
        try {
            int n;
            for (n = 0; n < JiveUtils.the_clipboard.getObjectPropertyLength(); ++n) {
                database.put_device_property(string, JiveUtils.makeDbDatum(JiveUtils.the_clipboard.getObjectPropertyName(n), JiveUtils.the_clipboard.getObjectPropertyValue(n)));
            }
            for (n = 0; n < JiveUtils.the_clipboard.getAttPropertyLength(); ++n) {
                DbAttribute dbAttribute = new DbAttribute(JiveUtils.the_clipboard.getAttName(n));
                dbAttribute.add(JiveUtils.the_clipboard.getAttPropertyName(n), JiveUtils.the_clipboard.getAttPropertyValue(n));
                database.put_device_attribute_property(string, dbAttribute);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public String getDeviceInfo(String string) {
        String string2 = "";
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            string2 = "- Device Info ----------------------------------------\n\n";
            string2 = string2 + deviceProxy.get_info().toString();
            string2 = string2 + "\n\n- Polling Status -------------------------------------\n\n";
            String[] stringArray = deviceProxy.polling_status();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i] + "\n\n";
            }
        }
        catch (DevFailed devFailed) {
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string2 = string2 + "Desc -> " + devFailed.errors[i].desc + "\n";
                string2 = string2 + "Reason -> " + devFailed.errors[i].reason + "\n";
                string2 = string2 + "Origin -> " + devFailed.errors[i].origin + "\n";
            }
        }
        return string2;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.updateOnChange) {
            this.refreshValues();
        }
    }

    public void refreshNode(TangoNode tangoNode, String string) {
        tangoNode.clearNodes();
        tangoNode.getChildCount();
        this.treeModel.nodeStructureChanged(tangoNode);
        if (string != null) {
            Object[] objectArray = tangoNode.getPath();
            TreePath treePath = new TreePath(objectArray);
            TangoNode tangoNode2 = this.searchNode(tangoNode, string);
            treePath = treePath.pathByAddingChild(tangoNode2);
            this.tree.setSelectionPath(treePath);
            this.tree.expandPath(treePath);
            this.tree.makeVisible(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
    }

    private void createSelectedNodes(int n) {
        if (selectedNodes == null) {
            selectedNodes = new TangoNode[n];
        } else if (selectedNodes.length != n) {
            selectedNodes = new TangoNode[n];
        }
    }

    private TreePath getNodePath(TangoNode tangoNode) {
        Object[] objectArray = tangoNode.getPath();
        return new TreePath(objectArray);
    }

    private boolean isGoodClass(String string, String string2, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length && !bl; i += 2) {
            bl = stringArray[i].equalsIgnoreCase(string);
            if (!bl) continue;
            return stringArray[i + 1].equalsIgnoreCase(string2);
        }
        return false;
    }

    public void selectNodesFromDomain(TangoNode tangoNode, String string) {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        this.tree.clearSelection();
        this.updateOnChange = false;
        try {
            int n;
            object3 = new DeviceData();
            object2 = "select name,class from device where domain='" + tangoNode.toString() + "'";
            object3.insert((String)object2);
            object = this.db.command_inout("DbMySqlSelect", object3);
            DevVarLongStringArray devVarLongStringArray = object.extractLongStringArray();
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < devVarLongStringArray.svalue.length; n += 2) {
                if (devVarLongStringArray.lvalue[n / 2] == 0) continue;
                vector.add(devVarLongStringArray.svalue[n]);
                vector.add(devVarLongStringArray.svalue[n + 1]);
            }
            stringArray = new String[vector.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)vector.get(n);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return;
        }
        object3 = (JFrame)ATKGraphicsUtils.getWindowForComponent((Component)this);
        object2 = new TangoClassSelector((JFrame)object3, stringArray, string);
        object = ((TangoClassSelector)object2).getSelectedClass();
        if (object == null) {
            this.updateOnChange = true;
            return;
        }
        int n = this.treeModel.getChildCount(tangoNode);
        for (int i = 0; i < n; ++i) {
            TangoNode tangoNode2 = (TangoNode)this.treeModel.getChild(tangoNode, i);
            int n2 = this.treeModel.getChildCount(tangoNode2);
            for (int j = 0; j < n2; ++j) {
                TangoNode tangoNode3 = (TangoNode)this.treeModel.getChild(tangoNode2, j);
                String string2 = tangoNode3.getParent().getParent().toString() + "/" + tangoNode3.getParent().toString() + "/" + tangoNode3.toString();
                if (!this.isGoodClass(string2, (String)object, stringArray)) continue;
                this.selectNodes(tangoNode3, string);
            }
        }
        this.refreshValues();
        this.updateOnChange = true;
    }

    public void selectNodesFromFamily(TangoNode tangoNode, String string) {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        this.tree.clearSelection();
        this.updateOnChange = false;
        try {
            int n;
            object3 = new DeviceData();
            object2 = "select name,class from device where family='" + tangoNode.toString() + "' and domain='" + tangoNode.getParent().toString() + "'";
            object3.insert((String)object2);
            object = this.db.command_inout("DbMySqlSelect", object3);
            DevVarLongStringArray devVarLongStringArray = object.extractLongStringArray();
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < devVarLongStringArray.svalue.length; n += 2) {
                if (devVarLongStringArray.lvalue[n / 2] == 0) continue;
                vector.add(devVarLongStringArray.svalue[n]);
                vector.add(devVarLongStringArray.svalue[n + 1]);
            }
            stringArray = new String[vector.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)vector.get(n);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return;
        }
        object3 = (JFrame)ATKGraphicsUtils.getWindowForComponent((Component)this);
        object2 = new TangoClassSelector((JFrame)object3, stringArray, string);
        object = ((TangoClassSelector)object2).getSelectedClass();
        if (object == null) {
            this.updateOnChange = true;
            return;
        }
        int n = this.treeModel.getChildCount(tangoNode);
        for (int i = 0; i < n; ++i) {
            TangoNode tangoNode2 = (TangoNode)this.treeModel.getChild(tangoNode, i);
            String string2 = tangoNode2.getParent().getParent().toString() + "/" + tangoNode2.getParent().toString() + "/" + tangoNode2.toString();
            if (!this.isGoodClass(string2, (String)object, stringArray)) continue;
            this.selectNodes(tangoNode2, string);
        }
        this.refreshValues();
        this.updateOnChange = true;
    }

    private void selectNodes(TangoNode tangoNode, String string) {
        int n = this.treeModel.getChildCount(tangoNode);
        boolean bl = false;
        for (int i = 0; !bl && i < n; ++i) {
            TangoNode tangoNode2 = (TangoNode)this.treeModel.getChild(tangoNode, i);
            bl = string.equalsIgnoreCase(tangoNode2.toString());
            if (!bl) continue;
            this.tree.addSelectionPath(this.getNodePath(tangoNode2));
        }
    }

    public String filterToRegExp(String string) {
        if (string.equals("*")) {
            return "*";
        }
        String string2 = "[a-z0-9_\\-\\.]*";
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '*') {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString().toLowerCase();
    }

    public String replaceWildcard(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '*') {
                stringBuffer.append('%');
                continue;
            }
            if (string.charAt(i) == '_') {
                stringBuffer.append("\\_");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public void launchLogViewer(String string) {
        Main main = new Main(new String[0], true);
        main.selectDevice(string);
    }

    public void launchDevDepend(String string) {
        try {
            DeviceHierarchyDialog deviceHierarchyDialog = new DeviceHierarchyDialog((JFrame)this.invoker, string);
            deviceHierarchyDialog.setTitle("Device Hierarchy");
            deviceHierarchyDialog.setVisible(true);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public void launchPollingThreadsManager(String string) {
        try {
            PoolThreadsManager poolThreadsManager = new PoolThreadsManager((JFrame)this.invoker, string);
            poolThreadsManager.setTitle("Polling threads manager");
            poolThreadsManager.setVisible(true);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            Object[] objectArray;
            if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3) {
                int n;
                if (!this.tree.isSelectionEmpty() && (mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
                    if (!this.tree.isPathSelected(treePath)) {
                        this.tree.addSelectionPath(treePath);
                    }
                    if ((objectArray = this.tree.getSelectionPaths()).length > 1) {
                        int n2;
                        n = 1;
                        this.createSelectedNodes(objectArray.length);
                        for (n2 = 0; n != 0 && n2 < objectArray.length; ++n2) {
                            TreePanel.selectedNodes[n2] = (TangoNode)objectArray[n2].getLastPathComponent();
                            int[] nArray = selectedNodes[n2].getAction();
                            n = JiveUtils.contains(nArray, 10) || JiveUtils.contains(nArray, 11) ? 1 : 0;
                        }
                        if (n != 0) {
                            for (n2 = 0; n2 < 30; ++n2) {
                                actionMenu.getComponent(n2).setVisible(false);
                            }
                            actionMenu.getComponent(10).setVisible(true);
                            actionMenu.getComponent(11).setVisible(true);
                            actionMenu.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                            return;
                        }
                    }
                }
                this.createSelectedNodes(1);
                this.tree.setSelectionPath(treePath);
                TreePanel.selectedNodes[0] = (TangoNode)treePath.getLastPathComponent();
                objectArray = selectedNodes[0].getAction();
                if (objectArray.length > 0) {
                    for (n = 0; n < 30; ++n) {
                        if (JiveUtils.contains((int[])objectArray, n)) {
                            actionMenu.getComponent(n).setVisible(true);
                            continue;
                        }
                        actionMenu.getComponent(n).setVisible(false);
                    }
                    actionMenu.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                this.createSelectedNodes(1);
                this.tree.setSelectionPath(treePath);
                TreePanel.selectedNodes[0] = (TangoNode)treePath.getLastPathComponent();
                objectArray = selectedNodes[0].getAction();
                if (objectArray.length > 0 && JiveUtils.contains((int[])objectArray, 10)) {
                    selectedNodes[0].execAction(10);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        actionMenu.add(copyMenu);
        copyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(0);
            }
        });
        pasteMenu = new JMenuItem("Paste");
        actionMenu.add(pasteMenu);
        pasteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(1);
            }
        });
        renameMenu = new JMenuItem("Rename");
        actionMenu.add(renameMenu);
        renameMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(2);
            }
        });
        deleteMenu = new JMenuItem("Delete");
        actionMenu.add(deleteMenu);
        deleteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(3);
            }
        });
        addClassMenu = new JMenuItem("Add class");
        actionMenu.add(addClassMenu);
        addClassMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(4);
            }
        });
        testAdminMenu = new JMenuItem("Test admin server");
        actionMenu.add(testAdminMenu);
        testAdminMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(5);
            }
        });
        saveServerMenu = new JMenuItem("Save server data");
        actionMenu.add(saveServerMenu);
        saveServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(6);
            }
        });
        classWizMenu = new JMenuItem("Classes wizard");
        actionMenu.add(classWizMenu);
        classWizMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(7);
            }
        });
        addDeviceMenu = new JMenuItem("Add device");
        actionMenu.add(addDeviceMenu);
        addDeviceMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(8);
            }
        });
        devicesWizMenu = new JMenuItem("Devices wizard");
        actionMenu.add(devicesWizMenu);
        devicesWizMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(9);
            }
        });
        monitorMenu = new JMenuItem("Monitor device");
        actionMenu.add(monitorMenu);
        monitorMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < selectedNodes.length; ++i) {
                    selectedNodes[i].execAction(10);
                }
            }
        });
        testMenu = new JMenuItem("Test device");
        actionMenu.add(testMenu);
        testMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < selectedNodes.length; ++i) {
                    selectedNodes[i].execAction(11);
                }
            }
        });
        aliasMenu = new JMenuItem("Define device alias");
        actionMenu.add(aliasMenu);
        aliasMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(12);
            }
        });
        goToDevMenu = new JMenuItem("Go to device node");
        actionMenu.add(goToDevMenu);
        goToDevMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(13);
            }
        });
        restartMenu = new JMenuItem("Restart device");
        actionMenu.add(restartMenu);
        restartMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(14);
            }
        });
        deviceWizMenu = new JMenuItem("Device wizard");
        actionMenu.add(deviceWizMenu);
        deviceWizMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(15);
            }
        });
        goToServMenu = new JMenuItem("Go to server node");
        actionMenu.add(goToServMenu);
        goToServMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(16);
            }
        });
        goToAdminMenu = new JMenuItem("Go to device admin node");
        actionMenu.add(goToAdminMenu);
        goToAdminMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(17);
            }
        });
        addClassAttMenu = new JMenuItem("Add attribute");
        actionMenu.add(addClassAttMenu);
        addClassAttMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(18);
            }
        });
        unexportDevices = new JMenuItem("Unexport devices");
        actionMenu.add(unexportDevices);
        unexportDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(19);
            }
        });
        selectPropNodeMenu = new JMenuItem("Select 'property' nodes");
        actionMenu.add(selectPropNodeMenu);
        selectPropNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(20);
            }
        });
        selectPollingNodeMenu = new JMenuItem("Select 'polling' nodes");
        actionMenu.add(selectPollingNodeMenu);
        selectPollingNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(21);
            }
        });
        selectEventNodeMenu = new JMenuItem("Select 'event' nodes");
        actionMenu.add(selectEventNodeMenu);
        selectEventNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(22);
            }
        });
        selectAttConfNodeMenu = new JMenuItem("Select 'attribute config' nodes");
        actionMenu.add(selectAttConfNodeMenu);
        selectAttConfNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(23);
            }
        });
        selectLoggingNodeMenu = new JMenuItem("Select 'logging' nodes");
        actionMenu.add(selectLoggingNodeMenu);
        selectLoggingNodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(24);
            }
        });
        logviewerMenu = new JMenuItem("Log Viewer");
        actionMenu.add(logviewerMenu);
        logviewerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(25);
            }
        });
        devDependMenu = new JMenuItem("Devices dependencies");
        actionMenu.add(devDependMenu);
        devDependMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(26);
            }
        });
        threadPollMenu = new JMenuItem("Polling threads manager");
        actionMenu.add(threadPollMenu);
        threadPollMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(27);
            }
        });
        viewHistoryMenu = new JMenuItem("View history");
        actionMenu.add(viewHistoryMenu);
        viewHistoryMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(28);
            }
        });
        moveServerMenu = new JMenuItem("Move server");
        actionMenu.add(moveServerMenu);
        moveServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                selectedNodes[0].execAction(29);
            }
        });
    }
}

