/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import jive.JiveUtils;
import jive3.ComboItem;
import jive3.NavigationListener;

public class NavigationBar
extends JPanel
implements ActionListener,
KeyListener {
    private static final Insets nullInsets = new Insets(0, 0, 0, 0);
    private JButton backBtn;
    private JButton forwardBtn;
    private JComboBox searchText;
    private JButton searchBtn;
    private JButton refreshBtn;
    private Vector<NavigationListener> listeners;
    private JButton upBtn;
    private JButton downBtn;
    private boolean isUpdating;

    NavigationBar() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.backBtn = new JButton();
        this.backBtn.setDisabledIcon(new ImageIcon(NavigationBar.class.getResource("/jive/bw_btn_disa.gif")));
        this.backBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/bw_btn_pressed.gif")));
        this.backBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/bw_btn.gif")));
        this.backBtn.setMargin(nullInsets);
        this.backBtn.addActionListener(this);
        this.backBtn.setToolTipText("Go back");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.backBtn, gridBagConstraints);
        this.forwardBtn = new JButton();
        this.forwardBtn.setDisabledIcon(new ImageIcon(NavigationBar.class.getResource("/jive/fw_btn_disa.gif")));
        this.forwardBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/fw_btn_pressed.gif")));
        this.forwardBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/fw_btn.gif")));
        this.forwardBtn.setMargin(nullInsets);
        this.forwardBtn.addActionListener(this);
        this.forwardBtn.setToolTipText("Go forward");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.forwardBtn, gridBagConstraints);
        this.refreshBtn = new JButton();
        this.refreshBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/refresh_btn_pressed.gif")));
        this.refreshBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/refresh_btn.gif")));
        this.refreshBtn.setMargin(nullInsets);
        this.refreshBtn.addActionListener(this);
        this.refreshBtn.setToolTipText("Refresh the tree");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.refreshBtn, gridBagConstraints);
        this.isUpdating = true;
        this.searchText = new JComboBox();
        this.searchText.setEditable(true);
        this.searchText.getEditor().getEditorComponent().addKeyListener(this);
        this.searchText.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.searchText, gridBagConstraints);
        this.isUpdating = false;
        this.downBtn = new JButton();
        this.downBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/down_btn_pressed.gif")));
        this.downBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/down_btn.gif")));
        this.downBtn.setDisabledIcon(new ImageIcon(NavigationBar.class.getResource("/jive/down_btn_disa.gif")));
        this.downBtn.setMargin(nullInsets);
        this.downBtn.addActionListener(this);
        this.downBtn.setToolTipText("Next occurence");
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.downBtn, gridBagConstraints);
        this.searchBtn = new JButton();
        this.searchBtn.setPressedIcon(new ImageIcon(NavigationBar.class.getResource("/jive/search_btn_pressed.gif")));
        this.searchBtn.setIcon(new ImageIcon(NavigationBar.class.getResource("/jive/search_btn.gif")));
        this.searchBtn.setMargin(nullInsets);
        this.searchBtn.addActionListener(this);
        this.searchBtn.setToolTipText("Search");
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.searchBtn, gridBagConstraints);
        this.listeners = new Vector();
    }

    public void addNavigationListener(NavigationListener navigationListener) {
        this.listeners.add(navigationListener);
    }

    public void removeNavigationListener(NavigationListener navigationListener) {
        this.listeners.remove(navigationListener);
    }

    public String getSearchText() {
        return this.searchText.getEditor().getItem().toString();
    }

    public TreePath getSelectedItemPath() {
        Object object = this.searchText.getSelectedItem();
        if (object instanceof ComboItem) {
            ComboItem comboItem = (ComboItem)object;
            return comboItem.path;
        }
        return null;
    }

    public void addLink(TreePath treePath) {
        this.isUpdating = true;
        int n = this.addSearchText(JiveUtils.getPathAsText(treePath), treePath);
        this.searchText.setSelectedIndex(n);
        this.isUpdating = false;
    }

    public void enableBack(boolean bl) {
        this.backBtn.setEnabled(bl);
    }

    public void enableForward(boolean bl) {
        this.forwardBtn.setEnabled(bl);
    }

    public void enableNextOcc(boolean bl) {
        this.downBtn.setEnabled(bl);
    }

    public void enablePreviousOcc(boolean bl) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            TreePath treePath;
            Object object;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                object = actionEvent.getSource();
                                if (object != this.backBtn) break block7;
                                for (int i = 0; i < this.listeners.size(); ++i) {
                                    this.listeners.get(i).backAction(this);
                                }
                                break block8;
                            }
                            if (object != this.forwardBtn) break block9;
                            for (int i = 0; i < this.listeners.size(); ++i) {
                                this.listeners.get(i).forwardAction(this);
                            }
                            break block8;
                        }
                        if (object != this.refreshBtn) break block10;
                        for (int i = 0; i < this.listeners.size(); ++i) {
                            this.listeners.get(i).refreshAction(this);
                        }
                        break block8;
                    }
                    if (object != this.downBtn) break block11;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).nextOccAction(this);
                    }
                    break block8;
                }
                if (object != this.searchBtn) break block12;
                TreePath treePath2 = this.getSelectedItemPath();
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).searchAction(this, treePath2);
                }
                if (treePath2 != null) break block8;
                this.isUpdating = true;
                this.addSearchText(this.getSearchText(), null);
                this.isUpdating = false;
                break block8;
            }
            if (object == this.searchText && !this.isUpdating && (treePath = this.getSelectedItemPath()) != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).searchAction(this, treePath);
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            TreePath treePath = this.getSelectedItemPath();
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).searchAction(this, treePath);
            }
            this.isUpdating = true;
            this.addSearchText(this.getSearchText(), null);
            this.isUpdating = false;
        }
    }

    private int addSearchText(String string, TreePath treePath) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.searchText.getItemCount() && !bl) {
            int n2 = string.compareToIgnoreCase(this.searchText.getItemAt(n).toString());
            bl2 = n2 == 0;
            bl = n2 <= 0;
            if (bl) continue;
            ++n;
        }
        ComboItem comboItem = new ComboItem();
        comboItem.text = string;
        comboItem.path = treePath;
        if (!bl2) {
            this.searchText.insertItemAt(comboItem, n);
        }
        return n;
    }
}

