/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import jive3.MainPanel;
import jive3.NavItem;

public class NavManager {
    MainPanel invoker;
    Vector<NavItem> items;
    int position;

    public NavManager(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.items = new Vector();
        this.position = 0;
    }

    public void reset() {
        this.items = new Vector();
        this.position = 0;
    }

    public void recordPath(JTree jTree) {
        NavItem navItem = new NavItem();
        navItem.selectedTree = jTree;
        navItem.path = jTree.getSelectionPath();
        for (int i = this.position + 1; i < this.items.size(); ++i) {
            this.items.remove(i);
        }
        this.items.add(navItem);
        this.position = this.items.size() - 1;
    }

    public void goBack() {
        --this.position;
    }

    public void goForward() {
        ++this.position;
    }

    public boolean canGoBackward() {
        return this.position > 0;
    }

    public boolean canGoForward() {
        return this.position < this.items.size() - 1;
    }

    public TreePath getCurrentPath() {
        return this.items.get((int)this.position).path;
    }

    public JTree getCurrentTree() {
        return this.items.get((int)this.position).selectedTree;
    }

    public void debug() {
        System.out.println("====================================");
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.position == i) {
                System.out.println("-->" + this.items.get(i));
                continue;
            }
            System.out.println("   " + this.items.get(i));
        }
    }
}

