/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.AttributePanel;
import explorer.AttributeTableModel;
import explorer.EntityTable;
import explorer.Preferences;
import explorer.SetDialog;
import explorer.ViewDialog;
import explorer.ui.Dialog;
import explorer.ui.PreferencesDialog;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.dnd.NodeFactory;
import fr.esrf.tangoatk.widget.dnd.NumberScalarNode;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AttributeTable
extends EntityTable {
    AttributePanel panel;
    JMenuItem set;
    JMenuItem trend;
    JMenuItem globalTrendItem;
    JMenuItem removeTrend;
    JMenuItem refresh;
    Trend trendPanel;
    Trend globalTrend;
    Dialog trendFrame;
    SetDialog setDialog;

    public AttributeTable(AttributeTableModel model, Preferences prefs, boolean isAdmin) {
        this.preferences = prefs;
        this.initComponents(model, isAdmin);
        this.flavor = NodeFactory.MIME_ATTRIBUTE;
        this.table.setTransferHandler((TransferHandler)new fr.esrf.tangoatk.widget.dnd.TransferHandler(){

            protected Transferable createTransferable(JComponent comp) {
                if (!(comp instanceof JTable)) {
                    return null;
                }
                JTable t = (JTable)comp;
                IEntity entity = ((AttributeTableModel)AttributeTable.this.getModel()).getEntityAt(AttributeTable.this.getSelectedRow());
                if (!(entity instanceof INumberScalar)) {
                    return null;
                }
                INumberScalar scalar = (INumberScalar)entity;
                return new NumberScalarNode(scalar);
            }
        });
        this.table.setDragEnabled(true);
        this.setModel(model);
    }

    protected void dtHandleDrop(String name, DataFlavor flavor) {
        String mimeType = flavor.getMimeType();
        if (mimeType.startsWith(NodeFactory.MIME_STRINGSCALAR)) {
            ((AttributeTableModel)this.model).addStringScalar(name);
            return;
        }
        if (mimeType.startsWith(NodeFactory.MIME_NUMBERSCALAR)) {
            ((AttributeTableModel)this.model).addNumberScalar(name);
            return;
        }
        if (mimeType.startsWith(NodeFactory.MIME_NUMBERSPECTRUM)) {
            ((AttributeTableModel)this.model).addNumberSpectrum(name);
            return;
        }
        if (mimeType.startsWith(NodeFactory.MIME_NUMBERIMAGE)) {
            ((AttributeTableModel)this.model).addNumberImage(name);
            return;
        }
    }

    protected void showSetDialog() {
        if (this.getSelectedRow() == -1) {
            return;
        }
        IAttribute attribute = (IAttribute)this.model.getEntityAt(this.getSelectedRow());
        this.setDialog = new SetDialog((IScalarAttribute)attribute);
        this.setDialog.show();
    }

    protected void refreshEntity() {
        IAttribute attribute = (IAttribute)this.model.getEntityAt(this.getSelectedRow());
        attribute.refresh();
        attribute.getDevice().refresh();
    }

    protected void showTrend() {
        IAttribute attribute = (IAttribute)this.model.getEntityAt(this.getSelectedRow());
        this.trendPanel = new Trend();
        this.trendPanel.setLegendVisible(false);
        this.trendFrame = new Dialog((JComponent)this.trendPanel);
        this.trendFrame.setTitle(attribute.getAlias());
        this.trendPanel.setListVisible(false);
        this.trendPanel.setXAxisLength(200);
        this.trendPanel.setShowingNames(false);
        this.trendPanel.setButtonBarVisible(false);
        this.trendPanel.addAttribute((INumberScalar)attribute);
        this.trendFrame.show();
    }

    public void setGlobalTrend(Trend trend) {
        this.globalTrend = trend;
    }

    protected void addGlobalTrend() {
        IAttribute attr = (IAttribute)this.model.getEntityAt(this.getSelectedRow());
        this.globalTrend.addAttribute((INumberScalar)attr);
    }

    protected void removeTrend() {
        IAttribute attr = (IAttribute)this.model.getEntityAt(this.getSelectedRow());
        this.globalTrend.removeAttribute((INumberScalar)attr);
    }

    void initHelp() {
        this.helpUrl = "/explorer/html/AttributeTableHelp.html";
        HelpWindow.getInstance().addCategory("Attribute Table", "Attribute table", this.getClass().getResource(this.helpUrl));
    }

    void initMenus() {
        this.refresh = new JMenuItem("Refresh");
        this.set = new JMenuItem("Set...");
        this.trend = new JMenuItem("Trend...");
        this.globalTrendItem = new JMenuItem("Add to trend");
        this.removeTrend = new JMenuItem("Remove from trend");
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.refreshEntity();
            }
        });
        this.set.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.showSetDialog();
            }
        });
        this.trend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.showTrend();
            }
        });
        this.globalTrendItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.addGlobalTrend();
            }
        });
        this.removeTrend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.removeTrend();
            }
        });
        this.popup.add(this.refresh);
        this.popup.add(new JSeparator());
        this.popup.add(this.trend);
        this.popup.add(this.globalTrendItem);
        this.popup.add(this.removeTrend);
    }

    void initPreferences() {
        PreferencesDialog.getInstance().addCategory("Attribute table", "visible fields", new ViewDialog(this.model));
    }

    protected void showPopup(MouseEvent evt) {
        int row = this.getRowAtPoint(evt.getPoint());
        if (row == -1) {
            return;
        }
        if (evt.isPopupTrigger()) {
            this.setRowSelectionInterval(row, row);
            IAttribute attribute = (IAttribute)this.model.getEntityAt(row);
            this.set.setEnabled(attribute.isWritable());
            this.trend.setEnabled(attribute instanceof INumberScalar);
            this.removeTrend.setEnabled(attribute instanceof INumberScalar);
            this.globalTrendItem.setEnabled(attribute instanceof INumberScalar);
            this.popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    protected void entityTableMouseClicked(MouseEvent evt) {
        int row = this.getRowAtPoint(evt.getPoint());
        if (row == -1) {
            return;
        }
        IAttribute attribute = (IAttribute)this.model.getEntityAt(row);
        if (this.model.isExecuteColumn(this.getSelectedColumn()) && attribute.isWritable()) {
            this.showSetDialog();
        }
    }

    TableColumn createTableColumn(String name, int i) {
        final AttributeTableModel myModel = (AttributeTableModel)this.model;
        if (AttributeTableModel.DEVICE == name) {
            return new TableColumn(i, 75, this.deviceRenderer, null);
        }
        if (AttributeTableModel.VALUE == name) {
            return new TableColumn(i, 75, this.entityRenderer, null);
        }
        if (AttributeTableModel.SET == name) {
            return new TableColumn(i, 75, new TableCellRenderer(){
                JButton renderer;

                public Component getTableCellRendererComponent(JTable table, Object value, boolean select, boolean focus, int row, int column) {
                    if (this.renderer == null) {
                        this.renderer = new JButton(AttributeTableModel.SET);
                    }
                    IAttribute attribute = (IAttribute)AttributeTable.this.model.getEntityAt(row);
                    this.renderer.setEnabled(attribute.isWritable());
                    return this.renderer;
                }
            }, null);
        }
        return new TableColumn(i, 75);
    }

    public void setPreferences(Preferences preferences) {
        String err;
        super.setPreferences(preferences);
        String s = preferences.getString("globalGraphSettings", null);
        if (s != null && (err = this.globalTrend.setSetting(s)).length() > 0) {
            JOptionPane.showMessageDialog(null, "Failed apply trend configuration: " + err, "Error", 0);
        }
    }

    public void storePreferences() {
        super.storePreferences();
        this.preferences.putString("globalGraphSettings", this.globalTrend.getSettings());
    }
}

