/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.Preferences;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IErrorListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FileManager {
    List attributes = new LinkedList();
    List commands = new LinkedList();
    Preferences preferences = new Preferences();
    EventSupport propChanges = new EventSupport();
    protected static FileManager instance;

    protected FileManager() {
    }

    public static synchronized FileManager getInstance() {
        if (instance == null) {
            instance = new FileManager();
        }
        return instance;
    }

    void publishError(Exception e) {
        this.propChanges.fireReadErrorEvent((Object)this, (Throwable)e);
    }

    public void addErrorListener(IErrorListener l) {
        this.propChanges.addErrorListener(l);
    }

    public void removeErrorListener(IErrorListener l) {
        this.propChanges.removeErrorListener(l);
    }

    public void setPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setAttributes(AttributeList attributeList) {
        this.attributes.clear();
        int i = 0;
        while (i < attributeList.size()) {
            IAttribute attribute = (IAttribute)attributeList.get(i);
            AttributeCache cache = new AttributeCache(attribute.getName(), attribute.getAlias(), attribute.getDevice().getAlias());
            this.attributes.add(cache);
            ++i;
        }
    }

    public void setCommands(CommandList commandList) {
        this.commands.clear();
        int i = 0;
        while (i < commandList.size()) {
            ICommand command = (ICommand)commandList.get(i);
            CommandCache cache = new CommandCache(command.getName(), command.getAlias(), command.getDevice().getAlias());
            this.commands.add(cache);
            ++i;
        }
    }

    public AttributeList getAttributeList() {
        AttributeList list = new AttributeList();
        int i = 0;
        while (i < this.attributes.size()) {
            AttributeCache cache = (AttributeCache)this.attributes.get(i);
            try {
                IAttribute attribute = (IAttribute)list.add(cache.name);
                if (cache.alias != null) {
                    attribute.setAlias(cache.alias);
                }
                if (cache.deviceAlias != null) {
                    attribute.getDevice().setAlias(cache.deviceAlias);
                }
            }
            catch (ConnectionException e) {
                this.publishError((Exception)((Object)e));
            }
            ++i;
        }
        return list;
    }

    public CommandList getCommandList() {
        CommandList list = new CommandList();
        int i = 0;
        while (i < this.commands.size()) {
            CommandCache cache = (CommandCache)this.commands.get(i);
            try {
                ICommand command = (ICommand)list.add(cache.name);
                if (cache.alias != null) {
                    command.setAlias(cache.alias);
                }
                if (cache.deviceAlias != null) {
                    command.getDevice().setAlias(cache.deviceAlias);
                }
            }
            catch (ConnectionException e) {
                this.publishError((Exception)((Object)e));
            }
            ++i;
        }
        return list;
    }

    public void writeEntity(PrintWriter writer, EntityCache entity) {
        String name = entity.name;
        String alias = entity.alias;
        String deviceAlias = entity.deviceAlias;
        writer.println("name = \"" + name + "\"");
        if (alias != null) {
            writer.println(" alias = \"" + alias + "\"");
        }
        if (deviceAlias != null) {
            writer.println(" deviceAlias = \"" + deviceAlias + "\"");
        }
    }

    void saveEntities(PrintWriter writer) {
        writer.println("\t<tangoentities>");
        writer.println("\t\t<attributes>");
        int i = 0;
        while (i < this.attributes.size()) {
            EntityCache attribute = (EntityCache)this.attributes.get(i);
            writer.print("\t\t\t<attribute ");
            this.writeEntity(writer, attribute);
            writer.println("/>");
            ++i;
        }
        writer.println("\t\t</attributes>");
        writer.println("\t\t<commands>");
        int i2 = 0;
        while (i2 < this.commands.size()) {
            EntityCache command = (EntityCache)this.commands.get(i2);
            writer.print("\t\t\t<command ");
            this.writeEntity(writer, command);
            writer.println("/>");
            ++i2;
        }
        writer.println("\t\t</commands>");
        writer.println("\t</tangoentities>");
    }

    void savePreferences(PrintWriter writer) {
        writer.println("<map MAP_XML_VERSION=\"1.0\">");
        Iterator i = this.preferences.getKeys().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            writer.print("  <entry key=");
            writer.print("\"" + key + "\"");
            writer.print(" ");
            writer.print("value=");
            writer.print("\"" + this.preferences.get(key) + "\"");
            writer.println(" />");
        }
        writer.println("</map>");
    }

    protected void cacheAttr(String name, String alias, String devAlias) {
        AttributeCache cache = new AttributeCache(name, alias, devAlias);
        this.attributes.add(cache);
    }

    protected void cacheCmd(String name, String alias, String devAlias) {
        CommandCache cache = new CommandCache(name, alias, devAlias);
        this.commands.add(cache);
    }

    protected void startEntity(String uri, String localName, String qname, Attributes attrs) throws ConnectionException {
        if ("attribute".equalsIgnoreCase(qname)) {
            String name = attrs.getValue("name");
            String alias = attrs.getValue("alias");
            String device = attrs.getValue("deviceAlias");
            this.cacheAttr(name, alias, device);
            return;
        }
        if ("command".equalsIgnoreCase(qname)) {
            String name = attrs.getValue("name");
            String alias = attrs.getValue("alias");
            String device = attrs.getValue("deviceAlias");
            this.cacheCmd(name, alias, device);
            return;
        }
        if ("entry".equalsIgnoreCase(qname)) {
            String key = attrs.getValue("key");
            String value = attrs.getValue("value");
            if ("true".equals(value) || "false".equals(value)) {
                this.preferences.putBoolean(key, "true".equals(value));
                return;
            }
            if (value.length() < 20) {
                try {
                    this.preferences.putDouble(key, Double.parseDouble(value));
                }
                catch (NumberFormatException e) {
                    this.preferences.putString(key, value);
                }
            } else {
                this.preferences.putString(key, value);
            }
        }
    }

    public void save(File file) throws IOException {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file.getAbsolutePath())));
        writer.println("<?xml version=\"1.0\"?>");
        writer.println("<devicetree>");
        this.saveEntities(writer);
        this.savePreferences(writer);
        writer.println("</devicetree>");
        writer.flush();
        writer.close();
    }

    public void open(String source) throws SAXException, ParserConfigurationException, IOException {
        String src = source;
        try {
            XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            parser.setContentHandler(new DefaultHandler(){

                public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
                    try {
                        FileManager.this.startEntity(uri, localName, qname, attributes);
                    }
                    catch (Exception e) {
                        throw new SAXException(e);
                    }
                }

                public void endElement(String uri, String localName, String qname) {
                }
            });
            this.commands.clear();
            this.attributes.clear();
            parser.parse(src);
        }
        catch (SAXParseException e) {
            JOptionPane.showMessageDialog(null, "Failed to parse " + source + "\n" + e.getMessage() + "[Line " + e.getLineNumber() + "]", "Error", 0);
        }
    }

    class CommandCache
    extends EntityCache {
        CommandCache(String name, String alias, String deviceAlias) {
            super(name, alias, deviceAlias);
        }
    }

    class AttributeCache
    extends EntityCache {
        AttributeCache(String name, String alias, String deviceAlias) {
            super(name, alias, deviceAlias);
        }
    }

    abstract class EntityCache {
        String name;
        String alias;
        String deviceAlias;

        protected EntityCache() {
        }

        EntityCache(String name, String alias, String deviceAlias) {
            this.name = name;
            this.alias = alias;
            this.deviceAlias = deviceAlias;
        }
    }
}

