/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.EventsTable;
import admin.astor.tools.SubscribedSignal;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class TablePopupMenu
extends JPopupMenu {
    private EventsTable parent;
    private JLabel titleLbl;
    private static String[] pMenuLabels = new String[]{"Signal Info", "Signal History", "Remove", "Move Up", "Move Down"};
    private static final int OFFSET = 2;
    private static final int INFO = 0;
    private static final int HISTORY = 1;
    private static final int REMOVE = 2;
    private static final int MOVE_UP = 3;
    private static final int MOVE_DOWN = 4;
    public static final int UP = 0;
    public static final int DOWN = 1;
    private SubscribedSignal signal;

    public TablePopupMenu(EventsTable parent) {
        this.parent = parent;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        this.titleLbl = new JLabel();
        this.titleLbl.setFont(new Font("Dialog", 1, 16));
        this.add(this.titleLbl);
        this.add(new JPopupMenu.Separator());
        for (int i = 0; i < pMenuLabels.length; ++i) {
            JMenuItem btn = new JMenuItem(pMenuLabels[i]);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TablePopupMenu.this.executeActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt, SubscribedSignal signal) {
        this.signal = signal;
        this.getComponent(3).setVisible(signal.histo.size() > 0);
        this.titleLbl.setText(signal.toString());
        this.show(this.parent.table, evt.getX(), evt.getY());
    }

    private void executeActionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(pMenuLabels[0])) {
            this.parent.displayInfo(this.signal);
        } else if (cmd.equals(pMenuLabels[1])) {
            this.parent.displayHistory(this.signal);
        } else if (cmd.equals(pMenuLabels[2])) {
            if (JOptionPane.showConfirmDialog(this.parent, "OK to remove " + this.signal + " ?", "Confim Dialog", 0) == 0) {
                this.parent.remove(this.signal);
            }
        } else if (cmd.equals(pMenuLabels[3])) {
            this.parent.move(this.signal, 0);
        } else if (cmd.equals(pMenuLabels[4])) {
            this.parent.move(this.signal, 1);
        }
    }
}

